<?php

namespace Eurostop\Products;

class ArrayOfSkuPriceCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var SkuPrice[] $SkuPrice
     */
    protected $SkuPrice = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return SkuPrice[]
     */
    public function getSkuPrice()
    {
      return $this->SkuPrice;
    }

    /**
     * @param SkuPrice[] $SkuPrice
     * @return \Eurostop\Products\ArrayOfSkuPrice
     */
    public function setSkuPrice(array $SkuPrice = null)
    {
      $this->SkuPrice = $SkuPrice;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->SkuPrice[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return SkuPrice
     */
    public function offsetGet($offset)
    {
      return $this->SkuPrice[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param SkuPrice $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->SkuPrice[] = $value;
      } else {
        $this->SkuPrice[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->SkuPrice[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return SkuPrice Return the current element
     */
    public function current()
    {
      return current($this->SkuPrice);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->SkuPrice);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->SkuPrice);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->SkuPrice);
    }

    /**
     * Countable implementation
     *
     * @return SkuPrice Return count of elements
     */
    public function count()
    {
      return count($this->SkuPrice);
    }

}
