<?php

namespace Eurostop\Products;

class ArrayOfSkuCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Sku[] $Sku
     */
    protected $Sku = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Sku[]
     */
    public function getSku()
    {
      return $this->Sku;
    }

    /**
     * @param Sku[] $Sku
     * @return \Eurostop\Products\ArrayOfSku
     */
    public function setSku(array $Sku = null)
    {
      $this->Sku = $Sku;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Sku[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Sku
     */
    public function offsetGet($offset)
    {
      return $this->Sku[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Sku $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Sku[] = $value;
      } else {
        $this->Sku[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Sku[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Sku Return the current element
     */
    public function current()
    {
      return current($this->Sku);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Sku);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Sku);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Sku);
    }

    /**
     * Countable implementation
     *
     * @return Sku Return count of elements
     */
    public function count()
    {
      return count($this->Sku);
    }

}
