<?php

namespace Eurostop\Products;

class ArrayOfProductImageCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ProductImage[] $ProductImage
     */
    protected $ProductImage = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ProductImage[]
     */
    public function getProductImage()
    {
      return $this->ProductImage;
    }

    /**
     * @param ProductImage[] $ProductImage
     * @return \Eurostop\Products\ArrayOfProductImage
     */
    public function setProductImage(array $ProductImage = null)
    {
      $this->ProductImage = $ProductImage;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ProductImage[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ProductImage
     */
    public function offsetGet($offset)
    {
      return $this->ProductImage[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ProductImage $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ProductImage[] = $value;
      } else {
        $this->ProductImage[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ProductImage[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ProductImage Return the current element
     */
    public function current()
    {
      return current($this->ProductImage);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ProductImage);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ProductImage);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ProductImage);
    }

    /**
     * Countable implementation
     *
     * @return ProductImage Return count of elements
     */
    public function count()
    {
      return count($this->ProductImage);
    }

}
