<?php

namespace Eurostop\Products;

class ArrayOfExtendedAttributeTypeCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ExtendedAttributeType[] $ExtendedAttributeType
     */
    protected $ExtendedAttributeType = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ExtendedAttributeType[]
     */
    public function getExtendedAttributeType()
    {
      return $this->ExtendedAttributeType;
    }

    /**
     * @param ExtendedAttributeType[] $ExtendedAttributeType
     * @return \Eurostop\Products\ArrayOfExtendedAttributeType
     */
    public function setExtendedAttributeType(array $ExtendedAttributeType = null)
    {
      $this->ExtendedAttributeType = $ExtendedAttributeType;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ExtendedAttributeType[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ExtendedAttributeType
     */
    public function offsetGet($offset)
    {
      return $this->ExtendedAttributeType[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ExtendedAttributeType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ExtendedAttributeType[] = $value;
      } else {
        $this->ExtendedAttributeType[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ExtendedAttributeType[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ExtendedAttributeType Return the current element
     */
    public function current()
    {
      return current($this->ExtendedAttributeType);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ExtendedAttributeType);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ExtendedAttributeType);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ExtendedAttributeType);
    }

    /**
     * Countable implementation
     *
     * @return ExtendedAttributeType Return count of elements
     */
    public function count()
    {
      return count($this->ExtendedAttributeType);
    }

}
