<?php

namespace Eurostop\Products;

class ArrayOfColourCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Colour[] $Colour
     */
    protected $Colour = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Colour[]
     */
    public function getColour()
    {
      return $this->Colour;
    }

    /**
     * @param Colour[] $Colour
     * @return \Eurostop\Products\ArrayOfColour
     */
    public function setColour(array $Colour = null)
    {
      $this->Colour = $Colour;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Colour[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Colour
     */
    public function offsetGet($offset)
    {
      return $this->Colour[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Colour $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Colour[] = $value;
      } else {
        $this->Colour[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Colour[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Colour Return the current element
     */
    public function current()
    {
      return current($this->Colour);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Colour);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Colour);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Colour);
    }

    /**
     * Countable implementation
     *
     * @return Colour Return count of elements
     */
    public function count()
    {
      return count($this->Colour);
    }

}
