<?php

namespace Eurostop\Products;

class ArrayOfAnalysisValue implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var AnalysisValue[] $AnalysisValue
     */
    protected $AnalysisValue = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return AnalysisValue[]
     */
    public function getAnalysisValue()
    {
      return $this->AnalysisValue;
    }

    /**
     * @param AnalysisValue[] $AnalysisValue
     * @return \Eurostop\Products\ArrayOfAnalysisValue
     */
    public function setAnalysisValue(array $AnalysisValue = null)
    {
      $this->AnalysisValue = $AnalysisValue;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->AnalysisValue[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return AnalysisValue
     */
    public function offsetGet($offset)
    {
      return $this->AnalysisValue[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param AnalysisValue $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->AnalysisValue[] = $value;
      } else {
        $this->AnalysisValue[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->AnalysisValue[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return AnalysisValue Return the current element
     */
    public function current()
    {
      return current($this->AnalysisValue);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->AnalysisValue);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->AnalysisValue);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->AnalysisValue);
    }

    /**
     * Countable implementation
     *
     * @return AnalysisValue Return count of elements
     */
    public function count()
    {
      return count($this->AnalysisValue);
    }

}
