<?php

namespace Eurostop\Organisation;

class SubmittedVatRateCustom extends SubmittedDataItemOfSubmittedVatRateDtoTPKTiFnXCustom
{

    /**
     * @var string $CountryIdentifier
     */
    protected $CountryIdentifier = null;

    /**
     * @var CountryIdentifierType $CountryIdentifierType
     */
    protected $CountryIdentifierType = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var \DateTime $EffectiveDate
     */
    protected $EffectiveDate = null;

    /**
     * @var string $EquivalentVatRateIdentifier
     */
    protected $EquivalentVatRateIdentifier = null;

    /**
     * @var float $PercentageRate
     */
    protected $PercentageRate = null;

    /**
     * @var string $VatRateIdentifier
     */
    protected $VatRateIdentifier = null;

    /**
     * @var VatRateIdentifierType $VatRateIdentifierType
     */
    protected $VatRateIdentifierType = null;

    /**
     * @param CountryIdentifierType $CountryIdentifierType
     * @param \DateTime $EffectiveDate
     * @param float $PercentageRate
     * @param VatRateIdentifierType $VatRateIdentifierType
     */
    public function __construct($CountryIdentifierType, \DateTime $EffectiveDate, $PercentageRate, $VatRateIdentifierType)
    {
      parent::__construct();
      $this->CountryIdentifierType = $CountryIdentifierType;
      $this->EffectiveDate = $EffectiveDate->format(\DateTime::ATOM);
      $this->PercentageRate = $PercentageRate;
      $this->VatRateIdentifierType = $VatRateIdentifierType;
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->CountryIdentifier;
    }

    /**
     * @param string $CountryIdentifier
     * @return \Eurostop\Organisation\SubmittedVatRate
     */
    public function setCountryIdentifier($CountryIdentifier)
    {
      $this->CountryIdentifier = $CountryIdentifier;
      return $this;
    }

    /**
     * @return CountryIdentifierType
     */
    public function getCountryIdentifierType()
    {
      return $this->CountryIdentifierType;
    }

    /**
     * @param CountryIdentifierType $CountryIdentifierType
     * @return \Eurostop\Organisation\SubmittedVatRate
     */
    public function setCountryIdentifierType($CountryIdentifierType)
    {
      $this->CountryIdentifierType = $CountryIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Eurostop\Organisation\SubmittedVatRate
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEffectiveDate()
    {
      if ($this->EffectiveDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->EffectiveDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $EffectiveDate
     * @return \Eurostop\Organisation\SubmittedVatRate
     */
    public function setEffectiveDate(\DateTime $EffectiveDate)
    {
      $this->EffectiveDate = $EffectiveDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getEquivalentVatRateIdentifier()
    {
      return $this->EquivalentVatRateIdentifier;
    }

    /**
     * @param string $EquivalentVatRateIdentifier
     * @return \Eurostop\Organisation\SubmittedVatRate
     */
    public function setEquivalentVatRateIdentifier($EquivalentVatRateIdentifier)
    {
      $this->EquivalentVatRateIdentifier = $EquivalentVatRateIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getPercentageRate()
    {
      return $this->PercentageRate;
    }

    /**
     * @param float $PercentageRate
     * @return \Eurostop\Organisation\SubmittedVatRate
     */
    public function setPercentageRate($PercentageRate)
    {
      $this->PercentageRate = $PercentageRate;
      return $this;
    }

    /**
     * @return string
     */
    public function getVatRateIdentifier()
    {
      return $this->VatRateIdentifier;
    }

    /**
     * @param string $VatRateIdentifier
     * @return \Eurostop\Organisation\SubmittedVatRate
     */
    public function setVatRateIdentifier($VatRateIdentifier)
    {
      $this->VatRateIdentifier = $VatRateIdentifier;
      return $this;
    }

    /**
     * @return VatRateIdentifierType
     */
    public function getVatRateIdentifierType()
    {
      return $this->VatRateIdentifierType;
    }

    /**
     * @param VatRateIdentifierType $VatRateIdentifierType
     * @return \Eurostop\Organisation\SubmittedVatRate
     */
    public function setVatRateIdentifierType($VatRateIdentifierType)
    {
      $this->VatRateIdentifierType = $VatRateIdentifierType;
      return $this;
    }

}
