<?php

namespace Eurostop\Organisation;

class SubmittedCurrencyConversion extends SubmittedDataItemOfSubmittedCurrencyConversionDtoTPKTiFnX
{

    /**
     * @var CurrencyIdentifierType $CurrencyIdentifierType
     */
    protected $CurrencyIdentifierType = null;

    /**
     * @var \DateTime $EffectiveDate
     */
    protected $EffectiveDate = null;

    /**
     * @var float $ExchangeRate
     */
    protected $ExchangeRate = null;

    /**
     * @var string $FromCurrencyIdentifier
     */
    protected $FromCurrencyIdentifier = null;

    /**
     * @var string $ToCurrencyIdentifier
     */
    protected $ToCurrencyIdentifier = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return CurrencyIdentifierType
     */
    public function getCurrencyIdentifierType()
    {
      return $this->CurrencyIdentifierType;
    }

    /**
     * @param CurrencyIdentifierType $CurrencyIdentifierType
     * @return \Eurostop\Organisation\SubmittedCurrencyConversion
     */
    public function setCurrencyIdentifierType($CurrencyIdentifierType)
    {
      $this->CurrencyIdentifierType = $CurrencyIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEffectiveDate()
    {
      if ($this->EffectiveDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->EffectiveDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $EffectiveDate
     * @return \Eurostop\Organisation\SubmittedCurrencyConversion
     */
    public function setEffectiveDate(\DateTime $EffectiveDate = null)
    {
      if ($EffectiveDate == null) {
       $this->EffectiveDate = null;
      } else {
        $this->EffectiveDate = $EffectiveDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return float
     */
    public function getExchangeRate()
    {
      return $this->ExchangeRate;
    }

    /**
     * @param float $ExchangeRate
     * @return \Eurostop\Organisation\SubmittedCurrencyConversion
     */
    public function setExchangeRate($ExchangeRate)
    {
      $this->ExchangeRate = $ExchangeRate;
      return $this;
    }

    /**
     * @return string
     */
    public function getFromCurrencyIdentifier()
    {
      return $this->FromCurrencyIdentifier;
    }

    /**
     * @param string $FromCurrencyIdentifier
     * @return \Eurostop\Organisation\SubmittedCurrencyConversion
     */
    public function setFromCurrencyIdentifier($FromCurrencyIdentifier)
    {
      $this->FromCurrencyIdentifier = $FromCurrencyIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getToCurrencyIdentifier()
    {
      return $this->ToCurrencyIdentifier;
    }

    /**
     * @param string $ToCurrencyIdentifier
     * @return \Eurostop\Organisation\SubmittedCurrencyConversion
     */
    public function setToCurrencyIdentifier($ToCurrencyIdentifier)
    {
      $this->ToCurrencyIdentifier = $ToCurrencyIdentifier;
      return $this;
    }

}
