<?php

namespace Eurostop\Organisation;

class SubmitCurrencyConversionRates
{

    /**
     * @var ArrayOfSubmittedCurrencyConversion $currencyConversions
     */
    protected $currencyConversions = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedCurrencyConversion $currencyConversions
     * @param string $submissionReference
     */
    public function __construct($currencyConversions = null, $submissionReference = null)
    {
      $this->currencyConversions = $currencyConversions;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedCurrencyConversion
     */
    public function getCurrencyConversions()
    {
      return $this->currencyConversions;
    }

    /**
     * @param ArrayOfSubmittedCurrencyConversion $currencyConversions
     * @return \Eurostop\Organisation\SubmitCurrencyConversionRates
     */
    public function setCurrencyConversions($currencyConversions)
    {
      $this->currencyConversions = $currencyConversions;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Organisation\SubmitCurrencyConversionRates
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
