<?php

namespace Eurostop\Organisation;

class GetVatRate
{

    /**
     * @var string $vatRateIdentifier
     */
    protected $vatRateIdentifier = null;

    /**
     * @var VatRateIdentifierType $vatRateIdentifierType
     */
    protected $vatRateIdentifierType = null;

    /**
     * @param string $vatRateIdentifier
     * @param VatRateIdentifierType $vatRateIdentifierType
     */
    public function __construct($vatRateIdentifier = null, $vatRateIdentifierType = null)
    {
      $this->vatRateIdentifier = $vatRateIdentifier;
      $this->vatRateIdentifierType = $vatRateIdentifierType;
    }

    /**
     * @return string
     */
    public function getVatRateIdentifier()
    {
      return $this->vatRateIdentifier;
    }

    /**
     * @param string $vatRateIdentifier
     * @return \Eurostop\Organisation\GetVatRate
     */
    public function setVatRateIdentifier($vatRateIdentifier)
    {
      $this->vatRateIdentifier = $vatRateIdentifier;
      return $this;
    }

    /**
     * @return VatRateIdentifierType
     */
    public function getVatRateIdentifierType()
    {
      return $this->vatRateIdentifierType;
    }

    /**
     * @param VatRateIdentifierType $vatRateIdentifierType
     * @return \Eurostop\Organisation\GetVatRate
     */
    public function setVatRateIdentifierType($vatRateIdentifierType)
    {
      $this->vatRateIdentifierType = $vatRateIdentifierType;
      return $this;
    }

}
