<?php

namespace Eurostop\Organisation;

class ArrayOfVatRateCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var VatRate[] $VatRate
     */
    protected $VatRate = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return VatRate[]
     */
    public function getVatRate()
    {
      return $this->VatRate;
    }

    /**
     * @param VatRate[] $VatRate
     * @return \Eurostop\Organisation\ArrayOfVatRate
     */
    public function setVatRate(array $VatRate = null)
    {
      $this->VatRate = $VatRate;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->VatRate[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return VatRate
     */
    public function offsetGet($offset)
    {
      return $this->VatRate[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param VatRate $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->VatRate[] = $value;
      } else {
        $this->VatRate[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->VatRate[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return VatRate Return the current element
     */
    public function current()
    {
      return current($this->VatRate);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->VatRate);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->VatRate);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->VatRate);
    }

    /**
     * Countable implementation
     *
     * @return VatRate Return count of elements
     */
    public function count()
    {
      return count($this->VatRate);
    }

}
