<?php

namespace Eurostop\Organisation;

class ArrayOfTenderTypeCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TenderType[] $TenderType
     */
    protected $TenderType = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return TenderType[]
     */
    public function getTenderType()
    {
      return $this->TenderType;
    }

    /**
     * @param TenderType[] $TenderType
     * @return \Eurostop\Organisation\ArrayOfTenderType
     */
    public function setTenderType(array $TenderType = null)
    {
      $this->TenderType = $TenderType;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->TenderType[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TenderType
     */
    public function offsetGet($offset)
    {
      return $this->TenderType[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TenderType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->TenderType[] = $value;
      } else {
        $this->TenderType[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->TenderType[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TenderType Return the current element
     */
    public function current()
    {
      return current($this->TenderType);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->TenderType);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->TenderType);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->TenderType);
    }

    /**
     * Countable implementation
     *
     * @return TenderType Return count of elements
     */
    public function count()
    {
      return count($this->TenderType);
    }

}
