<?php

namespace Eurostop\Organisation;

class ArrayOfCountryCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Country[] $Country
     */
    protected $Country = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Country[]
     */
    public function getCountry()
    {
      return $this->Country;
    }

    /**
     * @param Country[] $Country
     * @return \Eurostop\Organisation\ArrayOfCountry
     */
    public function setCountry(array $Country = null)
    {
      $this->Country = $Country;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Country[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Country
     */
    public function offsetGet($offset)
    {
      return $this->Country[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Country $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Country[] = $value;
      } else {
        $this->Country[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Country[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Country Return the current element
     */
    public function current()
    {
      return current($this->Country);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Country);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Country);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Country);
    }

    /**
     * Countable implementation
     *
     * @return Country Return count of elements
     */
    public function count()
    {
      return count($this->Country);
    }

}
