<?php

namespace Eurostop\Organisation;

class ArrayOfBranchGroup implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var BranchGroup[] $BranchGroup
     */
    protected $BranchGroup = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return BranchGroup[]
     */
    public function getBranchGroup()
    {
      return $this->BranchGroup;
    }

    /**
     * @param BranchGroup[] $BranchGroup
     * @return \Eurostop\Organisation\ArrayOfBranchGroup
     */
    public function setBranchGroup(array $BranchGroup = null)
    {
      $this->BranchGroup = $BranchGroup;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->BranchGroup[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return BranchGroup
     */
    public function offsetGet($offset)
    {
      return $this->BranchGroup[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param BranchGroup $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->BranchGroup[] = $value;
      } else {
        $this->BranchGroup[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->BranchGroup[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return BranchGroup Return the current element
     */
    public function current()
    {
      return current($this->BranchGroup);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->BranchGroup);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->BranchGroup);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->BranchGroup);
    }

    /**
     * Countable implementation
     *
     * @return BranchGroup Return count of elements
     */
    public function count()
    {
      return count($this->BranchGroup);
    }

}
