<?php

namespace Eurostop\Loyalty;

class SubmittedCustomerAccountCustom extends SubmittedDataItemOfSubmittedCustomerAccountDtoKJ8WzcEXCustom
{

    /**
     * @var string $AccountIdentifier
     */
    protected $AccountIdentifier = null;

    /**
     * @var CustomerAccountIdentifierType $AccountIdentifierType
     */
    protected $AccountIdentifierType = null;

    /**
     * @var string $AccountTypeIdentifier
     */
    protected $AccountTypeIdentifier = null;

    /**
     * @var CustomerAccountTypeIdentifierType $AccountTypeIdentifierType
     */
    protected $AccountTypeIdentifierType = null;

    /**
     * @param CustomerAccountIdentifierType $AccountIdentifierType
     * @param CustomerAccountTypeIdentifierType $AccountTypeIdentifierType
     */
    public function __construct($AccountIdentifierType, $AccountTypeIdentifierType)
    {
      parent::__construct();
      $this->AccountIdentifierType = $AccountIdentifierType;
      $this->AccountTypeIdentifierType = $AccountTypeIdentifierType;
    }

    /**
     * @return string
     */
    public function getAccountIdentifier()
    {
      return $this->AccountIdentifier;
    }

    /**
     * @param string $AccountIdentifier
     * @return \Eurostop\Loyalty\SubmittedCustomerAccount
     */
    public function setAccountIdentifier($AccountIdentifier)
    {
      $this->AccountIdentifier = $AccountIdentifier;
      return $this;
    }

    /**
     * @return CustomerAccountIdentifierType
     */
    public function getAccountIdentifierType()
    {
      return $this->AccountIdentifierType;
    }

    /**
     * @param CustomerAccountIdentifierType $AccountIdentifierType
     * @return \Eurostop\Loyalty\SubmittedCustomerAccount
     */
    public function setAccountIdentifierType($AccountIdentifierType)
    {
      $this->AccountIdentifierType = $AccountIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAccountTypeIdentifier()
    {
      return $this->AccountTypeIdentifier;
    }

    /**
     * @param string $AccountTypeIdentifier
     * @return \Eurostop\Loyalty\SubmittedCustomerAccount
     */
    public function setAccountTypeIdentifier($AccountTypeIdentifier)
    {
      $this->AccountTypeIdentifier = $AccountTypeIdentifier;
      return $this;
    }

    /**
     * @return CustomerAccountTypeIdentifierType
     */
    public function getAccountTypeIdentifierType()
    {
      return $this->AccountTypeIdentifierType;
    }

    /**
     * @param CustomerAccountTypeIdentifierType $AccountTypeIdentifierType
     * @return \Eurostop\Loyalty\SubmittedCustomerAccount
     */
    public function setAccountTypeIdentifierType($AccountTypeIdentifierType)
    {
      $this->AccountTypeIdentifierType = $AccountTypeIdentifierType;
      return $this;
    }

}
