<?php

namespace Eurostop\Loyalty;

class SubmitCustomersCustom
{

    /**
     * @var ArrayOfSubmittedCustomer $customers
     */
    protected $customers = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedCustomer $customers
     * @param string $submissionReference
     */
    public function __construct($customers, $submissionReference)
    {
      $this->customers = $customers;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedCustomer
     */
    public function getCustomers()
    {
      return $this->customers;
    }

    /**
     * @param ArrayOfSubmittedCustomer $customers
     * @return \Eurostop\Loyalty\SubmitCustomers
     */
    public function setCustomers($customers)
    {
      $this->customers = $customers;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Loyalty\SubmitCustomers
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
