<?php

namespace Eurostop\Loyalty;

class GetCustomersByAttribute
{

    /**
     * @var string $attributeIdentifier
     */
    protected $attributeIdentifier = null;

    /**
     * @var CustomerAttributeIdentifierType $attributeIdentifierType
     */
    protected $attributeIdentifierType = null;

    /**
     * @var string $attributeValue
     */
    protected $attributeValue = null;

    /**
     * @param string $attributeIdentifier
     * @param CustomerAttributeIdentifierType $attributeIdentifierType
     * @param string $attributeValue
     */
    public function __construct($attributeIdentifier = null, $attributeIdentifierType = null, $attributeValue = null)
    {
      $this->attributeIdentifier = $attributeIdentifier;
      $this->attributeIdentifierType = $attributeIdentifierType;
      $this->attributeValue = $attributeValue;
    }

    /**
     * @return string
     */
    public function getAttributeIdentifier()
    {
      return $this->attributeIdentifier;
    }

    /**
     * @param string $attributeIdentifier
     * @return \Eurostop\Loyalty\GetCustomersByAttribute
     */
    public function setAttributeIdentifier($attributeIdentifier)
    {
      $this->attributeIdentifier = $attributeIdentifier;
      return $this;
    }

    /**
     * @return CustomerAttributeIdentifierType
     */
    public function getAttributeIdentifierType()
    {
      return $this->attributeIdentifierType;
    }

    /**
     * @param CustomerAttributeIdentifierType $attributeIdentifierType
     * @return \Eurostop\Loyalty\GetCustomersByAttribute
     */
    public function setAttributeIdentifierType($attributeIdentifierType)
    {
      $this->attributeIdentifierType = $attributeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAttributeValue()
    {
      return $this->attributeValue;
    }

    /**
     * @param string $attributeValue
     * @return \Eurostop\Loyalty\GetCustomersByAttribute
     */
    public function setAttributeValue($attributeValue)
    {
      $this->attributeValue = $attributeValue;
      return $this;
    }

}
