<?php

namespace Eurostop\Loyalty;

class ArrayOfCustomerAccount implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var CustomerAccount[] $CustomerAccount
     */
    protected $CustomerAccount = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return CustomerAccount[]
     */
    public function getCustomerAccount()
    {
      return $this->CustomerAccount;
    }

    /**
     * @param CustomerAccount[] $CustomerAccount
     * @return \Eurostop\Loyalty\ArrayOfCustomerAccount
     */
    public function setCustomerAccount(array $CustomerAccount = null)
    {
      $this->CustomerAccount = $CustomerAccount;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->CustomerAccount[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return CustomerAccount
     */
    public function offsetGet($offset)
    {
      return $this->CustomerAccount[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param CustomerAccount $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->CustomerAccount[] = $value;
      } else {
        $this->CustomerAccount[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->CustomerAccount[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return CustomerAccount Return the current element
     */
    public function current()
    {
      return current($this->CustomerAccount);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->CustomerAccount);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->CustomerAccount);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->CustomerAccount);
    }

    /**
     * Countable implementation
     *
     * @return CustomerAccount Return count of elements
     */
    public function count()
    {
      return count($this->CustomerAccount);
    }

}
