<?php

namespace Eurostop\Fulfilment;

class SubmittedCustomerOrderLineCustom extends SubmittedDataItemOfSubmittedCustomerOrderLineDtoHay9ORuzCustom
{

    /**
     * @var \DateTime $CancellationDate
     */
    protected $CancellationDate = null;

    /**
     * @var int $LineNumber
     */
    protected $LineNumber = null;

    /**
     * @var int $QuantityOrdered
     */
    protected $QuantityOrdered = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @var float $UnitSoldValue
     */
    protected $UnitSoldValue = null;

    /**
     * @var float $VatValue
     */
    protected $VatValue = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return \DateTime
     */
    public function getCancellationDate()
    {
      if ($this->CancellationDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CancellationDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CancellationDate
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderLine
     */
    public function setCancellationDate(\DateTime $CancellationDate = null)
    {
      if ($CancellationDate == null) {
       $this->CancellationDate = null;
      } else {
        $this->CancellationDate = $CancellationDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getLineNumber()
    {
      return $this->LineNumber;
    }

    /**
     * @param int $LineNumber
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderLine
     */
    public function setLineNumber($LineNumber)
    {
      $this->LineNumber = $LineNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getQuantityOrdered()
    {
      return $this->QuantityOrdered;
    }

    /**
     * @param int $QuantityOrdered
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderLine
     */
    public function setQuantityOrdered($QuantityOrdered)
    {
      $this->QuantityOrdered = $QuantityOrdered;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderLine
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderLine
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitSoldValue()
    {
      return $this->UnitSoldValue;
    }

    /**
     * @param float $UnitSoldValue
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderLine
     */
    public function setUnitSoldValue($UnitSoldValue)
    {
      $this->UnitSoldValue = $UnitSoldValue;
      return $this;
    }

    /**
     * @return float
     */
    public function getVatValue()
    {
      return $this->VatValue;
    }

    /**
     * @param float $VatValue
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrderLine
     */
    public function setVatValue($VatValue)
    {
      $this->VatValue = $VatValue;
      return $this;
    }

}
