<?php

namespace Eurostop\Fulfilment;

class SubmitCustomerOrderShipment
{

    /**
     * @var SubmittedCustomerOrderShipment $customerOrderShipment
     */
    protected $customerOrderShipment = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedCustomerOrderShipment $customerOrderShipment
     * @param string $submissionReference
     */
    public function __construct($customerOrderShipment, $submissionReference)
    {
      $this->customerOrderShipment = $customerOrderShipment;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedCustomerOrderShipment
     */
    public function getCustomerOrderShipment()
    {
      return $this->customerOrderShipment;
    }

    /**
     * @param SubmittedCustomerOrderShipment $customerOrderShipment
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderShipment
     */
    public function setCustomerOrderShipment($customerOrderShipment)
    {
      $this->customerOrderShipment = $customerOrderShipment;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderShipment
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
