<?php

namespace Eurostop\Fulfilment;

class SubmitCustomerOrderAction
{

    /**
     * @var SubmittedCustomerOrderAction $customerOrderAction
     */
    protected $customerOrderAction = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedCustomerOrderAction $customerOrderAction
     * @param string $submissionReference
     */
    public function __construct($customerOrderAction, $submissionReference)
    {
      $this->customerOrderAction = $customerOrderAction;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedCustomerOrderAction
     */
    public function getCustomerOrderAction()
    {
      return $this->customerOrderAction;
    }

    /**
     * @param SubmittedCustomerOrderAction $customerOrderAction
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderAction
     */
    public function setCustomerOrderAction($customerOrderAction)
    {
      $this->customerOrderAction = $customerOrderAction;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Fulfilment\SubmitCustomerOrderAction
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
