<?php

namespace Eurostop\Fulfilment;

class GetCustomerOrdersByCustomerCreationDate
{

    /**
     * @var string $customerIdentifier
     */
    protected $customerIdentifier = null;

    /**
     * @var CustomerIdentifierType $customerIdentifierType
     */
    protected $customerIdentifierType = null;

    /**
     * @var \DateTime $fromDate
     */
    protected $fromDate = null;

    /**
     * @var \DateTime $toDate
     */
    protected $toDate = null;

    /**
     * @param string $customerIdentifier
     * @param CustomerIdentifierType $customerIdentifierType
     * @param \DateTime $fromDate
     * @param \DateTime $toDate
     */
    public function __construct($customerIdentifier, $customerIdentifierType, \DateTime $fromDate, \DateTime $toDate)
    {
      $this->customerIdentifier = $customerIdentifier;
      $this->customerIdentifierType = $customerIdentifierType;
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      $this->toDate = $toDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getCustomerIdentifier()
    {
      return $this->customerIdentifier;
    }

    /**
     * @param string $customerIdentifier
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByCustomerCreationDate
     */
    public function setCustomerIdentifier($customerIdentifier)
    {
      $this->customerIdentifier = $customerIdentifier;
      return $this;
    }

    /**
     * @return CustomerIdentifierType
     */
    public function getCustomerIdentifierType()
    {
      return $this->customerIdentifierType;
    }

    /**
     * @param CustomerIdentifierType $customerIdentifierType
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByCustomerCreationDate
     */
    public function setCustomerIdentifierType($customerIdentifierType)
    {
      $this->customerIdentifierType = $customerIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getFromDate()
    {
      if ($this->fromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->fromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $fromDate
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByCustomerCreationDate
     */
    public function setFromDate(\DateTime $fromDate)
    {
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getToDate()
    {
      if ($this->toDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->toDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $toDate
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByCustomerCreationDate
     */
    public function setToDate(\DateTime $toDate)
    {
      $this->toDate = $toDate->format(\DateTime::ATOM);
      return $this;
    }

}
