<?php

namespace Eurostop\Fulfilment;

class CustomerOrderFulfilmentPlanDetailCustom extends RetrievedDataItemOfCustomerOrderFulfilmentPlanDetailDtoHay9ORuzCustom
{

    /**
     * @var \DateTime $CancelledDate
     */
    protected $CancelledDate = null;

    /**
     * @var int $CancelledExternallyQuantity
     */
    protected $CancelledExternallyQuantity = null;

    /**
     * @var int $CancelledInternallyQuantity
     */
    protected $CancelledInternallyQuantity = null;

    /**
     * @var CustomerOrderItemPlanStatus $ItemStatus
     */
    protected $ItemStatus = null;

    /**
     * @var int $OrderLineNumber
     */
    protected $OrderLineNumber = null;

    /**
     * @var CustomerOrderItemPackStatus $PackStatus
     */
    protected $PackStatus = null;

    /**
     * @var CustomerOrderItemPickStatus $PickStatus
     */
    protected $PickStatus = null;

    /**
     * @var string $ProductIdentifier
     */
    protected $ProductIdentifier = null;

    /**
     * @var int $ReSourcedQuantity
     */
    protected $ReSourcedQuantity = null;

    /**
     * @var int $RequiredQuantity
     */
    protected $RequiredQuantity = null;

    /**
     * @var int $ShipmentNumber
     */
    protected $ShipmentNumber = null;

    /**
     * @var int $ShippedQuantity
     */
    protected $ShippedQuantity = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var string $SourceBranchIdentifier
     */
    protected $SourceBranchIdentifier = null;

    /**
     * @var int $TotalCancelledQuantity
     */
    protected $TotalCancelledQuantity = null;

    /**
     * @param int $CancelledExternallyQuantity
     * @param int $CancelledInternallyQuantity
     * @param int $OrderLineNumber
     * @param int $RequiredQuantity
     * @param int $ShippedQuantity
     * @param int $TotalCancelledQuantity
     */
    public function __construct($CancelledExternallyQuantity, $CancelledInternallyQuantity, $OrderLineNumber, $RequiredQuantity, $ShippedQuantity, $TotalCancelledQuantity)
    {
      parent::__construct();
      $this->CancelledExternallyQuantity = $CancelledExternallyQuantity;
      $this->CancelledInternallyQuantity = $CancelledInternallyQuantity;
      $this->OrderLineNumber = $OrderLineNumber;
      $this->RequiredQuantity = $RequiredQuantity;
      $this->ShippedQuantity = $ShippedQuantity;
      $this->TotalCancelledQuantity = $TotalCancelledQuantity;
    }

    /**
     * @return \DateTime
     */
    public function getCancelledDate()
    {
      if ($this->CancelledDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CancelledDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CancelledDate
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setCancelledDate(\DateTime $CancelledDate = null)
    {
      if ($CancelledDate == null) {
       $this->CancelledDate = null;
      } else {
        $this->CancelledDate = $CancelledDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getCancelledExternallyQuantity()
    {
      return $this->CancelledExternallyQuantity;
    }

    /**
     * @param int $CancelledExternallyQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setCancelledExternallyQuantity($CancelledExternallyQuantity)
    {
      $this->CancelledExternallyQuantity = $CancelledExternallyQuantity;
      return $this;
    }

    /**
     * @return int
     */
    public function getCancelledInternallyQuantity()
    {
      return $this->CancelledInternallyQuantity;
    }

    /**
     * @param int $CancelledInternallyQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setCancelledInternallyQuantity($CancelledInternallyQuantity)
    {
      $this->CancelledInternallyQuantity = $CancelledInternallyQuantity;
      return $this;
    }

    /**
     * @return CustomerOrderItemPlanStatus
     */
    public function getItemStatus()
    {
      return $this->ItemStatus;
    }

    /**
     * @param CustomerOrderItemPlanStatus $ItemStatus
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setItemStatus($ItemStatus)
    {
      $this->ItemStatus = $ItemStatus;
      return $this;
    }

    /**
     * @return int
     */
    public function getOrderLineNumber()
    {
      return $this->OrderLineNumber;
    }

    /**
     * @param int $OrderLineNumber
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setOrderLineNumber($OrderLineNumber)
    {
      $this->OrderLineNumber = $OrderLineNumber;
      return $this;
    }

    /**
     * @return CustomerOrderItemPackStatus
     */
    public function getPackStatus()
    {
      return $this->PackStatus;
    }

    /**
     * @param CustomerOrderItemPackStatus $PackStatus
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setPackStatus($PackStatus)
    {
      $this->PackStatus = $PackStatus;
      return $this;
    }

    /**
     * @return CustomerOrderItemPickStatus
     */
    public function getPickStatus()
    {
      return $this->PickStatus;
    }

    /**
     * @param CustomerOrderItemPickStatus $PickStatus
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setPickStatus($PickStatus)
    {
      $this->PickStatus = $PickStatus;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->ProductIdentifier;
    }

    /**
     * @param string $ProductIdentifier
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setProductIdentifier($ProductIdentifier)
    {
      $this->ProductIdentifier = $ProductIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getReSourcedQuantity()
    {
      return $this->ReSourcedQuantity;
    }

    /**
     * @param int $ReSourcedQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setReSourcedQuantity($ReSourcedQuantity)
    {
      $this->ReSourcedQuantity = $ReSourcedQuantity;
      return $this;
    }

    /**
     * @return int
     */
    public function getRequiredQuantity()
    {
      return $this->RequiredQuantity;
    }

    /**
     * @param int $RequiredQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setRequiredQuantity($RequiredQuantity)
    {
      $this->RequiredQuantity = $RequiredQuantity;
      return $this;
    }

    /**
     * @return int
     */
    public function getShipmentNumber()
    {
      return $this->ShipmentNumber;
    }

    /**
     * @param int $ShipmentNumber
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setShipmentNumber($ShipmentNumber)
    {
      $this->ShipmentNumber = $ShipmentNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getShippedQuantity()
    {
      return $this->ShippedQuantity;
    }

    /**
     * @param int $ShippedQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setShippedQuantity($ShippedQuantity)
    {
      $this->ShippedQuantity = $ShippedQuantity;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSourceBranchIdentifier()
    {
      return $this->SourceBranchIdentifier;
    }

    /**
     * @param string $SourceBranchIdentifier
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setSourceBranchIdentifier($SourceBranchIdentifier)
    {
      $this->SourceBranchIdentifier = $SourceBranchIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getTotalCancelledQuantity()
    {
      return $this->TotalCancelledQuantity;
    }

    /**
     * @param int $TotalCancelledQuantity
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlanDetail
     */
    public function setTotalCancelledQuantity($TotalCancelledQuantity)
    {
      $this->TotalCancelledQuantity = $TotalCancelledQuantity;
      return $this;
    }

}
