<?php

namespace Eurostop\Fulfilment;

class CustomerOrderFulfilmentPlan extends RetrievedDataItemOfCustomerOrderFulfilmentPlanDtoHay9ORuz
{

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var ArrayOfCustomerOrderFulfilmentPlanDetail $Details
     */
    protected $Details = null;

    /**
     * @var boolean $IsManuallyGenerated
     */
    protected $IsManuallyGenerated = null;

    /**
     * @var \DateTime $ModifiedDate
     */
    protected $ModifiedDate = null;

    /**
     * @var int $PlanNumber
     */
    protected $PlanNumber = null;

    /**
     * @var CustomerOrderFulfilmentPlanStatus $PlanStatus
     */
    protected $PlanStatus = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setCreatedDate(\DateTime $CreatedDate = null)
    {
      if ($CreatedDate == null) {
       $this->CreatedDate = null;
      } else {
        $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderFulfilmentPlanDetail
     */
    public function getDetails()
    {
      return $this->Details;
    }

    /**
     * @param ArrayOfCustomerOrderFulfilmentPlanDetail $Details
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setDetails($Details)
    {
      $this->Details = $Details;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsManuallyGenerated()
    {
      return $this->IsManuallyGenerated;
    }

    /**
     * @param boolean $IsManuallyGenerated
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setIsManuallyGenerated($IsManuallyGenerated)
    {
      $this->IsManuallyGenerated = $IsManuallyGenerated;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedDate()
    {
      if ($this->ModifiedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ModifiedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ModifiedDate
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setModifiedDate(\DateTime $ModifiedDate = null)
    {
      if ($ModifiedDate == null) {
       $this->ModifiedDate = null;
      } else {
        $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getPlanNumber()
    {
      return $this->PlanNumber;
    }

    /**
     * @param int $PlanNumber
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setPlanNumber($PlanNumber)
    {
      $this->PlanNumber = $PlanNumber;
      return $this;
    }

    /**
     * @return CustomerOrderFulfilmentPlanStatus
     */
    public function getPlanStatus()
    {
      return $this->PlanStatus;
    }

    /**
     * @param CustomerOrderFulfilmentPlanStatus $PlanStatus
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setPlanStatus($PlanStatus)
    {
      $this->PlanStatus = $PlanStatus;
      return $this;
    }

}
