<?php
/**
 * ShopShippingProfileUpgrade
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ShopShippingProfileUpgrade Class Doc Comment
 *
 * @category Class
 * @description A representation of a shipping profile upgrade option.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShopShippingProfileUpgrade implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShopShippingProfileUpgrade';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'shipping_profile_id' => 'int',
        'upgrade_id' => 'int',
        'upgrade_name' => 'string',
        'type' => 'string',
        'rank' => 'int',
        'language' => 'string',
        'price' => '\Etsy\Model\ShopShippingProfileUpgradePrice',
        'secondary_price' => '\Etsy\Model\ShopShippingProfileUpgradeSecondaryPrice',
        'shipping_carrier_id' => 'int',
        'mail_class' => 'string',
        'min_delivery_days' => 'int',
        'max_delivery_days' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'shipping_profile_id' => null,
        'upgrade_id' => null,
        'upgrade_name' => null,
        'type' => null,
        'rank' => null,
        'language' => null,
        'price' => null,
        'secondary_price' => null,
        'shipping_carrier_id' => null,
        'mail_class' => null,
        'min_delivery_days' => null,
        'max_delivery_days' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'shipping_profile_id' => false,
		'upgrade_id' => false,
		'upgrade_name' => false,
		'type' => false,
		'rank' => false,
		'language' => false,
		'price' => false,
		'secondary_price' => false,
		'shipping_carrier_id' => true,
		'mail_class' => true,
		'min_delivery_days' => true,
		'max_delivery_days' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shipping_profile_id' => 'shipping_profile_id',
        'upgrade_id' => 'upgrade_id',
        'upgrade_name' => 'upgrade_name',
        'type' => 'type',
        'rank' => 'rank',
        'language' => 'language',
        'price' => 'price',
        'secondary_price' => 'secondary_price',
        'shipping_carrier_id' => 'shipping_carrier_id',
        'mail_class' => 'mail_class',
        'min_delivery_days' => 'min_delivery_days',
        'max_delivery_days' => 'max_delivery_days'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shipping_profile_id' => 'setShippingProfileId',
        'upgrade_id' => 'setUpgradeId',
        'upgrade_name' => 'setUpgradeName',
        'type' => 'setType',
        'rank' => 'setRank',
        'language' => 'setLanguage',
        'price' => 'setPrice',
        'secondary_price' => 'setSecondaryPrice',
        'shipping_carrier_id' => 'setShippingCarrierId',
        'mail_class' => 'setMailClass',
        'min_delivery_days' => 'setMinDeliveryDays',
        'max_delivery_days' => 'setMaxDeliveryDays'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shipping_profile_id' => 'getShippingProfileId',
        'upgrade_id' => 'getUpgradeId',
        'upgrade_name' => 'getUpgradeName',
        'type' => 'getType',
        'rank' => 'getRank',
        'language' => 'getLanguage',
        'price' => 'getPrice',
        'secondary_price' => 'getSecondaryPrice',
        'shipping_carrier_id' => 'getShippingCarrierId',
        'mail_class' => 'getMailClass',
        'min_delivery_days' => 'getMinDeliveryDays',
        'max_delivery_days' => 'getMaxDeliveryDays'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE__0 = '0';
    public const TYPE__1 = '1';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE__0,
            self::TYPE__1,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('shipping_profile_id', $data ?? [], null);
        $this->setIfExists('upgrade_id', $data ?? [], null);
        $this->setIfExists('upgrade_name', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('rank', $data ?? [], null);
        $this->setIfExists('language', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('secondary_price', $data ?? [], null);
        $this->setIfExists('shipping_carrier_id', $data ?? [], null);
        $this->setIfExists('mail_class', $data ?? [], null);
        $this->setIfExists('min_delivery_days', $data ?? [], null);
        $this->setIfExists('max_delivery_days', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['shipping_profile_id']) && ($this->container['shipping_profile_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shipping_profile_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['upgrade_id']) && ($this->container['upgrade_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'upgrade_id', must be bigger than or equal to 1.";
        }

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['rank']) && ($this->container['rank'] < 0)) {
            $invalidProperties[] = "invalid value for 'rank', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['min_delivery_days']) && ($this->container['min_delivery_days'] > 45)) {
            $invalidProperties[] = "invalid value for 'min_delivery_days', must be smaller than or equal to 45.";
        }

        if (!is_null($this->container['min_delivery_days']) && ($this->container['min_delivery_days'] < 1)) {
            $invalidProperties[] = "invalid value for 'min_delivery_days', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['max_delivery_days']) && ($this->container['max_delivery_days'] > 45)) {
            $invalidProperties[] = "invalid value for 'max_delivery_days', must be smaller than or equal to 45.";
        }

        if (!is_null($this->container['max_delivery_days']) && ($this->container['max_delivery_days'] < 1)) {
            $invalidProperties[] = "invalid value for 'max_delivery_days', must be bigger than or equal to 1.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shipping_profile_id
     *
     * @return int|null
     */
    public function getShippingProfileId()
    {
        return $this->container['shipping_profile_id'];
    }

    /**
     * Sets shipping_profile_id
     *
     * @param int|null $shipping_profile_id The numeric ID of the base shipping profile.
     *
     * @return self
     */
    public function setShippingProfileId($shipping_profile_id)
    {
        if (is_null($shipping_profile_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_profile_id cannot be null');
        }

        if (($shipping_profile_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shipping_profile_id when calling ShopShippingProfileUpgrade., must be bigger than or equal to 1.');
        }

        $this->container['shipping_profile_id'] = $shipping_profile_id;

        return $this;
    }

    /**
     * Gets upgrade_id
     *
     * @return int|null
     */
    public function getUpgradeId()
    {
        return $this->container['upgrade_id'];
    }

    /**
     * Sets upgrade_id
     *
     * @param int|null $upgrade_id The numeric ID that is associated with a shipping upgrade
     *
     * @return self
     */
    public function setUpgradeId($upgrade_id)
    {
        if (is_null($upgrade_id)) {
            throw new \InvalidArgumentException('non-nullable upgrade_id cannot be null');
        }

        if (($upgrade_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $upgrade_id when calling ShopShippingProfileUpgrade., must be bigger than or equal to 1.');
        }

        $this->container['upgrade_id'] = $upgrade_id;

        return $this;
    }

    /**
     * Gets upgrade_name
     *
     * @return string|null
     */
    public function getUpgradeName()
    {
        return $this->container['upgrade_name'];
    }

    /**
     * Sets upgrade_name
     *
     * @param string|null $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority.
     *
     * @return self
     */
    public function setUpgradeName($upgrade_name)
    {
        if (is_null($upgrade_name)) {
            throw new \InvalidArgumentException('non-nullable upgrade_name cannot be null');
        }
        $this->container['upgrade_name'] = $upgrade_name;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The type of the shipping upgrade. Domestic (0) or international (1).
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets rank
     *
     * @return int|null
     */
    public function getRank()
    {
        return $this->container['rank'];
    }

    /**
     * Sets rank
     *
     * @param int|null $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing.
     *
     * @return self
     */
    public function setRank($rank)
    {
        if (is_null($rank)) {
            throw new \InvalidArgumentException('non-nullable rank cannot be null');
        }

        if (($rank < 0)) {
            throw new \InvalidArgumentException('invalid value for $rank when calling ShopShippingProfileUpgrade., must be bigger than or equal to 0.');
        }

        $this->container['rank'] = $rank;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string|null $language The IETF language tag for the language of the shipping profile. Ex: `de`, `en`, `es`, `fr`, `it`, `ja`, `nl`, `pl`, `pt`
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            throw new \InvalidArgumentException('non-nullable language cannot be null');
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets price
     *
     * @return \Etsy\Model\ShopShippingProfileUpgradePrice|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param \Etsy\Model\ShopShippingProfileUpgradePrice|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets secondary_price
     *
     * @return \Etsy\Model\ShopShippingProfileUpgradeSecondaryPrice|null
     */
    public function getSecondaryPrice()
    {
        return $this->container['secondary_price'];
    }

    /**
     * Sets secondary_price
     *
     * @param \Etsy\Model\ShopShippingProfileUpgradeSecondaryPrice|null $secondary_price secondary_price
     *
     * @return self
     */
    public function setSecondaryPrice($secondary_price)
    {
        if (is_null($secondary_price)) {
            throw new \InvalidArgumentException('non-nullable secondary_price cannot be null');
        }
        $this->container['secondary_price'] = $secondary_price;

        return $this;
    }

    /**
     * Gets shipping_carrier_id
     *
     * @return int|null
     */
    public function getShippingCarrierId()
    {
        return $this->container['shipping_carrier_id'];
    }

    /**
     * Sets shipping_carrier_id
     *
     * @param int|null $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with `mail_class`** if `min_delivery_days` and `max_delivery_days` are null.
     *
     * @return self
     */
    public function setShippingCarrierId($shipping_carrier_id)
    {
        if (is_null($shipping_carrier_id)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_carrier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_carrier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shipping_carrier_id'] = $shipping_carrier_id;

        return $this;
    }

    /**
     * Gets mail_class
     *
     * @return string|null
     */
    public function getMailClass()
    {
        return $this->container['mail_class'];
    }

    /**
     * Sets mail_class
     *
     * @param string|null $mail_class The unique ID string of a shipping carrier's mail class, which is used to calculate an estimated delivery date. **Required with `shipping_carrier_id`** if `min_delivery_days` and `max_delivery_days` are null.
     *
     * @return self
     */
    public function setMailClass($mail_class)
    {
        if (is_null($mail_class)) {
            array_push($this->openAPINullablesSetToNull, 'mail_class');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('mail_class', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['mail_class'] = $mail_class;

        return $this;
    }

    /**
     * Gets min_delivery_days
     *
     * @return int|null
     */
    public function getMinDeliveryDays()
    {
        return $this->container['min_delivery_days'];
    }

    /**
     * Sets min_delivery_days
     *
     * @param int|null $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with `max_delivery_days`** if `mail_class` is null.
     *
     * @return self
     */
    public function setMinDeliveryDays($min_delivery_days)
    {
        if (is_null($min_delivery_days)) {
            array_push($this->openAPINullablesSetToNull, 'min_delivery_days');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('min_delivery_days', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($min_delivery_days) && ($min_delivery_days > 45)) {
            throw new \InvalidArgumentException('invalid value for $min_delivery_days when calling ShopShippingProfileUpgrade., must be smaller than or equal to 45.');
        }
        if (!is_null($min_delivery_days) && ($min_delivery_days < 1)) {
            throw new \InvalidArgumentException('invalid value for $min_delivery_days when calling ShopShippingProfileUpgrade., must be bigger than or equal to 1.');
        }

        $this->container['min_delivery_days'] = $min_delivery_days;

        return $this;
    }

    /**
     * Gets max_delivery_days
     *
     * @return int|null
     */
    public function getMaxDeliveryDays()
    {
        return $this->container['max_delivery_days'];
    }

    /**
     * Sets max_delivery_days
     *
     * @param int|null $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with `min_delivery_days`** if `mail_class` is null.
     *
     * @return self
     */
    public function setMaxDeliveryDays($max_delivery_days)
    {
        if (is_null($max_delivery_days)) {
            array_push($this->openAPINullablesSetToNull, 'max_delivery_days');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('max_delivery_days', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($max_delivery_days) && ($max_delivery_days > 45)) {
            throw new \InvalidArgumentException('invalid value for $max_delivery_days when calling ShopShippingProfileUpgrade., must be smaller than or equal to 45.');
        }
        if (!is_null($max_delivery_days) && ($max_delivery_days < 1)) {
            throw new \InvalidArgumentException('invalid value for $max_delivery_days when calling ShopShippingProfileUpgrade., must be bigger than or equal to 1.');
        }

        $this->container['max_delivery_days'] = $max_delivery_days;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


