<?php
/**
 * ShopShippingProfileDestination
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ShopShippingProfileDestination Class Doc Comment
 *
 * @category Class
 * @description Represents a shipping destination assigned to a shipping profile.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShopShippingProfileDestination implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShopShippingProfileDestination';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'shipping_profile_destination_id' => 'int',
        'shipping_profile_id' => 'int',
        'origin_country_iso' => 'string',
        'destination_country_iso' => 'string',
        'destination_region' => 'string',
        'primary_cost' => '\Etsy\Model\ShopShippingProfileDestinationPrimaryCost',
        'secondary_cost' => '\Etsy\Model\ShopShippingProfileDestinationSecondaryCost',
        'shipping_carrier_id' => 'int',
        'mail_class' => 'string',
        'min_delivery_days' => 'int',
        'max_delivery_days' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'shipping_profile_destination_id' => null,
        'shipping_profile_id' => null,
        'origin_country_iso' => 'ISO 3166-1 alpha-2',
        'destination_country_iso' => null,
        'destination_region' => null,
        'primary_cost' => null,
        'secondary_cost' => null,
        'shipping_carrier_id' => null,
        'mail_class' => null,
        'min_delivery_days' => null,
        'max_delivery_days' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'shipping_profile_destination_id' => false,
		'shipping_profile_id' => false,
		'origin_country_iso' => false,
		'destination_country_iso' => false,
		'destination_region' => false,
		'primary_cost' => false,
		'secondary_cost' => false,
		'shipping_carrier_id' => true,
		'mail_class' => true,
		'min_delivery_days' => true,
		'max_delivery_days' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shipping_profile_destination_id' => 'shipping_profile_destination_id',
        'shipping_profile_id' => 'shipping_profile_id',
        'origin_country_iso' => 'origin_country_iso',
        'destination_country_iso' => 'destination_country_iso',
        'destination_region' => 'destination_region',
        'primary_cost' => 'primary_cost',
        'secondary_cost' => 'secondary_cost',
        'shipping_carrier_id' => 'shipping_carrier_id',
        'mail_class' => 'mail_class',
        'min_delivery_days' => 'min_delivery_days',
        'max_delivery_days' => 'max_delivery_days'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shipping_profile_destination_id' => 'setShippingProfileDestinationId',
        'shipping_profile_id' => 'setShippingProfileId',
        'origin_country_iso' => 'setOriginCountryIso',
        'destination_country_iso' => 'setDestinationCountryIso',
        'destination_region' => 'setDestinationRegion',
        'primary_cost' => 'setPrimaryCost',
        'secondary_cost' => 'setSecondaryCost',
        'shipping_carrier_id' => 'setShippingCarrierId',
        'mail_class' => 'setMailClass',
        'min_delivery_days' => 'setMinDeliveryDays',
        'max_delivery_days' => 'setMaxDeliveryDays'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shipping_profile_destination_id' => 'getShippingProfileDestinationId',
        'shipping_profile_id' => 'getShippingProfileId',
        'origin_country_iso' => 'getOriginCountryIso',
        'destination_country_iso' => 'getDestinationCountryIso',
        'destination_region' => 'getDestinationRegion',
        'primary_cost' => 'getPrimaryCost',
        'secondary_cost' => 'getSecondaryCost',
        'shipping_carrier_id' => 'getShippingCarrierId',
        'mail_class' => 'getMailClass',
        'min_delivery_days' => 'getMinDeliveryDays',
        'max_delivery_days' => 'getMaxDeliveryDays'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const DESTINATION_REGION_EU = 'eu';
    public const DESTINATION_REGION_NON_EU = 'non_eu';
    public const DESTINATION_REGION_NONE = 'none';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDestinationRegionAllowableValues()
    {
        return [
            self::DESTINATION_REGION_EU,
            self::DESTINATION_REGION_NON_EU,
            self::DESTINATION_REGION_NONE,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('shipping_profile_destination_id', $data ?? [], null);
        $this->setIfExists('shipping_profile_id', $data ?? [], null);
        $this->setIfExists('origin_country_iso', $data ?? [], null);
        $this->setIfExists('destination_country_iso', $data ?? [], null);
        $this->setIfExists('destination_region', $data ?? [], null);
        $this->setIfExists('primary_cost', $data ?? [], null);
        $this->setIfExists('secondary_cost', $data ?? [], null);
        $this->setIfExists('shipping_carrier_id', $data ?? [], null);
        $this->setIfExists('mail_class', $data ?? [], null);
        $this->setIfExists('min_delivery_days', $data ?? [], null);
        $this->setIfExists('max_delivery_days', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['shipping_profile_destination_id']) && ($this->container['shipping_profile_destination_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shipping_profile_destination_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['shipping_profile_id']) && ($this->container['shipping_profile_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shipping_profile_id', must be bigger than or equal to 1.";
        }

        $allowedValues = $this->getDestinationRegionAllowableValues();
        if (!is_null($this->container['destination_region']) && !in_array($this->container['destination_region'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'destination_region', must be one of '%s'",
                $this->container['destination_region'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['min_delivery_days']) && ($this->container['min_delivery_days'] > 45)) {
            $invalidProperties[] = "invalid value for 'min_delivery_days', must be smaller than or equal to 45.";
        }

        if (!is_null($this->container['min_delivery_days']) && ($this->container['min_delivery_days'] < 1)) {
            $invalidProperties[] = "invalid value for 'min_delivery_days', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['max_delivery_days']) && ($this->container['max_delivery_days'] > 45)) {
            $invalidProperties[] = "invalid value for 'max_delivery_days', must be smaller than or equal to 45.";
        }

        if (!is_null($this->container['max_delivery_days']) && ($this->container['max_delivery_days'] < 1)) {
            $invalidProperties[] = "invalid value for 'max_delivery_days', must be bigger than or equal to 1.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shipping_profile_destination_id
     *
     * @return int|null
     */
    public function getShippingProfileDestinationId()
    {
        return $this->container['shipping_profile_destination_id'];
    }

    /**
     * Sets shipping_profile_destination_id
     *
     * @param int|null $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing.
     *
     * @return self
     */
    public function setShippingProfileDestinationId($shipping_profile_destination_id)
    {
        if (is_null($shipping_profile_destination_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_profile_destination_id cannot be null');
        }

        if (($shipping_profile_destination_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shipping_profile_destination_id when calling ShopShippingProfileDestination., must be bigger than or equal to 1.');
        }

        $this->container['shipping_profile_destination_id'] = $shipping_profile_destination_id;

        return $this;
    }

    /**
     * Gets shipping_profile_id
     *
     * @return int|null
     */
    public function getShippingProfileId()
    {
        return $this->container['shipping_profile_id'];
    }

    /**
     * Sets shipping_profile_id
     *
     * @param int|null $shipping_profile_id The numeric ID of the shipping profile.
     *
     * @return self
     */
    public function setShippingProfileId($shipping_profile_id)
    {
        if (is_null($shipping_profile_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_profile_id cannot be null');
        }

        if (($shipping_profile_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shipping_profile_id when calling ShopShippingProfileDestination., must be bigger than or equal to 1.');
        }

        $this->container['shipping_profile_id'] = $shipping_profile_id;

        return $this;
    }

    /**
     * Gets origin_country_iso
     *
     * @return string|null
     */
    public function getOriginCountryIso()
    {
        return $this->container['origin_country_iso'];
    }

    /**
     * Sets origin_country_iso
     *
     * @param string|null $origin_country_iso The ISO code of the country from which the listing ships.
     *
     * @return self
     */
    public function setOriginCountryIso($origin_country_iso)
    {
        if (is_null($origin_country_iso)) {
            throw new \InvalidArgumentException('non-nullable origin_country_iso cannot be null');
        }
        $this->container['origin_country_iso'] = $origin_country_iso;

        return $this;
    }

    /**
     * Gets destination_country_iso
     *
     * @return string|null
     */
    public function getDestinationCountryIso()
    {
        return $this->container['destination_country_iso'];
    }

    /**
     * Sets destination_country_iso
     *
     * @param string|null $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided.
     *
     * @return self
     */
    public function setDestinationCountryIso($destination_country_iso)
    {
        if (is_null($destination_country_iso)) {
            throw new \InvalidArgumentException('non-nullable destination_country_iso cannot be null');
        }
        $this->container['destination_country_iso'] = $destination_country_iso;

        return $this;
    }

    /**
     * Gets destination_region
     *
     * @return string|null
     */
    public function getDestinationRegion()
    {
        return $this->container['destination_region'];
    }

    /**
     * Sets destination_region
     *
     * @param string|null $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If \\`none\\`, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided.
     *
     * @return self
     */
    public function setDestinationRegion($destination_region)
    {
        if (is_null($destination_region)) {
            throw new \InvalidArgumentException('non-nullable destination_region cannot be null');
        }
        $allowedValues = $this->getDestinationRegionAllowableValues();
        if (!in_array($destination_region, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'destination_region', must be one of '%s'",
                    $destination_region,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['destination_region'] = $destination_region;

        return $this;
    }

    /**
     * Gets primary_cost
     *
     * @return \Etsy\Model\ShopShippingProfileDestinationPrimaryCost|null
     */
    public function getPrimaryCost()
    {
        return $this->container['primary_cost'];
    }

    /**
     * Sets primary_cost
     *
     * @param \Etsy\Model\ShopShippingProfileDestinationPrimaryCost|null $primary_cost primary_cost
     *
     * @return self
     */
    public function setPrimaryCost($primary_cost)
    {
        if (is_null($primary_cost)) {
            throw new \InvalidArgumentException('non-nullable primary_cost cannot be null');
        }
        $this->container['primary_cost'] = $primary_cost;

        return $this;
    }

    /**
     * Gets secondary_cost
     *
     * @return \Etsy\Model\ShopShippingProfileDestinationSecondaryCost|null
     */
    public function getSecondaryCost()
    {
        return $this->container['secondary_cost'];
    }

    /**
     * Sets secondary_cost
     *
     * @param \Etsy\Model\ShopShippingProfileDestinationSecondaryCost|null $secondary_cost secondary_cost
     *
     * @return self
     */
    public function setSecondaryCost($secondary_cost)
    {
        if (is_null($secondary_cost)) {
            throw new \InvalidArgumentException('non-nullable secondary_cost cannot be null');
        }
        $this->container['secondary_cost'] = $secondary_cost;

        return $this;
    }

    /**
     * Gets shipping_carrier_id
     *
     * @return int|null
     */
    public function getShippingCarrierId()
    {
        return $this->container['shipping_carrier_id'];
    }

    /**
     * Sets shipping_carrier_id
     *
     * @param int|null $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with `mail_class`** if `min_delivery_days` and `max_delivery_days` are null.
     *
     * @return self
     */
    public function setShippingCarrierId($shipping_carrier_id)
    {
        if (is_null($shipping_carrier_id)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_carrier_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_carrier_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shipping_carrier_id'] = $shipping_carrier_id;

        return $this;
    }

    /**
     * Gets mail_class
     *
     * @return string|null
     */
    public function getMailClass()
    {
        return $this->container['mail_class'];
    }

    /**
     * Sets mail_class
     *
     * @param string|null $mail_class The unique ID string of a shipping carrier's mail class, which is used to calculate an estimated delivery date. **Required with `shipping_carrier_id`** if `min_delivery_days` and `max_delivery_days` are null.
     *
     * @return self
     */
    public function setMailClass($mail_class)
    {
        if (is_null($mail_class)) {
            array_push($this->openAPINullablesSetToNull, 'mail_class');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('mail_class', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['mail_class'] = $mail_class;

        return $this;
    }

    /**
     * Gets min_delivery_days
     *
     * @return int|null
     */
    public function getMinDeliveryDays()
    {
        return $this->container['min_delivery_days'];
    }

    /**
     * Sets min_delivery_days
     *
     * @param int|null $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with `max_delivery_days`** if `mail_class` is null.
     *
     * @return self
     */
    public function setMinDeliveryDays($min_delivery_days)
    {
        if (is_null($min_delivery_days)) {
            array_push($this->openAPINullablesSetToNull, 'min_delivery_days');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('min_delivery_days', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($min_delivery_days) && ($min_delivery_days > 45)) {
            throw new \InvalidArgumentException('invalid value for $min_delivery_days when calling ShopShippingProfileDestination., must be smaller than or equal to 45.');
        }
        if (!is_null($min_delivery_days) && ($min_delivery_days < 1)) {
            throw new \InvalidArgumentException('invalid value for $min_delivery_days when calling ShopShippingProfileDestination., must be bigger than or equal to 1.');
        }

        $this->container['min_delivery_days'] = $min_delivery_days;

        return $this;
    }

    /**
     * Gets max_delivery_days
     *
     * @return int|null
     */
    public function getMaxDeliveryDays()
    {
        return $this->container['max_delivery_days'];
    }

    /**
     * Sets max_delivery_days
     *
     * @param int|null $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with `min_delivery_days`** if `mail_class` is null.
     *
     * @return self
     */
    public function setMaxDeliveryDays($max_delivery_days)
    {
        if (is_null($max_delivery_days)) {
            array_push($this->openAPINullablesSetToNull, 'max_delivery_days');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('max_delivery_days', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($max_delivery_days) && ($max_delivery_days > 45)) {
            throw new \InvalidArgumentException('invalid value for $max_delivery_days when calling ShopShippingProfileDestination., must be smaller than or equal to 45.');
        }
        if (!is_null($max_delivery_days) && ($max_delivery_days < 1)) {
            throw new \InvalidArgumentException('invalid value for $max_delivery_days when calling ShopShippingProfileDestination., must be bigger than or equal to 1.');
        }

        $this->container['max_delivery_days'] = $max_delivery_days;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


