<?php
/**
 * ShopListing
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ShopListing Class Doc Comment
 *
 * @category Class
 * @description A listing from a shop, which contains a product quantity, title, description, price, etc.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShopListing implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShopListing';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'listing_id' => 'int',
        'user_id' => 'int',
        'shop_id' => 'int',
        'title' => 'string',
        'description' => 'string',
        'state' => 'string',
        'creation_timestamp' => 'int',
        'created_timestamp' => 'int',
        'ending_timestamp' => 'int',
        'original_creation_timestamp' => 'int',
        'last_modified_timestamp' => 'int',
        'updated_timestamp' => 'int',
        'state_timestamp' => 'int',
        'quantity' => 'int',
        'shop_section_id' => 'int',
        'featured_rank' => 'int',
        'url' => 'string',
        'num_favorers' => 'int',
        'non_taxable' => 'bool',
        'is_taxable' => 'bool',
        'is_customizable' => 'bool',
        'is_personalizable' => 'bool',
        'personalization_is_required' => 'bool',
        'personalization_char_count_max' => 'int',
        'personalization_instructions' => 'string',
        'listing_type' => 'string',
        'tags' => 'string[]',
        'materials' => 'string[]',
        'shipping_profile_id' => 'int',
        'return_policy_id' => 'int',
        'processing_min' => 'int',
        'processing_max' => 'int',
        'who_made' => 'string',
        'when_made' => 'string',
        'is_supply' => 'bool',
        'item_weight' => 'float',
        'item_weight_unit' => 'string',
        'item_length' => 'float',
        'item_width' => 'float',
        'item_height' => 'float',
        'item_dimensions_unit' => 'string',
        'is_private' => 'bool',
        'style' => 'string[]',
        'file_data' => 'string',
        'has_variations' => 'bool',
        'should_auto_renew' => 'bool',
        'language' => 'string',
        'price' => '\Etsy\Model\ShopListingPrice',
        'taxonomy_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'listing_id' => null,
        'user_id' => null,
        'shop_id' => null,
        'title' => null,
        'description' => null,
        'state' => null,
        'creation_timestamp' => null,
        'created_timestamp' => null,
        'ending_timestamp' => null,
        'original_creation_timestamp' => null,
        'last_modified_timestamp' => null,
        'updated_timestamp' => null,
        'state_timestamp' => null,
        'quantity' => null,
        'shop_section_id' => null,
        'featured_rank' => null,
        'url' => null,
        'num_favorers' => null,
        'non_taxable' => null,
        'is_taxable' => null,
        'is_customizable' => null,
        'is_personalizable' => null,
        'personalization_is_required' => null,
        'personalization_char_count_max' => null,
        'personalization_instructions' => null,
        'listing_type' => null,
        'tags' => null,
        'materials' => null,
        'shipping_profile_id' => null,
        'return_policy_id' => null,
        'processing_min' => null,
        'processing_max' => null,
        'who_made' => null,
        'when_made' => null,
        'is_supply' => null,
        'item_weight' => 'float',
        'item_weight_unit' => null,
        'item_length' => 'float',
        'item_width' => 'float',
        'item_height' => 'float',
        'item_dimensions_unit' => null,
        'is_private' => null,
        'style' => null,
        'file_data' => null,
        'has_variations' => null,
        'should_auto_renew' => null,
        'language' => null,
        'price' => null,
        'taxonomy_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'listing_id' => false,
		'user_id' => false,
		'shop_id' => false,
		'title' => false,
		'description' => false,
		'state' => false,
		'creation_timestamp' => false,
		'created_timestamp' => false,
		'ending_timestamp' => false,
		'original_creation_timestamp' => false,
		'last_modified_timestamp' => false,
		'updated_timestamp' => false,
		'state_timestamp' => false,
		'quantity' => false,
		'shop_section_id' => true,
		'featured_rank' => false,
		'url' => false,
		'num_favorers' => false,
		'non_taxable' => false,
		'is_taxable' => false,
		'is_customizable' => false,
		'is_personalizable' => false,
		'personalization_is_required' => false,
		'personalization_char_count_max' => true,
		'personalization_instructions' => true,
		'listing_type' => false,
		'tags' => false,
		'materials' => false,
		'shipping_profile_id' => true,
		'return_policy_id' => true,
		'processing_min' => true,
		'processing_max' => true,
		'who_made' => true,
		'when_made' => true,
		'is_supply' => true,
		'item_weight' => true,
		'item_weight_unit' => true,
		'item_length' => true,
		'item_width' => true,
		'item_height' => true,
		'item_dimensions_unit' => true,
		'is_private' => false,
		'style' => false,
		'file_data' => false,
		'has_variations' => false,
		'should_auto_renew' => false,
		'language' => true,
		'price' => false,
		'taxonomy_id' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'listing_id' => 'listing_id',
        'user_id' => 'user_id',
        'shop_id' => 'shop_id',
        'title' => 'title',
        'description' => 'description',
        'state' => 'state',
        'creation_timestamp' => 'creation_timestamp',
        'created_timestamp' => 'created_timestamp',
        'ending_timestamp' => 'ending_timestamp',
        'original_creation_timestamp' => 'original_creation_timestamp',
        'last_modified_timestamp' => 'last_modified_timestamp',
        'updated_timestamp' => 'updated_timestamp',
        'state_timestamp' => 'state_timestamp',
        'quantity' => 'quantity',
        'shop_section_id' => 'shop_section_id',
        'featured_rank' => 'featured_rank',
        'url' => 'url',
        'num_favorers' => 'num_favorers',
        'non_taxable' => 'non_taxable',
        'is_taxable' => 'is_taxable',
        'is_customizable' => 'is_customizable',
        'is_personalizable' => 'is_personalizable',
        'personalization_is_required' => 'personalization_is_required',
        'personalization_char_count_max' => 'personalization_char_count_max',
        'personalization_instructions' => 'personalization_instructions',
        'listing_type' => 'listing_type',
        'tags' => 'tags',
        'materials' => 'materials',
        'shipping_profile_id' => 'shipping_profile_id',
        'return_policy_id' => 'return_policy_id',
        'processing_min' => 'processing_min',
        'processing_max' => 'processing_max',
        'who_made' => 'who_made',
        'when_made' => 'when_made',
        'is_supply' => 'is_supply',
        'item_weight' => 'item_weight',
        'item_weight_unit' => 'item_weight_unit',
        'item_length' => 'item_length',
        'item_width' => 'item_width',
        'item_height' => 'item_height',
        'item_dimensions_unit' => 'item_dimensions_unit',
        'is_private' => 'is_private',
        'style' => 'style',
        'file_data' => 'file_data',
        'has_variations' => 'has_variations',
        'should_auto_renew' => 'should_auto_renew',
        'language' => 'language',
        'price' => 'price',
        'taxonomy_id' => 'taxonomy_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'listing_id' => 'setListingId',
        'user_id' => 'setUserId',
        'shop_id' => 'setShopId',
        'title' => 'setTitle',
        'description' => 'setDescription',
        'state' => 'setState',
        'creation_timestamp' => 'setCreationTimestamp',
        'created_timestamp' => 'setCreatedTimestamp',
        'ending_timestamp' => 'setEndingTimestamp',
        'original_creation_timestamp' => 'setOriginalCreationTimestamp',
        'last_modified_timestamp' => 'setLastModifiedTimestamp',
        'updated_timestamp' => 'setUpdatedTimestamp',
        'state_timestamp' => 'setStateTimestamp',
        'quantity' => 'setQuantity',
        'shop_section_id' => 'setShopSectionId',
        'featured_rank' => 'setFeaturedRank',
        'url' => 'setUrl',
        'num_favorers' => 'setNumFavorers',
        'non_taxable' => 'setNonTaxable',
        'is_taxable' => 'setIsTaxable',
        'is_customizable' => 'setIsCustomizable',
        'is_personalizable' => 'setIsPersonalizable',
        'personalization_is_required' => 'setPersonalizationIsRequired',
        'personalization_char_count_max' => 'setPersonalizationCharCountMax',
        'personalization_instructions' => 'setPersonalizationInstructions',
        'listing_type' => 'setListingType',
        'tags' => 'setTags',
        'materials' => 'setMaterials',
        'shipping_profile_id' => 'setShippingProfileId',
        'return_policy_id' => 'setReturnPolicyId',
        'processing_min' => 'setProcessingMin',
        'processing_max' => 'setProcessingMax',
        'who_made' => 'setWhoMade',
        'when_made' => 'setWhenMade',
        'is_supply' => 'setIsSupply',
        'item_weight' => 'setItemWeight',
        'item_weight_unit' => 'setItemWeightUnit',
        'item_length' => 'setItemLength',
        'item_width' => 'setItemWidth',
        'item_height' => 'setItemHeight',
        'item_dimensions_unit' => 'setItemDimensionsUnit',
        'is_private' => 'setIsPrivate',
        'style' => 'setStyle',
        'file_data' => 'setFileData',
        'has_variations' => 'setHasVariations',
        'should_auto_renew' => 'setShouldAutoRenew',
        'language' => 'setLanguage',
        'price' => 'setPrice',
        'taxonomy_id' => 'setTaxonomyId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'listing_id' => 'getListingId',
        'user_id' => 'getUserId',
        'shop_id' => 'getShopId',
        'title' => 'getTitle',
        'description' => 'getDescription',
        'state' => 'getState',
        'creation_timestamp' => 'getCreationTimestamp',
        'created_timestamp' => 'getCreatedTimestamp',
        'ending_timestamp' => 'getEndingTimestamp',
        'original_creation_timestamp' => 'getOriginalCreationTimestamp',
        'last_modified_timestamp' => 'getLastModifiedTimestamp',
        'updated_timestamp' => 'getUpdatedTimestamp',
        'state_timestamp' => 'getStateTimestamp',
        'quantity' => 'getQuantity',
        'shop_section_id' => 'getShopSectionId',
        'featured_rank' => 'getFeaturedRank',
        'url' => 'getUrl',
        'num_favorers' => 'getNumFavorers',
        'non_taxable' => 'getNonTaxable',
        'is_taxable' => 'getIsTaxable',
        'is_customizable' => 'getIsCustomizable',
        'is_personalizable' => 'getIsPersonalizable',
        'personalization_is_required' => 'getPersonalizationIsRequired',
        'personalization_char_count_max' => 'getPersonalizationCharCountMax',
        'personalization_instructions' => 'getPersonalizationInstructions',
        'listing_type' => 'getListingType',
        'tags' => 'getTags',
        'materials' => 'getMaterials',
        'shipping_profile_id' => 'getShippingProfileId',
        'return_policy_id' => 'getReturnPolicyId',
        'processing_min' => 'getProcessingMin',
        'processing_max' => 'getProcessingMax',
        'who_made' => 'getWhoMade',
        'when_made' => 'getWhenMade',
        'is_supply' => 'getIsSupply',
        'item_weight' => 'getItemWeight',
        'item_weight_unit' => 'getItemWeightUnit',
        'item_length' => 'getItemLength',
        'item_width' => 'getItemWidth',
        'item_height' => 'getItemHeight',
        'item_dimensions_unit' => 'getItemDimensionsUnit',
        'is_private' => 'getIsPrivate',
        'style' => 'getStyle',
        'file_data' => 'getFileData',
        'has_variations' => 'getHasVariations',
        'should_auto_renew' => 'getShouldAutoRenew',
        'language' => 'getLanguage',
        'price' => 'getPrice',
        'taxonomy_id' => 'getTaxonomyId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STATE_ACTIVE = 'active';
    public const STATE_INACTIVE = 'inactive';
    public const STATE_SOLD_OUT = 'sold_out';
    public const STATE_DRAFT = 'draft';
    public const STATE_EXPIRED = 'expired';
    public const LISTING_TYPE_PHYSICAL = 'physical';
    public const LISTING_TYPE_DOWNLOAD = 'download';
    public const LISTING_TYPE_BOTH = 'both';
    public const WHO_MADE_I_DID = 'i_did';
    public const WHO_MADE_SOMEONE_ELSE = 'someone_else';
    public const WHO_MADE_COLLECTIVE = 'collective';
    public const WHEN_MADE_MADE_TO_ORDER = 'made_to_order';
    public const WHEN_MADE__2020_2023 = '2020_2023';
    public const WHEN_MADE__2010_2019 = '2010_2019';
    public const WHEN_MADE__2004_2009 = '2004_2009';
    public const WHEN_MADE_BEFORE_2004 = 'before_2004';
    public const WHEN_MADE__2000_2003 = '2000_2003';
    public const WHEN_MADE__1990S = '1990s';
    public const WHEN_MADE__1980S = '1980s';
    public const WHEN_MADE__1970S = '1970s';
    public const WHEN_MADE__1960S = '1960s';
    public const WHEN_MADE__1950S = '1950s';
    public const WHEN_MADE__1940S = '1940s';
    public const WHEN_MADE__1930S = '1930s';
    public const WHEN_MADE__1920S = '1920s';
    public const WHEN_MADE__1910S = '1910s';
    public const WHEN_MADE__1900S = '1900s';
    public const WHEN_MADE__1800S = '1800s';
    public const WHEN_MADE__1700S = '1700s';
    public const WHEN_MADE_BEFORE_1700 = 'before_1700';
    public const ITEM_WEIGHT_UNIT_OZ = 'oz';
    public const ITEM_WEIGHT_UNIT_LB = 'lb';
    public const ITEM_WEIGHT_UNIT_G = 'g';
    public const ITEM_WEIGHT_UNIT_KG = 'kg';
    public const ITEM_DIMENSIONS_UNIT_IN = 'in';
    public const ITEM_DIMENSIONS_UNIT_FT = 'ft';
    public const ITEM_DIMENSIONS_UNIT_MM = 'mm';
    public const ITEM_DIMENSIONS_UNIT_CM = 'cm';
    public const ITEM_DIMENSIONS_UNIT_M = 'm';
    public const ITEM_DIMENSIONS_UNIT_YD = 'yd';
    public const ITEM_DIMENSIONS_UNIT_INCHES = 'inches';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_SOLD_OUT,
            self::STATE_DRAFT,
            self::STATE_EXPIRED,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getListingTypeAllowableValues()
    {
        return [
            self::LISTING_TYPE_PHYSICAL,
            self::LISTING_TYPE_DOWNLOAD,
            self::LISTING_TYPE_BOTH,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getWhoMadeAllowableValues()
    {
        return [
            self::WHO_MADE_I_DID,
            self::WHO_MADE_SOMEONE_ELSE,
            self::WHO_MADE_COLLECTIVE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getWhenMadeAllowableValues()
    {
        return [
            self::WHEN_MADE_MADE_TO_ORDER,
            self::WHEN_MADE__2020_2023,
            self::WHEN_MADE__2010_2019,
            self::WHEN_MADE__2004_2009,
            self::WHEN_MADE_BEFORE_2004,
            self::WHEN_MADE__2000_2003,
            self::WHEN_MADE__1990S,
            self::WHEN_MADE__1980S,
            self::WHEN_MADE__1970S,
            self::WHEN_MADE__1960S,
            self::WHEN_MADE__1950S,
            self::WHEN_MADE__1940S,
            self::WHEN_MADE__1930S,
            self::WHEN_MADE__1920S,
            self::WHEN_MADE__1910S,
            self::WHEN_MADE__1900S,
            self::WHEN_MADE__1800S,
            self::WHEN_MADE__1700S,
            self::WHEN_MADE_BEFORE_1700,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getItemWeightUnitAllowableValues()
    {
        return [
            self::ITEM_WEIGHT_UNIT_OZ,
            self::ITEM_WEIGHT_UNIT_LB,
            self::ITEM_WEIGHT_UNIT_G,
            self::ITEM_WEIGHT_UNIT_KG,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getItemDimensionsUnitAllowableValues()
    {
        return [
            self::ITEM_DIMENSIONS_UNIT_IN,
            self::ITEM_DIMENSIONS_UNIT_FT,
            self::ITEM_DIMENSIONS_UNIT_MM,
            self::ITEM_DIMENSIONS_UNIT_CM,
            self::ITEM_DIMENSIONS_UNIT_M,
            self::ITEM_DIMENSIONS_UNIT_YD,
            self::ITEM_DIMENSIONS_UNIT_INCHES,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('listing_id', $data ?? [], null);
        $this->setIfExists('user_id', $data ?? [], null);
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('state', $data ?? [], null);
        $this->setIfExists('creation_timestamp', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('ending_timestamp', $data ?? [], null);
        $this->setIfExists('original_creation_timestamp', $data ?? [], null);
        $this->setIfExists('last_modified_timestamp', $data ?? [], null);
        $this->setIfExists('updated_timestamp', $data ?? [], null);
        $this->setIfExists('state_timestamp', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('shop_section_id', $data ?? [], null);
        $this->setIfExists('featured_rank', $data ?? [], null);
        $this->setIfExists('url', $data ?? [], null);
        $this->setIfExists('num_favorers', $data ?? [], null);
        $this->setIfExists('non_taxable', $data ?? [], null);
        $this->setIfExists('is_taxable', $data ?? [], null);
        $this->setIfExists('is_customizable', $data ?? [], null);
        $this->setIfExists('is_personalizable', $data ?? [], null);
        $this->setIfExists('personalization_is_required', $data ?? [], null);
        $this->setIfExists('personalization_char_count_max', $data ?? [], null);
        $this->setIfExists('personalization_instructions', $data ?? [], null);
        $this->setIfExists('listing_type', $data ?? [], null);
        $this->setIfExists('tags', $data ?? [], null);
        $this->setIfExists('materials', $data ?? [], null);
        $this->setIfExists('shipping_profile_id', $data ?? [], null);
        $this->setIfExists('return_policy_id', $data ?? [], null);
        $this->setIfExists('processing_min', $data ?? [], null);
        $this->setIfExists('processing_max', $data ?? [], null);
        $this->setIfExists('who_made', $data ?? [], null);
        $this->setIfExists('when_made', $data ?? [], null);
        $this->setIfExists('is_supply', $data ?? [], null);
        $this->setIfExists('item_weight', $data ?? [], null);
        $this->setIfExists('item_weight_unit', $data ?? [], null);
        $this->setIfExists('item_length', $data ?? [], null);
        $this->setIfExists('item_width', $data ?? [], null);
        $this->setIfExists('item_height', $data ?? [], null);
        $this->setIfExists('item_dimensions_unit', $data ?? [], null);
        $this->setIfExists('is_private', $data ?? [], null);
        $this->setIfExists('style', $data ?? [], null);
        $this->setIfExists('file_data', $data ?? [], null);
        $this->setIfExists('has_variations', $data ?? [], null);
        $this->setIfExists('should_auto_renew', $data ?? [], null);
        $this->setIfExists('language', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('taxonomy_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['listing_id']) && ($this->container['listing_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'listing_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['user_id']) && ($this->container['user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'user_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['shop_id']) && ($this->container['shop_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shop_id', must be bigger than or equal to 1.";
        }

        $allowedValues = $this->getStateAllowableValues();
        if (!is_null($this->container['state']) && !in_array($this->container['state'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'state', must be one of '%s'",
                $this->container['state'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['creation_timestamp']) && ($this->container['creation_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'creation_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['ending_timestamp']) && ($this->container['ending_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'ending_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['original_creation_timestamp']) && ($this->container['original_creation_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'original_creation_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['last_modified_timestamp']) && ($this->container['last_modified_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'last_modified_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['updated_timestamp']) && ($this->container['updated_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'updated_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['state_timestamp']) && ($this->container['state_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'state_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['quantity']) && ($this->container['quantity'] < 0)) {
            $invalidProperties[] = "invalid value for 'quantity', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['shop_section_id']) && ($this->container['shop_section_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shop_section_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['num_favorers']) && ($this->container['num_favorers'] < 0)) {
            $invalidProperties[] = "invalid value for 'num_favorers', must be bigger than or equal to 0.";
        }

        $allowedValues = $this->getListingTypeAllowableValues();
        if (!is_null($this->container['listing_type']) && !in_array($this->container['listing_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'listing_type', must be one of '%s'",
                $this->container['listing_type'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['shipping_profile_id']) && ($this->container['shipping_profile_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shipping_profile_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['return_policy_id']) && ($this->container['return_policy_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'return_policy_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['processing_min']) && ($this->container['processing_min'] < 0)) {
            $invalidProperties[] = "invalid value for 'processing_min', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['processing_max']) && ($this->container['processing_max'] < 0)) {
            $invalidProperties[] = "invalid value for 'processing_max', must be bigger than or equal to 0.";
        }

        $allowedValues = $this->getWhoMadeAllowableValues();
        if (!is_null($this->container['who_made']) && !in_array($this->container['who_made'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'who_made', must be one of '%s'",
                $this->container['who_made'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getWhenMadeAllowableValues();
        if (!is_null($this->container['when_made']) && !in_array($this->container['when_made'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'when_made', must be one of '%s'",
                $this->container['when_made'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getItemWeightUnitAllowableValues();
        if (!is_null($this->container['item_weight_unit']) && !in_array($this->container['item_weight_unit'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'item_weight_unit', must be one of '%s'",
                $this->container['item_weight_unit'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getItemDimensionsUnitAllowableValues();
        if (!is_null($this->container['item_dimensions_unit']) && !in_array($this->container['item_dimensions_unit'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'item_dimensions_unit', must be one of '%s'",
                $this->container['item_dimensions_unit'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets listing_id
     *
     * @return int|null
     */
    public function getListingId()
    {
        return $this->container['listing_id'];
    }

    /**
     * Sets listing_id
     *
     * @param int|null $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
     *
     * @return self
     */
    public function setListingId($listing_id)
    {
        if (is_null($listing_id)) {
            throw new \InvalidArgumentException('non-nullable listing_id cannot be null');
        }

        if (($listing_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $listing_id when calling ShopListing., must be bigger than or equal to 1.');
        }

        $this->container['listing_id'] = $listing_id;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return int|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param int|null $user_id The numeric ID for the [user](/documentation/reference#tag/User) posting the listing.
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        if (is_null($user_id)) {
            throw new \InvalidArgumentException('non-nullable user_id cannot be null');
        }

        if (($user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $user_id when calling ShopListing., must be bigger than or equal to 1.');
        }

        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets shop_id
     *
     * @return int|null
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int|null $shop_id The unique positive non-zero numeric ID for an Etsy Shop.
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }

        if (($shop_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shop_id when calling ShopListing., must be bigger than or equal to 1.');
        }

        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title The listing's title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, & and + characters once each.
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description A description string of the product for sale in the listing.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets state
     *
     * @return string|null
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     *
     * @param string|null $state When _updating_ a listing, this value can be either `active` or `inactive`. Note: Setting a `draft` listing to `active` will also publish the listing on etsy.com and requires that the listing have an image set. Setting a `sold_out` listing to active will update the quantity to 1 and renew the listing on etsy.com.
     *
     * @return self
     */
    public function setState($state)
    {
        if (is_null($state)) {
            throw new \InvalidArgumentException('non-nullable state cannot be null');
        }
        $allowedValues = $this->getStateAllowableValues();
        if (!in_array($state, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'state', must be one of '%s'",
                    $state,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets creation_timestamp
     *
     * @return int|null
     */
    public function getCreationTimestamp()
    {
        return $this->container['creation_timestamp'];
    }

    /**
     * Sets creation_timestamp
     *
     * @param int|null $creation_timestamp The listing\\'s creation time, in epoch seconds.
     *
     * @return self
     */
    public function setCreationTimestamp($creation_timestamp)
    {
        if (is_null($creation_timestamp)) {
            throw new \InvalidArgumentException('non-nullable creation_timestamp cannot be null');
        }

        if (($creation_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $creation_timestamp when calling ShopListing., must be bigger than or equal to 946684800.');
        }

        $this->container['creation_timestamp'] = $creation_timestamp;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The listing\\'s creation time, in epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling ShopListing., must be bigger than or equal to 946684800.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets ending_timestamp
     *
     * @return int|null
     */
    public function getEndingTimestamp()
    {
        return $this->container['ending_timestamp'];
    }

    /**
     * Sets ending_timestamp
     *
     * @param int|null $ending_timestamp The listing\\'s expiration time, in epoch seconds.
     *
     * @return self
     */
    public function setEndingTimestamp($ending_timestamp)
    {
        if (is_null($ending_timestamp)) {
            throw new \InvalidArgumentException('non-nullable ending_timestamp cannot be null');
        }

        if (($ending_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $ending_timestamp when calling ShopListing., must be bigger than or equal to 946684800.');
        }

        $this->container['ending_timestamp'] = $ending_timestamp;

        return $this;
    }

    /**
     * Gets original_creation_timestamp
     *
     * @return int|null
     */
    public function getOriginalCreationTimestamp()
    {
        return $this->container['original_creation_timestamp'];
    }

    /**
     * Sets original_creation_timestamp
     *
     * @param int|null $original_creation_timestamp The listing\\'s creation time, in epoch seconds.
     *
     * @return self
     */
    public function setOriginalCreationTimestamp($original_creation_timestamp)
    {
        if (is_null($original_creation_timestamp)) {
            throw new \InvalidArgumentException('non-nullable original_creation_timestamp cannot be null');
        }

        if (($original_creation_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $original_creation_timestamp when calling ShopListing., must be bigger than or equal to 946684800.');
        }

        $this->container['original_creation_timestamp'] = $original_creation_timestamp;

        return $this;
    }

    /**
     * Gets last_modified_timestamp
     *
     * @return int|null
     */
    public function getLastModifiedTimestamp()
    {
        return $this->container['last_modified_timestamp'];
    }

    /**
     * Sets last_modified_timestamp
     *
     * @param int|null $last_modified_timestamp The time of the last update to the listing, in epoch seconds.
     *
     * @return self
     */
    public function setLastModifiedTimestamp($last_modified_timestamp)
    {
        if (is_null($last_modified_timestamp)) {
            throw new \InvalidArgumentException('non-nullable last_modified_timestamp cannot be null');
        }

        if (($last_modified_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $last_modified_timestamp when calling ShopListing., must be bigger than or equal to 946684800.');
        }

        $this->container['last_modified_timestamp'] = $last_modified_timestamp;

        return $this;
    }

    /**
     * Gets updated_timestamp
     *
     * @return int|null
     */
    public function getUpdatedTimestamp()
    {
        return $this->container['updated_timestamp'];
    }

    /**
     * Sets updated_timestamp
     *
     * @param int|null $updated_timestamp The time of the last update to the listing, in epoch seconds.
     *
     * @return self
     */
    public function setUpdatedTimestamp($updated_timestamp)
    {
        if (is_null($updated_timestamp)) {
            throw new \InvalidArgumentException('non-nullable updated_timestamp cannot be null');
        }

        if (($updated_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $updated_timestamp when calling ShopListing., must be bigger than or equal to 946684800.');
        }

        $this->container['updated_timestamp'] = $updated_timestamp;

        return $this;
    }

    /**
     * Gets state_timestamp
     *
     * @return int|null
     */
    public function getStateTimestamp()
    {
        return $this->container['state_timestamp'];
    }

    /**
     * Sets state_timestamp
     *
     * @param int|null $state_timestamp The date and time of the last state change of this listing.
     *
     * @return self
     */
    public function setStateTimestamp($state_timestamp)
    {
        if (is_null($state_timestamp)) {
            throw new \InvalidArgumentException('non-nullable state_timestamp cannot be null');
        }

        if (($state_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $state_timestamp when calling ShopListing., must be bigger than or equal to 946684800.');
        }

        $this->container['state_timestamp'] = $state_timestamp;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity The positive non-zero number of products available for purchase in the listing. Note: The listing quantity is the sum of available offering quantities. You can request the quantities for individual offerings from the ListingInventory resource using the [getListingInventory](/documentation/reference#operation/getListingInventory) endpoint.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }

        if (($quantity < 0)) {
            throw new \InvalidArgumentException('invalid value for $quantity when calling ShopListing., must be bigger than or equal to 0.');
        }

        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets shop_section_id
     *
     * @return int|null
     */
    public function getShopSectionId()
    {
        return $this->container['shop_section_id'];
    }

    /**
     * Sets shop_section_id
     *
     * @param int|null $shop_section_id The numeric ID of a section in a specific Etsy shop.
     *
     * @return self
     */
    public function setShopSectionId($shop_section_id)
    {
        if (is_null($shop_section_id)) {
            array_push($this->openAPINullablesSetToNull, 'shop_section_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shop_section_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($shop_section_id) && ($shop_section_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shop_section_id when calling ShopListing., must be bigger than or equal to 1.');
        }

        $this->container['shop_section_id'] = $shop_section_id;

        return $this;
    }

    /**
     * Gets featured_rank
     *
     * @return int|null
     */
    public function getFeaturedRank()
    {
        return $this->container['featured_rank'];
    }

    /**
     * Sets featured_rank
     *
     * @param int|null $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page.
     *
     * @return self
     */
    public function setFeaturedRank($featured_rank)
    {
        if (is_null($featured_rank)) {
            throw new \InvalidArgumentException('non-nullable featured_rank cannot be null');
        }
        $this->container['featured_rank'] = $featured_rank;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string|null
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string|null $url The full URL to the listing's page on Etsy.
     *
     * @return self
     */
    public function setUrl($url)
    {
        if (is_null($url)) {
            throw new \InvalidArgumentException('non-nullable url cannot be null');
        }
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets num_favorers
     *
     * @return int|null
     */
    public function getNumFavorers()
    {
        return $this->container['num_favorers'];
    }

    /**
     * Sets num_favorers
     *
     * @param int|null $num_favorers The number of users who marked this Listing a favorite.
     *
     * @return self
     */
    public function setNumFavorers($num_favorers)
    {
        if (is_null($num_favorers)) {
            throw new \InvalidArgumentException('non-nullable num_favorers cannot be null');
        }

        if (($num_favorers < 0)) {
            throw new \InvalidArgumentException('invalid value for $num_favorers when calling ShopListing., must be bigger than or equal to 0.');
        }

        $this->container['num_favorers'] = $num_favorers;

        return $this;
    }

    /**
     * Gets non_taxable
     *
     * @return bool|null
     */
    public function getNonTaxable()
    {
        return $this->container['non_taxable'];
    }

    /**
     * Sets non_taxable
     *
     * @param bool|null $non_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates do not apply to this listing at checkout.
     *
     * @return self
     */
    public function setNonTaxable($non_taxable)
    {
        if (is_null($non_taxable)) {
            throw new \InvalidArgumentException('non-nullable non_taxable cannot be null');
        }
        $this->container['non_taxable'] = $non_taxable;

        return $this;
    }

    /**
     * Gets is_taxable
     *
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->container['is_taxable'];
    }

    /**
     * Sets is_taxable
     *
     * @param bool|null $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout.
     *
     * @return self
     */
    public function setIsTaxable($is_taxable)
    {
        if (is_null($is_taxable)) {
            throw new \InvalidArgumentException('non-nullable is_taxable cannot be null');
        }
        $this->container['is_taxable'] = $is_taxable;

        return $this;
    }

    /**
     * Gets is_customizable
     *
     * @return bool|null
     */
    public function getIsCustomizable()
    {
        return $this->container['is_customizable'];
    }

    /**
     * Sets is_customizable
     *
     * @param bool|null $is_customizable When true, a buyer may contact the seller for a customized order. The default value is true when a shop accepts custom orders. Does not apply to shops that do not accept custom orders.
     *
     * @return self
     */
    public function setIsCustomizable($is_customizable)
    {
        if (is_null($is_customizable)) {
            throw new \InvalidArgumentException('non-nullable is_customizable cannot be null');
        }
        $this->container['is_customizable'] = $is_customizable;

        return $this;
    }

    /**
     * Gets is_personalizable
     *
     * @return bool|null
     */
    public function getIsPersonalizable()
    {
        return $this->container['is_personalizable'];
    }

    /**
     * Sets is_personalizable
     *
     * @param bool|null $is_personalizable When true, this listing is personalizable. The default value is null.
     *
     * @return self
     */
    public function setIsPersonalizable($is_personalizable)
    {
        if (is_null($is_personalizable)) {
            throw new \InvalidArgumentException('non-nullable is_personalizable cannot be null');
        }
        $this->container['is_personalizable'] = $is_personalizable;

        return $this;
    }

    /**
     * Gets personalization_is_required
     *
     * @return bool|null
     */
    public function getPersonalizationIsRequired()
    {
        return $this->container['personalization_is_required'];
    }

    /**
     * Sets personalization_is_required
     *
     * @param bool|null $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is 'true'.
     *
     * @return self
     */
    public function setPersonalizationIsRequired($personalization_is_required)
    {
        if (is_null($personalization_is_required)) {
            throw new \InvalidArgumentException('non-nullable personalization_is_required cannot be null');
        }
        $this->container['personalization_is_required'] = $personalization_is_required;

        return $this;
    }

    /**
     * Gets personalization_char_count_max
     *
     * @return int|null
     */
    public function getPersonalizationCharCountMax()
    {
        return $this->container['personalization_char_count_max'];
    }

    /**
     * Sets personalization_char_count_max
     *
     * @param int|null $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is 'true'.
     *
     * @return self
     */
    public function setPersonalizationCharCountMax($personalization_char_count_max)
    {
        if (is_null($personalization_char_count_max)) {
            array_push($this->openAPINullablesSetToNull, 'personalization_char_count_max');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('personalization_char_count_max', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['personalization_char_count_max'] = $personalization_char_count_max;

        return $this;
    }

    /**
     * Gets personalization_instructions
     *
     * @return string|null
     */
    public function getPersonalizationInstructions()
    {
        return $this->container['personalization_instructions'];
    }

    /**
     * Sets personalization_instructions
     *
     * @param string|null $personalization_instructions When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is 'true'.
     *
     * @return self
     */
    public function setPersonalizationInstructions($personalization_instructions)
    {
        if (is_null($personalization_instructions)) {
            array_push($this->openAPINullablesSetToNull, 'personalization_instructions');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('personalization_instructions', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['personalization_instructions'] = $personalization_instructions;

        return $this;
    }

    /**
     * Gets listing_type
     *
     * @return string|null
     */
    public function getListingType()
    {
        return $this->container['listing_type'];
    }

    /**
     * Sets listing_type
     *
     * @param string|null $listing_type An enumerated type string that indicates whether the listing is physical or a digital download.
     *
     * @return self
     */
    public function setListingType($listing_type)
    {
        if (is_null($listing_type)) {
            throw new \InvalidArgumentException('non-nullable listing_type cannot be null');
        }
        $allowedValues = $this->getListingTypeAllowableValues();
        if (!in_array($listing_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'listing_type', must be one of '%s'",
                    $listing_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['listing_type'] = $listing_type;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return string[]|null
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param string[]|null $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, ', ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-'™©®]/u) Default value is null.
     *
     * @return self
     */
    public function setTags($tags)
    {
        if (is_null($tags)) {
            throw new \InvalidArgumentException('non-nullable tags cannot be null');
        }
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets materials
     *
     * @return string[]|null
     */
    public function getMaterials()
    {
        return $this->container['materials'];
    }

    /**
     * Sets materials
     *
     * @param string[]|null $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null.
     *
     * @return self
     */
    public function setMaterials($materials)
    {
        if (is_null($materials)) {
            throw new \InvalidArgumentException('non-nullable materials cannot be null');
        }
        $this->container['materials'] = $materials;

        return $this;
    }

    /**
     * Gets shipping_profile_id
     *
     * @return int|null
     */
    public function getShippingProfileId()
    {
        return $this->container['shipping_profile_id'];
    }

    /**
     * Sets shipping_profile_id
     *
     * @param int|null $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is `physical`.
     *
     * @return self
     */
    public function setShippingProfileId($shipping_profile_id)
    {
        if (is_null($shipping_profile_id)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_profile_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_profile_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($shipping_profile_id) && ($shipping_profile_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shipping_profile_id when calling ShopListing., must be bigger than or equal to 1.');
        }

        $this->container['shipping_profile_id'] = $shipping_profile_id;

        return $this;
    }

    /**
     * Gets return_policy_id
     *
     * @return int|null
     */
    public function getReturnPolicyId()
    {
        return $this->container['return_policy_id'];
    }

    /**
     * Sets return_policy_id
     *
     * @param int|null $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies).
     *
     * @return self
     */
    public function setReturnPolicyId($return_policy_id)
    {
        if (is_null($return_policy_id)) {
            array_push($this->openAPINullablesSetToNull, 'return_policy_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('return_policy_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($return_policy_id) && ($return_policy_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $return_policy_id when calling ShopListing., must be bigger than or equal to 1.');
        }

        $this->container['return_policy_id'] = $return_policy_id;

        return $this;
    }

    /**
     * Gets processing_min
     *
     * @return int|null
     */
    public function getProcessingMin()
    {
        return $this->container['processing_min'];
    }

    /**
     * Sets processing_min
     *
     * @param int|null $processing_min The minimum number of days required to process this listing. Default value is null.
     *
     * @return self
     */
    public function setProcessingMin($processing_min)
    {
        if (is_null($processing_min)) {
            array_push($this->openAPINullablesSetToNull, 'processing_min');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('processing_min', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($processing_min) && ($processing_min < 0)) {
            throw new \InvalidArgumentException('invalid value for $processing_min when calling ShopListing., must be bigger than or equal to 0.');
        }

        $this->container['processing_min'] = $processing_min;

        return $this;
    }

    /**
     * Gets processing_max
     *
     * @return int|null
     */
    public function getProcessingMax()
    {
        return $this->container['processing_max'];
    }

    /**
     * Sets processing_max
     *
     * @param int|null $processing_max The maximum number of days required to process this listing. Default value is null.
     *
     * @return self
     */
    public function setProcessingMax($processing_max)
    {
        if (is_null($processing_max)) {
            array_push($this->openAPINullablesSetToNull, 'processing_max');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('processing_max', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($processing_max) && ($processing_max < 0)) {
            throw new \InvalidArgumentException('invalid value for $processing_max when calling ShopListing., must be bigger than or equal to 0.');
        }

        $this->container['processing_max'] = $processing_max;

        return $this;
    }

    /**
     * Gets who_made
     *
     * @return string|null
     */
    public function getWhoMade()
    {
        return $this->container['who_made'];
    }

    /**
     * Sets who_made
     *
     * @param string|null $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires 'is_supply' and 'when_made'.
     *
     * @return self
     */
    public function setWhoMade($who_made)
    {
        if (is_null($who_made)) {
            array_push($this->openAPINullablesSetToNull, 'who_made');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('who_made', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $allowedValues = $this->getWhoMadeAllowableValues();
        if (!is_null($who_made) && !in_array($who_made, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'who_made', must be one of '%s'",
                    $who_made,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['who_made'] = $who_made;

        return $this;
    }

    /**
     * Gets when_made
     *
     * @return string|null
     */
    public function getWhenMade()
    {
        return $this->container['when_made'];
    }

    /**
     * Sets when_made
     *
     * @param string|null $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires 'is_supply' and 'who_made'.
     *
     * @return self
     */
    public function setWhenMade($when_made)
    {
        if (is_null($when_made)) {
            array_push($this->openAPINullablesSetToNull, 'when_made');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('when_made', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $allowedValues = $this->getWhenMadeAllowableValues();
        if (!is_null($when_made) && !in_array($when_made, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'when_made', must be one of '%s'",
                    $when_made,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['when_made'] = $when_made;

        return $this;
    }

    /**
     * Gets is_supply
     *
     * @return bool|null
     */
    public function getIsSupply()
    {
        return $this->container['is_supply'];
    }

    /**
     * Sets is_supply
     *
     * @param bool|null $is_supply When true, tags the listing as a supply product, else indicates that it's a finished product. Helps buyers locate the listing under the Supplies heading. Requires 'who_made' and 'when_made'.
     *
     * @return self
     */
    public function setIsSupply($is_supply)
    {
        if (is_null($is_supply)) {
            array_push($this->openAPINullablesSetToNull, 'is_supply');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('is_supply', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['is_supply'] = $is_supply;

        return $this;
    }

    /**
     * Gets item_weight
     *
     * @return float|null
     */
    public function getItemWeight()
    {
        return $this->container['item_weight'];
    }

    /**
     * Sets item_weight
     *
     * @param float|null $item_weight The numeric weight of the product measured in units set in \\'item_weight_unit\\'. Default value is null. If set, the value must be greater than 0.
     *
     * @return self
     */
    public function setItemWeight($item_weight)
    {
        if (is_null($item_weight)) {
            array_push($this->openAPINullablesSetToNull, 'item_weight');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_weight', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_weight'] = $item_weight;

        return $this;
    }

    /**
     * Gets item_weight_unit
     *
     * @return string|null
     */
    public function getItemWeightUnit()
    {
        return $this->container['item_weight_unit'];
    }

    /**
     * Sets item_weight_unit
     *
     * @param string|null $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null.
     *
     * @return self
     */
    public function setItemWeightUnit($item_weight_unit)
    {
        if (is_null($item_weight_unit)) {
            array_push($this->openAPINullablesSetToNull, 'item_weight_unit');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_weight_unit', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $allowedValues = $this->getItemWeightUnitAllowableValues();
        if (!is_null($item_weight_unit) && !in_array($item_weight_unit, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'item_weight_unit', must be one of '%s'",
                    $item_weight_unit,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['item_weight_unit'] = $item_weight_unit;

        return $this;
    }

    /**
     * Gets item_length
     *
     * @return float|null
     */
    public function getItemLength()
    {
        return $this->container['item_length'];
    }

    /**
     * Sets item_length
     *
     * @param float|null $item_length The numeric length of the product measured in units set in \\'item_dimensions_unit\\'. Default value is null. If set, the value must be greater than 0.
     *
     * @return self
     */
    public function setItemLength($item_length)
    {
        if (is_null($item_length)) {
            array_push($this->openAPINullablesSetToNull, 'item_length');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_length', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_length'] = $item_length;

        return $this;
    }

    /**
     * Gets item_width
     *
     * @return float|null
     */
    public function getItemWidth()
    {
        return $this->container['item_width'];
    }

    /**
     * Sets item_width
     *
     * @param float|null $item_width The numeric width of the product measured in units set in \\'item_dimensions_unit\\'. Default value is null. If set, the value must be greater than 0.
     *
     * @return self
     */
    public function setItemWidth($item_width)
    {
        if (is_null($item_width)) {
            array_push($this->openAPINullablesSetToNull, 'item_width');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_width', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_width'] = $item_width;

        return $this;
    }

    /**
     * Gets item_height
     *
     * @return float|null
     */
    public function getItemHeight()
    {
        return $this->container['item_height'];
    }

    /**
     * Sets item_height
     *
     * @param float|null $item_height The numeric length of the product measured in units set in \\'item_dimensions_unit\\'. Default value is null. If set, the value must be greater than 0.
     *
     * @return self
     */
    public function setItemHeight($item_height)
    {
        if (is_null($item_height)) {
            array_push($this->openAPINullablesSetToNull, 'item_height');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_height', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['item_height'] = $item_height;

        return $this;
    }

    /**
     * Gets item_dimensions_unit
     *
     * @return string|null
     */
    public function getItemDimensionsUnit()
    {
        return $this->container['item_dimensions_unit'];
    }

    /**
     * Sets item_dimensions_unit
     *
     * @param string|null $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null.
     *
     * @return self
     */
    public function setItemDimensionsUnit($item_dimensions_unit)
    {
        if (is_null($item_dimensions_unit)) {
            array_push($this->openAPINullablesSetToNull, 'item_dimensions_unit');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('item_dimensions_unit', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $allowedValues = $this->getItemDimensionsUnitAllowableValues();
        if (!is_null($item_dimensions_unit) && !in_array($item_dimensions_unit, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'item_dimensions_unit', must be one of '%s'",
                    $item_dimensions_unit,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['item_dimensions_unit'] = $item_dimensions_unit;

        return $this;
    }

    /**
     * Gets is_private
     *
     * @return bool|null
     */
    public function getIsPrivate()
    {
        return $this->container['is_private'];
    }

    /**
     * Sets is_private
     *
     * @param bool|null $is_private When true, this is a private listing intended for a specific buyer and hidden from shop view.
     *
     * @return self
     */
    public function setIsPrivate($is_private)
    {
        if (is_null($is_private)) {
            throw new \InvalidArgumentException('non-nullable is_private cannot be null');
        }
        $this->container['is_private'] = $is_private;

        return $this;
    }

    /**
     * Gets style
     *
     * @return string[]|null
     */
    public function getStyle()
    {
        return $this->container['style'];
    }

    /**
     * Sets style
     *
     * @param string[]|null $style An array of style strings for this listing, each of which is free-form text string such as \\\"Formal\\\", or \\\"Steampunk\\\". When creating or updating a listing, the listing may have up to two styles. Valid style strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null.
     *
     * @return self
     */
    public function setStyle($style)
    {
        if (is_null($style)) {
            throw new \InvalidArgumentException('non-nullable style cannot be null');
        }
        $this->container['style'] = $style;

        return $this;
    }

    /**
     * Gets file_data
     *
     * @return string|null
     */
    public function getFileData()
    {
        return $this->container['file_data'];
    }

    /**
     * Sets file_data
     *
     * @param string|null $file_data A string describing the files attached to a digital listing.
     *
     * @return self
     */
    public function setFileData($file_data)
    {
        if (is_null($file_data)) {
            throw new \InvalidArgumentException('non-nullable file_data cannot be null');
        }
        $this->container['file_data'] = $file_data;

        return $this;
    }

    /**
     * Gets has_variations
     *
     * @return bool|null
     */
    public function getHasVariations()
    {
        return $this->container['has_variations'];
    }

    /**
     * Sets has_variations
     *
     * @param bool|null $has_variations When true, the listing has variations.
     *
     * @return self
     */
    public function setHasVariations($has_variations)
    {
        if (is_null($has_variations)) {
            throw new \InvalidArgumentException('non-nullable has_variations cannot be null');
        }
        $this->container['has_variations'] = $has_variations;

        return $this;
    }

    /**
     * Gets should_auto_renew
     *
     * @return bool|null
     */
    public function getShouldAutoRenew()
    {
        return $this->container['should_auto_renew'];
    }

    /**
     * Sets should_auto_renew
     *
     * @param bool|null $should_auto_renew When true, renews a listing for four months upon expiration.
     *
     * @return self
     */
    public function setShouldAutoRenew($should_auto_renew)
    {
        if (is_null($should_auto_renew)) {
            throw new \InvalidArgumentException('non-nullable should_auto_renew cannot be null');
        }
        $this->container['should_auto_renew'] = $should_auto_renew;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string|null $language The IETF language tag for the default language of the listing. Ex: `de`, `en`, `es`, `fr`, `it`, `ja`, `nl`, `pl`, `pt`, `ru`.
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            array_push($this->openAPINullablesSetToNull, 'language');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('language', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets price
     *
     * @return \Etsy\Model\ShopListingPrice|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param \Etsy\Model\ShopListingPrice|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets taxonomy_id
     *
     * @return int|null
     */
    public function getTaxonomyId()
    {
        return $this->container['taxonomy_id'];
    }

    /**
     * Sets taxonomy_id
     *
     * @param int|null $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information.
     *
     * @return self
     */
    public function setTaxonomyId($taxonomy_id)
    {
        if (is_null($taxonomy_id)) {
            array_push($this->openAPINullablesSetToNull, 'taxonomy_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('taxonomy_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['taxonomy_id'] = $taxonomy_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


