<?php
/**
 * PaymentAccountLedgerEntry
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * PaymentAccountLedgerEntry Class Doc Comment
 *
 * @category Class
 * @description Represents an entry in a shop&#39;s ledger.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentAccountLedgerEntry implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentAccountLedgerEntry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'entry_id' => 'int',
        'ledger_id' => 'int',
        'sequence_number' => 'int',
        'amount' => 'int',
        'currency' => 'string',
        'description' => 'string',
        'balance' => 'int',
        'create_date' => 'int',
        'created_timestamp' => 'int',
        'ledger_type' => 'string',
        'reference_type' => 'string',
        'reference_id' => 'string',
        'payment_adjustments' => '\Etsy\Model\PaymentAccountLedgerEntryPaymentAdjustmentsInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'entry_id' => null,
        'ledger_id' => null,
        'sequence_number' => null,
        'amount' => null,
        'currency' => null,
        'description' => null,
        'balance' => null,
        'create_date' => null,
        'created_timestamp' => null,
        'ledger_type' => null,
        'reference_type' => null,
        'reference_id' => null,
        'payment_adjustments' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'entry_id' => false,
		'ledger_id' => false,
		'sequence_number' => false,
		'amount' => false,
		'currency' => false,
		'description' => false,
		'balance' => false,
		'create_date' => false,
		'created_timestamp' => false,
		'ledger_type' => false,
		'reference_type' => false,
		'reference_id' => true,
		'payment_adjustments' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'entry_id' => 'entry_id',
        'ledger_id' => 'ledger_id',
        'sequence_number' => 'sequence_number',
        'amount' => 'amount',
        'currency' => 'currency',
        'description' => 'description',
        'balance' => 'balance',
        'create_date' => 'create_date',
        'created_timestamp' => 'created_timestamp',
        'ledger_type' => 'ledger_type',
        'reference_type' => 'reference_type',
        'reference_id' => 'reference_id',
        'payment_adjustments' => 'payment_adjustments'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'entry_id' => 'setEntryId',
        'ledger_id' => 'setLedgerId',
        'sequence_number' => 'setSequenceNumber',
        'amount' => 'setAmount',
        'currency' => 'setCurrency',
        'description' => 'setDescription',
        'balance' => 'setBalance',
        'create_date' => 'setCreateDate',
        'created_timestamp' => 'setCreatedTimestamp',
        'ledger_type' => 'setLedgerType',
        'reference_type' => 'setReferenceType',
        'reference_id' => 'setReferenceId',
        'payment_adjustments' => 'setPaymentAdjustments'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'entry_id' => 'getEntryId',
        'ledger_id' => 'getLedgerId',
        'sequence_number' => 'getSequenceNumber',
        'amount' => 'getAmount',
        'currency' => 'getCurrency',
        'description' => 'getDescription',
        'balance' => 'getBalance',
        'create_date' => 'getCreateDate',
        'created_timestamp' => 'getCreatedTimestamp',
        'ledger_type' => 'getLedgerType',
        'reference_type' => 'getReferenceType',
        'reference_id' => 'getReferenceId',
        'payment_adjustments' => 'getPaymentAdjustments'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('entry_id', $data ?? [], null);
        $this->setIfExists('ledger_id', $data ?? [], null);
        $this->setIfExists('sequence_number', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('balance', $data ?? [], null);
        $this->setIfExists('create_date', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('ledger_type', $data ?? [], null);
        $this->setIfExists('reference_type', $data ?? [], null);
        $this->setIfExists('reference_id', $data ?? [], null);
        $this->setIfExists('payment_adjustments', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['entry_id']) && ($this->container['entry_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'entry_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['ledger_id']) && ($this->container['ledger_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'ledger_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['sequence_number']) && ($this->container['sequence_number'] < 0)) {
            $invalidProperties[] = "invalid value for 'sequence_number', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['create_date']) && ($this->container['create_date'] < 0)) {
            $invalidProperties[] = "invalid value for 'create_date', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 0)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets entry_id
     *
     * @return int|null
     */
    public function getEntryId()
    {
        return $this->container['entry_id'];
    }

    /**
     * Sets entry_id
     *
     * @param int|null $entry_id The ledger entry's numeric ID.
     *
     * @return self
     */
    public function setEntryId($entry_id)
    {
        if (is_null($entry_id)) {
            throw new \InvalidArgumentException('non-nullable entry_id cannot be null');
        }

        if (($entry_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $entry_id when calling PaymentAccountLedgerEntry., must be bigger than or equal to 1.');
        }

        $this->container['entry_id'] = $entry_id;

        return $this;
    }

    /**
     * Gets ledger_id
     *
     * @return int|null
     */
    public function getLedgerId()
    {
        return $this->container['ledger_id'];
    }

    /**
     * Sets ledger_id
     *
     * @param int|null $ledger_id The ledger's numeric ID.
     *
     * @return self
     */
    public function setLedgerId($ledger_id)
    {
        if (is_null($ledger_id)) {
            throw new \InvalidArgumentException('non-nullable ledger_id cannot be null');
        }

        if (($ledger_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $ledger_id when calling PaymentAccountLedgerEntry., must be bigger than or equal to 1.');
        }

        $this->container['ledger_id'] = $ledger_id;

        return $this;
    }

    /**
     * Gets sequence_number
     *
     * @return int|null
     */
    public function getSequenceNumber()
    {
        return $this->container['sequence_number'];
    }

    /**
     * Sets sequence_number
     *
     * @param int|null $sequence_number The sequence allows ledger entries to be sorted chronologically. The higher the sequence, the more recent the entry.
     *
     * @return self
     */
    public function setSequenceNumber($sequence_number)
    {
        if (is_null($sequence_number)) {
            throw new \InvalidArgumentException('non-nullable sequence_number cannot be null');
        }

        if (($sequence_number < 0)) {
            throw new \InvalidArgumentException('invalid value for $sequence_number when calling PaymentAccountLedgerEntry., must be bigger than or equal to 0.');
        }

        $this->container['sequence_number'] = $sequence_number;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return int|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param int|null $amount The amount of money credited to the ledger.
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency The currency of the entry on the ledger.
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Details what kind of ledger entry this is: a payment, refund, reversal of a failed refund, disbursement, returned disbursement, recoupment, miscellaneous credit, miscellaneous debit, or bill payment.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets balance
     *
     * @return int|null
     */
    public function getBalance()
    {
        return $this->container['balance'];
    }

    /**
     * Sets balance
     *
     * @param int|null $balance The amount of money in the shop's ledger the moment after this entry was applied.
     *
     * @return self
     */
    public function setBalance($balance)
    {
        if (is_null($balance)) {
            throw new \InvalidArgumentException('non-nullable balance cannot be null');
        }
        $this->container['balance'] = $balance;

        return $this;
    }

    /**
     * Gets create_date
     *
     * @return int|null
     */
    public function getCreateDate()
    {
        return $this->container['create_date'];
    }

    /**
     * Sets create_date
     *
     * @param int|null $create_date The date and time the ledger entry was created in Epoch seconds.
     *
     * @return self
     */
    public function setCreateDate($create_date)
    {
        if (is_null($create_date)) {
            throw new \InvalidArgumentException('non-nullable create_date cannot be null');
        }

        if (($create_date < 0)) {
            throw new \InvalidArgumentException('invalid value for $create_date when calling PaymentAccountLedgerEntry., must be bigger than or equal to 0.');
        }

        $this->container['create_date'] = $create_date;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The date and time the ledger entry was created in Epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 0)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling PaymentAccountLedgerEntry., must be bigger than or equal to 0.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets ledger_type
     *
     * @return string|null
     */
    public function getLedgerType()
    {
        return $this->container['ledger_type'];
    }

    /**
     * Sets ledger_type
     *
     * @param string|null $ledger_type The original reference type for the ledger entry.
     *
     * @return self
     */
    public function setLedgerType($ledger_type)
    {
        if (is_null($ledger_type)) {
            throw new \InvalidArgumentException('non-nullable ledger_type cannot be null');
        }
        $this->container['ledger_type'] = $ledger_type;

        return $this;
    }

    /**
     * Gets reference_type
     *
     * @return string|null
     */
    public function getReferenceType()
    {
        return $this->container['reference_type'];
    }

    /**
     * Sets reference_type
     *
     * @param string|null $reference_type The object type the ledger entry refers to.
     *
     * @return self
     */
    public function setReferenceType($reference_type)
    {
        if (is_null($reference_type)) {
            throw new \InvalidArgumentException('non-nullable reference_type cannot be null');
        }
        $this->container['reference_type'] = $reference_type;

        return $this;
    }

    /**
     * Gets reference_id
     *
     * @return string|null
     */
    public function getReferenceId()
    {
        return $this->container['reference_id'];
    }

    /**
     * Sets reference_id
     *
     * @param string|null $reference_id The object id the ledger entry refers to.
     *
     * @return self
     */
    public function setReferenceId($reference_id)
    {
        if (is_null($reference_id)) {
            array_push($this->openAPINullablesSetToNull, 'reference_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('reference_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['reference_id'] = $reference_id;

        return $this;
    }

    /**
     * Gets payment_adjustments
     *
     * @return \Etsy\Model\PaymentAccountLedgerEntryPaymentAdjustmentsInner[]|null
     */
    public function getPaymentAdjustments()
    {
        return $this->container['payment_adjustments'];
    }

    /**
     * Sets payment_adjustments
     *
     * @param \Etsy\Model\PaymentAccountLedgerEntryPaymentAdjustmentsInner[]|null $payment_adjustments List of refund objects on an Etsy Payments transaction. All monetary amounts are in USD pennies unless otherwise specified.
     *
     * @return self
     */
    public function setPaymentAdjustments($payment_adjustments)
    {
        if (is_null($payment_adjustments)) {
            throw new \InvalidArgumentException('non-nullable payment_adjustments cannot be null');
        }
        $this->container['payment_adjustments'] = $payment_adjustments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


