<?php
/**
 * ListingReview
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ListingReview Class Doc Comment
 *
 * @category Class
 * @description A listing review record left by a User.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ListingReview implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ListingReview';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'shop_id' => 'int',
        'listing_id' => 'int',
        'rating' => 'int',
        'review' => 'string',
        'language' => 'string',
        'image_url_fullxfull' => 'string',
        'create_timestamp' => 'int',
        'created_timestamp' => 'int',
        'update_timestamp' => 'int',
        'updated_timestamp' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'shop_id' => null,
        'listing_id' => null,
        'rating' => null,
        'review' => null,
        'language' => null,
        'image_url_fullxfull' => null,
        'create_timestamp' => null,
        'created_timestamp' => null,
        'update_timestamp' => null,
        'updated_timestamp' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'shop_id' => false,
		'listing_id' => false,
		'rating' => false,
		'review' => true,
		'language' => false,
		'image_url_fullxfull' => true,
		'create_timestamp' => false,
		'created_timestamp' => false,
		'update_timestamp' => false,
		'updated_timestamp' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shop_id' => 'shop_id',
        'listing_id' => 'listing_id',
        'rating' => 'rating',
        'review' => 'review',
        'language' => 'language',
        'image_url_fullxfull' => 'image_url_fullxfull',
        'create_timestamp' => 'create_timestamp',
        'created_timestamp' => 'created_timestamp',
        'update_timestamp' => 'update_timestamp',
        'updated_timestamp' => 'updated_timestamp'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shop_id' => 'setShopId',
        'listing_id' => 'setListingId',
        'rating' => 'setRating',
        'review' => 'setReview',
        'language' => 'setLanguage',
        'image_url_fullxfull' => 'setImageUrlFullxfull',
        'create_timestamp' => 'setCreateTimestamp',
        'created_timestamp' => 'setCreatedTimestamp',
        'update_timestamp' => 'setUpdateTimestamp',
        'updated_timestamp' => 'setUpdatedTimestamp'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shop_id' => 'getShopId',
        'listing_id' => 'getListingId',
        'rating' => 'getRating',
        'review' => 'getReview',
        'language' => 'getLanguage',
        'image_url_fullxfull' => 'getImageUrlFullxfull',
        'create_timestamp' => 'getCreateTimestamp',
        'created_timestamp' => 'getCreatedTimestamp',
        'update_timestamp' => 'getUpdateTimestamp',
        'updated_timestamp' => 'getUpdatedTimestamp'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('listing_id', $data ?? [], null);
        $this->setIfExists('rating', $data ?? [], null);
        $this->setIfExists('review', $data ?? [], null);
        $this->setIfExists('language', $data ?? [], null);
        $this->setIfExists('image_url_fullxfull', $data ?? [], null);
        $this->setIfExists('create_timestamp', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('update_timestamp', $data ?? [], null);
        $this->setIfExists('updated_timestamp', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['shop_id']) && ($this->container['shop_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shop_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['listing_id']) && ($this->container['listing_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'listing_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['rating']) && ($this->container['rating'] > 5)) {
            $invalidProperties[] = "invalid value for 'rating', must be smaller than or equal to 5.";
        }

        if (!is_null($this->container['rating']) && ($this->container['rating'] < 1)) {
            $invalidProperties[] = "invalid value for 'rating', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['create_timestamp']) && ($this->container['create_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'create_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['update_timestamp']) && ($this->container['update_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'update_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['updated_timestamp']) && ($this->container['updated_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'updated_timestamp', must be bigger than or equal to 946684800.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shop_id
     *
     * @return int|null
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int|null $shop_id The shop's numeric ID.
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }

        if (($shop_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shop_id when calling ListingReview., must be bigger than or equal to 1.');
        }

        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets listing_id
     *
     * @return int|null
     */
    public function getListingId()
    {
        return $this->container['listing_id'];
    }

    /**
     * Sets listing_id
     *
     * @param int|null $listing_id The ID of the ShopListing that the TransactionReview belongs to.
     *
     * @return self
     */
    public function setListingId($listing_id)
    {
        if (is_null($listing_id)) {
            throw new \InvalidArgumentException('non-nullable listing_id cannot be null');
        }

        if (($listing_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $listing_id when calling ListingReview., must be bigger than or equal to 1.');
        }

        $this->container['listing_id'] = $listing_id;

        return $this;
    }

    /**
     * Gets rating
     *
     * @return int|null
     */
    public function getRating()
    {
        return $this->container['rating'];
    }

    /**
     * Sets rating
     *
     * @param int|null $rating Rating value on scale from 1 to 5
     *
     * @return self
     */
    public function setRating($rating)
    {
        if (is_null($rating)) {
            throw new \InvalidArgumentException('non-nullable rating cannot be null');
        }

        if (($rating > 5)) {
            throw new \InvalidArgumentException('invalid value for $rating when calling ListingReview., must be smaller than or equal to 5.');
        }
        if (($rating < 1)) {
            throw new \InvalidArgumentException('invalid value for $rating when calling ListingReview., must be bigger than or equal to 1.');
        }

        $this->container['rating'] = $rating;

        return $this;
    }

    /**
     * Gets review
     *
     * @return string|null
     */
    public function getReview()
    {
        return $this->container['review'];
    }

    /**
     * Sets review
     *
     * @param string|null $review A message left by the author, explaining the feedback, if provided.
     *
     * @return self
     */
    public function setReview($review)
    {
        if (is_null($review)) {
            array_push($this->openAPINullablesSetToNull, 'review');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('review', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['review'] = $review;

        return $this;
    }

    /**
     * Gets language
     *
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->container['language'];
    }

    /**
     * Sets language
     *
     * @param string|null $language The language of the TransactionReview
     *
     * @return self
     */
    public function setLanguage($language)
    {
        if (is_null($language)) {
            throw new \InvalidArgumentException('non-nullable language cannot be null');
        }
        $this->container['language'] = $language;

        return $this;
    }

    /**
     * Gets image_url_fullxfull
     *
     * @return string|null
     */
    public function getImageUrlFullxfull()
    {
        return $this->container['image_url_fullxfull'];
    }

    /**
     * Sets image_url_fullxfull
     *
     * @param string|null $image_url_fullxfull The url to a photo provided with the feedback, dimensions fullxfull. Note: This field may be absent, depending on the buyer's privacy settings.
     *
     * @return self
     */
    public function setImageUrlFullxfull($image_url_fullxfull)
    {
        if (is_null($image_url_fullxfull)) {
            array_push($this->openAPINullablesSetToNull, 'image_url_fullxfull');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('image_url_fullxfull', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['image_url_fullxfull'] = $image_url_fullxfull;

        return $this;
    }

    /**
     * Gets create_timestamp
     *
     * @return int|null
     */
    public function getCreateTimestamp()
    {
        return $this->container['create_timestamp'];
    }

    /**
     * Sets create_timestamp
     *
     * @param int|null $create_timestamp The date and time the TransactionReview was created in epoch seconds.
     *
     * @return self
     */
    public function setCreateTimestamp($create_timestamp)
    {
        if (is_null($create_timestamp)) {
            throw new \InvalidArgumentException('non-nullable create_timestamp cannot be null');
        }

        if (($create_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $create_timestamp when calling ListingReview., must be bigger than or equal to 946684800.');
        }

        $this->container['create_timestamp'] = $create_timestamp;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The date and time the TransactionReview was created in epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling ListingReview., must be bigger than or equal to 946684800.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets update_timestamp
     *
     * @return int|null
     */
    public function getUpdateTimestamp()
    {
        return $this->container['update_timestamp'];
    }

    /**
     * Sets update_timestamp
     *
     * @param int|null $update_timestamp The date and time the TransactionReview was updated in epoch seconds.
     *
     * @return self
     */
    public function setUpdateTimestamp($update_timestamp)
    {
        if (is_null($update_timestamp)) {
            throw new \InvalidArgumentException('non-nullable update_timestamp cannot be null');
        }

        if (($update_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $update_timestamp when calling ListingReview., must be bigger than or equal to 946684800.');
        }

        $this->container['update_timestamp'] = $update_timestamp;

        return $this;
    }

    /**
     * Gets updated_timestamp
     *
     * @return int|null
     */
    public function getUpdatedTimestamp()
    {
        return $this->container['updated_timestamp'];
    }

    /**
     * Sets updated_timestamp
     *
     * @param int|null $updated_timestamp The date and time the TransactionReview was updated in epoch seconds.
     *
     * @return self
     */
    public function setUpdatedTimestamp($updated_timestamp)
    {
        if (is_null($updated_timestamp)) {
            throw new \InvalidArgumentException('non-nullable updated_timestamp cannot be null');
        }

        if (($updated_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $updated_timestamp when calling ListingReview., must be bigger than or equal to 946684800.');
        }

        $this->container['updated_timestamp'] = $updated_timestamp;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


