<?php
/**
 * ListingImagesResultsInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ListingImagesResultsInner Class Doc Comment
 *
 * @category Class
 * @description The list of requested resources.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ListingImagesResultsInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ListingImages_results_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'listing_id' => 'int',
        'listing_image_id' => 'int',
        'hex_code' => 'string',
        'red' => 'int',
        'green' => 'int',
        'blue' => 'int',
        'hue' => 'int',
        'saturation' => 'int',
        'brightness' => 'int',
        'is_black_and_white' => 'bool',
        'creation_tsz' => 'int',
        'created_timestamp' => 'int',
        'rank' => 'int',
        'url_75x75' => 'string',
        'url_170x135' => 'string',
        'url_570x_n' => 'string',
        'url_fullxfull' => 'string',
        'full_height' => 'int',
        'full_width' => 'int',
        'alt_text' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'listing_id' => null,
        'listing_image_id' => null,
        'hex_code' => null,
        'red' => null,
        'green' => null,
        'blue' => null,
        'hue' => null,
        'saturation' => null,
        'brightness' => null,
        'is_black_and_white' => null,
        'creation_tsz' => null,
        'created_timestamp' => null,
        'rank' => null,
        'url_75x75' => null,
        'url_170x135' => null,
        'url_570x_n' => null,
        'url_fullxfull' => null,
        'full_height' => null,
        'full_width' => null,
        'alt_text' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'listing_id' => false,
		'listing_image_id' => false,
		'hex_code' => true,
		'red' => true,
		'green' => true,
		'blue' => true,
		'hue' => true,
		'saturation' => true,
		'brightness' => true,
		'is_black_and_white' => true,
		'creation_tsz' => false,
		'created_timestamp' => false,
		'rank' => false,
		'url_75x75' => false,
		'url_170x135' => false,
		'url_570x_n' => false,
		'url_fullxfull' => false,
		'full_height' => true,
		'full_width' => true,
		'alt_text' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'listing_id' => 'listing_id',
        'listing_image_id' => 'listing_image_id',
        'hex_code' => 'hex_code',
        'red' => 'red',
        'green' => 'green',
        'blue' => 'blue',
        'hue' => 'hue',
        'saturation' => 'saturation',
        'brightness' => 'brightness',
        'is_black_and_white' => 'is_black_and_white',
        'creation_tsz' => 'creation_tsz',
        'created_timestamp' => 'created_timestamp',
        'rank' => 'rank',
        'url_75x75' => 'url_75x75',
        'url_170x135' => 'url_170x135',
        'url_570x_n' => 'url_570xN',
        'url_fullxfull' => 'url_fullxfull',
        'full_height' => 'full_height',
        'full_width' => 'full_width',
        'alt_text' => 'alt_text'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'listing_id' => 'setListingId',
        'listing_image_id' => 'setListingImageId',
        'hex_code' => 'setHexCode',
        'red' => 'setRed',
        'green' => 'setGreen',
        'blue' => 'setBlue',
        'hue' => 'setHue',
        'saturation' => 'setSaturation',
        'brightness' => 'setBrightness',
        'is_black_and_white' => 'setIsBlackAndWhite',
        'creation_tsz' => 'setCreationTsz',
        'created_timestamp' => 'setCreatedTimestamp',
        'rank' => 'setRank',
        'url_75x75' => 'setUrl75x75',
        'url_170x135' => 'setUrl170x135',
        'url_570x_n' => 'setUrl570xN',
        'url_fullxfull' => 'setUrlFullxfull',
        'full_height' => 'setFullHeight',
        'full_width' => 'setFullWidth',
        'alt_text' => 'setAltText'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'listing_id' => 'getListingId',
        'listing_image_id' => 'getListingImageId',
        'hex_code' => 'getHexCode',
        'red' => 'getRed',
        'green' => 'getGreen',
        'blue' => 'getBlue',
        'hue' => 'getHue',
        'saturation' => 'getSaturation',
        'brightness' => 'getBrightness',
        'is_black_and_white' => 'getIsBlackAndWhite',
        'creation_tsz' => 'getCreationTsz',
        'created_timestamp' => 'getCreatedTimestamp',
        'rank' => 'getRank',
        'url_75x75' => 'getUrl75x75',
        'url_170x135' => 'getUrl170x135',
        'url_570x_n' => 'getUrl570xN',
        'url_fullxfull' => 'getUrlFullxfull',
        'full_height' => 'getFullHeight',
        'full_width' => 'getFullWidth',
        'alt_text' => 'getAltText'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('listing_id', $data ?? [], null);
        $this->setIfExists('listing_image_id', $data ?? [], null);
        $this->setIfExists('hex_code', $data ?? [], null);
        $this->setIfExists('red', $data ?? [], null);
        $this->setIfExists('green', $data ?? [], null);
        $this->setIfExists('blue', $data ?? [], null);
        $this->setIfExists('hue', $data ?? [], null);
        $this->setIfExists('saturation', $data ?? [], null);
        $this->setIfExists('brightness', $data ?? [], null);
        $this->setIfExists('is_black_and_white', $data ?? [], null);
        $this->setIfExists('creation_tsz', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('rank', $data ?? [], null);
        $this->setIfExists('url_75x75', $data ?? [], null);
        $this->setIfExists('url_170x135', $data ?? [], null);
        $this->setIfExists('url_570x_n', $data ?? [], null);
        $this->setIfExists('url_fullxfull', $data ?? [], null);
        $this->setIfExists('full_height', $data ?? [], null);
        $this->setIfExists('full_width', $data ?? [], null);
        $this->setIfExists('alt_text', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['listing_id']) && ($this->container['listing_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'listing_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['listing_image_id']) && ($this->container['listing_image_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'listing_image_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['red']) && ($this->container['red'] < 0)) {
            $invalidProperties[] = "invalid value for 'red', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['green']) && ($this->container['green'] < 0)) {
            $invalidProperties[] = "invalid value for 'green', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['blue']) && ($this->container['blue'] < 0)) {
            $invalidProperties[] = "invalid value for 'blue', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['hue']) && ($this->container['hue'] < 0)) {
            $invalidProperties[] = "invalid value for 'hue', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['saturation']) && ($this->container['saturation'] < 0)) {
            $invalidProperties[] = "invalid value for 'saturation', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['brightness']) && ($this->container['brightness'] < 0)) {
            $invalidProperties[] = "invalid value for 'brightness', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['creation_tsz']) && ($this->container['creation_tsz'] < 0)) {
            $invalidProperties[] = "invalid value for 'creation_tsz', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 0)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['rank']) && ($this->container['rank'] < 0)) {
            $invalidProperties[] = "invalid value for 'rank', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['full_height']) && ($this->container['full_height'] < 0)) {
            $invalidProperties[] = "invalid value for 'full_height', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['full_width']) && ($this->container['full_width'] < 0)) {
            $invalidProperties[] = "invalid value for 'full_width', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets listing_id
     *
     * @return int|null
     */
    public function getListingId()
    {
        return $this->container['listing_id'];
    }

    /**
     * Sets listing_id
     *
     * @param int|null $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
     *
     * @return self
     */
    public function setListingId($listing_id)
    {
        if (is_null($listing_id)) {
            throw new \InvalidArgumentException('non-nullable listing_id cannot be null');
        }

        if (($listing_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $listing_id when calling ListingImagesResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['listing_id'] = $listing_id;

        return $this;
    }

    /**
     * Gets listing_image_id
     *
     * @return int|null
     */
    public function getListingImageId()
    {
        return $this->container['listing_image_id'];
    }

    /**
     * Sets listing_image_id
     *
     * @param int|null $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction.
     *
     * @return self
     */
    public function setListingImageId($listing_image_id)
    {
        if (is_null($listing_image_id)) {
            throw new \InvalidArgumentException('non-nullable listing_image_id cannot be null');
        }

        if (($listing_image_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $listing_image_id when calling ListingImagesResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['listing_image_id'] = $listing_image_id;

        return $this;
    }

    /**
     * Gets hex_code
     *
     * @return string|null
     */
    public function getHexCode()
    {
        return $this->container['hex_code'];
    }

    /**
     * Sets hex_code
     *
     * @param string|null $hex_code The webhex string for the image's average color, in webhex notation.
     *
     * @return self
     */
    public function setHexCode($hex_code)
    {
        if (is_null($hex_code)) {
            array_push($this->openAPINullablesSetToNull, 'hex_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('hex_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['hex_code'] = $hex_code;

        return $this;
    }

    /**
     * Gets red
     *
     * @return int|null
     */
    public function getRed()
    {
        return $this->container['red'];
    }

    /**
     * Sets red
     *
     * @param int|null $red The numeric red value equal to the image's average red value, from 0-255 (RGB color).
     *
     * @return self
     */
    public function setRed($red)
    {
        if (is_null($red)) {
            array_push($this->openAPINullablesSetToNull, 'red');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('red', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($red) && ($red < 0)) {
            throw new \InvalidArgumentException('invalid value for $red when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['red'] = $red;

        return $this;
    }

    /**
     * Gets green
     *
     * @return int|null
     */
    public function getGreen()
    {
        return $this->container['green'];
    }

    /**
     * Sets green
     *
     * @param int|null $green The numeric red value equal to the image's average red value, from 0-255 (RGB color).
     *
     * @return self
     */
    public function setGreen($green)
    {
        if (is_null($green)) {
            array_push($this->openAPINullablesSetToNull, 'green');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('green', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($green) && ($green < 0)) {
            throw new \InvalidArgumentException('invalid value for $green when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['green'] = $green;

        return $this;
    }

    /**
     * Gets blue
     *
     * @return int|null
     */
    public function getBlue()
    {
        return $this->container['blue'];
    }

    /**
     * Sets blue
     *
     * @param int|null $blue The numeric red value equal to the image's average red value, from 0-255 (RGB color).
     *
     * @return self
     */
    public function setBlue($blue)
    {
        if (is_null($blue)) {
            array_push($this->openAPINullablesSetToNull, 'blue');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('blue', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($blue) && ($blue < 0)) {
            throw new \InvalidArgumentException('invalid value for $blue when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['blue'] = $blue;

        return $this;
    }

    /**
     * Gets hue
     *
     * @return int|null
     */
    public function getHue()
    {
        return $this->container['hue'];
    }

    /**
     * Sets hue
     *
     * @param int|null $hue The numeric hue equal to the image's average hue, from 0-360 (HSV color).
     *
     * @return self
     */
    public function setHue($hue)
    {
        if (is_null($hue)) {
            array_push($this->openAPINullablesSetToNull, 'hue');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('hue', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($hue) && ($hue < 0)) {
            throw new \InvalidArgumentException('invalid value for $hue when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['hue'] = $hue;

        return $this;
    }

    /**
     * Gets saturation
     *
     * @return int|null
     */
    public function getSaturation()
    {
        return $this->container['saturation'];
    }

    /**
     * Sets saturation
     *
     * @param int|null $saturation The numeric saturation equal to the image's average saturation, from 0-100 (HSV color).
     *
     * @return self
     */
    public function setSaturation($saturation)
    {
        if (is_null($saturation)) {
            array_push($this->openAPINullablesSetToNull, 'saturation');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('saturation', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($saturation) && ($saturation < 0)) {
            throw new \InvalidArgumentException('invalid value for $saturation when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['saturation'] = $saturation;

        return $this;
    }

    /**
     * Gets brightness
     *
     * @return int|null
     */
    public function getBrightness()
    {
        return $this->container['brightness'];
    }

    /**
     * Sets brightness
     *
     * @param int|null $brightness The numeric brightness equal to the image's average brightness, from 0-100 (HSV color).
     *
     * @return self
     */
    public function setBrightness($brightness)
    {
        if (is_null($brightness)) {
            array_push($this->openAPINullablesSetToNull, 'brightness');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('brightness', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($brightness) && ($brightness < 0)) {
            throw new \InvalidArgumentException('invalid value for $brightness when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['brightness'] = $brightness;

        return $this;
    }

    /**
     * Gets is_black_and_white
     *
     * @return bool|null
     */
    public function getIsBlackAndWhite()
    {
        return $this->container['is_black_and_white'];
    }

    /**
     * Sets is_black_and_white
     *
     * @param bool|null $is_black_and_white When true, the image is in black & white.
     *
     * @return self
     */
    public function setIsBlackAndWhite($is_black_and_white)
    {
        if (is_null($is_black_and_white)) {
            array_push($this->openAPINullablesSetToNull, 'is_black_and_white');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('is_black_and_white', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['is_black_and_white'] = $is_black_and_white;

        return $this;
    }

    /**
     * Gets creation_tsz
     *
     * @return int|null
     */
    public function getCreationTsz()
    {
        return $this->container['creation_tsz'];
    }

    /**
     * Sets creation_tsz
     *
     * @param int|null $creation_tsz The listing image\\'s creation time, in epoch seconds.
     *
     * @return self
     */
    public function setCreationTsz($creation_tsz)
    {
        if (is_null($creation_tsz)) {
            throw new \InvalidArgumentException('non-nullable creation_tsz cannot be null');
        }

        if (($creation_tsz < 0)) {
            throw new \InvalidArgumentException('invalid value for $creation_tsz when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['creation_tsz'] = $creation_tsz;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The listing image\\'s creation time, in epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 0)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets rank
     *
     * @return int|null
     */
    public function getRank()
    {
        return $this->container['rank'];
    }

    /**
     * Sets rank
     *
     * @param int|null $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing.
     *
     * @return self
     */
    public function setRank($rank)
    {
        if (is_null($rank)) {
            throw new \InvalidArgumentException('non-nullable rank cannot be null');
        }

        if (($rank < 0)) {
            throw new \InvalidArgumentException('invalid value for $rank when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['rank'] = $rank;

        return $this;
    }

    /**
     * Gets url_75x75
     *
     * @return string|null
     */
    public function getUrl75x75()
    {
        return $this->container['url_75x75'];
    }

    /**
     * Sets url_75x75
     *
     * @param string|null $url_75x75 The url string for a 75x75 pixel thumbnail of the image.
     *
     * @return self
     */
    public function setUrl75x75($url_75x75)
    {
        if (is_null($url_75x75)) {
            throw new \InvalidArgumentException('non-nullable url_75x75 cannot be null');
        }
        $this->container['url_75x75'] = $url_75x75;

        return $this;
    }

    /**
     * Gets url_170x135
     *
     * @return string|null
     */
    public function getUrl170x135()
    {
        return $this->container['url_170x135'];
    }

    /**
     * Sets url_170x135
     *
     * @param string|null $url_170x135 The url string for a 170x135 pixel thumbnail of the image.
     *
     * @return self
     */
    public function setUrl170x135($url_170x135)
    {
        if (is_null($url_170x135)) {
            throw new \InvalidArgumentException('non-nullable url_170x135 cannot be null');
        }
        $this->container['url_170x135'] = $url_170x135;

        return $this;
    }

    /**
     * Gets url_570x_n
     *
     * @return string|null
     */
    public function getUrl570xN()
    {
        return $this->container['url_570x_n'];
    }

    /**
     * Sets url_570x_n
     *
     * @param string|null $url_570x_n The url string for a thumbnail of the image, no more than 570 pixels wide with variable height.
     *
     * @return self
     */
    public function setUrl570xN($url_570x_n)
    {
        if (is_null($url_570x_n)) {
            throw new \InvalidArgumentException('non-nullable url_570x_n cannot be null');
        }
        $this->container['url_570x_n'] = $url_570x_n;

        return $this;
    }

    /**
     * Gets url_fullxfull
     *
     * @return string|null
     */
    public function getUrlFullxfull()
    {
        return $this->container['url_fullxfull'];
    }

    /**
     * Sets url_fullxfull
     *
     * @param string|null $url_fullxfull The url string for the full-size image, up to 3000 pixels in each dimension.
     *
     * @return self
     */
    public function setUrlFullxfull($url_fullxfull)
    {
        if (is_null($url_fullxfull)) {
            throw new \InvalidArgumentException('non-nullable url_fullxfull cannot be null');
        }
        $this->container['url_fullxfull'] = $url_fullxfull;

        return $this;
    }

    /**
     * Gets full_height
     *
     * @return int|null
     */
    public function getFullHeight()
    {
        return $this->container['full_height'];
    }

    /**
     * Sets full_height
     *
     * @param int|null $full_height The numeric height, measured in pixels, of the full-sized image referenced in url_fullxfull.
     *
     * @return self
     */
    public function setFullHeight($full_height)
    {
        if (is_null($full_height)) {
            array_push($this->openAPINullablesSetToNull, 'full_height');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('full_height', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($full_height) && ($full_height < 0)) {
            throw new \InvalidArgumentException('invalid value for $full_height when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['full_height'] = $full_height;

        return $this;
    }

    /**
     * Gets full_width
     *
     * @return int|null
     */
    public function getFullWidth()
    {
        return $this->container['full_width'];
    }

    /**
     * Sets full_width
     *
     * @param int|null $full_width The numeric width, measured in pixels, of the full-sized image referenced in url_fullxfull.
     *
     * @return self
     */
    public function setFullWidth($full_width)
    {
        if (is_null($full_width)) {
            array_push($this->openAPINullablesSetToNull, 'full_width');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('full_width', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($full_width) && ($full_width < 0)) {
            throw new \InvalidArgumentException('invalid value for $full_width when calling ListingImagesResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['full_width'] = $full_width;

        return $this;
    }

    /**
     * Gets alt_text
     *
     * @return string|null
     */
    public function getAltText()
    {
        return $this->container['alt_text'];
    }

    /**
     * Sets alt_text
     *
     * @param string|null $alt_text Alt text for the listing image. Max length 250 characters.
     *
     * @return self
     */
    public function setAltText($alt_text)
    {
        if (is_null($alt_text)) {
            array_push($this->openAPINullablesSetToNull, 'alt_text');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('alt_text', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['alt_text'] = $alt_text;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


