<?php
/**
 * ShopShippingProfileApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Etsy\ApiException;
use Etsy\Configuration;
use Etsy\HeaderSelector;
use Etsy\ObjectSerializer;

/**
 * ShopShippingProfileApi Class Doc Comment
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ShopShippingProfileApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createShopShippingProfile' => [
            'application/x-www-form-urlencoded',
        ],
        'createShopShippingProfileDestination' => [
            'application/x-www-form-urlencoded',
        ],
        'createShopShippingProfileUpgrade' => [
            'application/x-www-form-urlencoded',
        ],
        'deleteShopShippingProfile' => [
            'application/json',
        ],
        'deleteShopShippingProfileDestination' => [
            'application/json',
        ],
        'deleteShopShippingProfileUpgrade' => [
            'application/json',
        ],
        'getShippingCarriers' => [
            'application/json',
        ],
        'getShopShippingProfile' => [
            'application/json',
        ],
        'getShopShippingProfileDestinationsByShippingProfile' => [
            'application/json',
        ],
        'getShopShippingProfileUpgrades' => [
            'application/json',
        ],
        'getShopShippingProfiles' => [
            'application/json',
        ],
        'updateShopShippingProfile' => [
            'application/x-www-form-urlencoded',
        ],
        'updateShopShippingProfileDestination' => [
            'application/x-www-form-urlencoded',
        ],
        'updateShopShippingProfileUpgrade' => [
            'application/x-www-form-urlencoded',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createShopShippingProfile
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $title The name string of this shipping profile. (required)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (required)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (required)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional, default to '')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function createShopShippingProfile($shop_id, $title, $origin_country_iso, $primary_cost, $secondary_cost, $min_processing_time, $max_processing_time, $processing_time_unit = 'business_days', $destination_country_iso = null, $destination_region = 'none', $origin_postal_code = '', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfile'][0])
    {
        list($response) = $this->createShopShippingProfileWithHttpInfo($shop_id, $title, $origin_country_iso, $primary_cost, $secondary_cost, $min_processing_time, $max_processing_time, $processing_time_unit, $destination_country_iso, $destination_region, $origin_postal_code, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);
        return $response;
    }

    /**
     * Operation createShopShippingProfileWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $title The name string of this shipping profile. (required)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (required)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (required)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional, default to '')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function createShopShippingProfileWithHttpInfo($shop_id, $title, $origin_country_iso, $primary_cost, $secondary_cost, $min_processing_time, $max_processing_time, $processing_time_unit = 'business_days', $destination_country_iso = null, $destination_region = 'none', $origin_postal_code = '', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfile'][0])
    {
        $request = $this->createShopShippingProfileRequest($shop_id, $title, $origin_country_iso, $primary_cost, $secondary_cost, $min_processing_time, $max_processing_time, $processing_time_unit, $destination_country_iso, $destination_region, $origin_postal_code, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopShippingProfile' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfile' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfile', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfile';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfile',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createShopShippingProfileAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $title The name string of this shipping profile. (required)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (required)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (required)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional, default to '')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShopShippingProfileAsync($shop_id, $title, $origin_country_iso, $primary_cost, $secondary_cost, $min_processing_time, $max_processing_time, $processing_time_unit = 'business_days', $destination_country_iso = null, $destination_region = 'none', $origin_postal_code = '', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfile'][0])
    {
        return $this->createShopShippingProfileAsyncWithHttpInfo($shop_id, $title, $origin_country_iso, $primary_cost, $secondary_cost, $min_processing_time, $max_processing_time, $processing_time_unit, $destination_country_iso, $destination_region, $origin_postal_code, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createShopShippingProfileAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $title The name string of this shipping profile. (required)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (required)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (required)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional, default to '')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShopShippingProfileAsyncWithHttpInfo($shop_id, $title, $origin_country_iso, $primary_cost, $secondary_cost, $min_processing_time, $max_processing_time, $processing_time_unit = 'business_days', $destination_country_iso = null, $destination_region = 'none', $origin_postal_code = '', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfile'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfile';
        $request = $this->createShopShippingProfileRequest($shop_id, $title, $origin_country_iso, $primary_cost, $secondary_cost, $min_processing_time, $max_processing_time, $processing_time_unit, $destination_country_iso, $destination_region, $origin_postal_code, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createShopShippingProfile'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $title The name string of this shipping profile. (required)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (required)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (required)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional, default to '')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createShopShippingProfileRequest($shop_id, $title, $origin_country_iso, $primary_cost, $secondary_cost, $min_processing_time, $max_processing_time, $processing_time_unit = 'business_days', $destination_country_iso = null, $destination_region = 'none', $origin_postal_code = '', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfile'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling createShopShippingProfile'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.createShopShippingProfile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'title' is set
        if ($title === null || (is_array($title) && count($title) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $title when calling createShopShippingProfile'
            );
        }

        // verify the required parameter 'origin_country_iso' is set
        if ($origin_country_iso === null || (is_array($origin_country_iso) && count($origin_country_iso) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $origin_country_iso when calling createShopShippingProfile'
            );
        }

        // verify the required parameter 'primary_cost' is set
        if ($primary_cost === null || (is_array($primary_cost) && count($primary_cost) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $primary_cost when calling createShopShippingProfile'
            );
        }
        if ($primary_cost < 0) {
            throw new \InvalidArgumentException('invalid value for "$primary_cost" when calling ShopShippingProfileApi.createShopShippingProfile, must be bigger than or equal to 0.');
        }
        
        // verify the required parameter 'secondary_cost' is set
        if ($secondary_cost === null || (is_array($secondary_cost) && count($secondary_cost) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $secondary_cost when calling createShopShippingProfile'
            );
        }
        if ($secondary_cost < 0) {
            throw new \InvalidArgumentException('invalid value for "$secondary_cost" when calling ShopShippingProfileApi.createShopShippingProfile, must be bigger than or equal to 0.');
        }
        
        // verify the required parameter 'min_processing_time' is set
        if ($min_processing_time === null || (is_array($min_processing_time) && count($min_processing_time) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $min_processing_time when calling createShopShippingProfile'
            );
        }
        if ($min_processing_time > 10) {
            throw new \InvalidArgumentException('invalid value for "$min_processing_time" when calling ShopShippingProfileApi.createShopShippingProfile, must be smaller than or equal to 10.');
        }
        if ($min_processing_time < 1) {
            throw new \InvalidArgumentException('invalid value for "$min_processing_time" when calling ShopShippingProfileApi.createShopShippingProfile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'max_processing_time' is set
        if ($max_processing_time === null || (is_array($max_processing_time) && count($max_processing_time) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $max_processing_time when calling createShopShippingProfile'
            );
        }
        if ($max_processing_time > 10) {
            throw new \InvalidArgumentException('invalid value for "$max_processing_time" when calling ShopShippingProfileApi.createShopShippingProfile, must be smaller than or equal to 10.');
        }
        if ($max_processing_time < 1) {
            throw new \InvalidArgumentException('invalid value for "$max_processing_time" when calling ShopShippingProfileApi.createShopShippingProfile, must be bigger than or equal to 1.');
        }
        




        if ($shipping_carrier_id !== null && $shipping_carrier_id < 0) {
            throw new \InvalidArgumentException('invalid value for "$shipping_carrier_id" when calling ShopShippingProfileApi.createShopShippingProfile, must be bigger than or equal to 0.');
        }
        

        if ($min_delivery_days !== null && $min_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfile, must be smaller than or equal to 45.');
        }
        if ($min_delivery_days !== null && $min_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfile, must be bigger than or equal to 1.');
        }
        
        if ($max_delivery_days !== null && $max_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfile, must be smaller than or equal to 45.');
        }
        if ($max_delivery_days !== null && $max_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfile, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }

        // form params
        if ($title !== null) {
            $formParams['title'] = ObjectSerializer::toFormValue($title);
        }
        // form params
        if ($origin_country_iso !== null) {
            $formParams['origin_country_iso'] = ObjectSerializer::toFormValue($origin_country_iso);
        }
        // form params
        if ($primary_cost !== null) {
            $formParams['primary_cost'] = ObjectSerializer::toFormValue($primary_cost);
        }
        // form params
        if ($secondary_cost !== null) {
            $formParams['secondary_cost'] = ObjectSerializer::toFormValue($secondary_cost);
        }
        // form params
        if ($min_processing_time !== null) {
            $formParams['min_processing_time'] = ObjectSerializer::toFormValue($min_processing_time);
        }
        // form params
        if ($max_processing_time !== null) {
            $formParams['max_processing_time'] = ObjectSerializer::toFormValue($max_processing_time);
        }
        // form params
        if ($processing_time_unit !== null) {
            $formParams['processing_time_unit'] = ObjectSerializer::toFormValue($processing_time_unit);
        }
        // form params
        if ($destination_country_iso !== null) {
            $formParams['destination_country_iso'] = ObjectSerializer::toFormValue($destination_country_iso);
        }
        // form params
        if ($destination_region !== null) {
            $formParams['destination_region'] = ObjectSerializer::toFormValue($destination_region);
        }
        // form params
        if ($origin_postal_code !== null) {
            $formParams['origin_postal_code'] = ObjectSerializer::toFormValue($origin_postal_code);
        }
        // form params
        if ($shipping_carrier_id !== null) {
            $formParams['shipping_carrier_id'] = ObjectSerializer::toFormValue($shipping_carrier_id);
        }
        // form params
        if ($mail_class !== null) {
            $formParams['mail_class'] = ObjectSerializer::toFormValue($mail_class);
        }
        // form params
        if ($min_delivery_days !== null) {
            $formParams['min_delivery_days'] = ObjectSerializer::toFormValue($min_delivery_days);
        }
        // form params
        if ($max_delivery_days !== null) {
            $formParams['max_delivery_days'] = ObjectSerializer::toFormValue($max_delivery_days);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createShopShippingProfileDestination
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfileDestination|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function createShopShippingProfileDestination($shop_id, $shipping_profile_id, $primary_cost, $secondary_cost, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileDestination'][0])
    {
        list($response) = $this->createShopShippingProfileDestinationWithHttpInfo($shop_id, $shipping_profile_id, $primary_cost, $secondary_cost, $destination_country_iso, $destination_region, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);
        return $response;
    }

    /**
     * Operation createShopShippingProfileDestinationWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfileDestination|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function createShopShippingProfileDestinationWithHttpInfo($shop_id, $shipping_profile_id, $primary_cost, $secondary_cost, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileDestination'][0])
    {
        $request = $this->createShopShippingProfileDestinationRequest($shop_id, $shipping_profile_id, $primary_cost, $secondary_cost, $destination_country_iso, $destination_region, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\Etsy\Model\ShopShippingProfileDestination' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfileDestination' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfileDestination', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfileDestination';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfileDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createShopShippingProfileDestinationAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShopShippingProfileDestinationAsync($shop_id, $shipping_profile_id, $primary_cost, $secondary_cost, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileDestination'][0])
    {
        return $this->createShopShippingProfileDestinationAsyncWithHttpInfo($shop_id, $shipping_profile_id, $primary_cost, $secondary_cost, $destination_country_iso, $destination_region, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createShopShippingProfileDestinationAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShopShippingProfileDestinationAsyncWithHttpInfo($shop_id, $shipping_profile_id, $primary_cost, $secondary_cost, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileDestination'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfileDestination';
        $request = $this->createShopShippingProfileDestinationRequest($shop_id, $shipping_profile_id, $primary_cost, $secondary_cost, $destination_country_iso, $destination_region, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createShopShippingProfileDestination'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (required)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (required)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createShopShippingProfileDestinationRequest($shop_id, $shipping_profile_id, $primary_cost, $secondary_cost, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileDestination'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling createShopShippingProfileDestination'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.createShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling createShopShippingProfileDestination'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.createShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'primary_cost' is set
        if ($primary_cost === null || (is_array($primary_cost) && count($primary_cost) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $primary_cost when calling createShopShippingProfileDestination'
            );
        }
        if ($primary_cost < 0) {
            throw new \InvalidArgumentException('invalid value for "$primary_cost" when calling ShopShippingProfileApi.createShopShippingProfileDestination, must be bigger than or equal to 0.');
        }
        
        // verify the required parameter 'secondary_cost' is set
        if ($secondary_cost === null || (is_array($secondary_cost) && count($secondary_cost) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $secondary_cost when calling createShopShippingProfileDestination'
            );
        }
        if ($secondary_cost < 0) {
            throw new \InvalidArgumentException('invalid value for "$secondary_cost" when calling ShopShippingProfileApi.createShopShippingProfileDestination, must be bigger than or equal to 0.');
        }
        


        if ($shipping_carrier_id !== null && $shipping_carrier_id < 0) {
            throw new \InvalidArgumentException('invalid value for "$shipping_carrier_id" when calling ShopShippingProfileApi.createShopShippingProfileDestination, must be bigger than or equal to 0.');
        }
        

        if ($min_delivery_days !== null && $min_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfileDestination, must be smaller than or equal to 45.');
        }
        if ($min_delivery_days !== null && $min_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        
        if ($max_delivery_days !== null && $max_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfileDestination, must be smaller than or equal to 45.');
        }
        if ($max_delivery_days !== null && $max_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }

        // form params
        if ($primary_cost !== null) {
            $formParams['primary_cost'] = ObjectSerializer::toFormValue($primary_cost);
        }
        // form params
        if ($secondary_cost !== null) {
            $formParams['secondary_cost'] = ObjectSerializer::toFormValue($secondary_cost);
        }
        // form params
        if ($destination_country_iso !== null) {
            $formParams['destination_country_iso'] = ObjectSerializer::toFormValue($destination_country_iso);
        }
        // form params
        if ($destination_region !== null) {
            $formParams['destination_region'] = ObjectSerializer::toFormValue($destination_region);
        }
        // form params
        if ($shipping_carrier_id !== null) {
            $formParams['shipping_carrier_id'] = ObjectSerializer::toFormValue($shipping_carrier_id);
        }
        // form params
        if ($mail_class !== null) {
            $formParams['mail_class'] = ObjectSerializer::toFormValue($mail_class);
        }
        // form params
        if ($min_delivery_days !== null) {
            $formParams['min_delivery_days'] = ObjectSerializer::toFormValue($min_delivery_days);
        }
        // form params
        if ($max_delivery_days !== null) {
            $formParams['max_delivery_days'] = ObjectSerializer::toFormValue($max_delivery_days);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createShopShippingProfileUpgrade
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (required)
     * @param  float $price Additional cost of adding the shipping upgrade. (required)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (required)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfileUpgrade|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function createShopShippingProfileUpgrade($shop_id, $shipping_profile_id, $type, $upgrade_name, $price, $secondary_price, $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileUpgrade'][0])
    {
        list($response) = $this->createShopShippingProfileUpgradeWithHttpInfo($shop_id, $shipping_profile_id, $type, $upgrade_name, $price, $secondary_price, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);
        return $response;
    }

    /**
     * Operation createShopShippingProfileUpgradeWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (required)
     * @param  float $price Additional cost of adding the shipping upgrade. (required)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (required)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfileUpgrade|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function createShopShippingProfileUpgradeWithHttpInfo($shop_id, $shipping_profile_id, $type, $upgrade_name, $price, $secondary_price, $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileUpgrade'][0])
    {
        $request = $this->createShopShippingProfileUpgradeRequest($shop_id, $shipping_profile_id, $type, $upgrade_name, $price, $secondary_price, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopShippingProfileUpgrade' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfileUpgrade' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfileUpgrade', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfileUpgrade';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfileUpgrade',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createShopShippingProfileUpgradeAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (required)
     * @param  float $price Additional cost of adding the shipping upgrade. (required)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (required)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShopShippingProfileUpgradeAsync($shop_id, $shipping_profile_id, $type, $upgrade_name, $price, $secondary_price, $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileUpgrade'][0])
    {
        return $this->createShopShippingProfileUpgradeAsyncWithHttpInfo($shop_id, $shipping_profile_id, $type, $upgrade_name, $price, $secondary_price, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createShopShippingProfileUpgradeAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (required)
     * @param  float $price Additional cost of adding the shipping upgrade. (required)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (required)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShopShippingProfileUpgradeAsyncWithHttpInfo($shop_id, $shipping_profile_id, $type, $upgrade_name, $price, $secondary_price, $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileUpgrade'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfileUpgrade';
        $request = $this->createShopShippingProfileUpgradeRequest($shop_id, $shipping_profile_id, $type, $upgrade_name, $price, $secondary_price, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createShopShippingProfileUpgrade'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (required)
     * @param  float $price Additional cost of adding the shipping upgrade. (required)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (required)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional, default to 0)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createShopShippingProfileUpgradeRequest($shop_id, $shipping_profile_id, $type, $upgrade_name, $price, $secondary_price, $shipping_carrier_id = 0, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['createShopShippingProfileUpgrade'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling createShopShippingProfileUpgrade'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.createShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling createShopShippingProfileUpgrade'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.createShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'type' is set
        if ($type === null || (is_array($type) && count($type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $type when calling createShopShippingProfileUpgrade'
            );
        }

        // verify the required parameter 'upgrade_name' is set
        if ($upgrade_name === null || (is_array($upgrade_name) && count($upgrade_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $upgrade_name when calling createShopShippingProfileUpgrade'
            );
        }

        // verify the required parameter 'price' is set
        if ($price === null || (is_array($price) && count($price) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $price when calling createShopShippingProfileUpgrade'
            );
        }
        if ($price < 0) {
            throw new \InvalidArgumentException('invalid value for "$price" when calling ShopShippingProfileApi.createShopShippingProfileUpgrade, must be bigger than or equal to 0.');
        }
        
        // verify the required parameter 'secondary_price' is set
        if ($secondary_price === null || (is_array($secondary_price) && count($secondary_price) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $secondary_price when calling createShopShippingProfileUpgrade'
            );
        }
        if ($secondary_price < 0) {
            throw new \InvalidArgumentException('invalid value for "$secondary_price" when calling ShopShippingProfileApi.createShopShippingProfileUpgrade, must be bigger than or equal to 0.');
        }
        
        if ($shipping_carrier_id !== null && $shipping_carrier_id < 0) {
            throw new \InvalidArgumentException('invalid value for "$shipping_carrier_id" when calling ShopShippingProfileApi.createShopShippingProfileUpgrade, must be bigger than or equal to 0.');
        }
        

        if ($min_delivery_days !== null && $min_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfileUpgrade, must be smaller than or equal to 45.');
        }
        if ($min_delivery_days !== null && $min_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        
        if ($max_delivery_days !== null && $max_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfileUpgrade, must be smaller than or equal to 45.');
        }
        if ($max_delivery_days !== null && $max_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.createShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }

        // form params
        if ($type !== null) {
            $formParams['type'] = ObjectSerializer::toFormValue($type);
        }
        // form params
        if ($upgrade_name !== null) {
            $formParams['upgrade_name'] = ObjectSerializer::toFormValue($upgrade_name);
        }
        // form params
        if ($price !== null) {
            $formParams['price'] = ObjectSerializer::toFormValue($price);
        }
        // form params
        if ($secondary_price !== null) {
            $formParams['secondary_price'] = ObjectSerializer::toFormValue($secondary_price);
        }
        // form params
        if ($shipping_carrier_id !== null) {
            $formParams['shipping_carrier_id'] = ObjectSerializer::toFormValue($shipping_carrier_id);
        }
        // form params
        if ($mail_class !== null) {
            $formParams['mail_class'] = ObjectSerializer::toFormValue($mail_class);
        }
        // form params
        if ($min_delivery_days !== null) {
            $formParams['min_delivery_days'] = ObjectSerializer::toFormValue($min_delivery_days);
        }
        // form params
        if ($max_delivery_days !== null) {
            $formParams['max_delivery_days'] = ObjectSerializer::toFormValue($max_delivery_days);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteShopShippingProfile
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteShopShippingProfile($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['deleteShopShippingProfile'][0])
    {
        $this->deleteShopShippingProfileWithHttpInfo($shop_id, $shipping_profile_id, $contentType);
    }

    /**
     * Operation deleteShopShippingProfileWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteShopShippingProfileWithHttpInfo($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['deleteShopShippingProfile'][0])
    {
        $request = $this->deleteShopShippingProfileRequest($shop_id, $shipping_profile_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteShopShippingProfileAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteShopShippingProfileAsync($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['deleteShopShippingProfile'][0])
    {
        return $this->deleteShopShippingProfileAsyncWithHttpInfo($shop_id, $shipping_profile_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteShopShippingProfileAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteShopShippingProfileAsyncWithHttpInfo($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['deleteShopShippingProfile'][0])
    {
        $returnType = '';
        $request = $this->deleteShopShippingProfileRequest($shop_id, $shipping_profile_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteShopShippingProfile'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteShopShippingProfileRequest($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['deleteShopShippingProfile'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling deleteShopShippingProfile'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.deleteShopShippingProfile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling deleteShopShippingProfile'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.deleteShopShippingProfile, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteShopShippingProfileDestination
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteShopShippingProfileDestination($shop_id, $shipping_profile_id, $shipping_profile_destination_id, string $contentType = self::contentTypes['deleteShopShippingProfileDestination'][0])
    {
        $this->deleteShopShippingProfileDestinationWithHttpInfo($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $contentType);
    }

    /**
     * Operation deleteShopShippingProfileDestinationWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteShopShippingProfileDestinationWithHttpInfo($shop_id, $shipping_profile_id, $shipping_profile_destination_id, string $contentType = self::contentTypes['deleteShopShippingProfileDestination'][0])
    {
        $request = $this->deleteShopShippingProfileDestinationRequest($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteShopShippingProfileDestinationAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteShopShippingProfileDestinationAsync($shop_id, $shipping_profile_id, $shipping_profile_destination_id, string $contentType = self::contentTypes['deleteShopShippingProfileDestination'][0])
    {
        return $this->deleteShopShippingProfileDestinationAsyncWithHttpInfo($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteShopShippingProfileDestinationAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteShopShippingProfileDestinationAsyncWithHttpInfo($shop_id, $shipping_profile_id, $shipping_profile_destination_id, string $contentType = self::contentTypes['deleteShopShippingProfileDestination'][0])
    {
        $returnType = '';
        $request = $this->deleteShopShippingProfileDestinationRequest($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteShopShippingProfileDestination'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteShopShippingProfileDestinationRequest($shop_id, $shipping_profile_id, $shipping_profile_destination_id, string $contentType = self::contentTypes['deleteShopShippingProfileDestination'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling deleteShopShippingProfileDestination'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.deleteShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling deleteShopShippingProfileDestination'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.deleteShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_destination_id' is set
        if ($shipping_profile_destination_id === null || (is_array($shipping_profile_destination_id) && count($shipping_profile_destination_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_destination_id when calling deleteShopShippingProfileDestination'
            );
        }
        if ($shipping_profile_destination_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_destination_id" when calling ShopShippingProfileApi.deleteShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations/{shipping_profile_destination_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_destination_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_destination_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_destination_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteShopShippingProfileUpgrade
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the shipping profile. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteShopShippingProfileUpgrade($shop_id, $shipping_profile_id, $upgrade_id, string $contentType = self::contentTypes['deleteShopShippingProfileUpgrade'][0])
    {
        $this->deleteShopShippingProfileUpgradeWithHttpInfo($shop_id, $shipping_profile_id, $upgrade_id, $contentType);
    }

    /**
     * Operation deleteShopShippingProfileUpgradeWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the shipping profile. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteShopShippingProfileUpgradeWithHttpInfo($shop_id, $shipping_profile_id, $upgrade_id, string $contentType = self::contentTypes['deleteShopShippingProfileUpgrade'][0])
    {
        $request = $this->deleteShopShippingProfileUpgradeRequest($shop_id, $shipping_profile_id, $upgrade_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteShopShippingProfileUpgradeAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the shipping profile. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteShopShippingProfileUpgradeAsync($shop_id, $shipping_profile_id, $upgrade_id, string $contentType = self::contentTypes['deleteShopShippingProfileUpgrade'][0])
    {
        return $this->deleteShopShippingProfileUpgradeAsyncWithHttpInfo($shop_id, $shipping_profile_id, $upgrade_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteShopShippingProfileUpgradeAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the shipping profile. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteShopShippingProfileUpgradeAsyncWithHttpInfo($shop_id, $shipping_profile_id, $upgrade_id, string $contentType = self::contentTypes['deleteShopShippingProfileUpgrade'][0])
    {
        $returnType = '';
        $request = $this->deleteShopShippingProfileUpgradeRequest($shop_id, $shipping_profile_id, $upgrade_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteShopShippingProfileUpgrade'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the shipping profile. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteShopShippingProfileUpgradeRequest($shop_id, $shipping_profile_id, $upgrade_id, string $contentType = self::contentTypes['deleteShopShippingProfileUpgrade'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling deleteShopShippingProfileUpgrade'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.deleteShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling deleteShopShippingProfileUpgrade'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.deleteShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'upgrade_id' is set
        if ($upgrade_id === null || (is_array($upgrade_id) && count($upgrade_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $upgrade_id when calling deleteShopShippingProfileUpgrade'
            );
        }
        if ($upgrade_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$upgrade_id" when calling ShopShippingProfileApi.deleteShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades/{upgrade_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }
        // path params
        if ($upgrade_id !== null) {
            $resourcePath = str_replace(
                '{' . 'upgrade_id' . '}',
                ObjectSerializer::toPathValue($upgrade_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShippingCarriers
     *
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingCarriers'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShippingCarriers|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getShippingCarriers($origin_country_iso, string $contentType = self::contentTypes['getShippingCarriers'][0])
    {
        list($response) = $this->getShippingCarriersWithHttpInfo($origin_country_iso, $contentType);
        return $response;
    }

    /**
     * Operation getShippingCarriersWithHttpInfo
     *
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingCarriers'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShippingCarriers|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShippingCarriersWithHttpInfo($origin_country_iso, string $contentType = self::contentTypes['getShippingCarriers'][0])
    {
        $request = $this->getShippingCarriersRequest($origin_country_iso, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShippingCarriers' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShippingCarriers' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShippingCarriers', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShippingCarriers';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShippingCarriers',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShippingCarriersAsync
     *
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingCarriers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShippingCarriersAsync($origin_country_iso, string $contentType = self::contentTypes['getShippingCarriers'][0])
    {
        return $this->getShippingCarriersAsyncWithHttpInfo($origin_country_iso, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShippingCarriersAsyncWithHttpInfo
     *
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingCarriers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShippingCarriersAsyncWithHttpInfo($origin_country_iso, string $contentType = self::contentTypes['getShippingCarriers'][0])
    {
        $returnType = '\Etsy\Model\ShippingCarriers';
        $request = $this->getShippingCarriersRequest($origin_country_iso, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShippingCarriers'
     *
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShippingCarriers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShippingCarriersRequest($origin_country_iso, string $contentType = self::contentTypes['getShippingCarriers'][0])
    {

        // verify the required parameter 'origin_country_iso' is set
        if ($origin_country_iso === null || (is_array($origin_country_iso) && count($origin_country_iso) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $origin_country_iso when calling getShippingCarriers'
            );
        }


        $resourcePath = '/v3/application/shipping-carriers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $origin_country_iso,
            'origin_country_iso', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShopShippingProfile
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getShopShippingProfile($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfile'][0])
    {
        list($response) = $this->getShopShippingProfileWithHttpInfo($shop_id, $shipping_profile_id, $contentType);
        return $response;
    }

    /**
     * Operation getShopShippingProfileWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShopShippingProfileWithHttpInfo($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfile'][0])
    {
        $request = $this->getShopShippingProfileRequest($shop_id, $shipping_profile_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopShippingProfile' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfile' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfile', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfile';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfile',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShopShippingProfileAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopShippingProfileAsync($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfile'][0])
    {
        return $this->getShopShippingProfileAsyncWithHttpInfo($shop_id, $shipping_profile_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShopShippingProfileAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopShippingProfileAsyncWithHttpInfo($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfile'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfile';
        $request = $this->getShopShippingProfileRequest($shop_id, $shipping_profile_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShopShippingProfile'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShopShippingProfileRequest($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfile'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getShopShippingProfile'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.getShopShippingProfile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling getShopShippingProfile'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.getShopShippingProfile, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShopShippingProfileDestinationsByShippingProfile
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfileDestinations|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getShopShippingProfileDestinationsByShippingProfile($shop_id, $shipping_profile_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'][0])
    {
        list($response) = $this->getShopShippingProfileDestinationsByShippingProfileWithHttpInfo($shop_id, $shipping_profile_id, $limit, $offset, $contentType);
        return $response;
    }

    /**
     * Operation getShopShippingProfileDestinationsByShippingProfileWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfileDestinations|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShopShippingProfileDestinationsByShippingProfileWithHttpInfo($shop_id, $shipping_profile_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'][0])
    {
        $request = $this->getShopShippingProfileDestinationsByShippingProfileRequest($shop_id, $shipping_profile_id, $limit, $offset, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopShippingProfileDestinations' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfileDestinations' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfileDestinations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfileDestinations';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfileDestinations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShopShippingProfileDestinationsByShippingProfileAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopShippingProfileDestinationsByShippingProfileAsync($shop_id, $shipping_profile_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'][0])
    {
        return $this->getShopShippingProfileDestinationsByShippingProfileAsyncWithHttpInfo($shop_id, $shipping_profile_id, $limit, $offset, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShopShippingProfileDestinationsByShippingProfileAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopShippingProfileDestinationsByShippingProfileAsyncWithHttpInfo($shop_id, $shipping_profile_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfileDestinations';
        $request = $this->getShopShippingProfileDestinationsByShippingProfileRequest($shop_id, $shipping_profile_id, $limit, $offset, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShopShippingProfileDestinationsByShippingProfile'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShopShippingProfileDestinationsByShippingProfileRequest($shop_id, $shipping_profile_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getShopShippingProfileDestinationsByShippingProfile'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getShopShippingProfileDestinationsByShippingProfile'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.getShopShippingProfileDestinationsByShippingProfile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling getShopShippingProfileDestinationsByShippingProfile'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.getShopShippingProfileDestinationsByShippingProfile, must be bigger than or equal to 1.');
        }
        
        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopShippingProfileApi.getShopShippingProfileDestinationsByShippingProfile, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopShippingProfileApi.getShopShippingProfileDestinationsByShippingProfile, must be bigger than or equal to 1.');
        }
        
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling ShopShippingProfileApi.getShopShippingProfileDestinationsByShippingProfile, must be bigger than or equal to 0.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShopShippingProfileUpgrades
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileUpgrades'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfileUpgrades|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getShopShippingProfileUpgrades($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfileUpgrades'][0])
    {
        list($response) = $this->getShopShippingProfileUpgradesWithHttpInfo($shop_id, $shipping_profile_id, $contentType);
        return $response;
    }

    /**
     * Operation getShopShippingProfileUpgradesWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileUpgrades'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfileUpgrades|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShopShippingProfileUpgradesWithHttpInfo($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfileUpgrades'][0])
    {
        $request = $this->getShopShippingProfileUpgradesRequest($shop_id, $shipping_profile_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopShippingProfileUpgrades' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfileUpgrades' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfileUpgrades', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfileUpgrades';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfileUpgrades',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShopShippingProfileUpgradesAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileUpgrades'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopShippingProfileUpgradesAsync($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfileUpgrades'][0])
    {
        return $this->getShopShippingProfileUpgradesAsyncWithHttpInfo($shop_id, $shipping_profile_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShopShippingProfileUpgradesAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileUpgrades'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopShippingProfileUpgradesAsyncWithHttpInfo($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfileUpgrades'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfileUpgrades';
        $request = $this->getShopShippingProfileUpgradesRequest($shop_id, $shipping_profile_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShopShippingProfileUpgrades'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfileUpgrades'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShopShippingProfileUpgradesRequest($shop_id, $shipping_profile_id, string $contentType = self::contentTypes['getShopShippingProfileUpgrades'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getShopShippingProfileUpgrades'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.getShopShippingProfileUpgrades, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling getShopShippingProfileUpgrades'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.getShopShippingProfileUpgrades, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShopShippingProfiles
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfiles'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfiles|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getShopShippingProfiles($shop_id, string $contentType = self::contentTypes['getShopShippingProfiles'][0])
    {
        list($response) = $this->getShopShippingProfilesWithHttpInfo($shop_id, $contentType);
        return $response;
    }

    /**
     * Operation getShopShippingProfilesWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfiles'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfiles|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShopShippingProfilesWithHttpInfo($shop_id, string $contentType = self::contentTypes['getShopShippingProfiles'][0])
    {
        $request = $this->getShopShippingProfilesRequest($shop_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopShippingProfiles' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfiles' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfiles', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfiles';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfiles',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShopShippingProfilesAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfiles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopShippingProfilesAsync($shop_id, string $contentType = self::contentTypes['getShopShippingProfiles'][0])
    {
        return $this->getShopShippingProfilesAsyncWithHttpInfo($shop_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShopShippingProfilesAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfiles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopShippingProfilesAsyncWithHttpInfo($shop_id, string $contentType = self::contentTypes['getShopShippingProfiles'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfiles';
        $request = $this->getShopShippingProfilesRequest($shop_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShopShippingProfiles'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopShippingProfiles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShopShippingProfilesRequest($shop_id, string $contentType = self::contentTypes['getShopShippingProfiles'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getShopShippingProfiles'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.getShopShippingProfiles, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateShopShippingProfile
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $title The name string of this shipping profile. (optional)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (optional)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (optional)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (optional)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function updateShopShippingProfile($shop_id, $shipping_profile_id, $title = null, $origin_country_iso = null, $min_processing_time = null, $max_processing_time = null, $processing_time_unit = 'business_days', $origin_postal_code = null, string $contentType = self::contentTypes['updateShopShippingProfile'][0])
    {
        list($response) = $this->updateShopShippingProfileWithHttpInfo($shop_id, $shipping_profile_id, $title, $origin_country_iso, $min_processing_time, $max_processing_time, $processing_time_unit, $origin_postal_code, $contentType);
        return $response;
    }

    /**
     * Operation updateShopShippingProfileWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $title The name string of this shipping profile. (optional)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (optional)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (optional)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (optional)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateShopShippingProfileWithHttpInfo($shop_id, $shipping_profile_id, $title = null, $origin_country_iso = null, $min_processing_time = null, $max_processing_time = null, $processing_time_unit = 'business_days', $origin_postal_code = null, string $contentType = self::contentTypes['updateShopShippingProfile'][0])
    {
        $request = $this->updateShopShippingProfileRequest($shop_id, $shipping_profile_id, $title, $origin_country_iso, $min_processing_time, $max_processing_time, $processing_time_unit, $origin_postal_code, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopShippingProfile' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfile' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfile', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfile';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfile',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateShopShippingProfileAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $title The name string of this shipping profile. (optional)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (optional)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (optional)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (optional)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopShippingProfileAsync($shop_id, $shipping_profile_id, $title = null, $origin_country_iso = null, $min_processing_time = null, $max_processing_time = null, $processing_time_unit = 'business_days', $origin_postal_code = null, string $contentType = self::contentTypes['updateShopShippingProfile'][0])
    {
        return $this->updateShopShippingProfileAsyncWithHttpInfo($shop_id, $shipping_profile_id, $title, $origin_country_iso, $min_processing_time, $max_processing_time, $processing_time_unit, $origin_postal_code, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateShopShippingProfileAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $title The name string of this shipping profile. (optional)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (optional)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (optional)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (optional)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopShippingProfileAsyncWithHttpInfo($shop_id, $shipping_profile_id, $title = null, $origin_country_iso = null, $min_processing_time = null, $max_processing_time = null, $processing_time_unit = 'business_days', $origin_postal_code = null, string $contentType = self::contentTypes['updateShopShippingProfile'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfile';
        $request = $this->updateShopShippingProfileRequest($shop_id, $shipping_profile_id, $title, $origin_country_iso, $min_processing_time, $max_processing_time, $processing_time_unit, $origin_postal_code, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateShopShippingProfile'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  string $title The name string of this shipping profile. (optional)
     * @param  string $origin_country_iso The ISO code of the country from which the listing ships. (optional)
     * @param  int $min_processing_time The minimum time required to process to ship listings with this shipping profile. (optional)
     * @param  int $max_processing_time The maximum processing time the listing needs to ship. (optional)
     * @param  string $processing_time_unit The unit used to represent how long a processing time is. A week is equivalent to 5 business days. If none is provided, the unit is set to \\\&quot;business_days\\\&quot;. (optional, default to 'business_days')
     * @param  string $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the &#x60;origin_country_iso&#x60; is &#x60;US&#x60; or &#x60;CA&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateShopShippingProfileRequest($shop_id, $shipping_profile_id, $title = null, $origin_country_iso = null, $min_processing_time = null, $max_processing_time = null, $processing_time_unit = 'business_days', $origin_postal_code = null, string $contentType = self::contentTypes['updateShopShippingProfile'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling updateShopShippingProfile'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.updateShopShippingProfile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling updateShopShippingProfile'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.updateShopShippingProfile, must be bigger than or equal to 1.');
        }
        


        if ($min_processing_time !== null && $min_processing_time > 10) {
            throw new \InvalidArgumentException('invalid value for "$min_processing_time" when calling ShopShippingProfileApi.updateShopShippingProfile, must be smaller than or equal to 10.');
        }
        if ($min_processing_time !== null && $min_processing_time < 1) {
            throw new \InvalidArgumentException('invalid value for "$min_processing_time" when calling ShopShippingProfileApi.updateShopShippingProfile, must be bigger than or equal to 1.');
        }
        
        if ($max_processing_time !== null && $max_processing_time > 10) {
            throw new \InvalidArgumentException('invalid value for "$max_processing_time" when calling ShopShippingProfileApi.updateShopShippingProfile, must be smaller than or equal to 10.');
        }
        if ($max_processing_time !== null && $max_processing_time < 1) {
            throw new \InvalidArgumentException('invalid value for "$max_processing_time" when calling ShopShippingProfileApi.updateShopShippingProfile, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }

        // form params
        if ($title !== null) {
            $formParams['title'] = ObjectSerializer::toFormValue($title);
        }
        // form params
        if ($origin_country_iso !== null) {
            $formParams['origin_country_iso'] = ObjectSerializer::toFormValue($origin_country_iso);
        }
        // form params
        if ($min_processing_time !== null) {
            $formParams['min_processing_time'] = ObjectSerializer::toFormValue($min_processing_time);
        }
        // form params
        if ($max_processing_time !== null) {
            $formParams['max_processing_time'] = ObjectSerializer::toFormValue($max_processing_time);
        }
        // form params
        if ($processing_time_unit !== null) {
            $formParams['processing_time_unit'] = ObjectSerializer::toFormValue($processing_time_unit);
        }
        // form params
        if ($origin_postal_code !== null) {
            $formParams['origin_postal_code'] = ObjectSerializer::toFormValue($origin_postal_code);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateShopShippingProfileDestination
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (optional)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (optional)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfileDestination|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function updateShopShippingProfileDestination($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $primary_cost = null, $secondary_cost = null, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileDestination'][0])
    {
        list($response) = $this->updateShopShippingProfileDestinationWithHttpInfo($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $primary_cost, $secondary_cost, $destination_country_iso, $destination_region, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);
        return $response;
    }

    /**
     * Operation updateShopShippingProfileDestinationWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (optional)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (optional)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfileDestination|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateShopShippingProfileDestinationWithHttpInfo($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $primary_cost = null, $secondary_cost = null, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileDestination'][0])
    {
        $request = $this->updateShopShippingProfileDestinationRequest($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $primary_cost, $secondary_cost, $destination_country_iso, $destination_region, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopShippingProfileDestination' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfileDestination' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfileDestination', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfileDestination';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfileDestination',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateShopShippingProfileDestinationAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (optional)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (optional)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopShippingProfileDestinationAsync($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $primary_cost = null, $secondary_cost = null, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileDestination'][0])
    {
        return $this->updateShopShippingProfileDestinationAsyncWithHttpInfo($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $primary_cost, $secondary_cost, $destination_country_iso, $destination_region, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateShopShippingProfileDestinationAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (optional)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (optional)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopShippingProfileDestinationAsyncWithHttpInfo($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $primary_cost = null, $secondary_cost = null, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileDestination'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfileDestination';
        $request = $this->updateShopShippingProfileDestinationRequest($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $primary_cost, $secondary_cost, $destination_country_iso, $destination_region, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateShopShippingProfileDestination'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $shipping_profile_destination_id The numeric ID of the shipping profile destination in the [shipping profile](/documentation/reference#tag/Shop-ShippingProfile) associated with the listing. (required)
     * @param  float $primary_cost The cost of shipping to this country/region alone, measured in the store&#39;s default currency. (optional)
     * @param  float $secondary_cost The cost of shipping to this country/region with another item, measured in the store&#39;s default currency. (optional)
     * @param  string $destination_country_iso The ISO code of the country to which the listing ships. If null, request sets destination to destination_region. Required if destination_region is null or not provided. (optional)
     * @param  string $destination_region The code of the region to which the listing ships. A region represents a set of countries. Supported regions are Europe Union and Non-Europe Union (countries in Europe not in EU). If &#x60;none&#x60;, request sets destination to destination_country_iso. Required if destination_country_iso is null or not provided. (optional, default to 'none')
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileDestination'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateShopShippingProfileDestinationRequest($shop_id, $shipping_profile_id, $shipping_profile_destination_id, $primary_cost = null, $secondary_cost = null, $destination_country_iso = null, $destination_region = 'none', $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileDestination'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling updateShopShippingProfileDestination'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling updateShopShippingProfileDestination'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_destination_id' is set
        if ($shipping_profile_destination_id === null || (is_array($shipping_profile_destination_id) && count($shipping_profile_destination_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_destination_id when calling updateShopShippingProfileDestination'
            );
        }
        if ($shipping_profile_destination_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_destination_id" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        
        if ($primary_cost !== null && $primary_cost < 0) {
            throw new \InvalidArgumentException('invalid value for "$primary_cost" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be bigger than or equal to 0.');
        }
        
        if ($secondary_cost !== null && $secondary_cost < 0) {
            throw new \InvalidArgumentException('invalid value for "$secondary_cost" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be bigger than or equal to 0.');
        }
        


        if ($shipping_carrier_id !== null && $shipping_carrier_id < 0) {
            throw new \InvalidArgumentException('invalid value for "$shipping_carrier_id" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be bigger than or equal to 0.');
        }
        

        if ($min_delivery_days !== null && $min_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be smaller than or equal to 45.');
        }
        if ($min_delivery_days !== null && $min_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        
        if ($max_delivery_days !== null && $max_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be smaller than or equal to 45.');
        }
        if ($max_delivery_days !== null && $max_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.updateShopShippingProfileDestination, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations/{shipping_profile_destination_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_destination_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_destination_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_destination_id),
                $resourcePath
            );
        }

        // form params
        if ($primary_cost !== null) {
            $formParams['primary_cost'] = ObjectSerializer::toFormValue($primary_cost);
        }
        // form params
        if ($secondary_cost !== null) {
            $formParams['secondary_cost'] = ObjectSerializer::toFormValue($secondary_cost);
        }
        // form params
        if ($destination_country_iso !== null) {
            $formParams['destination_country_iso'] = ObjectSerializer::toFormValue($destination_country_iso);
        }
        // form params
        if ($destination_region !== null) {
            $formParams['destination_region'] = ObjectSerializer::toFormValue($destination_region);
        }
        // form params
        if ($shipping_carrier_id !== null) {
            $formParams['shipping_carrier_id'] = ObjectSerializer::toFormValue($shipping_carrier_id);
        }
        // form params
        if ($mail_class !== null) {
            $formParams['mail_class'] = ObjectSerializer::toFormValue($mail_class);
        }
        // form params
        if ($min_delivery_days !== null) {
            $formParams['min_delivery_days'] = ObjectSerializer::toFormValue($min_delivery_days);
        }
        // form params
        if ($max_delivery_days !== null) {
            $formParams['max_delivery_days'] = ObjectSerializer::toFormValue($max_delivery_days);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateShopShippingProfileUpgrade
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (optional)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (optional)
     * @param  float $price Additional cost of adding the shipping upgrade. (optional)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (optional)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopShippingProfileUpgrade|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function updateShopShippingProfileUpgrade($shop_id, $shipping_profile_id, $upgrade_id, $upgrade_name = null, $type = null, $price = null, $secondary_price = null, $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileUpgrade'][0])
    {
        list($response) = $this->updateShopShippingProfileUpgradeWithHttpInfo($shop_id, $shipping_profile_id, $upgrade_id, $upgrade_name, $type, $price, $secondary_price, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);
        return $response;
    }

    /**
     * Operation updateShopShippingProfileUpgradeWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (optional)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (optional)
     * @param  float $price Additional cost of adding the shipping upgrade. (optional)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (optional)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopShippingProfileUpgrade|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateShopShippingProfileUpgradeWithHttpInfo($shop_id, $shipping_profile_id, $upgrade_id, $upgrade_name = null, $type = null, $price = null, $secondary_price = null, $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileUpgrade'][0])
    {
        $request = $this->updateShopShippingProfileUpgradeRequest($shop_id, $shipping_profile_id, $upgrade_id, $upgrade_name, $type, $price, $secondary_price, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopShippingProfileUpgrade' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopShippingProfileUpgrade' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopShippingProfileUpgrade', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopShippingProfileUpgrade';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopShippingProfileUpgrade',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateShopShippingProfileUpgradeAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (optional)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (optional)
     * @param  float $price Additional cost of adding the shipping upgrade. (optional)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (optional)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopShippingProfileUpgradeAsync($shop_id, $shipping_profile_id, $upgrade_id, $upgrade_name = null, $type = null, $price = null, $secondary_price = null, $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileUpgrade'][0])
    {
        return $this->updateShopShippingProfileUpgradeAsyncWithHttpInfo($shop_id, $shipping_profile_id, $upgrade_id, $upgrade_name, $type, $price, $secondary_price, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateShopShippingProfileUpgradeAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (optional)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (optional)
     * @param  float $price Additional cost of adding the shipping upgrade. (optional)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (optional)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopShippingProfileUpgradeAsyncWithHttpInfo($shop_id, $shipping_profile_id, $upgrade_id, $upgrade_name = null, $type = null, $price = null, $secondary_price = null, $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileUpgrade'][0])
    {
        $returnType = '\Etsy\Model\ShopShippingProfileUpgrade';
        $request = $this->updateShopShippingProfileUpgradeRequest($shop_id, $shipping_profile_id, $upgrade_id, $upgrade_name, $type, $price, $secondary_price, $shipping_carrier_id, $mail_class, $min_delivery_days, $max_delivery_days, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateShopShippingProfileUpgrade'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (required)
     * @param  int $upgrade_id The numeric ID that is associated with a shipping upgrade (required)
     * @param  string $upgrade_name Name for the shipping upgrade shown to shoppers at checkout, e.g. USPS Priority. (optional)
     * @param  string $type The type of the shipping upgrade. Domestic (0) or international (1). (optional)
     * @param  float $price Additional cost of adding the shipping upgrade. (optional)
     * @param  float $secondary_price Additional cost of adding the shipping upgrade for each additional item. (optional)
     * @param  int $shipping_carrier_id The unique ID of a supported shipping carrier, which is used to calculate an Estimated Delivery Date. **Required with &#x60;mail_class&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  string $mail_class The unique ID string of a shipping carrier&#39;s mail class, which is used to calculate an estimated delivery date. **Required with &#x60;shipping_carrier_id&#x60;** if &#x60;min_delivery_days&#x60; and &#x60;max_delivery_days&#x60; are null. (optional)
     * @param  int $min_delivery_days The minimum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;max_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  int $max_delivery_days The maximum number of business days a buyer can expect to wait to receive their purchased item once it has shipped. **Required with &#x60;min_delivery_days&#x60;** if &#x60;mail_class&#x60; is null. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopShippingProfileUpgrade'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateShopShippingProfileUpgradeRequest($shop_id, $shipping_profile_id, $upgrade_id, $upgrade_name = null, $type = null, $price = null, $secondary_price = null, $shipping_carrier_id = null, $mail_class = null, $min_delivery_days = null, $max_delivery_days = null, string $contentType = self::contentTypes['updateShopShippingProfileUpgrade'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling updateShopShippingProfileUpgrade'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shipping_profile_id' is set
        if ($shipping_profile_id === null || (is_array($shipping_profile_id) && count($shipping_profile_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shipping_profile_id when calling updateShopShippingProfileUpgrade'
            );
        }
        if ($shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'upgrade_id' is set
        if ($upgrade_id === null || (is_array($upgrade_id) && count($upgrade_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $upgrade_id when calling updateShopShippingProfileUpgrade'
            );
        }
        if ($upgrade_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$upgrade_id" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        


        if ($price !== null && $price < 0) {
            throw new \InvalidArgumentException('invalid value for "$price" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be bigger than or equal to 0.');
        }
        
        if ($secondary_price !== null && $secondary_price < 0) {
            throw new \InvalidArgumentException('invalid value for "$secondary_price" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be bigger than or equal to 0.');
        }
        
        if ($shipping_carrier_id !== null && $shipping_carrier_id < 0) {
            throw new \InvalidArgumentException('invalid value for "$shipping_carrier_id" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be bigger than or equal to 0.');
        }
        

        if ($min_delivery_days !== null && $min_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be smaller than or equal to 45.');
        }
        if ($min_delivery_days !== null && $min_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$min_delivery_days" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        
        if ($max_delivery_days !== null && $max_delivery_days > 45) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be smaller than or equal to 45.');
        }
        if ($max_delivery_days !== null && $max_delivery_days < 1) {
            throw new \InvalidArgumentException('invalid value for "$max_delivery_days" when calling ShopShippingProfileApi.updateShopShippingProfileUpgrade, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades/{upgrade_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($shipping_profile_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shipping_profile_id' . '}',
                ObjectSerializer::toPathValue($shipping_profile_id),
                $resourcePath
            );
        }
        // path params
        if ($upgrade_id !== null) {
            $resourcePath = str_replace(
                '{' . 'upgrade_id' . '}',
                ObjectSerializer::toPathValue($upgrade_id),
                $resourcePath
            );
        }

        // form params
        if ($upgrade_name !== null) {
            $formParams['upgrade_name'] = ObjectSerializer::toFormValue($upgrade_name);
        }
        // form params
        if ($type !== null) {
            $formParams['type'] = ObjectSerializer::toFormValue($type);
        }
        // form params
        if ($price !== null) {
            $formParams['price'] = ObjectSerializer::toFormValue($price);
        }
        // form params
        if ($secondary_price !== null) {
            $formParams['secondary_price'] = ObjectSerializer::toFormValue($secondary_price);
        }
        // form params
        if ($shipping_carrier_id !== null) {
            $formParams['shipping_carrier_id'] = ObjectSerializer::toFormValue($shipping_carrier_id);
        }
        // form params
        if ($mail_class !== null) {
            $formParams['mail_class'] = ObjectSerializer::toFormValue($mail_class);
        }
        // form params
        if ($min_delivery_days !== null) {
            $formParams['min_delivery_days'] = ObjectSerializer::toFormValue($min_delivery_days);
        }
        // form params
        if ($max_delivery_days !== null) {
            $formParams['max_delivery_days'] = ObjectSerializer::toFormValue($max_delivery_days);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
