<?php
/**
 * ShopListingApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Etsy\ApiException;
use Etsy\Configuration;
use Etsy\HeaderSelector;
use Etsy\ObjectSerializer;

/**
 * ShopListingApi Class Doc Comment
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ShopListingApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createDraftListing' => [
            'application/x-www-form-urlencoded',
        ],
        'deleteListing' => [
            'application/json',
        ],
        'deleteListingProperty' => [
            'application/json',
        ],
        'findAllActiveListingsByShop' => [
            'application/json',
        ],
        'findAllListingsActive' => [
            'application/json',
        ],
        'getFeaturedListingsByShop' => [
            'application/json',
        ],
        'getListing' => [
            'application/json',
        ],
        'getListingProperties' => [
            'application/json',
        ],
        'getListingProperty' => [
            'application/json',
        ],
        'getListingsByListingIds' => [
            'application/json',
        ],
        'getListingsByShop' => [
            'application/json',
        ],
        'getListingsByShopReceipt' => [
            'application/json',
        ],
        'getListingsByShopReturnPolicy' => [
            'application/json',
        ],
        'getListingsByShopSectionId' => [
            'application/json',
        ],
        'updateListing' => [
            'application/x-www-form-urlencoded',
        ],
        'updateListingDeprecated' => [
            'application/x-www-form-urlencoded',
        ],
        'updateListingProperty' => [
            'application/x-www-form-urlencoded',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createDraftListing
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $quantity The positive non-zero number of products available for purchase in the listing. Note: The listing quantity is the sum of available offering quantities. You can request the quantities for individual offerings from the ListingInventory resource using the [getListingInventory](/documentation/reference#operation/getListingInventory) endpoint. (required)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (required)
     * @param  string $description A description string of the product for sale in the listing. (required)
     * @param  float $price The positive non-zero price of the product. (Sold product listings are private) Note: The price is the minimum possible price. The [&#x60;getListingInventory&#x60;](/documentation/reference/#operation/getListingInventory) method requests exact prices for available offerings. (required)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (required)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (required)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  int $processing_min The minimum number of days required to process this listing. Default value is null. (optional)
     * @param  int $processing_max The maximum number of days required to process this listing. Default value is null. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string[] $styles An array of style strings for this listing, each of which is free-form text string such as \\\&quot;Formal\\\&quot;, or \\\&quot;Steampunk\\\&quot;. When creating or updating a listing, the listing may have up to two styles. Valid style strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  bool $is_customizable When true, a buyer may contact the seller for a customized order. The default value is true when a shop accepts custom orders. Does not apply to shops that do not accept custom orders. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftListing'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListing|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function createDraftListing($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id = null, $return_policy_id = null, $materials = null, $shop_section_id = null, $processing_min = null, $processing_max = null, $tags = null, $styles = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $production_partner_ids = null, $image_ids = null, $is_supply = null, $is_customizable = null, $should_auto_renew = null, $is_taxable = null, $type = null, string $contentType = self::contentTypes['createDraftListing'][0])
    {
        list($response) = $this->createDraftListingWithHttpInfo($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id, $return_policy_id, $materials, $shop_section_id, $processing_min, $processing_max, $tags, $styles, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $production_partner_ids, $image_ids, $is_supply, $is_customizable, $should_auto_renew, $is_taxable, $type, $contentType);
        return $response;
    }

    /**
     * Operation createDraftListingWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $quantity The positive non-zero number of products available for purchase in the listing. Note: The listing quantity is the sum of available offering quantities. You can request the quantities for individual offerings from the ListingInventory resource using the [getListingInventory](/documentation/reference#operation/getListingInventory) endpoint. (required)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (required)
     * @param  string $description A description string of the product for sale in the listing. (required)
     * @param  float $price The positive non-zero price of the product. (Sold product listings are private) Note: The price is the minimum possible price. The [&#x60;getListingInventory&#x60;](/documentation/reference/#operation/getListingInventory) method requests exact prices for available offerings. (required)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (required)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (required)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  int $processing_min The minimum number of days required to process this listing. Default value is null. (optional)
     * @param  int $processing_max The maximum number of days required to process this listing. Default value is null. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string[] $styles An array of style strings for this listing, each of which is free-form text string such as \\\&quot;Formal\\\&quot;, or \\\&quot;Steampunk\\\&quot;. When creating or updating a listing, the listing may have up to two styles. Valid style strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  bool $is_customizable When true, a buyer may contact the seller for a customized order. The default value is true when a shop accepts custom orders. Does not apply to shops that do not accept custom orders. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftListing'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListing|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDraftListingWithHttpInfo($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id = null, $return_policy_id = null, $materials = null, $shop_section_id = null, $processing_min = null, $processing_max = null, $tags = null, $styles = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $production_partner_ids = null, $image_ids = null, $is_supply = null, $is_customizable = null, $should_auto_renew = null, $is_taxable = null, $type = null, string $contentType = self::contentTypes['createDraftListing'][0])
    {
        $request = $this->createDraftListingRequest($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id, $return_policy_id, $materials, $shop_section_id, $processing_min, $processing_max, $tags, $styles, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $production_partner_ids, $image_ids, $is_supply, $is_customizable, $should_auto_renew, $is_taxable, $type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\Etsy\Model\ShopListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createDraftListingAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $quantity The positive non-zero number of products available for purchase in the listing. Note: The listing quantity is the sum of available offering quantities. You can request the quantities for individual offerings from the ListingInventory resource using the [getListingInventory](/documentation/reference#operation/getListingInventory) endpoint. (required)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (required)
     * @param  string $description A description string of the product for sale in the listing. (required)
     * @param  float $price The positive non-zero price of the product. (Sold product listings are private) Note: The price is the minimum possible price. The [&#x60;getListingInventory&#x60;](/documentation/reference/#operation/getListingInventory) method requests exact prices for available offerings. (required)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (required)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (required)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  int $processing_min The minimum number of days required to process this listing. Default value is null. (optional)
     * @param  int $processing_max The maximum number of days required to process this listing. Default value is null. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string[] $styles An array of style strings for this listing, each of which is free-form text string such as \\\&quot;Formal\\\&quot;, or \\\&quot;Steampunk\\\&quot;. When creating or updating a listing, the listing may have up to two styles. Valid style strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  bool $is_customizable When true, a buyer may contact the seller for a customized order. The default value is true when a shop accepts custom orders. Does not apply to shops that do not accept custom orders. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDraftListingAsync($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id = null, $return_policy_id = null, $materials = null, $shop_section_id = null, $processing_min = null, $processing_max = null, $tags = null, $styles = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $production_partner_ids = null, $image_ids = null, $is_supply = null, $is_customizable = null, $should_auto_renew = null, $is_taxable = null, $type = null, string $contentType = self::contentTypes['createDraftListing'][0])
    {
        return $this->createDraftListingAsyncWithHttpInfo($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id, $return_policy_id, $materials, $shop_section_id, $processing_min, $processing_max, $tags, $styles, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $production_partner_ids, $image_ids, $is_supply, $is_customizable, $should_auto_renew, $is_taxable, $type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createDraftListingAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $quantity The positive non-zero number of products available for purchase in the listing. Note: The listing quantity is the sum of available offering quantities. You can request the quantities for individual offerings from the ListingInventory resource using the [getListingInventory](/documentation/reference#operation/getListingInventory) endpoint. (required)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (required)
     * @param  string $description A description string of the product for sale in the listing. (required)
     * @param  float $price The positive non-zero price of the product. (Sold product listings are private) Note: The price is the minimum possible price. The [&#x60;getListingInventory&#x60;](/documentation/reference/#operation/getListingInventory) method requests exact prices for available offerings. (required)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (required)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (required)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  int $processing_min The minimum number of days required to process this listing. Default value is null. (optional)
     * @param  int $processing_max The maximum number of days required to process this listing. Default value is null. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string[] $styles An array of style strings for this listing, each of which is free-form text string such as \\\&quot;Formal\\\&quot;, or \\\&quot;Steampunk\\\&quot;. When creating or updating a listing, the listing may have up to two styles. Valid style strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  bool $is_customizable When true, a buyer may contact the seller for a customized order. The default value is true when a shop accepts custom orders. Does not apply to shops that do not accept custom orders. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDraftListingAsyncWithHttpInfo($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id = null, $return_policy_id = null, $materials = null, $shop_section_id = null, $processing_min = null, $processing_max = null, $tags = null, $styles = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $production_partner_ids = null, $image_ids = null, $is_supply = null, $is_customizable = null, $should_auto_renew = null, $is_taxable = null, $type = null, string $contentType = self::contentTypes['createDraftListing'][0])
    {
        $returnType = '\Etsy\Model\ShopListing';
        $request = $this->createDraftListingRequest($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id, $return_policy_id, $materials, $shop_section_id, $processing_min, $processing_max, $tags, $styles, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $production_partner_ids, $image_ids, $is_supply, $is_customizable, $should_auto_renew, $is_taxable, $type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createDraftListing'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $quantity The positive non-zero number of products available for purchase in the listing. Note: The listing quantity is the sum of available offering quantities. You can request the quantities for individual offerings from the ListingInventory resource using the [getListingInventory](/documentation/reference#operation/getListingInventory) endpoint. (required)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (required)
     * @param  string $description A description string of the product for sale in the listing. (required)
     * @param  float $price The positive non-zero price of the product. (Sold product listings are private) Note: The price is the minimum possible price. The [&#x60;getListingInventory&#x60;](/documentation/reference/#operation/getListingInventory) method requests exact prices for available offerings. (required)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (required)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (required)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (required)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  int $processing_min The minimum number of days required to process this listing. Default value is null. (optional)
     * @param  int $processing_max The maximum number of days required to process this listing. Default value is null. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string[] $styles An array of style strings for this listing, each of which is free-form text string such as \\\&quot;Formal\\\&quot;, or \\\&quot;Steampunk\\\&quot;. When creating or updating a listing, the listing may have up to two styles. Valid style strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  bool $is_customizable When true, a buyer may contact the seller for a customized order. The default value is true when a shop accepts custom orders. Does not apply to shops that do not accept custom orders. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDraftListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createDraftListingRequest($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id = null, $return_policy_id = null, $materials = null, $shop_section_id = null, $processing_min = null, $processing_max = null, $tags = null, $styles = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $production_partner_ids = null, $image_ids = null, $is_supply = null, $is_customizable = null, $should_auto_renew = null, $is_taxable = null, $type = null, string $contentType = self::contentTypes['createDraftListing'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling createDraftListing'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.createDraftListing, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'quantity' is set
        if ($quantity === null || (is_array($quantity) && count($quantity) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $quantity when calling createDraftListing'
            );
        }

        // verify the required parameter 'title' is set
        if ($title === null || (is_array($title) && count($title) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $title when calling createDraftListing'
            );
        }

        // verify the required parameter 'description' is set
        if ($description === null || (is_array($description) && count($description) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $description when calling createDraftListing'
            );
        }

        // verify the required parameter 'price' is set
        if ($price === null || (is_array($price) && count($price) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $price when calling createDraftListing'
            );
        }

        // verify the required parameter 'who_made' is set
        if ($who_made === null || (is_array($who_made) && count($who_made) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $who_made when calling createDraftListing'
            );
        }

        // verify the required parameter 'when_made' is set
        if ($when_made === null || (is_array($when_made) && count($when_made) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $when_made when calling createDraftListing'
            );
        }

        // verify the required parameter 'taxonomy_id' is set
        if ($taxonomy_id === null || (is_array($taxonomy_id) && count($taxonomy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $taxonomy_id when calling createDraftListing'
            );
        }
        if ($taxonomy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$taxonomy_id" when calling ShopListingApi.createDraftListing, must be bigger than or equal to 1.');
        }
        
        if ($shipping_profile_id !== null && $shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopListingApi.createDraftListing, must be bigger than or equal to 1.');
        }
        
        if ($return_policy_id !== null && $return_policy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$return_policy_id" when calling ShopListingApi.createDraftListing, must be bigger than or equal to 1.');
        }
        

        if ($shop_section_id !== null && $shop_section_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_section_id" when calling ShopListingApi.createDraftListing, must be bigger than or equal to 1.');
        }
        




        if ($item_weight !== null && $item_weight > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_weight" when calling ShopListingApi.createDraftListing, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_weight !== null && $item_weight < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_weight" when calling ShopListingApi.createDraftListing, must be bigger than or equal to 0.');
        }
        
        if ($item_length !== null && $item_length > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_length" when calling ShopListingApi.createDraftListing, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_length !== null && $item_length < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_length" when calling ShopListingApi.createDraftListing, must be bigger than or equal to 0.');
        }
        
        if ($item_width !== null && $item_width > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_width" when calling ShopListingApi.createDraftListing, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_width !== null && $item_width < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_width" when calling ShopListingApi.createDraftListing, must be bigger than or equal to 0.');
        }
        
        if ($item_height !== null && $item_height > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_height" when calling ShopListingApi.createDraftListing, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_height !== null && $item_height < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_height" when calling ShopListingApi.createDraftListing, must be bigger than or equal to 0.');
        }
        














        $resourcePath = '/v3/application/shops/{shop_id}/listings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }

        // form params
        if ($quantity !== null) {
            $formParams['quantity'] = ObjectSerializer::toFormValue($quantity);
        }
        // form params
        if ($title !== null) {
            $formParams['title'] = ObjectSerializer::toFormValue($title);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = ObjectSerializer::toFormValue($description);
        }
        // form params
        if ($price !== null) {
            $formParams['price'] = ObjectSerializer::toFormValue($price);
        }
        // form params
        if ($who_made !== null) {
            $formParams['who_made'] = ObjectSerializer::toFormValue($who_made);
        }
        // form params
        if ($when_made !== null) {
            $formParams['when_made'] = ObjectSerializer::toFormValue($when_made);
        }
        // form params
        if ($taxonomy_id !== null) {
            $formParams['taxonomy_id'] = ObjectSerializer::toFormValue($taxonomy_id);
        }
        // form params
        if ($shipping_profile_id !== null) {
            $formParams['shipping_profile_id'] = ObjectSerializer::toFormValue($shipping_profile_id);
        }
        // form params
        if ($return_policy_id !== null) {
            $formParams['return_policy_id'] = ObjectSerializer::toFormValue($return_policy_id);
        }
        // form params
        if ($materials !== null) {
            $formParams['materials'] = ObjectSerializer::toFormValue($materials);
        }
        // form params
        if ($shop_section_id !== null) {
            $formParams['shop_section_id'] = ObjectSerializer::toFormValue($shop_section_id);
        }
        // form params
        if ($processing_min !== null) {
            $formParams['processing_min'] = ObjectSerializer::toFormValue($processing_min);
        }
        // form params
        if ($processing_max !== null) {
            $formParams['processing_max'] = ObjectSerializer::toFormValue($processing_max);
        }
        // form params
        if ($tags !== null) {
            $formParams['tags'] = ObjectSerializer::toFormValue($tags);
        }
        // form params
        if ($styles !== null) {
            $formParams['styles'] = ObjectSerializer::toFormValue($styles);
        }
        // form params
        if ($item_weight !== null) {
            $formParams['item_weight'] = ObjectSerializer::toFormValue($item_weight);
        }
        // form params
        if ($item_length !== null) {
            $formParams['item_length'] = ObjectSerializer::toFormValue($item_length);
        }
        // form params
        if ($item_width !== null) {
            $formParams['item_width'] = ObjectSerializer::toFormValue($item_width);
        }
        // form params
        if ($item_height !== null) {
            $formParams['item_height'] = ObjectSerializer::toFormValue($item_height);
        }
        // form params
        if ($item_weight_unit !== null) {
            $formParams['item_weight_unit'] = ObjectSerializer::toFormValue($item_weight_unit);
        }
        // form params
        if ($item_dimensions_unit !== null) {
            $formParams['item_dimensions_unit'] = ObjectSerializer::toFormValue($item_dimensions_unit);
        }
        // form params
        if ($is_personalizable !== null) {
            $formParams['is_personalizable'] = ObjectSerializer::toFormValue($is_personalizable);
        }
        // form params
        if ($personalization_is_required !== null) {
            $formParams['personalization_is_required'] = ObjectSerializer::toFormValue($personalization_is_required);
        }
        // form params
        if ($personalization_char_count_max !== null) {
            $formParams['personalization_char_count_max'] = ObjectSerializer::toFormValue($personalization_char_count_max);
        }
        // form params
        if ($personalization_instructions !== null) {
            $formParams['personalization_instructions'] = ObjectSerializer::toFormValue($personalization_instructions);
        }
        // form params
        if ($production_partner_ids !== null) {
            $formParams['production_partner_ids'] = ObjectSerializer::toFormValue($production_partner_ids);
        }
        // form params
        if ($image_ids !== null) {
            $formParams['image_ids'] = ObjectSerializer::toFormValue($image_ids);
        }
        // form params
        if ($is_supply !== null) {
            $formParams['is_supply'] = ObjectSerializer::toFormValue($is_supply);
        }
        // form params
        if ($is_customizable !== null) {
            $formParams['is_customizable'] = ObjectSerializer::toFormValue($is_customizable);
        }
        // form params
        if ($should_auto_renew !== null) {
            $formParams['should_auto_renew'] = ObjectSerializer::toFormValue($should_auto_renew);
        }
        // form params
        if ($is_taxable !== null) {
            $formParams['is_taxable'] = ObjectSerializer::toFormValue($is_taxable);
        }
        // form params
        if ($type !== null) {
            $formParams['type'] = ObjectSerializer::toFormValue($type);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteListing
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListing'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteListing($listing_id, string $contentType = self::contentTypes['deleteListing'][0])
    {
        $this->deleteListingWithHttpInfo($listing_id, $contentType);
    }

    /**
     * Operation deleteListingWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListing'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteListingWithHttpInfo($listing_id, string $contentType = self::contentTypes['deleteListing'][0])
    {
        $request = $this->deleteListingRequest($listing_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteListingAsync
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteListingAsync($listing_id, string $contentType = self::contentTypes['deleteListing'][0])
    {
        return $this->deleteListingAsyncWithHttpInfo($listing_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteListingAsyncWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteListingAsyncWithHttpInfo($listing_id, string $contentType = self::contentTypes['deleteListing'][0])
    {
        $returnType = '';
        $request = $this->deleteListingRequest($listing_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteListing'
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteListingRequest($listing_id, string $contentType = self::contentTypes['deleteListing'][0])
    {

        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling deleteListing'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingApi.deleteListing, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/listings/{listing_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteListingProperty
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingProperty'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteListingProperty($shop_id, $listing_id, $property_id, string $contentType = self::contentTypes['deleteListingProperty'][0])
    {
        $this->deleteListingPropertyWithHttpInfo($shop_id, $listing_id, $property_id, $contentType);
    }

    /**
     * Operation deleteListingPropertyWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingProperty'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteListingPropertyWithHttpInfo($shop_id, $listing_id, $property_id, string $contentType = self::contentTypes['deleteListingProperty'][0])
    {
        $request = $this->deleteListingPropertyRequest($shop_id, $listing_id, $property_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteListingPropertyAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingProperty'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteListingPropertyAsync($shop_id, $listing_id, $property_id, string $contentType = self::contentTypes['deleteListingProperty'][0])
    {
        return $this->deleteListingPropertyAsyncWithHttpInfo($shop_id, $listing_id, $property_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteListingPropertyAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingProperty'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteListingPropertyAsyncWithHttpInfo($shop_id, $listing_id, $property_id, string $contentType = self::contentTypes['deleteListingProperty'][0])
    {
        $returnType = '';
        $request = $this->deleteListingPropertyRequest($shop_id, $listing_id, $property_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteListingProperty'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingProperty'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteListingPropertyRequest($shop_id, $listing_id, $property_id, string $contentType = self::contentTypes['deleteListingProperty'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling deleteListingProperty'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.deleteListingProperty, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling deleteListingProperty'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingApi.deleteListingProperty, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'property_id' is set
        if ($property_id === null || (is_array($property_id) && count($property_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $property_id when calling deleteListingProperty'
            );
        }
        if ($property_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$property_id" when calling ShopListingApi.deleteListingProperty, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/properties/{property_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }
        // path params
        if ($property_id !== null) {
            $resourcePath = str_replace(
                '{' . 'property_id' . '}',
                ObjectSerializer::toPathValue($property_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findAllActiveListingsByShop
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllActiveListingsByShop'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function findAllActiveListingsByShop($shop_id, $limit = 25, $sort_on = 'created', $sort_order = 'desc', $offset = 0, $keywords = null, string $contentType = self::contentTypes['findAllActiveListingsByShop'][0])
    {
        list($response) = $this->findAllActiveListingsByShopWithHttpInfo($shop_id, $limit, $sort_on, $sort_order, $offset, $keywords, $contentType);
        return $response;
    }

    /**
     * Operation findAllActiveListingsByShopWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllActiveListingsByShop'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function findAllActiveListingsByShopWithHttpInfo($shop_id, $limit = 25, $sort_on = 'created', $sort_order = 'desc', $offset = 0, $keywords = null, string $contentType = self::contentTypes['findAllActiveListingsByShop'][0])
    {
        $request = $this->findAllActiveListingsByShopRequest($shop_id, $limit, $sort_on, $sort_order, $offset, $keywords, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListings' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListings' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListings';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findAllActiveListingsByShopAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllActiveListingsByShop'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findAllActiveListingsByShopAsync($shop_id, $limit = 25, $sort_on = 'created', $sort_order = 'desc', $offset = 0, $keywords = null, string $contentType = self::contentTypes['findAllActiveListingsByShop'][0])
    {
        return $this->findAllActiveListingsByShopAsyncWithHttpInfo($shop_id, $limit, $sort_on, $sort_order, $offset, $keywords, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findAllActiveListingsByShopAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllActiveListingsByShop'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findAllActiveListingsByShopAsyncWithHttpInfo($shop_id, $limit = 25, $sort_on = 'created', $sort_order = 'desc', $offset = 0, $keywords = null, string $contentType = self::contentTypes['findAllActiveListingsByShop'][0])
    {
        $returnType = '\Etsy\Model\ShopListings';
        $request = $this->findAllActiveListingsByShopRequest($shop_id, $limit, $sort_on, $sort_order, $offset, $keywords, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findAllActiveListingsByShop'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllActiveListingsByShop'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function findAllActiveListingsByShopRequest($shop_id, $limit = 25, $sort_on = 'created', $sort_order = 'desc', $offset = 0, $keywords = null, string $contentType = self::contentTypes['findAllActiveListingsByShop'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling findAllActiveListingsByShop'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.findAllActiveListingsByShop, must be bigger than or equal to 1.');
        }
        
        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.findAllActiveListingsByShop, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.findAllActiveListingsByShop, must be bigger than or equal to 1.');
        }
        


        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling ShopListingApi.findAllActiveListingsByShop, must be bigger than or equal to 0.');
        }
        


        $resourcePath = '/v3/application/shops/{shop_id}/listings/active';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_on,
            'sort_on', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sort_order', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $keywords,
            'keywords', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findAllListingsActive
     *
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  float $min_price The minimum price of listings to be returned by a search result. (optional)
     * @param  float $max_price The maximum price of listings to be returned by a search result. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string $shop_location Filters by shop location. If location cannot be parsed, Etsy responds with an error. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllListingsActive'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function findAllListingsActive($limit = 25, $offset = 0, $keywords = null, $sort_on = 'created', $sort_order = 'desc', $min_price = null, $max_price = null, $taxonomy_id = null, $shop_location = null, string $contentType = self::contentTypes['findAllListingsActive'][0])
    {
        list($response) = $this->findAllListingsActiveWithHttpInfo($limit, $offset, $keywords, $sort_on, $sort_order, $min_price, $max_price, $taxonomy_id, $shop_location, $contentType);
        return $response;
    }

    /**
     * Operation findAllListingsActiveWithHttpInfo
     *
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  float $min_price The minimum price of listings to be returned by a search result. (optional)
     * @param  float $max_price The maximum price of listings to be returned by a search result. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string $shop_location Filters by shop location. If location cannot be parsed, Etsy responds with an error. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllListingsActive'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function findAllListingsActiveWithHttpInfo($limit = 25, $offset = 0, $keywords = null, $sort_on = 'created', $sort_order = 'desc', $min_price = null, $max_price = null, $taxonomy_id = null, $shop_location = null, string $contentType = self::contentTypes['findAllListingsActive'][0])
    {
        $request = $this->findAllListingsActiveRequest($limit, $offset, $keywords, $sort_on, $sort_order, $min_price, $max_price, $taxonomy_id, $shop_location, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListings' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListings' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListings';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findAllListingsActiveAsync
     *
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  float $min_price The minimum price of listings to be returned by a search result. (optional)
     * @param  float $max_price The maximum price of listings to be returned by a search result. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string $shop_location Filters by shop location. If location cannot be parsed, Etsy responds with an error. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllListingsActive'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findAllListingsActiveAsync($limit = 25, $offset = 0, $keywords = null, $sort_on = 'created', $sort_order = 'desc', $min_price = null, $max_price = null, $taxonomy_id = null, $shop_location = null, string $contentType = self::contentTypes['findAllListingsActive'][0])
    {
        return $this->findAllListingsActiveAsyncWithHttpInfo($limit, $offset, $keywords, $sort_on, $sort_order, $min_price, $max_price, $taxonomy_id, $shop_location, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findAllListingsActiveAsyncWithHttpInfo
     *
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  float $min_price The minimum price of listings to be returned by a search result. (optional)
     * @param  float $max_price The maximum price of listings to be returned by a search result. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string $shop_location Filters by shop location. If location cannot be parsed, Etsy responds with an error. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllListingsActive'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findAllListingsActiveAsyncWithHttpInfo($limit = 25, $offset = 0, $keywords = null, $sort_on = 'created', $sort_order = 'desc', $min_price = null, $max_price = null, $taxonomy_id = null, $shop_location = null, string $contentType = self::contentTypes['findAllListingsActive'][0])
    {
        $returnType = '\Etsy\Model\ShopListings';
        $request = $this->findAllListingsActiveRequest($limit, $offset, $keywords, $sort_on, $sort_order, $min_price, $max_price, $taxonomy_id, $shop_location, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findAllListingsActive'
     *
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $keywords Search term or phrase that must appear in all results. (optional)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  float $min_price The minimum price of listings to be returned by a search result. (optional)
     * @param  float $max_price The maximum price of listings to be returned by a search result. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string $shop_location Filters by shop location. If location cannot be parsed, Etsy responds with an error. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['findAllListingsActive'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function findAllListingsActiveRequest($limit = 25, $offset = 0, $keywords = null, $sort_on = 'created', $sort_order = 'desc', $min_price = null, $max_price = null, $taxonomy_id = null, $shop_location = null, string $contentType = self::contentTypes['findAllListingsActive'][0])
    {

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.findAllListingsActive, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.findAllListingsActive, must be bigger than or equal to 1.');
        }
        
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling ShopListingApi.findAllListingsActive, must be bigger than or equal to 0.');
        }
        





        if ($taxonomy_id !== null && $taxonomy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$taxonomy_id" when calling ShopListingApi.findAllListingsActive, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/v3/application/listings/active';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $keywords,
            'keywords', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_on,
            'sort_on', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sort_order', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_price,
            'min_price', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_price,
            'max_price', // param base name
            'number', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $taxonomy_id,
            'taxonomy_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_location,
            'shop_location', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFeaturedListingsByShop
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFeaturedListingsByShop'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getFeaturedListingsByShop($shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getFeaturedListingsByShop'][0])
    {
        list($response) = $this->getFeaturedListingsByShopWithHttpInfo($shop_id, $limit, $offset, $contentType);
        return $response;
    }

    /**
     * Operation getFeaturedListingsByShopWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFeaturedListingsByShop'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFeaturedListingsByShopWithHttpInfo($shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getFeaturedListingsByShop'][0])
    {
        $request = $this->getFeaturedListingsByShopRequest($shop_id, $limit, $offset, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListings' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListings' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListings';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getFeaturedListingsByShopAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFeaturedListingsByShop'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFeaturedListingsByShopAsync($shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getFeaturedListingsByShop'][0])
    {
        return $this->getFeaturedListingsByShopAsyncWithHttpInfo($shop_id, $limit, $offset, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getFeaturedListingsByShopAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFeaturedListingsByShop'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFeaturedListingsByShopAsyncWithHttpInfo($shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getFeaturedListingsByShop'][0])
    {
        $returnType = '\Etsy\Model\ShopListings';
        $request = $this->getFeaturedListingsByShopRequest($shop_id, $limit, $offset, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFeaturedListingsByShop'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFeaturedListingsByShop'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getFeaturedListingsByShopRequest($shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getFeaturedListingsByShop'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getFeaturedListingsByShop'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.getFeaturedListingsByShop, must be bigger than or equal to 1.');
        }
        
        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.getFeaturedListingsByShop, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.getFeaturedListingsByShop, must be bigger than or equal to 1.');
        }
        
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling ShopListingApi.getFeaturedListingsByShop, must be bigger than or equal to 0.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/featured';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListing
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $language The IETF language tag for the language of this translation. Ex: &#x60;de&#x60;, &#x60;en&#x60;, &#x60;es&#x60;, &#x60;fr&#x60;, &#x60;it&#x60;, &#x60;ja&#x60;, &#x60;nl&#x60;, &#x60;pl&#x60;, &#x60;pt&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListing'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListingWithAssociations|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListing($listing_id, $includes = null, $language = null, string $contentType = self::contentTypes['getListing'][0])
    {
        list($response) = $this->getListingWithHttpInfo($listing_id, $includes, $language, $contentType);
        return $response;
    }

    /**
     * Operation getListingWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $language The IETF language tag for the language of this translation. Ex: &#x60;de&#x60;, &#x60;en&#x60;, &#x60;es&#x60;, &#x60;fr&#x60;, &#x60;it&#x60;, &#x60;ja&#x60;, &#x60;nl&#x60;, &#x60;pl&#x60;, &#x60;pt&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListing'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListingWithAssociations|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingWithHttpInfo($listing_id, $includes = null, $language = null, string $contentType = self::contentTypes['getListing'][0])
    {
        $request = $this->getListingRequest($listing_id, $includes, $language, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListingWithAssociations' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListingWithAssociations' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListingWithAssociations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListingWithAssociations';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListingWithAssociations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingAsync
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $language The IETF language tag for the language of this translation. Ex: &#x60;de&#x60;, &#x60;en&#x60;, &#x60;es&#x60;, &#x60;fr&#x60;, &#x60;it&#x60;, &#x60;ja&#x60;, &#x60;nl&#x60;, &#x60;pl&#x60;, &#x60;pt&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingAsync($listing_id, $includes = null, $language = null, string $contentType = self::contentTypes['getListing'][0])
    {
        return $this->getListingAsyncWithHttpInfo($listing_id, $includes, $language, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingAsyncWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $language The IETF language tag for the language of this translation. Ex: &#x60;de&#x60;, &#x60;en&#x60;, &#x60;es&#x60;, &#x60;fr&#x60;, &#x60;it&#x60;, &#x60;ja&#x60;, &#x60;nl&#x60;, &#x60;pl&#x60;, &#x60;pt&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingAsyncWithHttpInfo($listing_id, $includes = null, $language = null, string $contentType = self::contentTypes['getListing'][0])
    {
        $returnType = '\Etsy\Model\ShopListingWithAssociations';
        $request = $this->getListingRequest($listing_id, $includes, $language, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListing'
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $language The IETF language tag for the language of this translation. Ex: &#x60;de&#x60;, &#x60;en&#x60;, &#x60;es&#x60;, &#x60;fr&#x60;, &#x60;it&#x60;, &#x60;ja&#x60;, &#x60;nl&#x60;, &#x60;pl&#x60;, &#x60;pt&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingRequest($listing_id, $includes = null, $language = null, string $contentType = self::contentTypes['getListing'][0])
    {

        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling getListing'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingApi.getListing, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/v3/application/listings/{listing_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $includes,
            'includes', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $language,
            'language', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingProperties
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperties'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ListingPropertyValues|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingProperties($shop_id, $listing_id, string $contentType = self::contentTypes['getListingProperties'][0])
    {
        list($response) = $this->getListingPropertiesWithHttpInfo($shop_id, $listing_id, $contentType);
        return $response;
    }

    /**
     * Operation getListingPropertiesWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperties'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ListingPropertyValues|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingPropertiesWithHttpInfo($shop_id, $listing_id, string $contentType = self::contentTypes['getListingProperties'][0])
    {
        $request = $this->getListingPropertiesRequest($shop_id, $listing_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ListingPropertyValues' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ListingPropertyValues' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ListingPropertyValues', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ListingPropertyValues';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ListingPropertyValues',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingPropertiesAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingPropertiesAsync($shop_id, $listing_id, string $contentType = self::contentTypes['getListingProperties'][0])
    {
        return $this->getListingPropertiesAsyncWithHttpInfo($shop_id, $listing_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingPropertiesAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingPropertiesAsyncWithHttpInfo($shop_id, $listing_id, string $contentType = self::contentTypes['getListingProperties'][0])
    {
        $returnType = '\Etsy\Model\ListingPropertyValues';
        $request = $this->getListingPropertiesRequest($shop_id, $listing_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingProperties'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingPropertiesRequest($shop_id, $listing_id, string $contentType = self::contentTypes['getListingProperties'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getListingProperties'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.getListingProperties, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling getListingProperties'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingApi.getListingProperties, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/properties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingProperty
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperty'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ListingPropertyValue|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingProperty($listing_id, $property_id, string $contentType = self::contentTypes['getListingProperty'][0])
    {
        list($response) = $this->getListingPropertyWithHttpInfo($listing_id, $property_id, $contentType);
        return $response;
    }

    /**
     * Operation getListingPropertyWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperty'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ListingPropertyValue|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingPropertyWithHttpInfo($listing_id, $property_id, string $contentType = self::contentTypes['getListingProperty'][0])
    {
        $request = $this->getListingPropertyRequest($listing_id, $property_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ListingPropertyValue' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ListingPropertyValue' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ListingPropertyValue', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 501:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ListingPropertyValue';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ListingPropertyValue',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 501:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingPropertyAsync
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperty'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingPropertyAsync($listing_id, $property_id, string $contentType = self::contentTypes['getListingProperty'][0])
    {
        return $this->getListingPropertyAsyncWithHttpInfo($listing_id, $property_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingPropertyAsyncWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperty'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingPropertyAsyncWithHttpInfo($listing_id, $property_id, string $contentType = self::contentTypes['getListingProperty'][0])
    {
        $returnType = '\Etsy\Model\ListingPropertyValue';
        $request = $this->getListingPropertyRequest($listing_id, $property_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingProperty'
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingProperty'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingPropertyRequest($listing_id, $property_id, string $contentType = self::contentTypes['getListingProperty'][0])
    {

        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling getListingProperty'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingApi.getListingProperty, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'property_id' is set
        if ($property_id === null || (is_array($property_id) && count($property_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $property_id when calling getListingProperty'
            );
        }
        if ($property_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$property_id" when calling ShopListingApi.getListingProperty, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/listings/{listing_id}/properties/{property_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }
        // path params
        if ($property_id !== null) {
            $resourcePath = str_replace(
                '{' . 'property_id' . '}',
                ObjectSerializer::toPathValue($property_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingsByListingIds
     *
     * @param  int[] $listing_ids The list of numeric IDS for the listings in a specific Etsy shop. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByListingIds'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListingsWithAssociations|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingsByListingIds($listing_ids, $includes = null, string $contentType = self::contentTypes['getListingsByListingIds'][0])
    {
        list($response) = $this->getListingsByListingIdsWithHttpInfo($listing_ids, $includes, $contentType);
        return $response;
    }

    /**
     * Operation getListingsByListingIdsWithHttpInfo
     *
     * @param  int[] $listing_ids The list of numeric IDS for the listings in a specific Etsy shop. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByListingIds'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListingsWithAssociations|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingsByListingIdsWithHttpInfo($listing_ids, $includes = null, string $contentType = self::contentTypes['getListingsByListingIds'][0])
    {
        $request = $this->getListingsByListingIdsRequest($listing_ids, $includes, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListingsWithAssociations' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListingsWithAssociations' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListingsWithAssociations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListingsWithAssociations';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListingsWithAssociations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingsByListingIdsAsync
     *
     * @param  int[] $listing_ids The list of numeric IDS for the listings in a specific Etsy shop. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByListingIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByListingIdsAsync($listing_ids, $includes = null, string $contentType = self::contentTypes['getListingsByListingIds'][0])
    {
        return $this->getListingsByListingIdsAsyncWithHttpInfo($listing_ids, $includes, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingsByListingIdsAsyncWithHttpInfo
     *
     * @param  int[] $listing_ids The list of numeric IDS for the listings in a specific Etsy shop. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByListingIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByListingIdsAsyncWithHttpInfo($listing_ids, $includes = null, string $contentType = self::contentTypes['getListingsByListingIds'][0])
    {
        $returnType = '\Etsy\Model\ShopListingsWithAssociations';
        $request = $this->getListingsByListingIdsRequest($listing_ids, $includes, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingsByListingIds'
     *
     * @param  int[] $listing_ids The list of numeric IDS for the listings in a specific Etsy shop. (required)
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByListingIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingsByListingIdsRequest($listing_ids, $includes = null, string $contentType = self::contentTypes['getListingsByListingIds'][0])
    {

        // verify the required parameter 'listing_ids' is set
        if ($listing_ids === null || (is_array($listing_ids) && count($listing_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_ids when calling getListingsByListingIds'
            );
        }



        $resourcePath = '/v3/application/listings/batch';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $listing_ids,
            'listing_ids', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $includes,
            'includes', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingsByShop
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional, default to 'active')
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShop'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListingsWithAssociations|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingsByShop($shop_id, $state = 'active', $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $includes = null, string $contentType = self::contentTypes['getListingsByShop'][0])
    {
        list($response) = $this->getListingsByShopWithHttpInfo($shop_id, $state, $limit, $offset, $sort_on, $sort_order, $includes, $contentType);
        return $response;
    }

    /**
     * Operation getListingsByShopWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional, default to 'active')
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShop'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListingsWithAssociations|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingsByShopWithHttpInfo($shop_id, $state = 'active', $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $includes = null, string $contentType = self::contentTypes['getListingsByShop'][0])
    {
        $request = $this->getListingsByShopRequest($shop_id, $state, $limit, $offset, $sort_on, $sort_order, $includes, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListingsWithAssociations' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListingsWithAssociations' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListingsWithAssociations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListingsWithAssociations';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListingsWithAssociations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingsByShopAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional, default to 'active')
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShop'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByShopAsync($shop_id, $state = 'active', $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $includes = null, string $contentType = self::contentTypes['getListingsByShop'][0])
    {
        return $this->getListingsByShopAsyncWithHttpInfo($shop_id, $state, $limit, $offset, $sort_on, $sort_order, $includes, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingsByShopAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional, default to 'active')
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShop'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByShopAsyncWithHttpInfo($shop_id, $state = 'active', $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $includes = null, string $contentType = self::contentTypes['getListingsByShop'][0])
    {
        $returnType = '\Etsy\Model\ShopListingsWithAssociations';
        $request = $this->getListingsByShopRequest($shop_id, $state, $limit, $offset, $sort_on, $sort_order, $includes, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingsByShop'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional, default to 'active')
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string[] $includes An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShop'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingsByShopRequest($shop_id, $state = 'active', $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $includes = null, string $contentType = self::contentTypes['getListingsByShop'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getListingsByShop'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.getListingsByShop, must be bigger than or equal to 1.');
        }
        

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.getListingsByShop, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.getListingsByShop, must be bigger than or equal to 1.');
        }
        
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling ShopListingApi.getListingsByShop, must be bigger than or equal to 0.');
        }
        




        $resourcePath = '/v3/application/shops/{shop_id}/listings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $state,
            'state', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_on,
            'sort_on', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sort_order', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $includes,
            'includes', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingsByShopReceipt
     *
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReceipt'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingsByShopReceipt($receipt_id, $shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getListingsByShopReceipt'][0])
    {
        list($response) = $this->getListingsByShopReceiptWithHttpInfo($receipt_id, $shop_id, $limit, $offset, $contentType);
        return $response;
    }

    /**
     * Operation getListingsByShopReceiptWithHttpInfo
     *
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReceipt'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingsByShopReceiptWithHttpInfo($receipt_id, $shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getListingsByShopReceipt'][0])
    {
        $request = $this->getListingsByShopReceiptRequest($receipt_id, $shop_id, $limit, $offset, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListings' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListings' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListings';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingsByShopReceiptAsync
     *
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReceipt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByShopReceiptAsync($receipt_id, $shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getListingsByShopReceipt'][0])
    {
        return $this->getListingsByShopReceiptAsyncWithHttpInfo($receipt_id, $shop_id, $limit, $offset, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingsByShopReceiptAsyncWithHttpInfo
     *
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReceipt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByShopReceiptAsyncWithHttpInfo($receipt_id, $shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getListingsByShopReceipt'][0])
    {
        $returnType = '\Etsy\Model\ShopListings';
        $request = $this->getListingsByShopReceiptRequest($receipt_id, $shop_id, $limit, $offset, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingsByShopReceipt'
     *
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReceipt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingsByShopReceiptRequest($receipt_id, $shop_id, $limit = 25, $offset = 0, string $contentType = self::contentTypes['getListingsByShopReceipt'][0])
    {

        // verify the required parameter 'receipt_id' is set
        if ($receipt_id === null || (is_array($receipt_id) && count($receipt_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipt_id when calling getListingsByShopReceipt'
            );
        }
        if ($receipt_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$receipt_id" when calling ShopListingApi.getListingsByShopReceipt, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getListingsByShopReceipt'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.getListingsByShopReceipt, must be bigger than or equal to 1.');
        }
        
        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.getListingsByShopReceipt, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.getListingsByShopReceipt, must be bigger than or equal to 1.');
        }
        
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling ShopListingApi.getListingsByShopReceipt, must be bigger than or equal to 0.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/receipts/{receipt_id}/listings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($receipt_id !== null) {
            $resourcePath = str_replace(
                '{' . 'receipt_id' . '}',
                ObjectSerializer::toPathValue($receipt_id),
                $resourcePath
            );
        }
        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingsByShopReturnPolicy
     *
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingsByShopReturnPolicy($return_policy_id, $shop_id, string $contentType = self::contentTypes['getListingsByShopReturnPolicy'][0])
    {
        list($response) = $this->getListingsByShopReturnPolicyWithHttpInfo($return_policy_id, $shop_id, $contentType);
        return $response;
    }

    /**
     * Operation getListingsByShopReturnPolicyWithHttpInfo
     *
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingsByShopReturnPolicyWithHttpInfo($return_policy_id, $shop_id, string $contentType = self::contentTypes['getListingsByShopReturnPolicy'][0])
    {
        $request = $this->getListingsByShopReturnPolicyRequest($return_policy_id, $shop_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListings' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListings' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListings';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingsByShopReturnPolicyAsync
     *
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByShopReturnPolicyAsync($return_policy_id, $shop_id, string $contentType = self::contentTypes['getListingsByShopReturnPolicy'][0])
    {
        return $this->getListingsByShopReturnPolicyAsyncWithHttpInfo($return_policy_id, $shop_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingsByShopReturnPolicyAsyncWithHttpInfo
     *
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByShopReturnPolicyAsyncWithHttpInfo($return_policy_id, $shop_id, string $contentType = self::contentTypes['getListingsByShopReturnPolicy'][0])
    {
        $returnType = '\Etsy\Model\ShopListings';
        $request = $this->getListingsByShopReturnPolicyRequest($return_policy_id, $shop_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingsByShopReturnPolicy'
     *
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingsByShopReturnPolicyRequest($return_policy_id, $shop_id, string $contentType = self::contentTypes['getListingsByShopReturnPolicy'][0])
    {

        // verify the required parameter 'return_policy_id' is set
        if ($return_policy_id === null || (is_array($return_policy_id) && count($return_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_policy_id when calling getListingsByShopReturnPolicy'
            );
        }
        if ($return_policy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$return_policy_id" when calling ShopListingApi.getListingsByShopReturnPolicy, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getListingsByShopReturnPolicy'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.getListingsByShopReturnPolicy, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/policies/return/{return_policy_id}/listings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($return_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'return_policy_id' . '}',
                ObjectSerializer::toPathValue($return_policy_id),
                $resourcePath
            );
        }
        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingsByShopSectionId
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int[] $shop_section_ids A list of numeric IDS for all sections in a specific Etsy shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopSectionId'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingsByShopSectionId($shop_id, $shop_section_ids, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', string $contentType = self::contentTypes['getListingsByShopSectionId'][0])
    {
        list($response) = $this->getListingsByShopSectionIdWithHttpInfo($shop_id, $shop_section_ids, $limit, $offset, $sort_on, $sort_order, $contentType);
        return $response;
    }

    /**
     * Operation getListingsByShopSectionIdWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int[] $shop_section_ids A list of numeric IDS for all sections in a specific Etsy shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopSectionId'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListings|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingsByShopSectionIdWithHttpInfo($shop_id, $shop_section_ids, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', string $contentType = self::contentTypes['getListingsByShopSectionId'][0])
    {
        $request = $this->getListingsByShopSectionIdRequest($shop_id, $shop_section_ids, $limit, $offset, $sort_on, $sort_order, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListings' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListings' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListings';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingsByShopSectionIdAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int[] $shop_section_ids A list of numeric IDS for all sections in a specific Etsy shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopSectionId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByShopSectionIdAsync($shop_id, $shop_section_ids, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', string $contentType = self::contentTypes['getListingsByShopSectionId'][0])
    {
        return $this->getListingsByShopSectionIdAsyncWithHttpInfo($shop_id, $shop_section_ids, $limit, $offset, $sort_on, $sort_order, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingsByShopSectionIdAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int[] $shop_section_ids A list of numeric IDS for all sections in a specific Etsy shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopSectionId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingsByShopSectionIdAsyncWithHttpInfo($shop_id, $shop_section_ids, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', string $contentType = self::contentTypes['getListingsByShopSectionId'][0])
    {
        $returnType = '\Etsy\Model\ShopListings';
        $request = $this->getListingsByShopSectionIdRequest($shop_id, $shop_section_ids, $limit, $offset, $sort_on, $sort_order, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingsByShopSectionId'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int[] $shop_section_ids A list of numeric IDS for all sections in a specific Etsy shop. (required)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). (optional, default to 'desc')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingsByShopSectionId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingsByShopSectionIdRequest($shop_id, $shop_section_ids, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', string $contentType = self::contentTypes['getListingsByShopSectionId'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getListingsByShopSectionId'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.getListingsByShopSectionId, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shop_section_ids' is set
        if ($shop_section_ids === null || (is_array($shop_section_ids) && count($shop_section_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_section_ids when calling getListingsByShopSectionId'
            );
        }

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.getListingsByShopSectionId, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopListingApi.getListingsByShopSectionId, must be bigger than or equal to 1.');
        }
        
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling ShopListingApi.getListingsByShopSectionId, must be bigger than or equal to 0.');
        }
        



        $resourcePath = '/v3/application/shops/{shop_id}/shop-sections/listings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_section_ids,
            'shop_section_ids', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_on,
            'sort_on', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sort_order', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateListing
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). Required for active physical listings. This requirement does not apply to listings of EU-based shops. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListing'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListing|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function updateListing($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $return_policy_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListing'][0])
    {
        list($response) = $this->updateListingWithHttpInfo($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $return_policy_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type, $contentType);
        return $response;
    }

    /**
     * Operation updateListingWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). Required for active physical listings. This requirement does not apply to listings of EU-based shops. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListing'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListing|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateListingWithHttpInfo($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $return_policy_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListing'][0])
    {
        $request = $this->updateListingRequest($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $return_policy_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateListingAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). Required for active physical listings. This requirement does not apply to listings of EU-based shops. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateListingAsync($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $return_policy_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListing'][0])
    {
        return $this->updateListingAsyncWithHttpInfo($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $return_policy_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateListingAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). Required for active physical listings. This requirement does not apply to listings of EU-based shops. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateListingAsyncWithHttpInfo($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $return_policy_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListing'][0])
    {
        $returnType = '\Etsy\Model\ShopListing';
        $request = $this->updateListingRequest($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $return_policy_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateListing'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). Required for active physical listings. This requirement does not apply to listings of EU-based shops. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListing'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateListingRequest($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $return_policy_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListing'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling updateListing'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.updateListing, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling updateListing'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingApi.updateListing, must be bigger than or equal to 1.');
        }
        





        if ($shipping_profile_id !== null && $shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopListingApi.updateListing, must be bigger than or equal to 1.');
        }
        
        if ($return_policy_id !== null && $return_policy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$return_policy_id" when calling ShopListingApi.updateListing, must be bigger than or equal to 1.');
        }
        

        if ($item_weight !== null && $item_weight > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_weight" when calling ShopListingApi.updateListing, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_weight !== null && $item_weight < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_weight" when calling ShopListingApi.updateListing, must be bigger than or equal to 0.');
        }
        
        if ($item_length !== null && $item_length > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_length" when calling ShopListingApi.updateListing, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_length !== null && $item_length < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_length" when calling ShopListingApi.updateListing, must be bigger than or equal to 0.');
        }
        
        if ($item_width !== null && $item_width > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_width" when calling ShopListingApi.updateListing, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_width !== null && $item_width < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_width" when calling ShopListingApi.updateListing, must be bigger than or equal to 0.');
        }
        
        if ($item_height !== null && $item_height > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_height" when calling ShopListingApi.updateListing, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_height !== null && $item_height < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_height" when calling ShopListingApi.updateListing, must be bigger than or equal to 0.');
        }
        



        if ($taxonomy_id !== null && $taxonomy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$taxonomy_id" when calling ShopListingApi.updateListing, must be bigger than or equal to 1.');
        }
        













        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }

        // form params
        if ($image_ids !== null) {
            $formParams['image_ids'] = ObjectSerializer::toFormValue($image_ids);
        }
        // form params
        if ($title !== null) {
            $formParams['title'] = ObjectSerializer::toFormValue($title);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = ObjectSerializer::toFormValue($description);
        }
        // form params
        if ($materials !== null) {
            $formParams['materials'] = ObjectSerializer::toFormValue($materials);
        }
        // form params
        if ($should_auto_renew !== null) {
            $formParams['should_auto_renew'] = ObjectSerializer::toFormValue($should_auto_renew);
        }
        // form params
        if ($shipping_profile_id !== null) {
            $formParams['shipping_profile_id'] = ObjectSerializer::toFormValue($shipping_profile_id);
        }
        // form params
        if ($return_policy_id !== null) {
            $formParams['return_policy_id'] = ObjectSerializer::toFormValue($return_policy_id);
        }
        // form params
        if ($shop_section_id !== null) {
            $formParams['shop_section_id'] = ObjectSerializer::toFormValue($shop_section_id);
        }
        // form params
        if ($item_weight !== null) {
            $formParams['item_weight'] = ObjectSerializer::toFormValue($item_weight);
        }
        // form params
        if ($item_length !== null) {
            $formParams['item_length'] = ObjectSerializer::toFormValue($item_length);
        }
        // form params
        if ($item_width !== null) {
            $formParams['item_width'] = ObjectSerializer::toFormValue($item_width);
        }
        // form params
        if ($item_height !== null) {
            $formParams['item_height'] = ObjectSerializer::toFormValue($item_height);
        }
        // form params
        if ($item_weight_unit !== null) {
            $formParams['item_weight_unit'] = ObjectSerializer::toFormValue($item_weight_unit);
        }
        // form params
        if ($item_dimensions_unit !== null) {
            $formParams['item_dimensions_unit'] = ObjectSerializer::toFormValue($item_dimensions_unit);
        }
        // form params
        if ($is_taxable !== null) {
            $formParams['is_taxable'] = ObjectSerializer::toFormValue($is_taxable);
        }
        // form params
        if ($taxonomy_id !== null) {
            $formParams['taxonomy_id'] = ObjectSerializer::toFormValue($taxonomy_id);
        }
        // form params
        if ($tags !== null) {
            $formParams['tags'] = ObjectSerializer::toFormValue($tags);
        }
        // form params
        if ($who_made !== null) {
            $formParams['who_made'] = ObjectSerializer::toFormValue($who_made);
        }
        // form params
        if ($when_made !== null) {
            $formParams['when_made'] = ObjectSerializer::toFormValue($when_made);
        }
        // form params
        if ($featured_rank !== null) {
            $formParams['featured_rank'] = ObjectSerializer::toFormValue($featured_rank);
        }
        // form params
        if ($is_personalizable !== null) {
            $formParams['is_personalizable'] = ObjectSerializer::toFormValue($is_personalizable);
        }
        // form params
        if ($personalization_is_required !== null) {
            $formParams['personalization_is_required'] = ObjectSerializer::toFormValue($personalization_is_required);
        }
        // form params
        if ($personalization_char_count_max !== null) {
            $formParams['personalization_char_count_max'] = ObjectSerializer::toFormValue($personalization_char_count_max);
        }
        // form params
        if ($personalization_instructions !== null) {
            $formParams['personalization_instructions'] = ObjectSerializer::toFormValue($personalization_instructions);
        }
        // form params
        if ($state !== null) {
            $formParams['state'] = ObjectSerializer::toFormValue($state);
        }
        // form params
        if ($is_supply !== null) {
            $formParams['is_supply'] = ObjectSerializer::toFormValue($is_supply);
        }
        // form params
        if ($production_partner_ids !== null) {
            $formParams['production_partner_ids'] = ObjectSerializer::toFormValue($production_partner_ids);
        }
        // form params
        if ($type !== null) {
            $formParams['type'] = ObjectSerializer::toFormValue($type);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateListingDeprecated
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingDeprecated'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListing|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function updateListingDeprecated($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListingDeprecated'][0])
    {
        list($response) = $this->updateListingDeprecatedWithHttpInfo($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type, $contentType);
        return $response;
    }

    /**
     * Operation updateListingDeprecatedWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingDeprecated'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListing|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateListingDeprecatedWithHttpInfo($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListingDeprecated'][0])
    {
        $request = $this->updateListingDeprecatedRequest($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListing' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListing' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListing', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListing';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateListingDeprecatedAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingDeprecated'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateListingDeprecatedAsync($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListingDeprecated'][0])
    {
        return $this->updateListingDeprecatedAsyncWithHttpInfo($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateListingDeprecatedAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingDeprecated'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateListingDeprecatedAsyncWithHttpInfo($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListingDeprecated'][0])
    {
        $returnType = '\Etsy\Model\ShopListing';
        $request = $this->updateListingDeprecatedRequest($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateListingDeprecated'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int[] $image_ids An array of numeric image IDs of the images in a listing, which can include up to 10 images. (optional)
     * @param  string $title The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. (optional)
     * @param  string $description A description string of the product for sale in the listing. (optional)
     * @param  string[] $materials A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. (optional)
     * @param  bool $should_auto_renew When true, renews a listing for four months upon expiration. (optional)
     * @param  int $shipping_profile_id The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. (optional)
     * @param  int $shop_section_id The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. (optional)
     * @param  float $item_weight The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_length The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_width The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  float $item_height The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. (optional)
     * @param  string $item_weight_unit A string defining the units used to measure the weight of the product. Default value is null. (optional)
     * @param  string $item_dimensions_unit A string defining the units used to measure the dimensions of the product. Default value is null. (optional)
     * @param  bool $is_taxable When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. (optional)
     * @param  int $taxonomy_id The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. (optional)
     * @param  string[] $tags A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. (optional)
     * @param  string $who_made An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. (optional)
     * @param  string $when_made An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. (optional)
     * @param  int $featured_rank The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. (optional)
     * @param  bool $is_personalizable When true, this listing is personalizable. The default value is null. (optional)
     * @param  bool $personalization_is_required When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  int $personalization_char_count_max This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $personalization_instructions A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. (optional)
     * @param  string $state When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. (optional)
     * @param  bool $is_supply When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. (optional)
     * @param  int[] $production_partner_ids An array of unique IDs of production partner ids. (optional)
     * @param  string $type An enumerated type string that indicates whether the listing is physical or a digital download. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingDeprecated'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateListingDeprecatedRequest($shop_id, $listing_id, $image_ids = null, $title = null, $description = null, $materials = null, $should_auto_renew = null, $shipping_profile_id = null, $shop_section_id = null, $item_weight = null, $item_length = null, $item_width = null, $item_height = null, $item_weight_unit = null, $item_dimensions_unit = null, $is_taxable = null, $taxonomy_id = null, $tags = null, $who_made = null, $when_made = null, $featured_rank = null, $is_personalizable = null, $personalization_is_required = null, $personalization_char_count_max = null, $personalization_instructions = null, $state = null, $is_supply = null, $production_partner_ids = null, $type = null, string $contentType = self::contentTypes['updateListingDeprecated'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling updateListingDeprecated'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.updateListingDeprecated, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling updateListingDeprecated'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingApi.updateListingDeprecated, must be bigger than or equal to 1.');
        }
        





        if ($shipping_profile_id !== null && $shipping_profile_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shipping_profile_id" when calling ShopListingApi.updateListingDeprecated, must be bigger than or equal to 1.');
        }
        

        if ($item_weight !== null && $item_weight > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_weight" when calling ShopListingApi.updateListingDeprecated, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_weight !== null && $item_weight < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_weight" when calling ShopListingApi.updateListingDeprecated, must be bigger than or equal to 0.');
        }
        
        if ($item_length !== null && $item_length > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_length" when calling ShopListingApi.updateListingDeprecated, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_length !== null && $item_length < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_length" when calling ShopListingApi.updateListingDeprecated, must be bigger than or equal to 0.');
        }
        
        if ($item_width !== null && $item_width > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_width" when calling ShopListingApi.updateListingDeprecated, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_width !== null && $item_width < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_width" when calling ShopListingApi.updateListingDeprecated, must be bigger than or equal to 0.');
        }
        
        if ($item_height !== null && $item_height > 1.79769313486E+308) {
            throw new \InvalidArgumentException('invalid value for "$item_height" when calling ShopListingApi.updateListingDeprecated, must be smaller than or equal to 1.79769313486E+308.');
        }
        if ($item_height !== null && $item_height < 0) {
            throw new \InvalidArgumentException('invalid value for "$item_height" when calling ShopListingApi.updateListingDeprecated, must be bigger than or equal to 0.');
        }
        



        if ($taxonomy_id !== null && $taxonomy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$taxonomy_id" when calling ShopListingApi.updateListingDeprecated, must be bigger than or equal to 1.');
        }
        













        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }

        // form params
        if ($image_ids !== null) {
            $formParams['image_ids'] = ObjectSerializer::toFormValue($image_ids);
        }
        // form params
        if ($title !== null) {
            $formParams['title'] = ObjectSerializer::toFormValue($title);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = ObjectSerializer::toFormValue($description);
        }
        // form params
        if ($materials !== null) {
            $formParams['materials'] = ObjectSerializer::toFormValue($materials);
        }
        // form params
        if ($should_auto_renew !== null) {
            $formParams['should_auto_renew'] = ObjectSerializer::toFormValue($should_auto_renew);
        }
        // form params
        if ($shipping_profile_id !== null) {
            $formParams['shipping_profile_id'] = ObjectSerializer::toFormValue($shipping_profile_id);
        }
        // form params
        if ($shop_section_id !== null) {
            $formParams['shop_section_id'] = ObjectSerializer::toFormValue($shop_section_id);
        }
        // form params
        if ($item_weight !== null) {
            $formParams['item_weight'] = ObjectSerializer::toFormValue($item_weight);
        }
        // form params
        if ($item_length !== null) {
            $formParams['item_length'] = ObjectSerializer::toFormValue($item_length);
        }
        // form params
        if ($item_width !== null) {
            $formParams['item_width'] = ObjectSerializer::toFormValue($item_width);
        }
        // form params
        if ($item_height !== null) {
            $formParams['item_height'] = ObjectSerializer::toFormValue($item_height);
        }
        // form params
        if ($item_weight_unit !== null) {
            $formParams['item_weight_unit'] = ObjectSerializer::toFormValue($item_weight_unit);
        }
        // form params
        if ($item_dimensions_unit !== null) {
            $formParams['item_dimensions_unit'] = ObjectSerializer::toFormValue($item_dimensions_unit);
        }
        // form params
        if ($is_taxable !== null) {
            $formParams['is_taxable'] = ObjectSerializer::toFormValue($is_taxable);
        }
        // form params
        if ($taxonomy_id !== null) {
            $formParams['taxonomy_id'] = ObjectSerializer::toFormValue($taxonomy_id);
        }
        // form params
        if ($tags !== null) {
            $formParams['tags'] = ObjectSerializer::toFormValue($tags);
        }
        // form params
        if ($who_made !== null) {
            $formParams['who_made'] = ObjectSerializer::toFormValue($who_made);
        }
        // form params
        if ($when_made !== null) {
            $formParams['when_made'] = ObjectSerializer::toFormValue($when_made);
        }
        // form params
        if ($featured_rank !== null) {
            $formParams['featured_rank'] = ObjectSerializer::toFormValue($featured_rank);
        }
        // form params
        if ($is_personalizable !== null) {
            $formParams['is_personalizable'] = ObjectSerializer::toFormValue($is_personalizable);
        }
        // form params
        if ($personalization_is_required !== null) {
            $formParams['personalization_is_required'] = ObjectSerializer::toFormValue($personalization_is_required);
        }
        // form params
        if ($personalization_char_count_max !== null) {
            $formParams['personalization_char_count_max'] = ObjectSerializer::toFormValue($personalization_char_count_max);
        }
        // form params
        if ($personalization_instructions !== null) {
            $formParams['personalization_instructions'] = ObjectSerializer::toFormValue($personalization_instructions);
        }
        // form params
        if ($state !== null) {
            $formParams['state'] = ObjectSerializer::toFormValue($state);
        }
        // form params
        if ($is_supply !== null) {
            $formParams['is_supply'] = ObjectSerializer::toFormValue($is_supply);
        }
        // form params
        if ($production_partner_ids !== null) {
            $formParams['production_partner_ids'] = ObjectSerializer::toFormValue($production_partner_ids);
        }
        // form params
        if ($type !== null) {
            $formParams['type'] = ObjectSerializer::toFormValue($type);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateListingProperty
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  int[] $value_ids An array of unique IDs of multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different sizes of a product, then the value ID list contains value IDs for each size. (required)
     * @param  string[] $values An array of value strings for multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different colored products, then the values array contains the color strings for each color. Note: parenthesis characters (&#x60;(&#x60; and &#x60;)&#x60;) are not allowed. (required)
     * @param  int $scale_id The numeric ID of a single Etsy.com measurement scale. For example, for shoe size, there are three &#x60;scale_id&#x60;s available - &#x60;UK&#x60;, &#x60;US/Canada&#x60;, and &#x60;EU&#x60;, where &#x60;US/Canada&#x60; has &#x60;scale_id&#x60; 19. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingProperty'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ListingPropertyValue|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function updateListingProperty($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id = null, string $contentType = self::contentTypes['updateListingProperty'][0])
    {
        list($response) = $this->updateListingPropertyWithHttpInfo($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id, $contentType);
        return $response;
    }

    /**
     * Operation updateListingPropertyWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  int[] $value_ids An array of unique IDs of multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different sizes of a product, then the value ID list contains value IDs for each size. (required)
     * @param  string[] $values An array of value strings for multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different colored products, then the values array contains the color strings for each color. Note: parenthesis characters (&#x60;(&#x60; and &#x60;)&#x60;) are not allowed. (required)
     * @param  int $scale_id The numeric ID of a single Etsy.com measurement scale. For example, for shoe size, there are three &#x60;scale_id&#x60;s available - &#x60;UK&#x60;, &#x60;US/Canada&#x60;, and &#x60;EU&#x60;, where &#x60;US/Canada&#x60; has &#x60;scale_id&#x60; 19. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingProperty'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ListingPropertyValue|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateListingPropertyWithHttpInfo($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id = null, string $contentType = self::contentTypes['updateListingProperty'][0])
    {
        $request = $this->updateListingPropertyRequest($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ListingPropertyValue' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ListingPropertyValue' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ListingPropertyValue', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ListingPropertyValue';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ListingPropertyValue',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateListingPropertyAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  int[] $value_ids An array of unique IDs of multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different sizes of a product, then the value ID list contains value IDs for each size. (required)
     * @param  string[] $values An array of value strings for multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different colored products, then the values array contains the color strings for each color. Note: parenthesis characters (&#x60;(&#x60; and &#x60;)&#x60;) are not allowed. (required)
     * @param  int $scale_id The numeric ID of a single Etsy.com measurement scale. For example, for shoe size, there are three &#x60;scale_id&#x60;s available - &#x60;UK&#x60;, &#x60;US/Canada&#x60;, and &#x60;EU&#x60;, where &#x60;US/Canada&#x60; has &#x60;scale_id&#x60; 19. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingProperty'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateListingPropertyAsync($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id = null, string $contentType = self::contentTypes['updateListingProperty'][0])
    {
        return $this->updateListingPropertyAsyncWithHttpInfo($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateListingPropertyAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  int[] $value_ids An array of unique IDs of multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different sizes of a product, then the value ID list contains value IDs for each size. (required)
     * @param  string[] $values An array of value strings for multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different colored products, then the values array contains the color strings for each color. Note: parenthesis characters (&#x60;(&#x60; and &#x60;)&#x60;) are not allowed. (required)
     * @param  int $scale_id The numeric ID of a single Etsy.com measurement scale. For example, for shoe size, there are three &#x60;scale_id&#x60;s available - &#x60;UK&#x60;, &#x60;US/Canada&#x60;, and &#x60;EU&#x60;, where &#x60;US/Canada&#x60; has &#x60;scale_id&#x60; 19. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingProperty'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateListingPropertyAsyncWithHttpInfo($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id = null, string $contentType = self::contentTypes['updateListingProperty'][0])
    {
        $returnType = '\Etsy\Model\ListingPropertyValue';
        $request = $this->updateListingPropertyRequest($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateListingProperty'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $property_id The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). (required)
     * @param  int[] $value_ids An array of unique IDs of multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different sizes of a product, then the value ID list contains value IDs for each size. (required)
     * @param  string[] $values An array of value strings for multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different colored products, then the values array contains the color strings for each color. Note: parenthesis characters (&#x60;(&#x60; and &#x60;)&#x60;) are not allowed. (required)
     * @param  int $scale_id The numeric ID of a single Etsy.com measurement scale. For example, for shoe size, there are three &#x60;scale_id&#x60;s available - &#x60;UK&#x60;, &#x60;US/Canada&#x60;, and &#x60;EU&#x60;, where &#x60;US/Canada&#x60; has &#x60;scale_id&#x60; 19. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateListingProperty'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateListingPropertyRequest($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id = null, string $contentType = self::contentTypes['updateListingProperty'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling updateListingProperty'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingApi.updateListingProperty, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling updateListingProperty'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingApi.updateListingProperty, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'property_id' is set
        if ($property_id === null || (is_array($property_id) && count($property_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $property_id when calling updateListingProperty'
            );
        }
        if ($property_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$property_id" when calling ShopListingApi.updateListingProperty, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'value_ids' is set
        if ($value_ids === null || (is_array($value_ids) && count($value_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $value_ids when calling updateListingProperty'
            );
        }

        // verify the required parameter 'values' is set
        if ($values === null || (is_array($values) && count($values) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $values when calling updateListingProperty'
            );
        }

        if ($scale_id !== null && $scale_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$scale_id" when calling ShopListingApi.updateListingProperty, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/properties/{property_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }
        // path params
        if ($property_id !== null) {
            $resourcePath = str_replace(
                '{' . 'property_id' . '}',
                ObjectSerializer::toPathValue($property_id),
                $resourcePath
            );
        }

        // form params
        if ($value_ids !== null) {
            $formParams['value_ids'] = ObjectSerializer::toFormValue($value_ids);
        }
        // form params
        if ($values !== null) {
            $formParams['values'] = ObjectSerializer::toFormValue($values);
        }
        // form params
        if ($scale_id !== null) {
            $formParams['scale_id'] = ObjectSerializer::toFormValue($scale_id);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
