# # ShopReceiptsResultsInner

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**receipt_id** | **int** | The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. | [optional]
**receipt_type** | **int** | The numeric value for the Etsy channel that serviced the purchase: 0 for Etsy.com, 1 for a Pattern shop. | [optional]
**seller_user_id** | **int** | The numeric ID for the [user](/documentation/reference#tag/User) (seller) fulfilling the purchase. | [optional]
**seller_email** | **string** | The email address string for the seller of the listing. | [optional]
**buyer_user_id** | **int** | The numeric ID for the [user](/documentation/reference#tag/User) making the purchase. | [optional]
**buyer_email** | **string** | The email address string for the buyer of the listing. | [optional]
**name** | **string** | The name string for the recipient in the shipping address. | [optional]
**first_line** | **string** | The first address line string for the recipient in the shipping address. | [optional]
**second_line** | **string** | The optional second address line string for the recipient in the shipping address. | [optional]
**city** | **string** | The city string for the recipient in the shipping address. | [optional]
**state** | **string** | The state string for the recipient in the shipping address. | [optional]
**zip** | **string** | The zip code string (not necessarily a number) for the recipient in the shipping address. | [optional]
**status** | **string** | The current order status string. One of: &#x60;paid&#x60;, &#x60;completed&#x60;, &#x60;open&#x60;, &#x60;payment processing&#x60; or &#x60;canceled&#x60;. | [optional]
**formatted_address** | **string** | The formatted shipping address string for the recipient in the shipping address. | [optional]
**country_iso** | **string** | The ISO-3166 alpha-2 country code string for the recipient in the shipping address. | [optional]
**payment_method** | **string** | The payment method string identifying purchaser&#39;s payment method, which must be one of: \\&#39;cc\\&#39; (credit card), \\&#39;paypal\\&#39;, \\&#39;check\\&#39;, \\&#39;mo\\&#39; (money order), \\&#39;bt\\&#39; (bank transfer), \\&#39;other\\&#39;, \\&#39;ideal\\&#39;, \\&#39;sofort\\&#39;, \\&#39;apple_pay\\&#39;, \\&#39;google\\&#39;, \\&#39;android_pay\\&#39;, \\&#39;google_pay\\&#39;, \\&#39;klarna\\&#39;, \\&#39;k_pay_in_4\\&#39; (klarna), \\&#39;k_pay_in_3\\&#39; (klarna), or \\&#39;k_financing\\&#39; (klarna). | [optional]
**payment_email** | **string** | The email address string for the email address to which to send payment confirmation | [optional]
**message_from_seller** | **string** | An optional message string from the seller. | [optional]
**message_from_buyer** | **string** | An optional message string from the buyer. | [optional]
**message_from_payment** | **string** | The machine-generated acknowledgement string from the payment system. | [optional]
**is_paid** | **bool** | When true, buyer paid for this purchase. | [optional]
**is_shipped** | **bool** | When true, seller shipped the products. | [optional]
**create_timestamp** | **int** | The receipt\\&#39;s creation time, in epoch seconds. | [optional]
**created_timestamp** | **int** | The receipt\\&#39;s creation time, in epoch seconds. | [optional]
**update_timestamp** | **int** | The time of the last update to the receipt, in epoch seconds. | [optional]
**updated_timestamp** | **int** | The time of the last update to the receipt, in epoch seconds. | [optional]
**is_gift** | **bool** | When true, the buyer indicated this purchase is a gift. | [optional]
**gift_message** | **string** | A gift message string the buyer requests delivered with the product. | [optional]
**grandtotal** | [**\Etsy\Model\ShopReceiptGrandtotal**](ShopReceiptGrandtotal.md) |  | [optional]
**subtotal** | [**\Etsy\Model\ShopReceiptSubtotal**](ShopReceiptSubtotal.md) |  | [optional]
**total_price** | [**\Etsy\Model\ShopReceiptTotalPrice**](ShopReceiptTotalPrice.md) |  | [optional]
**total_shipping_cost** | [**\Etsy\Model\ShopReceiptTotalShippingCost**](ShopReceiptTotalShippingCost.md) |  | [optional]
**total_tax_cost** | [**\Etsy\Model\ShopReceiptTotalTaxCost**](ShopReceiptTotalTaxCost.md) |  | [optional]
**total_vat_cost** | [**\Etsy\Model\ShopReceiptTotalVatCost**](ShopReceiptTotalVatCost.md) |  | [optional]
**discount_amt** | [**\Etsy\Model\ShopReceiptDiscountAmt**](ShopReceiptDiscountAmt.md) |  | [optional]
**gift_wrap_price** | [**\Etsy\Model\ShopReceiptGiftWrapPrice**](ShopReceiptGiftWrapPrice.md) |  | [optional]
**shipments** | [**\Etsy\Model\ShopReceiptShipmentsInner[]**](ShopReceiptShipmentsInner.md) | A list of shipment statements for this receipt. | [optional]
**transactions** | [**\Etsy\Model\ShopReceiptTransactionsInner[]**](ShopReceiptTransactionsInner.md) | Array of transactions for the receipt. | [optional]
**refunds** | [**\Etsy\Model\ShopReceiptRefundsInner[]**](ShopReceiptRefundsInner.md) | Refunds for a given receipt. | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
