# Etsy\ShopReceiptApi

All URIs are relative to https://openapi.etsy.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createReceiptShipment()**](ShopReceiptApi.md#createReceiptShipment) | **POST** /v3/application/shops/{shop_id}/receipts/{receipt_id}/tracking |  |
| [**getShopReceipt()**](ShopReceiptApi.md#getShopReceipt) | **GET** /v3/application/shops/{shop_id}/receipts/{receipt_id} |  |
| [**getShopReceipts()**](ShopReceiptApi.md#getShopReceipts) | **GET** /v3/application/shops/{shop_id}/receipts |  |
| [**updateShopReceipt()**](ShopReceiptApi.md#updateShopReceipt) | **PUT** /v3/application/shops/{shop_id}/receipts/{receipt_id} |  |


## `createReceiptShipment()`

```php
createReceiptShipment($shop_id, $receipt_id, $tracking_code, $carrier_name, $send_bcc, $note_to_buyer): \Etsy\Model\ShopReceipt
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Submits tracking information for a Shop Receipt, which creates a Shop Receipt Shipment entry for the given receipt_id. Each time you successfully submit tracking info, Etsy sends a notification email to the buyer User. When send_bcc is true, Etsy sends shipping notifications to the seller as well. When tracking_code and carrier_name aren't sent, the receipt is marked as shipped only. If the carrier is not supported, you may use `other` as the carrier name so you can provide the tracking code. **NOTE** When shipping within the United States AND the order is over $10 _or_ when shipping to India, tracking code and carrier name ARE required.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopReceiptApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$receipt_id = 56; // int | The receipt to submit tracking for.
$tracking_code = 'tracking_code_example'; // string | The tracking code for this receipt.
$carrier_name = 'carrier_name_example'; // string | The carrier name for this receipt.
$send_bcc = True; // bool | If true, the shipping notification will be sent to the seller as well
$note_to_buyer = 'note_to_buyer_example'; // string | Message to include in notification to the buyer.

try {
    $result = $apiInstance->createReceiptShipment($shop_id, $receipt_id, $tracking_code, $carrier_name, $send_bcc, $note_to_buyer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopReceiptApi->createReceiptShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **receipt_id** | **int**| The receipt to submit tracking for. | |
| **tracking_code** | **string**| The tracking code for this receipt. | [optional] |
| **carrier_name** | **string**| The carrier name for this receipt. | [optional] |
| **send_bcc** | **bool**| If true, the shipping notification will be sent to the seller as well | [optional] |
| **note_to_buyer** | **string**| Message to include in notification to the buyer. | [optional] |

### Return type

[**\Etsy\Model\ShopReceipt**](../Model/ShopReceipt.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: `application/x-www-form-urlencoded`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getShopReceipt()`

```php
getShopReceipt($shop_id, $receipt_id): \Etsy\Model\ShopReceipt
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Retrieves a receipt, identified by a receipt id, from an Etsy shop

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopReceiptApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$receipt_id = 56; // int | The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction.

try {
    $result = $apiInstance->getShopReceipt($shop_id, $receipt_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopReceiptApi->getShopReceipt: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **receipt_id** | **int**| The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. | |

### Return type

[**\Etsy\Model\ShopReceipt**](../Model/ShopReceipt.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getShopReceipts()`

```php
getShopReceipts($shop_id, $min_created, $max_created, $min_last_modified, $max_last_modified, $limit, $offset, $sort_on, $sort_order, $was_paid, $was_shipped, $was_delivered, $was_canceled): \Etsy\Model\ShopReceipts
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Requests the Shop Receipts from a specific Shop, unfiltered or filtered by receipt id range or offset, date, paid, and/or shipped purchases.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopReceiptApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$min_created = 56; // int | The earliest unix timestamp for when a record was created.
$max_created = 56; // int | The latest unix timestamp for when a record was created.
$min_last_modified = 56; // int | The earliest unix timestamp for when a record last changed.
$max_last_modified = 56; // int | The latest unix timestamp for when a record last changed.
$limit = 25; // int | The maximum number of results to return.
$offset = 0; // int | The number of records to skip before selecting the first result.
$sort_on = 'created'; // string | The value to sort a search result of listings on.
$sort_order = 'desc'; // string | The ascending(up) or descending(down) order to sort receipts by.
$was_paid = True; // bool | When `true`, returns receipts where the seller has recieved payment for the receipt. When `false`, returns receipts where payment has not been received.
$was_shipped = True; // bool | When `true`, returns receipts where the seller shipped the product(s) in this receipt. When `false`, returns receipts where shipment has not been set.
$was_delivered = True; // bool | When `true`, returns receipts that have been marked as delivered. When `false`, returns receipts where shipment has not been marked as delivered.
$was_canceled = True; // bool | When `true`, the endpoint will only return the canceled receipts. When `false`, the endpoint will only return non-canceled receipts.

try {
    $result = $apiInstance->getShopReceipts($shop_id, $min_created, $max_created, $min_last_modified, $max_last_modified, $limit, $offset, $sort_on, $sort_order, $was_paid, $was_shipped, $was_delivered, $was_canceled);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopReceiptApi->getShopReceipts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **min_created** | **int**| The earliest unix timestamp for when a record was created. | [optional] |
| **max_created** | **int**| The latest unix timestamp for when a record was created. | [optional] |
| **min_last_modified** | **int**| The earliest unix timestamp for when a record last changed. | [optional] |
| **max_last_modified** | **int**| The latest unix timestamp for when a record last changed. | [optional] |
| **limit** | **int**| The maximum number of results to return. | [optional] [default to 25] |
| **offset** | **int**| The number of records to skip before selecting the first result. | [optional] [default to 0] |
| **sort_on** | **string**| The value to sort a search result of listings on. | [optional] [default to &#39;created&#39;] |
| **sort_order** | **string**| The ascending(up) or descending(down) order to sort receipts by. | [optional] [default to &#39;desc&#39;] |
| **was_paid** | **bool**| When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. | [optional] |
| **was_shipped** | **bool**| When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. | [optional] |
| **was_delivered** | **bool**| When &#x60;true&#x60;, returns receipts that have been marked as delivered. When &#x60;false&#x60;, returns receipts where shipment has not been marked as delivered. | [optional] |
| **was_canceled** | **bool**| When &#x60;true&#x60;, the endpoint will only return the canceled receipts. When &#x60;false&#x60;, the endpoint will only return non-canceled receipts. | [optional] |

### Return type

[**\Etsy\Model\ShopReceipts**](../Model/ShopReceipts.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateShopReceipt()`

```php
updateShopReceipt($shop_id, $receipt_id, $was_shipped, $was_paid): \Etsy\Model\ShopReceipt
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Updates the status of a receipt, identified by a receipt id, from an Etsy shop

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopReceiptApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$receipt_id = 56; // int | The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction.
$was_shipped = True; // bool | When `true`, returns receipts where the seller shipped the product(s) in this receipt. When `false`, returns receipts where shipment has not been set.
$was_paid = True; // bool | When `true`, returns receipts where the seller has recieved payment for the receipt. When `false`, returns receipts where payment has not been received.

try {
    $result = $apiInstance->updateShopReceipt($shop_id, $receipt_id, $was_shipped, $was_paid);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopReceiptApi->updateShopReceipt: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **receipt_id** | **int**| The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. | |
| **was_shipped** | **bool**| When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. | [optional] |
| **was_paid** | **bool**| When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. | [optional] |

### Return type

[**\Etsy\Model\ShopReceipt**](../Model/ShopReceipt.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: `application/x-www-form-urlencoded`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
