# OpenAPIClient-php

<div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/etsy.git"
    }
  ],
  "require": {
    "talisman/etsy": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');


$apiInstance = new Etsy\Api\BuyerTaxonomyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getBuyerTaxonomyNodes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BuyerTaxonomyApi->getBuyerTaxonomyNodes: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://openapi.etsy.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BuyerTaxonomyApi* | [**getBuyerTaxonomyNodes**](docs/Api/BuyerTaxonomyApi.md#getbuyertaxonomynodes) | **GET** /v3/application/buyer-taxonomy/nodes | 
*BuyerTaxonomyApi* | [**getPropertiesByBuyerTaxonomyId**](docs/Api/BuyerTaxonomyApi.md#getpropertiesbybuyertaxonomyid) | **GET** /v3/application/buyer-taxonomy/nodes/{taxonomy_id}/properties | 
*LedgerEntryApi* | [**getShopPaymentAccountLedgerEntries**](docs/Api/LedgerEntryApi.md#getshoppaymentaccountledgerentries) | **GET** /v3/application/shops/{shop_id}/payment-account/ledger-entries | 
*LedgerEntryApi* | [**getShopPaymentAccountLedgerEntry**](docs/Api/LedgerEntryApi.md#getshoppaymentaccountledgerentry) | **GET** /v3/application/shops/{shop_id}/payment-account/ledger-entries/{ledger_entry_id} | 
*OtherApi* | [**ping**](docs/Api/OtherApi.md#ping) | **GET** /v3/application/openapi-ping | 
*OtherApi* | [**tokenScopes**](docs/Api/OtherApi.md#tokenscopes) | **POST** /v3/application/scopes | 
*PaymentApi* | [**getPaymentAccountLedgerEntryPayments**](docs/Api/PaymentApi.md#getpaymentaccountledgerentrypayments) | **GET** /v3/application/shops/{shop_id}/payment-account/ledger-entries/payments | 
*PaymentApi* | [**getPayments**](docs/Api/PaymentApi.md#getpayments) | **GET** /v3/application/shops/{shop_id}/payments | 
*PaymentApi* | [**getShopPaymentByReceiptId**](docs/Api/PaymentApi.md#getshoppaymentbyreceiptid) | **GET** /v3/application/shops/{shop_id}/receipts/{receipt_id}/payments | 
*ReviewApi* | [**getReviewsByListing**](docs/Api/ReviewApi.md#getreviewsbylisting) | **GET** /v3/application/listings/{listing_id}/reviews | 
*ReviewApi* | [**getReviewsByShop**](docs/Api/ReviewApi.md#getreviewsbyshop) | **GET** /v3/application/shops/{shop_id}/reviews | 
*SellerTaxonomyApi* | [**getPropertiesByTaxonomyId**](docs/Api/SellerTaxonomyApi.md#getpropertiesbytaxonomyid) | **GET** /v3/application/seller-taxonomy/nodes/{taxonomy_id}/properties | 
*SellerTaxonomyApi* | [**getSellerTaxonomyNodes**](docs/Api/SellerTaxonomyApi.md#getsellertaxonomynodes) | **GET** /v3/application/seller-taxonomy/nodes | 
*ShopApi* | [**findShops**](docs/Api/ShopApi.md#findshops) | **GET** /v3/application/shops | 
*ShopApi* | [**getShop**](docs/Api/ShopApi.md#getshop) | **GET** /v3/application/shops/{shop_id} | 
*ShopApi* | [**getShopByOwnerUserId**](docs/Api/ShopApi.md#getshopbyowneruserid) | **GET** /v3/application/users/{user_id}/shops | 
*ShopApi* | [**updateShop**](docs/Api/ShopApi.md#updateshop) | **PUT** /v3/application/shops/{shop_id} | 
*ShopListingApi* | [**createDraftListing**](docs/Api/ShopListingApi.md#createdraftlisting) | **POST** /v3/application/shops/{shop_id}/listings | 
*ShopListingApi* | [**deleteListing**](docs/Api/ShopListingApi.md#deletelisting) | **DELETE** /v3/application/listings/{listing_id} | 
*ShopListingApi* | [**deleteListingProperty**](docs/Api/ShopListingApi.md#deletelistingproperty) | **DELETE** /v3/application/shops/{shop_id}/listings/{listing_id}/properties/{property_id} | 
*ShopListingApi* | [**findAllActiveListingsByShop**](docs/Api/ShopListingApi.md#findallactivelistingsbyshop) | **GET** /v3/application/shops/{shop_id}/listings/active | 
*ShopListingApi* | [**findAllListingsActive**](docs/Api/ShopListingApi.md#findalllistingsactive) | **GET** /v3/application/listings/active | 
*ShopListingApi* | [**getFeaturedListingsByShop**](docs/Api/ShopListingApi.md#getfeaturedlistingsbyshop) | **GET** /v3/application/shops/{shop_id}/listings/featured | 
*ShopListingApi* | [**getListing**](docs/Api/ShopListingApi.md#getlisting) | **GET** /v3/application/listings/{listing_id} | 
*ShopListingApi* | [**getListingProperties**](docs/Api/ShopListingApi.md#getlistingproperties) | **GET** /v3/application/shops/{shop_id}/listings/{listing_id}/properties | 
*ShopListingApi* | [**getListingProperty**](docs/Api/ShopListingApi.md#getlistingproperty) | **GET** /v3/application/listings/{listing_id}/properties/{property_id} | 
*ShopListingApi* | [**getListingsByListingIds**](docs/Api/ShopListingApi.md#getlistingsbylistingids) | **GET** /v3/application/listings/batch | 
*ShopListingApi* | [**getListingsByShop**](docs/Api/ShopListingApi.md#getlistingsbyshop) | **GET** /v3/application/shops/{shop_id}/listings | 
*ShopListingApi* | [**getListingsByShopReceipt**](docs/Api/ShopListingApi.md#getlistingsbyshopreceipt) | **GET** /v3/application/shops/{shop_id}/receipts/{receipt_id}/listings | 
*ShopListingApi* | [**getListingsByShopReturnPolicy**](docs/Api/ShopListingApi.md#getlistingsbyshopreturnpolicy) | **GET** /v3/application/shops/{shop_id}/policies/return/{return_policy_id}/listings | 
*ShopListingApi* | [**getListingsByShopSectionId**](docs/Api/ShopListingApi.md#getlistingsbyshopsectionid) | **GET** /v3/application/shops/{shop_id}/shop-sections/listings | 
*ShopListingApi* | [**updateListing**](docs/Api/ShopListingApi.md#updatelisting) | **PATCH** /v3/application/shops/{shop_id}/listings/{listing_id} | 
*ShopListingApi* | [**updateListingDeprecated**](docs/Api/ShopListingApi.md#updatelistingdeprecated) | **PUT** /v3/application/shops/{shop_id}/listings/{listing_id} | 
*ShopListingApi* | [**updateListingProperty**](docs/Api/ShopListingApi.md#updatelistingproperty) | **PUT** /v3/application/shops/{shop_id}/listings/{listing_id}/properties/{property_id} | 
*ShopListingFileApi* | [**deleteListingFile**](docs/Api/ShopListingFileApi.md#deletelistingfile) | **DELETE** /v3/application/shops/{shop_id}/listings/{listing_id}/files/{listing_file_id} | 
*ShopListingFileApi* | [**getAllListingFiles**](docs/Api/ShopListingFileApi.md#getalllistingfiles) | **GET** /v3/application/shops/{shop_id}/listings/{listing_id}/files | 
*ShopListingFileApi* | [**getListingFile**](docs/Api/ShopListingFileApi.md#getlistingfile) | **GET** /v3/application/shops/{shop_id}/listings/{listing_id}/files/{listing_file_id} | 
*ShopListingFileApi* | [**uploadListingFile**](docs/Api/ShopListingFileApi.md#uploadlistingfile) | **POST** /v3/application/shops/{shop_id}/listings/{listing_id}/files | 
*ShopListingImageApi* | [**deleteListingImage**](docs/Api/ShopListingImageApi.md#deletelistingimage) | **DELETE** /v3/application/shops/{shop_id}/listings/{listing_id}/images/{listing_image_id} | 
*ShopListingImageApi* | [**getListingImage**](docs/Api/ShopListingImageApi.md#getlistingimage) | **GET** /v3/application/listings/{listing_id}/images/{listing_image_id} | 
*ShopListingImageApi* | [**getListingImageDeprecated**](docs/Api/ShopListingImageApi.md#getlistingimagedeprecated) | **GET** /v3/application/shops/{shop_id}/listings/{listing_id}/images/{listing_image_id} | 
*ShopListingImageApi* | [**getListingImages**](docs/Api/ShopListingImageApi.md#getlistingimages) | **GET** /v3/application/listings/{listing_id}/images | 
*ShopListingImageApi* | [**getListingImagesDeprecated**](docs/Api/ShopListingImageApi.md#getlistingimagesdeprecated) | **GET** /v3/application/shops/{shop_id}/listings/{listing_id}/images | 
*ShopListingImageApi* | [**uploadListingImage**](docs/Api/ShopListingImageApi.md#uploadlistingimage) | **POST** /v3/application/shops/{shop_id}/listings/{listing_id}/images | 
*ShopListingInventoryApi* | [**getListingInventory**](docs/Api/ShopListingInventoryApi.md#getlistinginventory) | **GET** /v3/application/listings/{listing_id}/inventory | 
*ShopListingInventoryApi* | [**updateListingInventory**](docs/Api/ShopListingInventoryApi.md#updatelistinginventory) | **PUT** /v3/application/listings/{listing_id}/inventory | 
*ShopListingOfferingApi* | [**getListingOffering**](docs/Api/ShopListingOfferingApi.md#getlistingoffering) | **GET** /v3/application/listings/{listing_id}/products/{product_id}/offerings/{product_offering_id} | 
*ShopListingProductApi* | [**getListingProduct**](docs/Api/ShopListingProductApi.md#getlistingproduct) | **GET** /v3/application/listings/{listing_id}/inventory/products/{product_id} | 
*ShopListingTranslationApi* | [**createListingTranslation**](docs/Api/ShopListingTranslationApi.md#createlistingtranslation) | **POST** /v3/application/shops/{shop_id}/listings/{listing_id}/translations/{language} | 
*ShopListingTranslationApi* | [**getListingTranslation**](docs/Api/ShopListingTranslationApi.md#getlistingtranslation) | **GET** /v3/application/shops/{shop_id}/listings/{listing_id}/translations/{language} | 
*ShopListingTranslationApi* | [**updateListingTranslation**](docs/Api/ShopListingTranslationApi.md#updatelistingtranslation) | **PUT** /v3/application/shops/{shop_id}/listings/{listing_id}/translations/{language} | 
*ShopListingVariationImageApi* | [**getListingVariationImages**](docs/Api/ShopListingVariationImageApi.md#getlistingvariationimages) | **GET** /v3/application/shops/{shop_id}/listings/{listing_id}/variation-images | 
*ShopListingVariationImageApi* | [**updateVariationImages**](docs/Api/ShopListingVariationImageApi.md#updatevariationimages) | **POST** /v3/application/shops/{shop_id}/listings/{listing_id}/variation-images | 
*ShopListingVideoApi* | [**deleteListingVideo**](docs/Api/ShopListingVideoApi.md#deletelistingvideo) | **DELETE** /v3/application/shops/{shop_id}/listings/{listing_id}/videos/{video_id} | 
*ShopListingVideoApi* | [**getListingVideo**](docs/Api/ShopListingVideoApi.md#getlistingvideo) | **GET** /v3/application/listings/{listing_id}/videos/{video_id} | 
*ShopListingVideoApi* | [**getListingVideos**](docs/Api/ShopListingVideoApi.md#getlistingvideos) | **GET** /v3/application/listings/{listing_id}/videos | 
*ShopListingVideoApi* | [**uploadListingVideo**](docs/Api/ShopListingVideoApi.md#uploadlistingvideo) | **POST** /v3/application/shops/{shop_id}/listings/{listing_id}/videos | 
*ShopProductionPartnerApi* | [**getShopProductionPartners**](docs/Api/ShopProductionPartnerApi.md#getshopproductionpartners) | **GET** /v3/application/shops/{shop_id}/production-partners | 
*ShopReceiptApi* | [**createReceiptShipment**](docs/Api/ShopReceiptApi.md#createreceiptshipment) | **POST** /v3/application/shops/{shop_id}/receipts/{receipt_id}/tracking | 
*ShopReceiptApi* | [**getShopReceipt**](docs/Api/ShopReceiptApi.md#getshopreceipt) | **GET** /v3/application/shops/{shop_id}/receipts/{receipt_id} | 
*ShopReceiptApi* | [**getShopReceipts**](docs/Api/ShopReceiptApi.md#getshopreceipts) | **GET** /v3/application/shops/{shop_id}/receipts | 
*ShopReceiptApi* | [**updateShopReceipt**](docs/Api/ShopReceiptApi.md#updateshopreceipt) | **PUT** /v3/application/shops/{shop_id}/receipts/{receipt_id} | 
*ShopReceiptTransactionsApi* | [**getShopReceiptTransaction**](docs/Api/ShopReceiptTransactionsApi.md#getshopreceipttransaction) | **GET** /v3/application/shops/{shop_id}/transactions/{transaction_id} | 
*ShopReceiptTransactionsApi* | [**getShopReceiptTransactionsByListing**](docs/Api/ShopReceiptTransactionsApi.md#getshopreceipttransactionsbylisting) | **GET** /v3/application/shops/{shop_id}/listings/{listing_id}/transactions | 
*ShopReceiptTransactionsApi* | [**getShopReceiptTransactionsByReceipt**](docs/Api/ShopReceiptTransactionsApi.md#getshopreceipttransactionsbyreceipt) | **GET** /v3/application/shops/{shop_id}/receipts/{receipt_id}/transactions | 
*ShopReceiptTransactionsApi* | [**getShopReceiptTransactionsByShop**](docs/Api/ShopReceiptTransactionsApi.md#getshopreceipttransactionsbyshop) | **GET** /v3/application/shops/{shop_id}/transactions | 
*ShopReturnPolicyApi* | [**consolidateShopReturnPolicies**](docs/Api/ShopReturnPolicyApi.md#consolidateshopreturnpolicies) | **POST** /v3/application/shops/{shop_id}/policies/return/consolidate | 
*ShopReturnPolicyApi* | [**createShopReturnPolicy**](docs/Api/ShopReturnPolicyApi.md#createshopreturnpolicy) | **POST** /v3/application/shops/{shop_id}/policies/return | 
*ShopReturnPolicyApi* | [**deleteShopReturnPolicy**](docs/Api/ShopReturnPolicyApi.md#deleteshopreturnpolicy) | **DELETE** /v3/application/shops/{shop_id}/policies/return/{return_policy_id} | 
*ShopReturnPolicyApi* | [**getShopReturnPolicies**](docs/Api/ShopReturnPolicyApi.md#getshopreturnpolicies) | **GET** /v3/application/shops/{shop_id}/policies/return | 
*ShopReturnPolicyApi* | [**getShopReturnPolicy**](docs/Api/ShopReturnPolicyApi.md#getshopreturnpolicy) | **GET** /v3/application/shops/{shop_id}/policies/return/{return_policy_id} | 
*ShopReturnPolicyApi* | [**updateShopReturnPolicy**](docs/Api/ShopReturnPolicyApi.md#updateshopreturnpolicy) | **PUT** /v3/application/shops/{shop_id}/policies/return/{return_policy_id} | 
*ShopSectionApi* | [**createShopSection**](docs/Api/ShopSectionApi.md#createshopsection) | **POST** /v3/application/shops/{shop_id}/sections | 
*ShopSectionApi* | [**deleteShopSection**](docs/Api/ShopSectionApi.md#deleteshopsection) | **DELETE** /v3/application/shops/{shop_id}/sections/{shop_section_id} | 
*ShopSectionApi* | [**getShopSection**](docs/Api/ShopSectionApi.md#getshopsection) | **GET** /v3/application/shops/{shop_id}/sections/{shop_section_id} | 
*ShopSectionApi* | [**getShopSections**](docs/Api/ShopSectionApi.md#getshopsections) | **GET** /v3/application/shops/{shop_id}/sections | 
*ShopSectionApi* | [**updateShopSection**](docs/Api/ShopSectionApi.md#updateshopsection) | **PUT** /v3/application/shops/{shop_id}/sections/{shop_section_id} | 
*ShopShippingProfileApi* | [**createShopShippingProfile**](docs/Api/ShopShippingProfileApi.md#createshopshippingprofile) | **POST** /v3/application/shops/{shop_id}/shipping-profiles | 
*ShopShippingProfileApi* | [**createShopShippingProfileDestination**](docs/Api/ShopShippingProfileApi.md#createshopshippingprofiledestination) | **POST** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations | 
*ShopShippingProfileApi* | [**createShopShippingProfileUpgrade**](docs/Api/ShopShippingProfileApi.md#createshopshippingprofileupgrade) | **POST** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades | 
*ShopShippingProfileApi* | [**deleteShopShippingProfile**](docs/Api/ShopShippingProfileApi.md#deleteshopshippingprofile) | **DELETE** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id} | 
*ShopShippingProfileApi* | [**deleteShopShippingProfileDestination**](docs/Api/ShopShippingProfileApi.md#deleteshopshippingprofiledestination) | **DELETE** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations/{shipping_profile_destination_id} | 
*ShopShippingProfileApi* | [**deleteShopShippingProfileUpgrade**](docs/Api/ShopShippingProfileApi.md#deleteshopshippingprofileupgrade) | **DELETE** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades/{upgrade_id} | 
*ShopShippingProfileApi* | [**getShippingCarriers**](docs/Api/ShopShippingProfileApi.md#getshippingcarriers) | **GET** /v3/application/shipping-carriers | 
*ShopShippingProfileApi* | [**getShopShippingProfile**](docs/Api/ShopShippingProfileApi.md#getshopshippingprofile) | **GET** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id} | 
*ShopShippingProfileApi* | [**getShopShippingProfileDestinationsByShippingProfile**](docs/Api/ShopShippingProfileApi.md#getshopshippingprofiledestinationsbyshippingprofile) | **GET** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations | 
*ShopShippingProfileApi* | [**getShopShippingProfileUpgrades**](docs/Api/ShopShippingProfileApi.md#getshopshippingprofileupgrades) | **GET** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades | 
*ShopShippingProfileApi* | [**getShopShippingProfiles**](docs/Api/ShopShippingProfileApi.md#getshopshippingprofiles) | **GET** /v3/application/shops/{shop_id}/shipping-profiles | 
*ShopShippingProfileApi* | [**updateShopShippingProfile**](docs/Api/ShopShippingProfileApi.md#updateshopshippingprofile) | **PUT** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id} | 
*ShopShippingProfileApi* | [**updateShopShippingProfileDestination**](docs/Api/ShopShippingProfileApi.md#updateshopshippingprofiledestination) | **PUT** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/destinations/{shipping_profile_destination_id} | 
*ShopShippingProfileApi* | [**updateShopShippingProfileUpgrade**](docs/Api/ShopShippingProfileApi.md#updateshopshippingprofileupgrade) | **PUT** /v3/application/shops/{shop_id}/shipping-profiles/{shipping_profile_id}/upgrades/{upgrade_id} | 
*UserApi* | [**getMe**](docs/Api/UserApi.md#getme) | **GET** /v3/application/users/me | 
*UserApi* | [**getUser**](docs/Api/UserApi.md#getuser) | **GET** /v3/application/users/{user_id} | 
*UserAddressApi* | [**deleteUserAddress**](docs/Api/UserAddressApi.md#deleteuseraddress) | **DELETE** /v3/application/user/addresses/{user_address_id} | 
*UserAddressApi* | [**getUserAddress**](docs/Api/UserAddressApi.md#getuseraddress) | **GET** /v3/application/user/addresses/{user_address_id} | 
*UserAddressApi* | [**getUserAddresses**](docs/Api/UserAddressApi.md#getuseraddresses) | **GET** /v3/application/user/addresses | 

## Models

- [BuyerTaxonomyNode](docs/Model/BuyerTaxonomyNode.md)
- [BuyerTaxonomyNodeChildrenInner](docs/Model/BuyerTaxonomyNodeChildrenInner.md)
- [BuyerTaxonomyNodeProperties](docs/Model/BuyerTaxonomyNodeProperties.md)
- [BuyerTaxonomyNodePropertiesResultsInner](docs/Model/BuyerTaxonomyNodePropertiesResultsInner.md)
- [BuyerTaxonomyNodeProperty](docs/Model/BuyerTaxonomyNodeProperty.md)
- [BuyerTaxonomyNodePropertyPossibleValuesInner](docs/Model/BuyerTaxonomyNodePropertyPossibleValuesInner.md)
- [BuyerTaxonomyNodePropertyScalesInner](docs/Model/BuyerTaxonomyNodePropertyScalesInner.md)
- [BuyerTaxonomyNodePropertySelectedValuesInner](docs/Model/BuyerTaxonomyNodePropertySelectedValuesInner.md)
- [BuyerTaxonomyNodes](docs/Model/BuyerTaxonomyNodes.md)
- [BuyerTaxonomyNodesResultsInner](docs/Model/BuyerTaxonomyNodesResultsInner.md)
- [BuyerTaxonomyPropertyScale](docs/Model/BuyerTaxonomyPropertyScale.md)
- [BuyerTaxonomyPropertyValue](docs/Model/BuyerTaxonomyPropertyValue.md)
- [ErrorSchema](docs/Model/ErrorSchema.md)
- [ListingImage](docs/Model/ListingImage.md)
- [ListingImages](docs/Model/ListingImages.md)
- [ListingImagesResultsInner](docs/Model/ListingImagesResultsInner.md)
- [ListingInventory](docs/Model/ListingInventory.md)
- [ListingInventoryProduct](docs/Model/ListingInventoryProduct.md)
- [ListingInventoryProductOffering](docs/Model/ListingInventoryProductOffering.md)
- [ListingInventoryProductOfferingPrice](docs/Model/ListingInventoryProductOfferingPrice.md)
- [ListingInventoryProductOfferingsInner](docs/Model/ListingInventoryProductOfferingsInner.md)
- [ListingInventoryProductPropertyValuesInner](docs/Model/ListingInventoryProductPropertyValuesInner.md)
- [ListingInventoryProductsInner](docs/Model/ListingInventoryProductsInner.md)
- [ListingInventoryWithAssociations](docs/Model/ListingInventoryWithAssociations.md)
- [ListingInventoryWithAssociationsListing](docs/Model/ListingInventoryWithAssociationsListing.md)
- [ListingPropertyValue](docs/Model/ListingPropertyValue.md)
- [ListingPropertyValues](docs/Model/ListingPropertyValues.md)
- [ListingPropertyValuesResultsInner](docs/Model/ListingPropertyValuesResultsInner.md)
- [ListingReview](docs/Model/ListingReview.md)
- [ListingReviews](docs/Model/ListingReviews.md)
- [ListingReviewsResultsInner](docs/Model/ListingReviewsResultsInner.md)
- [ListingTranslation](docs/Model/ListingTranslation.md)
- [ListingVariationImage](docs/Model/ListingVariationImage.md)
- [ListingVariationImages](docs/Model/ListingVariationImages.md)
- [ListingVariationImagesResultsInner](docs/Model/ListingVariationImagesResultsInner.md)
- [ListingVideo](docs/Model/ListingVideo.md)
- [ListingVideos](docs/Model/ListingVideos.md)
- [ListingVideosResultsInner](docs/Model/ListingVideosResultsInner.md)
- [Money](docs/Model/Money.md)
- [Payment](docs/Model/Payment.md)
- [PaymentAccountLedgerEntries](docs/Model/PaymentAccountLedgerEntries.md)
- [PaymentAccountLedgerEntriesResultsInner](docs/Model/PaymentAccountLedgerEntriesResultsInner.md)
- [PaymentAccountLedgerEntry](docs/Model/PaymentAccountLedgerEntry.md)
- [PaymentAccountLedgerEntryPaymentAdjustmentsInner](docs/Model/PaymentAccountLedgerEntryPaymentAdjustmentsInner.md)
- [PaymentAdjustedFees](docs/Model/PaymentAdjustedFees.md)
- [PaymentAdjustedGross](docs/Model/PaymentAdjustedGross.md)
- [PaymentAdjustedNet](docs/Model/PaymentAdjustedNet.md)
- [PaymentAdjustment](docs/Model/PaymentAdjustment.md)
- [PaymentAdjustmentItem](docs/Model/PaymentAdjustmentItem.md)
- [PaymentAdjustmentPaymentAdjustmentItemsInner](docs/Model/PaymentAdjustmentPaymentAdjustmentItemsInner.md)
- [PaymentAmountFees](docs/Model/PaymentAmountFees.md)
- [PaymentAmountGross](docs/Model/PaymentAmountGross.md)
- [PaymentAmountNet](docs/Model/PaymentAmountNet.md)
- [PaymentPostedFees](docs/Model/PaymentPostedFees.md)
- [PaymentPostedGross](docs/Model/PaymentPostedGross.md)
- [PaymentPostedNet](docs/Model/PaymentPostedNet.md)
- [Payments](docs/Model/Payments.md)
- [PaymentsResultsInner](docs/Model/PaymentsResultsInner.md)
- [Pong](docs/Model/Pong.md)
- [Self](docs/Model/Self.md)
- [SellerTaxonomyNode](docs/Model/SellerTaxonomyNode.md)
- [SellerTaxonomyNodeChildrenInner](docs/Model/SellerTaxonomyNodeChildrenInner.md)
- [SellerTaxonomyNodes](docs/Model/SellerTaxonomyNodes.md)
- [SellerTaxonomyNodesResultsInner](docs/Model/SellerTaxonomyNodesResultsInner.md)
- [ShippingCarrier](docs/Model/ShippingCarrier.md)
- [ShippingCarrierDomesticClassesInner](docs/Model/ShippingCarrierDomesticClassesInner.md)
- [ShippingCarrierInternationalClassesInner](docs/Model/ShippingCarrierInternationalClassesInner.md)
- [ShippingCarrierMailClass](docs/Model/ShippingCarrierMailClass.md)
- [ShippingCarriers](docs/Model/ShippingCarriers.md)
- [ShippingCarriersResultsInner](docs/Model/ShippingCarriersResultsInner.md)
- [Shop](docs/Model/Shop.md)
- [ShopListing](docs/Model/ShopListing.md)
- [ShopListingFile](docs/Model/ShopListingFile.md)
- [ShopListingFiles](docs/Model/ShopListingFiles.md)
- [ShopListingFilesResultsInner](docs/Model/ShopListingFilesResultsInner.md)
- [ShopListingPrice](docs/Model/ShopListingPrice.md)
- [ShopListingWithAssociations](docs/Model/ShopListingWithAssociations.md)
- [ShopListingWithAssociationsImagesInner](docs/Model/ShopListingWithAssociationsImagesInner.md)
- [ShopListingWithAssociationsInventory](docs/Model/ShopListingWithAssociationsInventory.md)
- [ShopListingWithAssociationsProductionPartnersInner](docs/Model/ShopListingWithAssociationsProductionPartnersInner.md)
- [ShopListingWithAssociationsShippingProfile](docs/Model/ShopListingWithAssociationsShippingProfile.md)
- [ShopListingWithAssociationsShop](docs/Model/ShopListingWithAssociationsShop.md)
- [ShopListingWithAssociationsTranslationsInner](docs/Model/ShopListingWithAssociationsTranslationsInner.md)
- [ShopListingWithAssociationsUser](docs/Model/ShopListingWithAssociationsUser.md)
- [ShopListingWithAssociationsVideosInner](docs/Model/ShopListingWithAssociationsVideosInner.md)
- [ShopListings](docs/Model/ShopListings.md)
- [ShopListingsResultsInner](docs/Model/ShopListingsResultsInner.md)
- [ShopListingsWithAssociations](docs/Model/ShopListingsWithAssociations.md)
- [ShopListingsWithAssociationsResultsInner](docs/Model/ShopListingsWithAssociationsResultsInner.md)
- [ShopProductionPartner](docs/Model/ShopProductionPartner.md)
- [ShopProductionPartners](docs/Model/ShopProductionPartners.md)
- [ShopProductionPartnersResultsInner](docs/Model/ShopProductionPartnersResultsInner.md)
- [ShopReceipt](docs/Model/ShopReceipt.md)
- [ShopReceiptDiscountAmt](docs/Model/ShopReceiptDiscountAmt.md)
- [ShopReceiptGiftWrapPrice](docs/Model/ShopReceiptGiftWrapPrice.md)
- [ShopReceiptGrandtotal](docs/Model/ShopReceiptGrandtotal.md)
- [ShopReceiptRefundsInner](docs/Model/ShopReceiptRefundsInner.md)
- [ShopReceiptShipment](docs/Model/ShopReceiptShipment.md)
- [ShopReceiptShipmentsInner](docs/Model/ShopReceiptShipmentsInner.md)
- [ShopReceiptSubtotal](docs/Model/ShopReceiptSubtotal.md)
- [ShopReceiptTotalPrice](docs/Model/ShopReceiptTotalPrice.md)
- [ShopReceiptTotalShippingCost](docs/Model/ShopReceiptTotalShippingCost.md)
- [ShopReceiptTotalTaxCost](docs/Model/ShopReceiptTotalTaxCost.md)
- [ShopReceiptTotalVatCost](docs/Model/ShopReceiptTotalVatCost.md)
- [ShopReceiptTransaction](docs/Model/ShopReceiptTransaction.md)
- [ShopReceiptTransactionPrice](docs/Model/ShopReceiptTransactionPrice.md)
- [ShopReceiptTransactionShippingCost](docs/Model/ShopReceiptTransactionShippingCost.md)
- [ShopReceiptTransactionVariationsInner](docs/Model/ShopReceiptTransactionVariationsInner.md)
- [ShopReceiptTransactions](docs/Model/ShopReceiptTransactions.md)
- [ShopReceiptTransactionsInner](docs/Model/ShopReceiptTransactionsInner.md)
- [ShopReceiptTransactionsResultsInner](docs/Model/ShopReceiptTransactionsResultsInner.md)
- [ShopReceipts](docs/Model/ShopReceipts.md)
- [ShopReceiptsResultsInner](docs/Model/ShopReceiptsResultsInner.md)
- [ShopRefund](docs/Model/ShopRefund.md)
- [ShopRefundAmount](docs/Model/ShopRefundAmount.md)
- [ShopReturnPolicies](docs/Model/ShopReturnPolicies.md)
- [ShopReturnPoliciesResultsInner](docs/Model/ShopReturnPoliciesResultsInner.md)
- [ShopReturnPolicy](docs/Model/ShopReturnPolicy.md)
- [ShopSection](docs/Model/ShopSection.md)
- [ShopSections](docs/Model/ShopSections.md)
- [ShopSectionsResultsInner](docs/Model/ShopSectionsResultsInner.md)
- [ShopShippingProfile](docs/Model/ShopShippingProfile.md)
- [ShopShippingProfileDestination](docs/Model/ShopShippingProfileDestination.md)
- [ShopShippingProfileDestinationPrimaryCost](docs/Model/ShopShippingProfileDestinationPrimaryCost.md)
- [ShopShippingProfileDestinationSecondaryCost](docs/Model/ShopShippingProfileDestinationSecondaryCost.md)
- [ShopShippingProfileDestinations](docs/Model/ShopShippingProfileDestinations.md)
- [ShopShippingProfileDestinationsResultsInner](docs/Model/ShopShippingProfileDestinationsResultsInner.md)
- [ShopShippingProfileShippingProfileDestinationsInner](docs/Model/ShopShippingProfileShippingProfileDestinationsInner.md)
- [ShopShippingProfileShippingProfileUpgradesInner](docs/Model/ShopShippingProfileShippingProfileUpgradesInner.md)
- [ShopShippingProfileUpgrade](docs/Model/ShopShippingProfileUpgrade.md)
- [ShopShippingProfileUpgradePrice](docs/Model/ShopShippingProfileUpgradePrice.md)
- [ShopShippingProfileUpgradeSecondaryPrice](docs/Model/ShopShippingProfileUpgradeSecondaryPrice.md)
- [ShopShippingProfileUpgrades](docs/Model/ShopShippingProfileUpgrades.md)
- [ShopShippingProfileUpgradesResultsInner](docs/Model/ShopShippingProfileUpgradesResultsInner.md)
- [ShopShippingProfiles](docs/Model/ShopShippingProfiles.md)
- [ShopShippingProfilesResultsInner](docs/Model/ShopShippingProfilesResultsInner.md)
- [Shops](docs/Model/Shops.md)
- [ShopsResultsInner](docs/Model/ShopsResultsInner.md)
- [TaxonomyNodeProperties](docs/Model/TaxonomyNodeProperties.md)
- [TaxonomyNodePropertiesResultsInner](docs/Model/TaxonomyNodePropertiesResultsInner.md)
- [TaxonomyNodeProperty](docs/Model/TaxonomyNodeProperty.md)
- [TaxonomyNodePropertyPossibleValuesInner](docs/Model/TaxonomyNodePropertyPossibleValuesInner.md)
- [TaxonomyNodePropertyScalesInner](docs/Model/TaxonomyNodePropertyScalesInner.md)
- [TaxonomyNodePropertySelectedValuesInner](docs/Model/TaxonomyNodePropertySelectedValuesInner.md)
- [TaxonomyPropertyScale](docs/Model/TaxonomyPropertyScale.md)
- [TaxonomyPropertyValue](docs/Model/TaxonomyPropertyValue.md)
- [TransactionReview](docs/Model/TransactionReview.md)
- [TransactionReviews](docs/Model/TransactionReviews.md)
- [TransactionReviewsResultsInner](docs/Model/TransactionReviewsResultsInner.md)
- [TransactionVariations](docs/Model/TransactionVariations.md)
- [UpdateListingInventoryRequest](docs/Model/UpdateListingInventoryRequest.md)
- [UpdateListingInventoryRequestProductsInner](docs/Model/UpdateListingInventoryRequestProductsInner.md)
- [UpdateListingInventoryRequestProductsInnerOfferingsInner](docs/Model/UpdateListingInventoryRequestProductsInnerOfferingsInner.md)
- [UpdateListingInventoryRequestProductsInnerPropertyValuesInner](docs/Model/UpdateListingInventoryRequestProductsInnerPropertyValuesInner.md)
- [UpdateVariationImagesRequest](docs/Model/UpdateVariationImagesRequest.md)
- [UpdateVariationImagesRequestVariationImagesInner](docs/Model/UpdateVariationImagesRequestVariationImagesInner.md)
- [User](docs/Model/User.md)
- [UserAddress](docs/Model/UserAddress.md)
- [UserAddresses](docs/Model/UserAddresses.md)
- [UserAddressesResultsInner](docs/Model/UserAddressesResultsInner.md)

## Authorization

Authentication schemes defined for the API:
### api_key

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


### oauth2

- **Type**: `OAuth`
- **Flow**: `accessCode`
- **Authorization URL**: `https://www.etsy.com/oauth/connect`
- **Scopes**: 
    - **address_r**: see billing and shipping addresses
    - **address_w**: update billing and shipping addresses
    - **billing_r**: see all billing statement data
    - **cart_r**: read shopping carts
    - **cart_w**: add/remove from shopping carts
    - **email_r**: Read a member's email address
    - **favorites_r**: see private favorites
    - **favorites_w**: add/remove favorites
    - **feedback_r**: see purchase info in feedback
    - **listings_d**: delete listings
    - **listings_r**: see all listings (including expired etc)
    - **listings_w**: create/edit listings
    - **profile_r**: see all profile data
    - **profile_w**: update user profile, avatar, etc
    - **recommend_r**: see recommended listings
    - **recommend_w**: accept/reject recommended listings
    - **shops_r**: see private shop info
    - **shops_w**: update shop
    - **transactions_r**: see all checkout/payment data
    - **transactions_w**: update receipts

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

developers@etsy.com

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `3.0.0`
    - Package version: `1.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
