<?php
/**
 * ShopShippingProfile
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ShopShippingProfile Class Doc Comment
 *
 * @category Class
 * @description Represents a profile used to set a listing&#39;s shipping information. Please note that it&#39;s not possible to create calculated shipping templates via the API. However, you can associate calculated shipping profiles created from Shop Manager with listings using the API.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShopShippingProfile implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShopShippingProfile';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'shipping_profile_id' => 'int',
        'title' => 'string',
        'user_id' => 'int',
        'min_processing_days' => 'int',
        'max_processing_days' => 'int',
        'processing_days_display_label' => 'string',
        'origin_country_iso' => 'string',
        'is_deleted' => 'bool',
        'shipping_profile_destinations' => '\Etsy\Model\ShopShippingProfileShippingProfileDestinationsInner[]',
        'shipping_profile_upgrades' => '\Etsy\Model\ShopShippingProfileShippingProfileUpgradesInner[]',
        'origin_postal_code' => 'string',
        'profile_type' => 'string',
        'domestic_handling_fee' => 'float',
        'international_handling_fee' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'shipping_profile_id' => null,
        'title' => null,
        'user_id' => null,
        'min_processing_days' => null,
        'max_processing_days' => null,
        'processing_days_display_label' => null,
        'origin_country_iso' => 'ISO 3166-1 alpha-2',
        'is_deleted' => null,
        'shipping_profile_destinations' => null,
        'shipping_profile_upgrades' => null,
        'origin_postal_code' => null,
        'profile_type' => null,
        'domestic_handling_fee' => 'float',
        'international_handling_fee' => 'float'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'shipping_profile_id' => false,
		'title' => true,
		'user_id' => false,
		'min_processing_days' => true,
		'max_processing_days' => true,
		'processing_days_display_label' => false,
		'origin_country_iso' => false,
		'is_deleted' => false,
		'shipping_profile_destinations' => false,
		'shipping_profile_upgrades' => false,
		'origin_postal_code' => true,
		'profile_type' => false,
		'domestic_handling_fee' => false,
		'international_handling_fee' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shipping_profile_id' => 'shipping_profile_id',
        'title' => 'title',
        'user_id' => 'user_id',
        'min_processing_days' => 'min_processing_days',
        'max_processing_days' => 'max_processing_days',
        'processing_days_display_label' => 'processing_days_display_label',
        'origin_country_iso' => 'origin_country_iso',
        'is_deleted' => 'is_deleted',
        'shipping_profile_destinations' => 'shipping_profile_destinations',
        'shipping_profile_upgrades' => 'shipping_profile_upgrades',
        'origin_postal_code' => 'origin_postal_code',
        'profile_type' => 'profile_type',
        'domestic_handling_fee' => 'domestic_handling_fee',
        'international_handling_fee' => 'international_handling_fee'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shipping_profile_id' => 'setShippingProfileId',
        'title' => 'setTitle',
        'user_id' => 'setUserId',
        'min_processing_days' => 'setMinProcessingDays',
        'max_processing_days' => 'setMaxProcessingDays',
        'processing_days_display_label' => 'setProcessingDaysDisplayLabel',
        'origin_country_iso' => 'setOriginCountryIso',
        'is_deleted' => 'setIsDeleted',
        'shipping_profile_destinations' => 'setShippingProfileDestinations',
        'shipping_profile_upgrades' => 'setShippingProfileUpgrades',
        'origin_postal_code' => 'setOriginPostalCode',
        'profile_type' => 'setProfileType',
        'domestic_handling_fee' => 'setDomesticHandlingFee',
        'international_handling_fee' => 'setInternationalHandlingFee'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shipping_profile_id' => 'getShippingProfileId',
        'title' => 'getTitle',
        'user_id' => 'getUserId',
        'min_processing_days' => 'getMinProcessingDays',
        'max_processing_days' => 'getMaxProcessingDays',
        'processing_days_display_label' => 'getProcessingDaysDisplayLabel',
        'origin_country_iso' => 'getOriginCountryIso',
        'is_deleted' => 'getIsDeleted',
        'shipping_profile_destinations' => 'getShippingProfileDestinations',
        'shipping_profile_upgrades' => 'getShippingProfileUpgrades',
        'origin_postal_code' => 'getOriginPostalCode',
        'profile_type' => 'getProfileType',
        'domestic_handling_fee' => 'getDomesticHandlingFee',
        'international_handling_fee' => 'getInternationalHandlingFee'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const PROFILE_TYPE_MANUAL = 'manual';
    public const PROFILE_TYPE_CALCULATED = 'calculated';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getProfileTypeAllowableValues()
    {
        return [
            self::PROFILE_TYPE_MANUAL,
            self::PROFILE_TYPE_CALCULATED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('shipping_profile_id', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('user_id', $data ?? [], null);
        $this->setIfExists('min_processing_days', $data ?? [], null);
        $this->setIfExists('max_processing_days', $data ?? [], null);
        $this->setIfExists('processing_days_display_label', $data ?? [], null);
        $this->setIfExists('origin_country_iso', $data ?? [], null);
        $this->setIfExists('is_deleted', $data ?? [], null);
        $this->setIfExists('shipping_profile_destinations', $data ?? [], null);
        $this->setIfExists('shipping_profile_upgrades', $data ?? [], null);
        $this->setIfExists('origin_postal_code', $data ?? [], null);
        $this->setIfExists('profile_type', $data ?? [], null);
        $this->setIfExists('domestic_handling_fee', $data ?? [], 0);
        $this->setIfExists('international_handling_fee', $data ?? [], 0);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['shipping_profile_id']) && ($this->container['shipping_profile_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shipping_profile_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['user_id']) && ($this->container['user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'user_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['min_processing_days']) && ($this->container['min_processing_days'] < 0)) {
            $invalidProperties[] = "invalid value for 'min_processing_days', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['max_processing_days']) && ($this->container['max_processing_days'] < 0)) {
            $invalidProperties[] = "invalid value for 'max_processing_days', must be bigger than or equal to 0.";
        }

        $allowedValues = $this->getProfileTypeAllowableValues();
        if (!is_null($this->container['profile_type']) && !in_array($this->container['profile_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'profile_type', must be one of '%s'",
                $this->container['profile_type'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['domestic_handling_fee']) && ($this->container['domestic_handling_fee'] < 0)) {
            $invalidProperties[] = "invalid value for 'domestic_handling_fee', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['international_handling_fee']) && ($this->container['international_handling_fee'] < 0)) {
            $invalidProperties[] = "invalid value for 'international_handling_fee', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shipping_profile_id
     *
     * @return int|null
     */
    public function getShippingProfileId()
    {
        return $this->container['shipping_profile_id'];
    }

    /**
     * Sets shipping_profile_id
     *
     * @param int|null $shipping_profile_id The numeric ID of the shipping profile.
     *
     * @return self
     */
    public function setShippingProfileId($shipping_profile_id)
    {
        if (is_null($shipping_profile_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_profile_id cannot be null');
        }

        if (($shipping_profile_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shipping_profile_id when calling ShopShippingProfile., must be bigger than or equal to 1.');
        }

        $this->container['shipping_profile_id'] = $shipping_profile_id;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title The name string of this shipping profile.
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            array_push($this->openAPINullablesSetToNull, 'title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('title', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return int|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param int|null $user_id The numeric ID for the [user](/documentation/reference#tag/User) who owns the shipping profile.
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        if (is_null($user_id)) {
            throw new \InvalidArgumentException('non-nullable user_id cannot be null');
        }

        if (($user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $user_id when calling ShopShippingProfile., must be bigger than or equal to 1.');
        }

        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets min_processing_days
     *
     * @return int|null
     */
    public function getMinProcessingDays()
    {
        return $this->container['min_processing_days'];
    }

    /**
     * Sets min_processing_days
     *
     * @param int|null $min_processing_days The minimum number of days for processing the listing.
     *
     * @return self
     */
    public function setMinProcessingDays($min_processing_days)
    {
        if (is_null($min_processing_days)) {
            array_push($this->openAPINullablesSetToNull, 'min_processing_days');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('min_processing_days', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($min_processing_days) && ($min_processing_days < 0)) {
            throw new \InvalidArgumentException('invalid value for $min_processing_days when calling ShopShippingProfile., must be bigger than or equal to 0.');
        }

        $this->container['min_processing_days'] = $min_processing_days;

        return $this;
    }

    /**
     * Gets max_processing_days
     *
     * @return int|null
     */
    public function getMaxProcessingDays()
    {
        return $this->container['max_processing_days'];
    }

    /**
     * Sets max_processing_days
     *
     * @param int|null $max_processing_days The maximum number of days for processing the listing.
     *
     * @return self
     */
    public function setMaxProcessingDays($max_processing_days)
    {
        if (is_null($max_processing_days)) {
            array_push($this->openAPINullablesSetToNull, 'max_processing_days');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('max_processing_days', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($max_processing_days) && ($max_processing_days < 0)) {
            throw new \InvalidArgumentException('invalid value for $max_processing_days when calling ShopShippingProfile., must be bigger than or equal to 0.');
        }

        $this->container['max_processing_days'] = $max_processing_days;

        return $this;
    }

    /**
     * Gets processing_days_display_label
     *
     * @return string|null
     */
    public function getProcessingDaysDisplayLabel()
    {
        return $this->container['processing_days_display_label'];
    }

    /**
     * Sets processing_days_display_label
     *
     * @param string|null $processing_days_display_label Translated display label string for processing days.
     *
     * @return self
     */
    public function setProcessingDaysDisplayLabel($processing_days_display_label)
    {
        if (is_null($processing_days_display_label)) {
            throw new \InvalidArgumentException('non-nullable processing_days_display_label cannot be null');
        }
        $this->container['processing_days_display_label'] = $processing_days_display_label;

        return $this;
    }

    /**
     * Gets origin_country_iso
     *
     * @return string|null
     */
    public function getOriginCountryIso()
    {
        return $this->container['origin_country_iso'];
    }

    /**
     * Sets origin_country_iso
     *
     * @param string|null $origin_country_iso The ISO code of the country from which the listing ships.
     *
     * @return self
     */
    public function setOriginCountryIso($origin_country_iso)
    {
        if (is_null($origin_country_iso)) {
            throw new \InvalidArgumentException('non-nullable origin_country_iso cannot be null');
        }
        $this->container['origin_country_iso'] = $origin_country_iso;

        return $this;
    }

    /**
     * Gets is_deleted
     *
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return $this->container['is_deleted'];
    }

    /**
     * Sets is_deleted
     *
     * @param bool|null $is_deleted When true, someone deleted this shipping profile.
     *
     * @return self
     */
    public function setIsDeleted($is_deleted)
    {
        if (is_null($is_deleted)) {
            throw new \InvalidArgumentException('non-nullable is_deleted cannot be null');
        }
        $this->container['is_deleted'] = $is_deleted;

        return $this;
    }

    /**
     * Gets shipping_profile_destinations
     *
     * @return \Etsy\Model\ShopShippingProfileShippingProfileDestinationsInner[]|null
     */
    public function getShippingProfileDestinations()
    {
        return $this->container['shipping_profile_destinations'];
    }

    /**
     * Sets shipping_profile_destinations
     *
     * @param \Etsy\Model\ShopShippingProfileShippingProfileDestinationsInner[]|null $shipping_profile_destinations A list of [shipping profile destinations](/documentation/reference/#operation/createShopShippingProfileDestination) available for this shipping profile.
     *
     * @return self
     */
    public function setShippingProfileDestinations($shipping_profile_destinations)
    {
        if (is_null($shipping_profile_destinations)) {
            throw new \InvalidArgumentException('non-nullable shipping_profile_destinations cannot be null');
        }
        $this->container['shipping_profile_destinations'] = $shipping_profile_destinations;

        return $this;
    }

    /**
     * Gets shipping_profile_upgrades
     *
     * @return \Etsy\Model\ShopShippingProfileShippingProfileUpgradesInner[]|null
     */
    public function getShippingProfileUpgrades()
    {
        return $this->container['shipping_profile_upgrades'];
    }

    /**
     * Sets shipping_profile_upgrades
     *
     * @param \Etsy\Model\ShopShippingProfileShippingProfileUpgradesInner[]|null $shipping_profile_upgrades A list of [shipping profile upgrades](/documentation/reference/#operation/createShopShippingProfileUpgrade) available for this shipping profile.
     *
     * @return self
     */
    public function setShippingProfileUpgrades($shipping_profile_upgrades)
    {
        if (is_null($shipping_profile_upgrades)) {
            throw new \InvalidArgumentException('non-nullable shipping_profile_upgrades cannot be null');
        }
        $this->container['shipping_profile_upgrades'] = $shipping_profile_upgrades;

        return $this;
    }

    /**
     * Gets origin_postal_code
     *
     * @return string|null
     */
    public function getOriginPostalCode()
    {
        return $this->container['origin_postal_code'];
    }

    /**
     * Sets origin_postal_code
     *
     * @param string|null $origin_postal_code The postal code string (not necessarily a number) for the location from which the listing ships. Required if the `origin_country_iso` is `US` or `CA`.
     *
     * @return self
     */
    public function setOriginPostalCode($origin_postal_code)
    {
        if (is_null($origin_postal_code)) {
            array_push($this->openAPINullablesSetToNull, 'origin_postal_code');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('origin_postal_code', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['origin_postal_code'] = $origin_postal_code;

        return $this;
    }

    /**
     * Gets profile_type
     *
     * @return string|null
     */
    public function getProfileType()
    {
        return $this->container['profile_type'];
    }

    /**
     * Sets profile_type
     *
     * @param string|null $profile_type profile_type
     *
     * @return self
     */
    public function setProfileType($profile_type)
    {
        if (is_null($profile_type)) {
            throw new \InvalidArgumentException('non-nullable profile_type cannot be null');
        }
        $allowedValues = $this->getProfileTypeAllowableValues();
        if (!in_array($profile_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'profile_type', must be one of '%s'",
                    $profile_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['profile_type'] = $profile_type;

        return $this;
    }

    /**
     * Gets domestic_handling_fee
     *
     * @return float|null
     */
    public function getDomesticHandlingFee()
    {
        return $this->container['domestic_handling_fee'];
    }

    /**
     * Sets domestic_handling_fee
     *
     * @param float|null $domestic_handling_fee The domestic handling fee added to buyer's shipping total - only available for calculated shipping profiles.
     *
     * @return self
     */
    public function setDomesticHandlingFee($domestic_handling_fee)
    {
        if (is_null($domestic_handling_fee)) {
            throw new \InvalidArgumentException('non-nullable domestic_handling_fee cannot be null');
        }

        if (($domestic_handling_fee < 0)) {
            throw new \InvalidArgumentException('invalid value for $domestic_handling_fee when calling ShopShippingProfile., must be bigger than or equal to 0.');
        }

        $this->container['domestic_handling_fee'] = $domestic_handling_fee;

        return $this;
    }

    /**
     * Gets international_handling_fee
     *
     * @return float|null
     */
    public function getInternationalHandlingFee()
    {
        return $this->container['international_handling_fee'];
    }

    /**
     * Sets international_handling_fee
     *
     * @param float|null $international_handling_fee The international handling fee added to buyer's shipping total - only available for calculated shipping profiles.
     *
     * @return self
     */
    public function setInternationalHandlingFee($international_handling_fee)
    {
        if (is_null($international_handling_fee)) {
            throw new \InvalidArgumentException('non-nullable international_handling_fee cannot be null');
        }

        if (($international_handling_fee < 0)) {
            throw new \InvalidArgumentException('invalid value for $international_handling_fee when calling ShopShippingProfile., must be bigger than or equal to 0.');
        }

        $this->container['international_handling_fee'] = $international_handling_fee;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


