<?php
/**
 * ShopReceiptsResultsInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ShopReceiptsResultsInner Class Doc Comment
 *
 * @category Class
 * @description List of Shop Receipt resources found, with all Shop Receipt fields for each resource.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShopReceiptsResultsInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShopReceipts_results_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'receipt_id' => 'int',
        'receipt_type' => 'int',
        'seller_user_id' => 'int',
        'seller_email' => 'string',
        'buyer_user_id' => 'int',
        'buyer_email' => 'string',
        'name' => 'string',
        'first_line' => 'string',
        'second_line' => 'string',
        'city' => 'string',
        'state' => 'string',
        'zip' => 'string',
        'status' => 'string',
        'formatted_address' => 'string',
        'country_iso' => 'string',
        'payment_method' => 'string',
        'payment_email' => 'string',
        'message_from_seller' => 'string',
        'message_from_buyer' => 'string',
        'message_from_payment' => 'string',
        'is_paid' => 'bool',
        'is_shipped' => 'bool',
        'create_timestamp' => 'int',
        'created_timestamp' => 'int',
        'update_timestamp' => 'int',
        'updated_timestamp' => 'int',
        'is_gift' => 'bool',
        'gift_message' => 'string',
        'grandtotal' => '\Etsy\Model\ShopReceiptGrandtotal',
        'subtotal' => '\Etsy\Model\ShopReceiptSubtotal',
        'total_price' => '\Etsy\Model\ShopReceiptTotalPrice',
        'total_shipping_cost' => '\Etsy\Model\ShopReceiptTotalShippingCost',
        'total_tax_cost' => '\Etsy\Model\ShopReceiptTotalTaxCost',
        'total_vat_cost' => '\Etsy\Model\ShopReceiptTotalVatCost',
        'discount_amt' => '\Etsy\Model\ShopReceiptDiscountAmt',
        'gift_wrap_price' => '\Etsy\Model\ShopReceiptGiftWrapPrice',
        'shipments' => '\Etsy\Model\ShopReceiptShipmentsInner[]',
        'transactions' => '\Etsy\Model\ShopReceiptTransactionsInner[]',
        'refunds' => '\Etsy\Model\ShopReceiptRefundsInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'receipt_id' => null,
        'receipt_type' => null,
        'seller_user_id' => null,
        'seller_email' => 'email',
        'buyer_user_id' => null,
        'buyer_email' => null,
        'name' => null,
        'first_line' => null,
        'second_line' => null,
        'city' => null,
        'state' => null,
        'zip' => null,
        'status' => null,
        'formatted_address' => null,
        'country_iso' => null,
        'payment_method' => null,
        'payment_email' => null,
        'message_from_seller' => null,
        'message_from_buyer' => null,
        'message_from_payment' => null,
        'is_paid' => null,
        'is_shipped' => null,
        'create_timestamp' => null,
        'created_timestamp' => null,
        'update_timestamp' => null,
        'updated_timestamp' => null,
        'is_gift' => null,
        'gift_message' => null,
        'grandtotal' => null,
        'subtotal' => null,
        'total_price' => null,
        'total_shipping_cost' => null,
        'total_tax_cost' => null,
        'total_vat_cost' => null,
        'discount_amt' => null,
        'gift_wrap_price' => null,
        'shipments' => null,
        'transactions' => null,
        'refunds' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'receipt_id' => false,
		'receipt_type' => false,
		'seller_user_id' => false,
		'seller_email' => true,
		'buyer_user_id' => false,
		'buyer_email' => true,
		'name' => false,
		'first_line' => false,
		'second_line' => true,
		'city' => false,
		'state' => true,
		'zip' => false,
		'status' => false,
		'formatted_address' => false,
		'country_iso' => false,
		'payment_method' => false,
		'payment_email' => false,
		'message_from_seller' => true,
		'message_from_buyer' => true,
		'message_from_payment' => true,
		'is_paid' => false,
		'is_shipped' => false,
		'create_timestamp' => false,
		'created_timestamp' => false,
		'update_timestamp' => false,
		'updated_timestamp' => false,
		'is_gift' => false,
		'gift_message' => false,
		'grandtotal' => false,
		'subtotal' => false,
		'total_price' => false,
		'total_shipping_cost' => false,
		'total_tax_cost' => false,
		'total_vat_cost' => false,
		'discount_amt' => false,
		'gift_wrap_price' => false,
		'shipments' => false,
		'transactions' => false,
		'refunds' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'receipt_id' => 'receipt_id',
        'receipt_type' => 'receipt_type',
        'seller_user_id' => 'seller_user_id',
        'seller_email' => 'seller_email',
        'buyer_user_id' => 'buyer_user_id',
        'buyer_email' => 'buyer_email',
        'name' => 'name',
        'first_line' => 'first_line',
        'second_line' => 'second_line',
        'city' => 'city',
        'state' => 'state',
        'zip' => 'zip',
        'status' => 'status',
        'formatted_address' => 'formatted_address',
        'country_iso' => 'country_iso',
        'payment_method' => 'payment_method',
        'payment_email' => 'payment_email',
        'message_from_seller' => 'message_from_seller',
        'message_from_buyer' => 'message_from_buyer',
        'message_from_payment' => 'message_from_payment',
        'is_paid' => 'is_paid',
        'is_shipped' => 'is_shipped',
        'create_timestamp' => 'create_timestamp',
        'created_timestamp' => 'created_timestamp',
        'update_timestamp' => 'update_timestamp',
        'updated_timestamp' => 'updated_timestamp',
        'is_gift' => 'is_gift',
        'gift_message' => 'gift_message',
        'grandtotal' => 'grandtotal',
        'subtotal' => 'subtotal',
        'total_price' => 'total_price',
        'total_shipping_cost' => 'total_shipping_cost',
        'total_tax_cost' => 'total_tax_cost',
        'total_vat_cost' => 'total_vat_cost',
        'discount_amt' => 'discount_amt',
        'gift_wrap_price' => 'gift_wrap_price',
        'shipments' => 'shipments',
        'transactions' => 'transactions',
        'refunds' => 'refunds'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'receipt_id' => 'setReceiptId',
        'receipt_type' => 'setReceiptType',
        'seller_user_id' => 'setSellerUserId',
        'seller_email' => 'setSellerEmail',
        'buyer_user_id' => 'setBuyerUserId',
        'buyer_email' => 'setBuyerEmail',
        'name' => 'setName',
        'first_line' => 'setFirstLine',
        'second_line' => 'setSecondLine',
        'city' => 'setCity',
        'state' => 'setState',
        'zip' => 'setZip',
        'status' => 'setStatus',
        'formatted_address' => 'setFormattedAddress',
        'country_iso' => 'setCountryIso',
        'payment_method' => 'setPaymentMethod',
        'payment_email' => 'setPaymentEmail',
        'message_from_seller' => 'setMessageFromSeller',
        'message_from_buyer' => 'setMessageFromBuyer',
        'message_from_payment' => 'setMessageFromPayment',
        'is_paid' => 'setIsPaid',
        'is_shipped' => 'setIsShipped',
        'create_timestamp' => 'setCreateTimestamp',
        'created_timestamp' => 'setCreatedTimestamp',
        'update_timestamp' => 'setUpdateTimestamp',
        'updated_timestamp' => 'setUpdatedTimestamp',
        'is_gift' => 'setIsGift',
        'gift_message' => 'setGiftMessage',
        'grandtotal' => 'setGrandtotal',
        'subtotal' => 'setSubtotal',
        'total_price' => 'setTotalPrice',
        'total_shipping_cost' => 'setTotalShippingCost',
        'total_tax_cost' => 'setTotalTaxCost',
        'total_vat_cost' => 'setTotalVatCost',
        'discount_amt' => 'setDiscountAmt',
        'gift_wrap_price' => 'setGiftWrapPrice',
        'shipments' => 'setShipments',
        'transactions' => 'setTransactions',
        'refunds' => 'setRefunds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'receipt_id' => 'getReceiptId',
        'receipt_type' => 'getReceiptType',
        'seller_user_id' => 'getSellerUserId',
        'seller_email' => 'getSellerEmail',
        'buyer_user_id' => 'getBuyerUserId',
        'buyer_email' => 'getBuyerEmail',
        'name' => 'getName',
        'first_line' => 'getFirstLine',
        'second_line' => 'getSecondLine',
        'city' => 'getCity',
        'state' => 'getState',
        'zip' => 'getZip',
        'status' => 'getStatus',
        'formatted_address' => 'getFormattedAddress',
        'country_iso' => 'getCountryIso',
        'payment_method' => 'getPaymentMethod',
        'payment_email' => 'getPaymentEmail',
        'message_from_seller' => 'getMessageFromSeller',
        'message_from_buyer' => 'getMessageFromBuyer',
        'message_from_payment' => 'getMessageFromPayment',
        'is_paid' => 'getIsPaid',
        'is_shipped' => 'getIsShipped',
        'create_timestamp' => 'getCreateTimestamp',
        'created_timestamp' => 'getCreatedTimestamp',
        'update_timestamp' => 'getUpdateTimestamp',
        'updated_timestamp' => 'getUpdatedTimestamp',
        'is_gift' => 'getIsGift',
        'gift_message' => 'getGiftMessage',
        'grandtotal' => 'getGrandtotal',
        'subtotal' => 'getSubtotal',
        'total_price' => 'getTotalPrice',
        'total_shipping_cost' => 'getTotalShippingCost',
        'total_tax_cost' => 'getTotalTaxCost',
        'total_vat_cost' => 'getTotalVatCost',
        'discount_amt' => 'getDiscountAmt',
        'gift_wrap_price' => 'getGiftWrapPrice',
        'shipments' => 'getShipments',
        'transactions' => 'getTransactions',
        'refunds' => 'getRefunds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STATUS_PAID = 'paid';
    public const STATUS_COMPLETED = 'completed';
    public const STATUS_OPEN = 'open';
    public const STATUS_PAYMENT_PROCESSING = 'payment processing';
    public const STATUS_CANCELED = 'canceled';
    public const STATUS_FULLY_REFUNDED = 'fully refunded';
    public const STATUS_PARTIALLY_REFUNDED = 'partially refunded';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_PAID,
            self::STATUS_COMPLETED,
            self::STATUS_OPEN,
            self::STATUS_PAYMENT_PROCESSING,
            self::STATUS_CANCELED,
            self::STATUS_FULLY_REFUNDED,
            self::STATUS_PARTIALLY_REFUNDED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('receipt_id', $data ?? [], null);
        $this->setIfExists('receipt_type', $data ?? [], null);
        $this->setIfExists('seller_user_id', $data ?? [], null);
        $this->setIfExists('seller_email', $data ?? [], null);
        $this->setIfExists('buyer_user_id', $data ?? [], null);
        $this->setIfExists('buyer_email', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('first_line', $data ?? [], null);
        $this->setIfExists('second_line', $data ?? [], null);
        $this->setIfExists('city', $data ?? [], null);
        $this->setIfExists('state', $data ?? [], null);
        $this->setIfExists('zip', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('formatted_address', $data ?? [], null);
        $this->setIfExists('country_iso', $data ?? [], null);
        $this->setIfExists('payment_method', $data ?? [], null);
        $this->setIfExists('payment_email', $data ?? [], null);
        $this->setIfExists('message_from_seller', $data ?? [], null);
        $this->setIfExists('message_from_buyer', $data ?? [], null);
        $this->setIfExists('message_from_payment', $data ?? [], null);
        $this->setIfExists('is_paid', $data ?? [], null);
        $this->setIfExists('is_shipped', $data ?? [], null);
        $this->setIfExists('create_timestamp', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('update_timestamp', $data ?? [], null);
        $this->setIfExists('updated_timestamp', $data ?? [], null);
        $this->setIfExists('is_gift', $data ?? [], null);
        $this->setIfExists('gift_message', $data ?? [], null);
        $this->setIfExists('grandtotal', $data ?? [], null);
        $this->setIfExists('subtotal', $data ?? [], null);
        $this->setIfExists('total_price', $data ?? [], null);
        $this->setIfExists('total_shipping_cost', $data ?? [], null);
        $this->setIfExists('total_tax_cost', $data ?? [], null);
        $this->setIfExists('total_vat_cost', $data ?? [], null);
        $this->setIfExists('discount_amt', $data ?? [], null);
        $this->setIfExists('gift_wrap_price', $data ?? [], null);
        $this->setIfExists('shipments', $data ?? [], null);
        $this->setIfExists('transactions', $data ?? [], null);
        $this->setIfExists('refunds', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['receipt_id']) && ($this->container['receipt_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'receipt_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['receipt_type']) && ($this->container['receipt_type'] < 0)) {
            $invalidProperties[] = "invalid value for 'receipt_type', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['seller_user_id']) && ($this->container['seller_user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'seller_user_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['buyer_user_id']) && ($this->container['buyer_user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'buyer_user_id', must be bigger than or equal to 1.";
        }

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['create_timestamp']) && ($this->container['create_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'create_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['update_timestamp']) && ($this->container['update_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'update_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['updated_timestamp']) && ($this->container['updated_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'updated_timestamp', must be bigger than or equal to 946684800.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets receipt_id
     *
     * @return int|null
     */
    public function getReceiptId()
    {
        return $this->container['receipt_id'];
    }

    /**
     * Sets receipt_id
     *
     * @param int|null $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction.
     *
     * @return self
     */
    public function setReceiptId($receipt_id)
    {
        if (is_null($receipt_id)) {
            throw new \InvalidArgumentException('non-nullable receipt_id cannot be null');
        }

        if (($receipt_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $receipt_id when calling ShopReceiptsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['receipt_id'] = $receipt_id;

        return $this;
    }

    /**
     * Gets receipt_type
     *
     * @return int|null
     */
    public function getReceiptType()
    {
        return $this->container['receipt_type'];
    }

    /**
     * Sets receipt_type
     *
     * @param int|null $receipt_type The numeric value for the Etsy channel that serviced the purchase: 0 for Etsy.com, 1 for a Pattern shop.
     *
     * @return self
     */
    public function setReceiptType($receipt_type)
    {
        if (is_null($receipt_type)) {
            throw new \InvalidArgumentException('non-nullable receipt_type cannot be null');
        }

        if (($receipt_type < 0)) {
            throw new \InvalidArgumentException('invalid value for $receipt_type when calling ShopReceiptsResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['receipt_type'] = $receipt_type;

        return $this;
    }

    /**
     * Gets seller_user_id
     *
     * @return int|null
     */
    public function getSellerUserId()
    {
        return $this->container['seller_user_id'];
    }

    /**
     * Sets seller_user_id
     *
     * @param int|null $seller_user_id The numeric ID for the [user](/documentation/reference#tag/User) (seller) fulfilling the purchase.
     *
     * @return self
     */
    public function setSellerUserId($seller_user_id)
    {
        if (is_null($seller_user_id)) {
            throw new \InvalidArgumentException('non-nullable seller_user_id cannot be null');
        }

        if (($seller_user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $seller_user_id when calling ShopReceiptsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['seller_user_id'] = $seller_user_id;

        return $this;
    }

    /**
     * Gets seller_email
     *
     * @return string|null
     */
    public function getSellerEmail()
    {
        return $this->container['seller_email'];
    }

    /**
     * Sets seller_email
     *
     * @param string|null $seller_email The email address string for the seller of the listing.
     *
     * @return self
     */
    public function setSellerEmail($seller_email)
    {
        if (is_null($seller_email)) {
            array_push($this->openAPINullablesSetToNull, 'seller_email');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('seller_email', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['seller_email'] = $seller_email;

        return $this;
    }

    /**
     * Gets buyer_user_id
     *
     * @return int|null
     */
    public function getBuyerUserId()
    {
        return $this->container['buyer_user_id'];
    }

    /**
     * Sets buyer_user_id
     *
     * @param int|null $buyer_user_id The numeric ID for the [user](/documentation/reference#tag/User) making the purchase.
     *
     * @return self
     */
    public function setBuyerUserId($buyer_user_id)
    {
        if (is_null($buyer_user_id)) {
            throw new \InvalidArgumentException('non-nullable buyer_user_id cannot be null');
        }

        if (($buyer_user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $buyer_user_id when calling ShopReceiptsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['buyer_user_id'] = $buyer_user_id;

        return $this;
    }

    /**
     * Gets buyer_email
     *
     * @return string|null
     */
    public function getBuyerEmail()
    {
        return $this->container['buyer_email'];
    }

    /**
     * Sets buyer_email
     *
     * @param string|null $buyer_email The email address string for the buyer of the listing.
     *
     * @return self
     */
    public function setBuyerEmail($buyer_email)
    {
        if (is_null($buyer_email)) {
            array_push($this->openAPINullablesSetToNull, 'buyer_email');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('buyer_email', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['buyer_email'] = $buyer_email;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name string for the recipient in the shipping address.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets first_line
     *
     * @return string|null
     */
    public function getFirstLine()
    {
        return $this->container['first_line'];
    }

    /**
     * Sets first_line
     *
     * @param string|null $first_line The first address line string for the recipient in the shipping address.
     *
     * @return self
     */
    public function setFirstLine($first_line)
    {
        if (is_null($first_line)) {
            throw new \InvalidArgumentException('non-nullable first_line cannot be null');
        }
        $this->container['first_line'] = $first_line;

        return $this;
    }

    /**
     * Gets second_line
     *
     * @return string|null
     */
    public function getSecondLine()
    {
        return $this->container['second_line'];
    }

    /**
     * Sets second_line
     *
     * @param string|null $second_line The optional second address line string for the recipient in the shipping address.
     *
     * @return self
     */
    public function setSecondLine($second_line)
    {
        if (is_null($second_line)) {
            array_push($this->openAPINullablesSetToNull, 'second_line');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('second_line', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['second_line'] = $second_line;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city The city string for the recipient in the shipping address.
     *
     * @return self
     */
    public function setCity($city)
    {
        if (is_null($city)) {
            throw new \InvalidArgumentException('non-nullable city cannot be null');
        }
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets state
     *
     * @return string|null
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     *
     * @param string|null $state The state string for the recipient in the shipping address.
     *
     * @return self
     */
    public function setState($state)
    {
        if (is_null($state)) {
            array_push($this->openAPINullablesSetToNull, 'state');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('state', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets zip
     *
     * @return string|null
     */
    public function getZip()
    {
        return $this->container['zip'];
    }

    /**
     * Sets zip
     *
     * @param string|null $zip The zip code string (not necessarily a number) for the recipient in the shipping address.
     *
     * @return self
     */
    public function setZip($zip)
    {
        if (is_null($zip)) {
            throw new \InvalidArgumentException('non-nullable zip cannot be null');
        }
        $this->container['zip'] = $zip;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The current order status string. One of: `paid`, `completed`, `open`, `payment processing` or `canceled`.
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $allowedValues = $this->getStatusAllowableValues();
        if (!in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets formatted_address
     *
     * @return string|null
     */
    public function getFormattedAddress()
    {
        return $this->container['formatted_address'];
    }

    /**
     * Sets formatted_address
     *
     * @param string|null $formatted_address The formatted shipping address string for the recipient in the shipping address.
     *
     * @return self
     */
    public function setFormattedAddress($formatted_address)
    {
        if (is_null($formatted_address)) {
            throw new \InvalidArgumentException('non-nullable formatted_address cannot be null');
        }
        $this->container['formatted_address'] = $formatted_address;

        return $this;
    }

    /**
     * Gets country_iso
     *
     * @return string|null
     */
    public function getCountryIso()
    {
        return $this->container['country_iso'];
    }

    /**
     * Sets country_iso
     *
     * @param string|null $country_iso The ISO-3166 alpha-2 country code string for the recipient in the shipping address.
     *
     * @return self
     */
    public function setCountryIso($country_iso)
    {
        if (is_null($country_iso)) {
            throw new \InvalidArgumentException('non-nullable country_iso cannot be null');
        }
        $this->container['country_iso'] = $country_iso;

        return $this;
    }

    /**
     * Gets payment_method
     *
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     *
     * @param string|null $payment_method The payment method string identifying purchaser's payment method, which must be one of: \\'cc\\' (credit card), \\'paypal\\', \\'check\\', \\'mo\\' (money order), \\'bt\\' (bank transfer), \\'other\\', \\'ideal\\', \\'sofort\\', \\'apple_pay\\', \\'google\\', \\'android_pay\\', \\'google_pay\\', \\'klarna\\', \\'k_pay_in_4\\' (klarna), \\'k_pay_in_3\\' (klarna), or \\'k_financing\\' (klarna).
     *
     * @return self
     */
    public function setPaymentMethod($payment_method)
    {
        if (is_null($payment_method)) {
            throw new \InvalidArgumentException('non-nullable payment_method cannot be null');
        }
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets payment_email
     *
     * @return string|null
     */
    public function getPaymentEmail()
    {
        return $this->container['payment_email'];
    }

    /**
     * Sets payment_email
     *
     * @param string|null $payment_email The email address string for the email address to which to send payment confirmation
     *
     * @return self
     */
    public function setPaymentEmail($payment_email)
    {
        if (is_null($payment_email)) {
            throw new \InvalidArgumentException('non-nullable payment_email cannot be null');
        }
        $this->container['payment_email'] = $payment_email;

        return $this;
    }

    /**
     * Gets message_from_seller
     *
     * @return string|null
     */
    public function getMessageFromSeller()
    {
        return $this->container['message_from_seller'];
    }

    /**
     * Sets message_from_seller
     *
     * @param string|null $message_from_seller An optional message string from the seller.
     *
     * @return self
     */
    public function setMessageFromSeller($message_from_seller)
    {
        if (is_null($message_from_seller)) {
            array_push($this->openAPINullablesSetToNull, 'message_from_seller');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('message_from_seller', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['message_from_seller'] = $message_from_seller;

        return $this;
    }

    /**
     * Gets message_from_buyer
     *
     * @return string|null
     */
    public function getMessageFromBuyer()
    {
        return $this->container['message_from_buyer'];
    }

    /**
     * Sets message_from_buyer
     *
     * @param string|null $message_from_buyer An optional message string from the buyer.
     *
     * @return self
     */
    public function setMessageFromBuyer($message_from_buyer)
    {
        if (is_null($message_from_buyer)) {
            array_push($this->openAPINullablesSetToNull, 'message_from_buyer');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('message_from_buyer', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['message_from_buyer'] = $message_from_buyer;

        return $this;
    }

    /**
     * Gets message_from_payment
     *
     * @return string|null
     */
    public function getMessageFromPayment()
    {
        return $this->container['message_from_payment'];
    }

    /**
     * Sets message_from_payment
     *
     * @param string|null $message_from_payment The machine-generated acknowledgement string from the payment system.
     *
     * @return self
     */
    public function setMessageFromPayment($message_from_payment)
    {
        if (is_null($message_from_payment)) {
            array_push($this->openAPINullablesSetToNull, 'message_from_payment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('message_from_payment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['message_from_payment'] = $message_from_payment;

        return $this;
    }

    /**
     * Gets is_paid
     *
     * @return bool|null
     */
    public function getIsPaid()
    {
        return $this->container['is_paid'];
    }

    /**
     * Sets is_paid
     *
     * @param bool|null $is_paid When true, buyer paid for this purchase.
     *
     * @return self
     */
    public function setIsPaid($is_paid)
    {
        if (is_null($is_paid)) {
            throw new \InvalidArgumentException('non-nullable is_paid cannot be null');
        }
        $this->container['is_paid'] = $is_paid;

        return $this;
    }

    /**
     * Gets is_shipped
     *
     * @return bool|null
     */
    public function getIsShipped()
    {
        return $this->container['is_shipped'];
    }

    /**
     * Sets is_shipped
     *
     * @param bool|null $is_shipped When true, seller shipped the products.
     *
     * @return self
     */
    public function setIsShipped($is_shipped)
    {
        if (is_null($is_shipped)) {
            throw new \InvalidArgumentException('non-nullable is_shipped cannot be null');
        }
        $this->container['is_shipped'] = $is_shipped;

        return $this;
    }

    /**
     * Gets create_timestamp
     *
     * @return int|null
     */
    public function getCreateTimestamp()
    {
        return $this->container['create_timestamp'];
    }

    /**
     * Sets create_timestamp
     *
     * @param int|null $create_timestamp The receipt\\'s creation time, in epoch seconds.
     *
     * @return self
     */
    public function setCreateTimestamp($create_timestamp)
    {
        if (is_null($create_timestamp)) {
            throw new \InvalidArgumentException('non-nullable create_timestamp cannot be null');
        }

        if (($create_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $create_timestamp when calling ShopReceiptsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['create_timestamp'] = $create_timestamp;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The receipt\\'s creation time, in epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling ShopReceiptsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets update_timestamp
     *
     * @return int|null
     */
    public function getUpdateTimestamp()
    {
        return $this->container['update_timestamp'];
    }

    /**
     * Sets update_timestamp
     *
     * @param int|null $update_timestamp The time of the last update to the receipt, in epoch seconds.
     *
     * @return self
     */
    public function setUpdateTimestamp($update_timestamp)
    {
        if (is_null($update_timestamp)) {
            throw new \InvalidArgumentException('non-nullable update_timestamp cannot be null');
        }

        if (($update_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $update_timestamp when calling ShopReceiptsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['update_timestamp'] = $update_timestamp;

        return $this;
    }

    /**
     * Gets updated_timestamp
     *
     * @return int|null
     */
    public function getUpdatedTimestamp()
    {
        return $this->container['updated_timestamp'];
    }

    /**
     * Sets updated_timestamp
     *
     * @param int|null $updated_timestamp The time of the last update to the receipt, in epoch seconds.
     *
     * @return self
     */
    public function setUpdatedTimestamp($updated_timestamp)
    {
        if (is_null($updated_timestamp)) {
            throw new \InvalidArgumentException('non-nullable updated_timestamp cannot be null');
        }

        if (($updated_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $updated_timestamp when calling ShopReceiptsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['updated_timestamp'] = $updated_timestamp;

        return $this;
    }

    /**
     * Gets is_gift
     *
     * @return bool|null
     */
    public function getIsGift()
    {
        return $this->container['is_gift'];
    }

    /**
     * Sets is_gift
     *
     * @param bool|null $is_gift When true, the buyer indicated this purchase is a gift.
     *
     * @return self
     */
    public function setIsGift($is_gift)
    {
        if (is_null($is_gift)) {
            throw new \InvalidArgumentException('non-nullable is_gift cannot be null');
        }
        $this->container['is_gift'] = $is_gift;

        return $this;
    }

    /**
     * Gets gift_message
     *
     * @return string|null
     */
    public function getGiftMessage()
    {
        return $this->container['gift_message'];
    }

    /**
     * Sets gift_message
     *
     * @param string|null $gift_message A gift message string the buyer requests delivered with the product.
     *
     * @return self
     */
    public function setGiftMessage($gift_message)
    {
        if (is_null($gift_message)) {
            throw new \InvalidArgumentException('non-nullable gift_message cannot be null');
        }
        $this->container['gift_message'] = $gift_message;

        return $this;
    }

    /**
     * Gets grandtotal
     *
     * @return \Etsy\Model\ShopReceiptGrandtotal|null
     */
    public function getGrandtotal()
    {
        return $this->container['grandtotal'];
    }

    /**
     * Sets grandtotal
     *
     * @param \Etsy\Model\ShopReceiptGrandtotal|null $grandtotal grandtotal
     *
     * @return self
     */
    public function setGrandtotal($grandtotal)
    {
        if (is_null($grandtotal)) {
            throw new \InvalidArgumentException('non-nullable grandtotal cannot be null');
        }
        $this->container['grandtotal'] = $grandtotal;

        return $this;
    }

    /**
     * Gets subtotal
     *
     * @return \Etsy\Model\ShopReceiptSubtotal|null
     */
    public function getSubtotal()
    {
        return $this->container['subtotal'];
    }

    /**
     * Sets subtotal
     *
     * @param \Etsy\Model\ShopReceiptSubtotal|null $subtotal subtotal
     *
     * @return self
     */
    public function setSubtotal($subtotal)
    {
        if (is_null($subtotal)) {
            throw new \InvalidArgumentException('non-nullable subtotal cannot be null');
        }
        $this->container['subtotal'] = $subtotal;

        return $this;
    }

    /**
     * Gets total_price
     *
     * @return \Etsy\Model\ShopReceiptTotalPrice|null
     */
    public function getTotalPrice()
    {
        return $this->container['total_price'];
    }

    /**
     * Sets total_price
     *
     * @param \Etsy\Model\ShopReceiptTotalPrice|null $total_price total_price
     *
     * @return self
     */
    public function setTotalPrice($total_price)
    {
        if (is_null($total_price)) {
            throw new \InvalidArgumentException('non-nullable total_price cannot be null');
        }
        $this->container['total_price'] = $total_price;

        return $this;
    }

    /**
     * Gets total_shipping_cost
     *
     * @return \Etsy\Model\ShopReceiptTotalShippingCost|null
     */
    public function getTotalShippingCost()
    {
        return $this->container['total_shipping_cost'];
    }

    /**
     * Sets total_shipping_cost
     *
     * @param \Etsy\Model\ShopReceiptTotalShippingCost|null $total_shipping_cost total_shipping_cost
     *
     * @return self
     */
    public function setTotalShippingCost($total_shipping_cost)
    {
        if (is_null($total_shipping_cost)) {
            throw new \InvalidArgumentException('non-nullable total_shipping_cost cannot be null');
        }
        $this->container['total_shipping_cost'] = $total_shipping_cost;

        return $this;
    }

    /**
     * Gets total_tax_cost
     *
     * @return \Etsy\Model\ShopReceiptTotalTaxCost|null
     */
    public function getTotalTaxCost()
    {
        return $this->container['total_tax_cost'];
    }

    /**
     * Sets total_tax_cost
     *
     * @param \Etsy\Model\ShopReceiptTotalTaxCost|null $total_tax_cost total_tax_cost
     *
     * @return self
     */
    public function setTotalTaxCost($total_tax_cost)
    {
        if (is_null($total_tax_cost)) {
            throw new \InvalidArgumentException('non-nullable total_tax_cost cannot be null');
        }
        $this->container['total_tax_cost'] = $total_tax_cost;

        return $this;
    }

    /**
     * Gets total_vat_cost
     *
     * @return \Etsy\Model\ShopReceiptTotalVatCost|null
     */
    public function getTotalVatCost()
    {
        return $this->container['total_vat_cost'];
    }

    /**
     * Sets total_vat_cost
     *
     * @param \Etsy\Model\ShopReceiptTotalVatCost|null $total_vat_cost total_vat_cost
     *
     * @return self
     */
    public function setTotalVatCost($total_vat_cost)
    {
        if (is_null($total_vat_cost)) {
            throw new \InvalidArgumentException('non-nullable total_vat_cost cannot be null');
        }
        $this->container['total_vat_cost'] = $total_vat_cost;

        return $this;
    }

    /**
     * Gets discount_amt
     *
     * @return \Etsy\Model\ShopReceiptDiscountAmt|null
     */
    public function getDiscountAmt()
    {
        return $this->container['discount_amt'];
    }

    /**
     * Sets discount_amt
     *
     * @param \Etsy\Model\ShopReceiptDiscountAmt|null $discount_amt discount_amt
     *
     * @return self
     */
    public function setDiscountAmt($discount_amt)
    {
        if (is_null($discount_amt)) {
            throw new \InvalidArgumentException('non-nullable discount_amt cannot be null');
        }
        $this->container['discount_amt'] = $discount_amt;

        return $this;
    }

    /**
     * Gets gift_wrap_price
     *
     * @return \Etsy\Model\ShopReceiptGiftWrapPrice|null
     */
    public function getGiftWrapPrice()
    {
        return $this->container['gift_wrap_price'];
    }

    /**
     * Sets gift_wrap_price
     *
     * @param \Etsy\Model\ShopReceiptGiftWrapPrice|null $gift_wrap_price gift_wrap_price
     *
     * @return self
     */
    public function setGiftWrapPrice($gift_wrap_price)
    {
        if (is_null($gift_wrap_price)) {
            throw new \InvalidArgumentException('non-nullable gift_wrap_price cannot be null');
        }
        $this->container['gift_wrap_price'] = $gift_wrap_price;

        return $this;
    }

    /**
     * Gets shipments
     *
     * @return \Etsy\Model\ShopReceiptShipmentsInner[]|null
     */
    public function getShipments()
    {
        return $this->container['shipments'];
    }

    /**
     * Sets shipments
     *
     * @param \Etsy\Model\ShopReceiptShipmentsInner[]|null $shipments A list of shipment statements for this receipt.
     *
     * @return self
     */
    public function setShipments($shipments)
    {
        if (is_null($shipments)) {
            throw new \InvalidArgumentException('non-nullable shipments cannot be null');
        }
        $this->container['shipments'] = $shipments;

        return $this;
    }

    /**
     * Gets transactions
     *
     * @return \Etsy\Model\ShopReceiptTransactionsInner[]|null
     */
    public function getTransactions()
    {
        return $this->container['transactions'];
    }

    /**
     * Sets transactions
     *
     * @param \Etsy\Model\ShopReceiptTransactionsInner[]|null $transactions Array of transactions for the receipt.
     *
     * @return self
     */
    public function setTransactions($transactions)
    {
        if (is_null($transactions)) {
            throw new \InvalidArgumentException('non-nullable transactions cannot be null');
        }
        $this->container['transactions'] = $transactions;

        return $this;
    }

    /**
     * Gets refunds
     *
     * @return \Etsy\Model\ShopReceiptRefundsInner[]|null
     */
    public function getRefunds()
    {
        return $this->container['refunds'];
    }

    /**
     * Sets refunds
     *
     * @param \Etsy\Model\ShopReceiptRefundsInner[]|null $refunds Refunds for a given receipt.
     *
     * @return self
     */
    public function setRefunds($refunds)
    {
        if (is_null($refunds)) {
            throw new \InvalidArgumentException('non-nullable refunds cannot be null');
        }
        $this->container['refunds'] = $refunds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


