<?php
/**
 * ShopReceiptTransactionsResultsInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ShopReceiptTransactionsResultsInner Class Doc Comment
 *
 * @category Class
 * @description The ShopReceiptTransaction resources found.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShopReceiptTransactionsResultsInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShopReceiptTransactions_results_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transaction_id' => 'int',
        'title' => 'string',
        'description' => 'string',
        'seller_user_id' => 'int',
        'buyer_user_id' => 'int',
        'create_timestamp' => 'int',
        'created_timestamp' => 'int',
        'paid_timestamp' => 'int',
        'shipped_timestamp' => 'int',
        'quantity' => 'int',
        'listing_image_id' => 'int',
        'receipt_id' => 'int',
        'is_digital' => 'bool',
        'file_data' => 'string',
        'listing_id' => 'int',
        'transaction_type' => 'string',
        'product_id' => 'int',
        'sku' => 'string',
        'price' => '\Etsy\Model\ShopReceiptTransactionPrice',
        'shipping_cost' => '\Etsy\Model\ShopReceiptTransactionShippingCost',
        'variations' => '\Etsy\Model\ShopReceiptTransactionVariationsInner[]',
        'product_data' => '\Etsy\Model\ListingInventoryProductPropertyValuesInner[]',
        'shipping_profile_id' => 'int',
        'min_processing_days' => 'int',
        'max_processing_days' => 'int',
        'shipping_method' => 'string',
        'shipping_upgrade' => 'string',
        'expected_ship_date' => 'int',
        'buyer_coupon' => 'float',
        'shop_coupon' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transaction_id' => null,
        'title' => null,
        'description' => null,
        'seller_user_id' => null,
        'buyer_user_id' => null,
        'create_timestamp' => null,
        'created_timestamp' => null,
        'paid_timestamp' => null,
        'shipped_timestamp' => null,
        'quantity' => null,
        'listing_image_id' => null,
        'receipt_id' => null,
        'is_digital' => null,
        'file_data' => null,
        'listing_id' => null,
        'transaction_type' => null,
        'product_id' => null,
        'sku' => null,
        'price' => null,
        'shipping_cost' => null,
        'variations' => null,
        'product_data' => null,
        'shipping_profile_id' => null,
        'min_processing_days' => null,
        'max_processing_days' => null,
        'shipping_method' => null,
        'shipping_upgrade' => null,
        'expected_ship_date' => null,
        'buyer_coupon' => 'float',
        'shop_coupon' => 'float'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'transaction_id' => false,
		'title' => true,
		'description' => true,
		'seller_user_id' => false,
		'buyer_user_id' => false,
		'create_timestamp' => false,
		'created_timestamp' => false,
		'paid_timestamp' => true,
		'shipped_timestamp' => true,
		'quantity' => false,
		'listing_image_id' => true,
		'receipt_id' => false,
		'is_digital' => false,
		'file_data' => false,
		'listing_id' => true,
		'transaction_type' => false,
		'product_id' => true,
		'sku' => true,
		'price' => false,
		'shipping_cost' => false,
		'variations' => false,
		'product_data' => false,
		'shipping_profile_id' => true,
		'min_processing_days' => true,
		'max_processing_days' => true,
		'shipping_method' => true,
		'shipping_upgrade' => true,
		'expected_ship_date' => true,
		'buyer_coupon' => false,
		'shop_coupon' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transaction_id' => 'transaction_id',
        'title' => 'title',
        'description' => 'description',
        'seller_user_id' => 'seller_user_id',
        'buyer_user_id' => 'buyer_user_id',
        'create_timestamp' => 'create_timestamp',
        'created_timestamp' => 'created_timestamp',
        'paid_timestamp' => 'paid_timestamp',
        'shipped_timestamp' => 'shipped_timestamp',
        'quantity' => 'quantity',
        'listing_image_id' => 'listing_image_id',
        'receipt_id' => 'receipt_id',
        'is_digital' => 'is_digital',
        'file_data' => 'file_data',
        'listing_id' => 'listing_id',
        'transaction_type' => 'transaction_type',
        'product_id' => 'product_id',
        'sku' => 'sku',
        'price' => 'price',
        'shipping_cost' => 'shipping_cost',
        'variations' => 'variations',
        'product_data' => 'product_data',
        'shipping_profile_id' => 'shipping_profile_id',
        'min_processing_days' => 'min_processing_days',
        'max_processing_days' => 'max_processing_days',
        'shipping_method' => 'shipping_method',
        'shipping_upgrade' => 'shipping_upgrade',
        'expected_ship_date' => 'expected_ship_date',
        'buyer_coupon' => 'buyer_coupon',
        'shop_coupon' => 'shop_coupon'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transaction_id' => 'setTransactionId',
        'title' => 'setTitle',
        'description' => 'setDescription',
        'seller_user_id' => 'setSellerUserId',
        'buyer_user_id' => 'setBuyerUserId',
        'create_timestamp' => 'setCreateTimestamp',
        'created_timestamp' => 'setCreatedTimestamp',
        'paid_timestamp' => 'setPaidTimestamp',
        'shipped_timestamp' => 'setShippedTimestamp',
        'quantity' => 'setQuantity',
        'listing_image_id' => 'setListingImageId',
        'receipt_id' => 'setReceiptId',
        'is_digital' => 'setIsDigital',
        'file_data' => 'setFileData',
        'listing_id' => 'setListingId',
        'transaction_type' => 'setTransactionType',
        'product_id' => 'setProductId',
        'sku' => 'setSku',
        'price' => 'setPrice',
        'shipping_cost' => 'setShippingCost',
        'variations' => 'setVariations',
        'product_data' => 'setProductData',
        'shipping_profile_id' => 'setShippingProfileId',
        'min_processing_days' => 'setMinProcessingDays',
        'max_processing_days' => 'setMaxProcessingDays',
        'shipping_method' => 'setShippingMethod',
        'shipping_upgrade' => 'setShippingUpgrade',
        'expected_ship_date' => 'setExpectedShipDate',
        'buyer_coupon' => 'setBuyerCoupon',
        'shop_coupon' => 'setShopCoupon'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transaction_id' => 'getTransactionId',
        'title' => 'getTitle',
        'description' => 'getDescription',
        'seller_user_id' => 'getSellerUserId',
        'buyer_user_id' => 'getBuyerUserId',
        'create_timestamp' => 'getCreateTimestamp',
        'created_timestamp' => 'getCreatedTimestamp',
        'paid_timestamp' => 'getPaidTimestamp',
        'shipped_timestamp' => 'getShippedTimestamp',
        'quantity' => 'getQuantity',
        'listing_image_id' => 'getListingImageId',
        'receipt_id' => 'getReceiptId',
        'is_digital' => 'getIsDigital',
        'file_data' => 'getFileData',
        'listing_id' => 'getListingId',
        'transaction_type' => 'getTransactionType',
        'product_id' => 'getProductId',
        'sku' => 'getSku',
        'price' => 'getPrice',
        'shipping_cost' => 'getShippingCost',
        'variations' => 'getVariations',
        'product_data' => 'getProductData',
        'shipping_profile_id' => 'getShippingProfileId',
        'min_processing_days' => 'getMinProcessingDays',
        'max_processing_days' => 'getMaxProcessingDays',
        'shipping_method' => 'getShippingMethod',
        'shipping_upgrade' => 'getShippingUpgrade',
        'expected_ship_date' => 'getExpectedShipDate',
        'buyer_coupon' => 'getBuyerCoupon',
        'shop_coupon' => 'getShopCoupon'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('transaction_id', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('seller_user_id', $data ?? [], null);
        $this->setIfExists('buyer_user_id', $data ?? [], null);
        $this->setIfExists('create_timestamp', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('paid_timestamp', $data ?? [], null);
        $this->setIfExists('shipped_timestamp', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('listing_image_id', $data ?? [], null);
        $this->setIfExists('receipt_id', $data ?? [], null);
        $this->setIfExists('is_digital', $data ?? [], null);
        $this->setIfExists('file_data', $data ?? [], null);
        $this->setIfExists('listing_id', $data ?? [], null);
        $this->setIfExists('transaction_type', $data ?? [], null);
        $this->setIfExists('product_id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('shipping_cost', $data ?? [], null);
        $this->setIfExists('variations', $data ?? [], null);
        $this->setIfExists('product_data', $data ?? [], null);
        $this->setIfExists('shipping_profile_id', $data ?? [], null);
        $this->setIfExists('min_processing_days', $data ?? [], null);
        $this->setIfExists('max_processing_days', $data ?? [], null);
        $this->setIfExists('shipping_method', $data ?? [], null);
        $this->setIfExists('shipping_upgrade', $data ?? [], null);
        $this->setIfExists('expected_ship_date', $data ?? [], null);
        $this->setIfExists('buyer_coupon', $data ?? [], 0);
        $this->setIfExists('shop_coupon', $data ?? [], 0);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['transaction_id']) && ($this->container['transaction_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'transaction_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['seller_user_id']) && ($this->container['seller_user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'seller_user_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['buyer_user_id']) && ($this->container['buyer_user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'buyer_user_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['create_timestamp']) && ($this->container['create_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'create_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['paid_timestamp']) && ($this->container['paid_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'paid_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['shipped_timestamp']) && ($this->container['shipped_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'shipped_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['quantity']) && ($this->container['quantity'] < 0)) {
            $invalidProperties[] = "invalid value for 'quantity', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['listing_image_id']) && ($this->container['listing_image_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'listing_image_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['receipt_id']) && ($this->container['receipt_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'receipt_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['listing_id']) && ($this->container['listing_id'] < 0)) {
            $invalidProperties[] = "invalid value for 'listing_id', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['product_id']) && ($this->container['product_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'product_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['shipping_profile_id']) && ($this->container['shipping_profile_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shipping_profile_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['min_processing_days']) && ($this->container['min_processing_days'] < 1)) {
            $invalidProperties[] = "invalid value for 'min_processing_days', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['max_processing_days']) && ($this->container['max_processing_days'] < 1)) {
            $invalidProperties[] = "invalid value for 'max_processing_days', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['expected_ship_date']) && ($this->container['expected_ship_date'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'expected_ship_date', must be bigger than or equal to 946684800.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transaction_id
     *
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param int|null $transaction_id The unique numeric ID for a transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        if (is_null($transaction_id)) {
            throw new \InvalidArgumentException('non-nullable transaction_id cannot be null');
        }

        if (($transaction_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $transaction_id when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title The title string of the [listing](/documentation/reference#tag/ShopListing) purchased in this transaction.
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            array_push($this->openAPINullablesSetToNull, 'title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('title', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The description string of the [listing](/documentation/reference#tag/ShopListing) purchased in this transaction.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets seller_user_id
     *
     * @return int|null
     */
    public function getSellerUserId()
    {
        return $this->container['seller_user_id'];
    }

    /**
     * Sets seller_user_id
     *
     * @param int|null $seller_user_id The numeric user ID for the seller in this transaction.
     *
     * @return self
     */
    public function setSellerUserId($seller_user_id)
    {
        if (is_null($seller_user_id)) {
            throw new \InvalidArgumentException('non-nullable seller_user_id cannot be null');
        }

        if (($seller_user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $seller_user_id when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['seller_user_id'] = $seller_user_id;

        return $this;
    }

    /**
     * Gets buyer_user_id
     *
     * @return int|null
     */
    public function getBuyerUserId()
    {
        return $this->container['buyer_user_id'];
    }

    /**
     * Sets buyer_user_id
     *
     * @param int|null $buyer_user_id The numeric user ID for the buyer in this transaction.
     *
     * @return self
     */
    public function setBuyerUserId($buyer_user_id)
    {
        if (is_null($buyer_user_id)) {
            throw new \InvalidArgumentException('non-nullable buyer_user_id cannot be null');
        }

        if (($buyer_user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $buyer_user_id when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['buyer_user_id'] = $buyer_user_id;

        return $this;
    }

    /**
     * Gets create_timestamp
     *
     * @return int|null
     */
    public function getCreateTimestamp()
    {
        return $this->container['create_timestamp'];
    }

    /**
     * Sets create_timestamp
     *
     * @param int|null $create_timestamp The transaction\\'s creation date and time, in epoch seconds.
     *
     * @return self
     */
    public function setCreateTimestamp($create_timestamp)
    {
        if (is_null($create_timestamp)) {
            throw new \InvalidArgumentException('non-nullable create_timestamp cannot be null');
        }

        if (($create_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $create_timestamp when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['create_timestamp'] = $create_timestamp;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The transaction\\'s creation date and time, in epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets paid_timestamp
     *
     * @return int|null
     */
    public function getPaidTimestamp()
    {
        return $this->container['paid_timestamp'];
    }

    /**
     * Sets paid_timestamp
     *
     * @param int|null $paid_timestamp The transaction\\'s paid date and time, in epoch seconds.
     *
     * @return self
     */
    public function setPaidTimestamp($paid_timestamp)
    {
        if (is_null($paid_timestamp)) {
            array_push($this->openAPINullablesSetToNull, 'paid_timestamp');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('paid_timestamp', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($paid_timestamp) && ($paid_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $paid_timestamp when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['paid_timestamp'] = $paid_timestamp;

        return $this;
    }

    /**
     * Gets shipped_timestamp
     *
     * @return int|null
     */
    public function getShippedTimestamp()
    {
        return $this->container['shipped_timestamp'];
    }

    /**
     * Sets shipped_timestamp
     *
     * @param int|null $shipped_timestamp The transaction\\'s shipping date and time, in epoch seconds.
     *
     * @return self
     */
    public function setShippedTimestamp($shipped_timestamp)
    {
        if (is_null($shipped_timestamp)) {
            array_push($this->openAPINullablesSetToNull, 'shipped_timestamp');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipped_timestamp', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($shipped_timestamp) && ($shipped_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $shipped_timestamp when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['shipped_timestamp'] = $shipped_timestamp;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity The numeric quantity of products purchased in this transaction.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }

        if (($quantity < 0)) {
            throw new \InvalidArgumentException('invalid value for $quantity when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets listing_image_id
     *
     * @return int|null
     */
    public function getListingImageId()
    {
        return $this->container['listing_image_id'];
    }

    /**
     * Sets listing_image_id
     *
     * @param int|null $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction.
     *
     * @return self
     */
    public function setListingImageId($listing_image_id)
    {
        if (is_null($listing_image_id)) {
            array_push($this->openAPINullablesSetToNull, 'listing_image_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('listing_image_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($listing_image_id) && ($listing_image_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $listing_image_id when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['listing_image_id'] = $listing_image_id;

        return $this;
    }

    /**
     * Gets receipt_id
     *
     * @return int|null
     */
    public function getReceiptId()
    {
        return $this->container['receipt_id'];
    }

    /**
     * Sets receipt_id
     *
     * @param int|null $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction.
     *
     * @return self
     */
    public function setReceiptId($receipt_id)
    {
        if (is_null($receipt_id)) {
            throw new \InvalidArgumentException('non-nullable receipt_id cannot be null');
        }

        if (($receipt_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $receipt_id when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['receipt_id'] = $receipt_id;

        return $this;
    }

    /**
     * Gets is_digital
     *
     * @return bool|null
     */
    public function getIsDigital()
    {
        return $this->container['is_digital'];
    }

    /**
     * Sets is_digital
     *
     * @param bool|null $is_digital When true, the transaction recorded the purchase of a digital listing.
     *
     * @return self
     */
    public function setIsDigital($is_digital)
    {
        if (is_null($is_digital)) {
            throw new \InvalidArgumentException('non-nullable is_digital cannot be null');
        }
        $this->container['is_digital'] = $is_digital;

        return $this;
    }

    /**
     * Gets file_data
     *
     * @return string|null
     */
    public function getFileData()
    {
        return $this->container['file_data'];
    }

    /**
     * Sets file_data
     *
     * @param string|null $file_data A string describing the files purchased in this transaction.
     *
     * @return self
     */
    public function setFileData($file_data)
    {
        if (is_null($file_data)) {
            throw new \InvalidArgumentException('non-nullable file_data cannot be null');
        }
        $this->container['file_data'] = $file_data;

        return $this;
    }

    /**
     * Gets listing_id
     *
     * @return int|null
     */
    public function getListingId()
    {
        return $this->container['listing_id'];
    }

    /**
     * Sets listing_id
     *
     * @param int|null $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
     *
     * @return self
     */
    public function setListingId($listing_id)
    {
        if (is_null($listing_id)) {
            array_push($this->openAPINullablesSetToNull, 'listing_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('listing_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($listing_id) && ($listing_id < 0)) {
            throw new \InvalidArgumentException('invalid value for $listing_id when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['listing_id'] = $listing_id;

        return $this;
    }

    /**
     * Gets transaction_type
     *
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type
     *
     * @param string|null $transaction_type The type string for the transaction, usually \"listing\".
     *
     * @return self
     */
    public function setTransactionType($transaction_type)
    {
        if (is_null($transaction_type)) {
            throw new \InvalidArgumentException('non-nullable transaction_type cannot be null');
        }
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return int|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param int|null $product_id The numeric ID for a specific [product](/documentation/reference#tag/ShopListing-Product) purchased from a listing.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        if (is_null($product_id)) {
            array_push($this->openAPINullablesSetToNull, 'product_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('product_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($product_id) && ($product_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $product_id when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku The SKU string for the product
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            array_push($this->openAPINullablesSetToNull, 'sku');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sku', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets price
     *
     * @return \Etsy\Model\ShopReceiptTransactionPrice|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param \Etsy\Model\ShopReceiptTransactionPrice|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets shipping_cost
     *
     * @return \Etsy\Model\ShopReceiptTransactionShippingCost|null
     */
    public function getShippingCost()
    {
        return $this->container['shipping_cost'];
    }

    /**
     * Sets shipping_cost
     *
     * @param \Etsy\Model\ShopReceiptTransactionShippingCost|null $shipping_cost shipping_cost
     *
     * @return self
     */
    public function setShippingCost($shipping_cost)
    {
        if (is_null($shipping_cost)) {
            throw new \InvalidArgumentException('non-nullable shipping_cost cannot be null');
        }
        $this->container['shipping_cost'] = $shipping_cost;

        return $this;
    }

    /**
     * Gets variations
     *
     * @return \Etsy\Model\ShopReceiptTransactionVariationsInner[]|null
     */
    public function getVariations()
    {
        return $this->container['variations'];
    }

    /**
     * Sets variations
     *
     * @param \Etsy\Model\ShopReceiptTransactionVariationsInner[]|null $variations Array of variations and personalizations the buyer chose.
     *
     * @return self
     */
    public function setVariations($variations)
    {
        if (is_null($variations)) {
            throw new \InvalidArgumentException('non-nullable variations cannot be null');
        }
        $this->container['variations'] = $variations;

        return $this;
    }

    /**
     * Gets product_data
     *
     * @return \Etsy\Model\ListingInventoryProductPropertyValuesInner[]|null
     */
    public function getProductData()
    {
        return $this->container['product_data'];
    }

    /**
     * Sets product_data
     *
     * @param \Etsy\Model\ListingInventoryProductPropertyValuesInner[]|null $product_data A list of property value entries for this product. Note: parenthesis characters (`(` and `)`) are not allowed.
     *
     * @return self
     */
    public function setProductData($product_data)
    {
        if (is_null($product_data)) {
            throw new \InvalidArgumentException('non-nullable product_data cannot be null');
        }
        $this->container['product_data'] = $product_data;

        return $this;
    }

    /**
     * Gets shipping_profile_id
     *
     * @return int|null
     */
    public function getShippingProfileId()
    {
        return $this->container['shipping_profile_id'];
    }

    /**
     * Sets shipping_profile_id
     *
     * @param int|null $shipping_profile_id The ID of the shipping profile selected for this listing.
     *
     * @return self
     */
    public function setShippingProfileId($shipping_profile_id)
    {
        if (is_null($shipping_profile_id)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_profile_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_profile_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($shipping_profile_id) && ($shipping_profile_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shipping_profile_id when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['shipping_profile_id'] = $shipping_profile_id;

        return $this;
    }

    /**
     * Gets min_processing_days
     *
     * @return int|null
     */
    public function getMinProcessingDays()
    {
        return $this->container['min_processing_days'];
    }

    /**
     * Sets min_processing_days
     *
     * @param int|null $min_processing_days The minimum number of days for processing the listing.
     *
     * @return self
     */
    public function setMinProcessingDays($min_processing_days)
    {
        if (is_null($min_processing_days)) {
            array_push($this->openAPINullablesSetToNull, 'min_processing_days');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('min_processing_days', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($min_processing_days) && ($min_processing_days < 1)) {
            throw new \InvalidArgumentException('invalid value for $min_processing_days when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['min_processing_days'] = $min_processing_days;

        return $this;
    }

    /**
     * Gets max_processing_days
     *
     * @return int|null
     */
    public function getMaxProcessingDays()
    {
        return $this->container['max_processing_days'];
    }

    /**
     * Sets max_processing_days
     *
     * @param int|null $max_processing_days The maximum number of days for processing the listing.
     *
     * @return self
     */
    public function setMaxProcessingDays($max_processing_days)
    {
        if (is_null($max_processing_days)) {
            array_push($this->openAPINullablesSetToNull, 'max_processing_days');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('max_processing_days', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($max_processing_days) && ($max_processing_days < 1)) {
            throw new \InvalidArgumentException('invalid value for $max_processing_days when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['max_processing_days'] = $max_processing_days;

        return $this;
    }

    /**
     * Gets shipping_method
     *
     * @return string|null
     */
    public function getShippingMethod()
    {
        return $this->container['shipping_method'];
    }

    /**
     * Sets shipping_method
     *
     * @param string|null $shipping_method Name of the selected shipping method.
     *
     * @return self
     */
    public function setShippingMethod($shipping_method)
    {
        if (is_null($shipping_method)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_method');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_method', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shipping_method'] = $shipping_method;

        return $this;
    }

    /**
     * Gets shipping_upgrade
     *
     * @return string|null
     */
    public function getShippingUpgrade()
    {
        return $this->container['shipping_upgrade'];
    }

    /**
     * Sets shipping_upgrade
     *
     * @param string|null $shipping_upgrade The name of the shipping upgrade selected for this listing. Default value is null.
     *
     * @return self
     */
    public function setShippingUpgrade($shipping_upgrade)
    {
        if (is_null($shipping_upgrade)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_upgrade');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_upgrade', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shipping_upgrade'] = $shipping_upgrade;

        return $this;
    }

    /**
     * Gets expected_ship_date
     *
     * @return int|null
     */
    public function getExpectedShipDate()
    {
        return $this->container['expected_ship_date'];
    }

    /**
     * Sets expected_ship_date
     *
     * @param int|null $expected_ship_date The date & time of the expected ship date, in epoch seconds.
     *
     * @return self
     */
    public function setExpectedShipDate($expected_ship_date)
    {
        if (is_null($expected_ship_date)) {
            array_push($this->openAPINullablesSetToNull, 'expected_ship_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('expected_ship_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($expected_ship_date) && ($expected_ship_date < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $expected_ship_date when calling ShopReceiptTransactionsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['expected_ship_date'] = $expected_ship_date;

        return $this;
    }

    /**
     * Gets buyer_coupon
     *
     * @return float|null
     */
    public function getBuyerCoupon()
    {
        return $this->container['buyer_coupon'];
    }

    /**
     * Sets buyer_coupon
     *
     * @param float|null $buyer_coupon The amount of the buyer coupon that was discounted in the shop's currency.
     *
     * @return self
     */
    public function setBuyerCoupon($buyer_coupon)
    {
        if (is_null($buyer_coupon)) {
            throw new \InvalidArgumentException('non-nullable buyer_coupon cannot be null');
        }
        $this->container['buyer_coupon'] = $buyer_coupon;

        return $this;
    }

    /**
     * Gets shop_coupon
     *
     * @return float|null
     */
    public function getShopCoupon()
    {
        return $this->container['shop_coupon'];
    }

    /**
     * Sets shop_coupon
     *
     * @param float|null $shop_coupon The amount of the shop coupon that was discounted in the shop's currency.
     *
     * @return self
     */
    public function setShopCoupon($shop_coupon)
    {
        if (is_null($shop_coupon)) {
            throw new \InvalidArgumentException('non-nullable shop_coupon cannot be null');
        }
        $this->container['shop_coupon'] = $shop_coupon;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


