<?php
/**
 * ShopListingWithAssociationsShop
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ShopListingWithAssociationsShop Class Doc Comment
 *
 * @category Class
 * @description A shop created by an Etsy user.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShopListingWithAssociationsShop implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShopListingWithAssociations_shop';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'shop_id' => 'int',
        'user_id' => 'int',
        'shop_name' => 'string',
        'create_date' => 'int',
        'created_timestamp' => 'int',
        'title' => 'string',
        'announcement' => 'string',
        'currency_code' => 'string',
        'is_vacation' => 'bool',
        'vacation_message' => 'string',
        'sale_message' => 'string',
        'digital_sale_message' => 'string',
        'update_date' => 'int',
        'updated_timestamp' => 'int',
        'listing_active_count' => 'int',
        'digital_listing_count' => 'int',
        'login_name' => 'string',
        'accepts_custom_requests' => 'bool',
        'policy_welcome' => 'string',
        'policy_payment' => 'string',
        'policy_shipping' => 'string',
        'policy_refunds' => 'string',
        'policy_additional' => 'string',
        'policy_seller_info' => 'string',
        'policy_update_date' => 'int',
        'policy_has_private_receipt_info' => 'bool',
        'has_unstructured_policies' => 'bool',
        'policy_privacy' => 'string',
        'vacation_autoreply' => 'string',
        'url' => 'string',
        'image_url_760x100' => 'string',
        'num_favorers' => 'int',
        'languages' => 'string[]',
        'icon_url_fullxfull' => 'string',
        'is_using_structured_policies' => 'bool',
        'has_onboarded_structured_policies' => 'bool',
        'include_dispute_form_link' => 'bool',
        'is_direct_checkout_onboarded' => 'bool',
        'is_etsy_payments_onboarded' => 'bool',
        'is_calculated_eligible' => 'bool',
        'is_opted_in_to_buyer_promise' => 'bool',
        'is_shop_us_based' => 'bool',
        'transaction_sold_count' => 'int',
        'shipping_from_country_iso' => 'string',
        'shop_location_country_iso' => 'string',
        'review_count' => 'int',
        'review_average' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'shop_id' => null,
        'user_id' => null,
        'shop_name' => null,
        'create_date' => null,
        'created_timestamp' => null,
        'title' => null,
        'announcement' => null,
        'currency_code' => null,
        'is_vacation' => null,
        'vacation_message' => null,
        'sale_message' => null,
        'digital_sale_message' => null,
        'update_date' => null,
        'updated_timestamp' => null,
        'listing_active_count' => null,
        'digital_listing_count' => null,
        'login_name' => null,
        'accepts_custom_requests' => null,
        'policy_welcome' => null,
        'policy_payment' => null,
        'policy_shipping' => null,
        'policy_refunds' => null,
        'policy_additional' => null,
        'policy_seller_info' => null,
        'policy_update_date' => null,
        'policy_has_private_receipt_info' => null,
        'has_unstructured_policies' => null,
        'policy_privacy' => null,
        'vacation_autoreply' => null,
        'url' => null,
        'image_url_760x100' => null,
        'num_favorers' => null,
        'languages' => null,
        'icon_url_fullxfull' => null,
        'is_using_structured_policies' => null,
        'has_onboarded_structured_policies' => null,
        'include_dispute_form_link' => null,
        'is_direct_checkout_onboarded' => null,
        'is_etsy_payments_onboarded' => null,
        'is_calculated_eligible' => null,
        'is_opted_in_to_buyer_promise' => null,
        'is_shop_us_based' => null,
        'transaction_sold_count' => null,
        'shipping_from_country_iso' => 'ISO 3166-1 alpha-2',
        'shop_location_country_iso' => 'ISO 3166-1 alpha-2',
        'review_count' => null,
        'review_average' => 'float'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'shop_id' => false,
		'user_id' => false,
		'shop_name' => false,
		'create_date' => false,
		'created_timestamp' => false,
		'title' => true,
		'announcement' => true,
		'currency_code' => false,
		'is_vacation' => false,
		'vacation_message' => true,
		'sale_message' => true,
		'digital_sale_message' => true,
		'update_date' => false,
		'updated_timestamp' => false,
		'listing_active_count' => false,
		'digital_listing_count' => false,
		'login_name' => false,
		'accepts_custom_requests' => false,
		'policy_welcome' => true,
		'policy_payment' => true,
		'policy_shipping' => true,
		'policy_refunds' => true,
		'policy_additional' => true,
		'policy_seller_info' => true,
		'policy_update_date' => false,
		'policy_has_private_receipt_info' => false,
		'has_unstructured_policies' => false,
		'policy_privacy' => true,
		'vacation_autoreply' => true,
		'url' => false,
		'image_url_760x100' => true,
		'num_favorers' => false,
		'languages' => false,
		'icon_url_fullxfull' => true,
		'is_using_structured_policies' => false,
		'has_onboarded_structured_policies' => false,
		'include_dispute_form_link' => false,
		'is_direct_checkout_onboarded' => false,
		'is_etsy_payments_onboarded' => false,
		'is_calculated_eligible' => false,
		'is_opted_in_to_buyer_promise' => false,
		'is_shop_us_based' => false,
		'transaction_sold_count' => false,
		'shipping_from_country_iso' => true,
		'shop_location_country_iso' => true,
		'review_count' => true,
		'review_average' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shop_id' => 'shop_id',
        'user_id' => 'user_id',
        'shop_name' => 'shop_name',
        'create_date' => 'create_date',
        'created_timestamp' => 'created_timestamp',
        'title' => 'title',
        'announcement' => 'announcement',
        'currency_code' => 'currency_code',
        'is_vacation' => 'is_vacation',
        'vacation_message' => 'vacation_message',
        'sale_message' => 'sale_message',
        'digital_sale_message' => 'digital_sale_message',
        'update_date' => 'update_date',
        'updated_timestamp' => 'updated_timestamp',
        'listing_active_count' => 'listing_active_count',
        'digital_listing_count' => 'digital_listing_count',
        'login_name' => 'login_name',
        'accepts_custom_requests' => 'accepts_custom_requests',
        'policy_welcome' => 'policy_welcome',
        'policy_payment' => 'policy_payment',
        'policy_shipping' => 'policy_shipping',
        'policy_refunds' => 'policy_refunds',
        'policy_additional' => 'policy_additional',
        'policy_seller_info' => 'policy_seller_info',
        'policy_update_date' => 'policy_update_date',
        'policy_has_private_receipt_info' => 'policy_has_private_receipt_info',
        'has_unstructured_policies' => 'has_unstructured_policies',
        'policy_privacy' => 'policy_privacy',
        'vacation_autoreply' => 'vacation_autoreply',
        'url' => 'url',
        'image_url_760x100' => 'image_url_760x100',
        'num_favorers' => 'num_favorers',
        'languages' => 'languages',
        'icon_url_fullxfull' => 'icon_url_fullxfull',
        'is_using_structured_policies' => 'is_using_structured_policies',
        'has_onboarded_structured_policies' => 'has_onboarded_structured_policies',
        'include_dispute_form_link' => 'include_dispute_form_link',
        'is_direct_checkout_onboarded' => 'is_direct_checkout_onboarded',
        'is_etsy_payments_onboarded' => 'is_etsy_payments_onboarded',
        'is_calculated_eligible' => 'is_calculated_eligible',
        'is_opted_in_to_buyer_promise' => 'is_opted_in_to_buyer_promise',
        'is_shop_us_based' => 'is_shop_us_based',
        'transaction_sold_count' => 'transaction_sold_count',
        'shipping_from_country_iso' => 'shipping_from_country_iso',
        'shop_location_country_iso' => 'shop_location_country_iso',
        'review_count' => 'review_count',
        'review_average' => 'review_average'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shop_id' => 'setShopId',
        'user_id' => 'setUserId',
        'shop_name' => 'setShopName',
        'create_date' => 'setCreateDate',
        'created_timestamp' => 'setCreatedTimestamp',
        'title' => 'setTitle',
        'announcement' => 'setAnnouncement',
        'currency_code' => 'setCurrencyCode',
        'is_vacation' => 'setIsVacation',
        'vacation_message' => 'setVacationMessage',
        'sale_message' => 'setSaleMessage',
        'digital_sale_message' => 'setDigitalSaleMessage',
        'update_date' => 'setUpdateDate',
        'updated_timestamp' => 'setUpdatedTimestamp',
        'listing_active_count' => 'setListingActiveCount',
        'digital_listing_count' => 'setDigitalListingCount',
        'login_name' => 'setLoginName',
        'accepts_custom_requests' => 'setAcceptsCustomRequests',
        'policy_welcome' => 'setPolicyWelcome',
        'policy_payment' => 'setPolicyPayment',
        'policy_shipping' => 'setPolicyShipping',
        'policy_refunds' => 'setPolicyRefunds',
        'policy_additional' => 'setPolicyAdditional',
        'policy_seller_info' => 'setPolicySellerInfo',
        'policy_update_date' => 'setPolicyUpdateDate',
        'policy_has_private_receipt_info' => 'setPolicyHasPrivateReceiptInfo',
        'has_unstructured_policies' => 'setHasUnstructuredPolicies',
        'policy_privacy' => 'setPolicyPrivacy',
        'vacation_autoreply' => 'setVacationAutoreply',
        'url' => 'setUrl',
        'image_url_760x100' => 'setImageUrl760x100',
        'num_favorers' => 'setNumFavorers',
        'languages' => 'setLanguages',
        'icon_url_fullxfull' => 'setIconUrlFullxfull',
        'is_using_structured_policies' => 'setIsUsingStructuredPolicies',
        'has_onboarded_structured_policies' => 'setHasOnboardedStructuredPolicies',
        'include_dispute_form_link' => 'setIncludeDisputeFormLink',
        'is_direct_checkout_onboarded' => 'setIsDirectCheckoutOnboarded',
        'is_etsy_payments_onboarded' => 'setIsEtsyPaymentsOnboarded',
        'is_calculated_eligible' => 'setIsCalculatedEligible',
        'is_opted_in_to_buyer_promise' => 'setIsOptedInToBuyerPromise',
        'is_shop_us_based' => 'setIsShopUsBased',
        'transaction_sold_count' => 'setTransactionSoldCount',
        'shipping_from_country_iso' => 'setShippingFromCountryIso',
        'shop_location_country_iso' => 'setShopLocationCountryIso',
        'review_count' => 'setReviewCount',
        'review_average' => 'setReviewAverage'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shop_id' => 'getShopId',
        'user_id' => 'getUserId',
        'shop_name' => 'getShopName',
        'create_date' => 'getCreateDate',
        'created_timestamp' => 'getCreatedTimestamp',
        'title' => 'getTitle',
        'announcement' => 'getAnnouncement',
        'currency_code' => 'getCurrencyCode',
        'is_vacation' => 'getIsVacation',
        'vacation_message' => 'getVacationMessage',
        'sale_message' => 'getSaleMessage',
        'digital_sale_message' => 'getDigitalSaleMessage',
        'update_date' => 'getUpdateDate',
        'updated_timestamp' => 'getUpdatedTimestamp',
        'listing_active_count' => 'getListingActiveCount',
        'digital_listing_count' => 'getDigitalListingCount',
        'login_name' => 'getLoginName',
        'accepts_custom_requests' => 'getAcceptsCustomRequests',
        'policy_welcome' => 'getPolicyWelcome',
        'policy_payment' => 'getPolicyPayment',
        'policy_shipping' => 'getPolicyShipping',
        'policy_refunds' => 'getPolicyRefunds',
        'policy_additional' => 'getPolicyAdditional',
        'policy_seller_info' => 'getPolicySellerInfo',
        'policy_update_date' => 'getPolicyUpdateDate',
        'policy_has_private_receipt_info' => 'getPolicyHasPrivateReceiptInfo',
        'has_unstructured_policies' => 'getHasUnstructuredPolicies',
        'policy_privacy' => 'getPolicyPrivacy',
        'vacation_autoreply' => 'getVacationAutoreply',
        'url' => 'getUrl',
        'image_url_760x100' => 'getImageUrl760x100',
        'num_favorers' => 'getNumFavorers',
        'languages' => 'getLanguages',
        'icon_url_fullxfull' => 'getIconUrlFullxfull',
        'is_using_structured_policies' => 'getIsUsingStructuredPolicies',
        'has_onboarded_structured_policies' => 'getHasOnboardedStructuredPolicies',
        'include_dispute_form_link' => 'getIncludeDisputeFormLink',
        'is_direct_checkout_onboarded' => 'getIsDirectCheckoutOnboarded',
        'is_etsy_payments_onboarded' => 'getIsEtsyPaymentsOnboarded',
        'is_calculated_eligible' => 'getIsCalculatedEligible',
        'is_opted_in_to_buyer_promise' => 'getIsOptedInToBuyerPromise',
        'is_shop_us_based' => 'getIsShopUsBased',
        'transaction_sold_count' => 'getTransactionSoldCount',
        'shipping_from_country_iso' => 'getShippingFromCountryIso',
        'shop_location_country_iso' => 'getShopLocationCountryIso',
        'review_count' => 'getReviewCount',
        'review_average' => 'getReviewAverage'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('user_id', $data ?? [], null);
        $this->setIfExists('shop_name', $data ?? [], null);
        $this->setIfExists('create_date', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('announcement', $data ?? [], null);
        $this->setIfExists('currency_code', $data ?? [], null);
        $this->setIfExists('is_vacation', $data ?? [], null);
        $this->setIfExists('vacation_message', $data ?? [], null);
        $this->setIfExists('sale_message', $data ?? [], null);
        $this->setIfExists('digital_sale_message', $data ?? [], null);
        $this->setIfExists('update_date', $data ?? [], null);
        $this->setIfExists('updated_timestamp', $data ?? [], null);
        $this->setIfExists('listing_active_count', $data ?? [], null);
        $this->setIfExists('digital_listing_count', $data ?? [], null);
        $this->setIfExists('login_name', $data ?? [], null);
        $this->setIfExists('accepts_custom_requests', $data ?? [], null);
        $this->setIfExists('policy_welcome', $data ?? [], null);
        $this->setIfExists('policy_payment', $data ?? [], null);
        $this->setIfExists('policy_shipping', $data ?? [], null);
        $this->setIfExists('policy_refunds', $data ?? [], null);
        $this->setIfExists('policy_additional', $data ?? [], null);
        $this->setIfExists('policy_seller_info', $data ?? [], null);
        $this->setIfExists('policy_update_date', $data ?? [], null);
        $this->setIfExists('policy_has_private_receipt_info', $data ?? [], null);
        $this->setIfExists('has_unstructured_policies', $data ?? [], null);
        $this->setIfExists('policy_privacy', $data ?? [], null);
        $this->setIfExists('vacation_autoreply', $data ?? [], null);
        $this->setIfExists('url', $data ?? [], null);
        $this->setIfExists('image_url_760x100', $data ?? [], null);
        $this->setIfExists('num_favorers', $data ?? [], null);
        $this->setIfExists('languages', $data ?? [], null);
        $this->setIfExists('icon_url_fullxfull', $data ?? [], null);
        $this->setIfExists('is_using_structured_policies', $data ?? [], null);
        $this->setIfExists('has_onboarded_structured_policies', $data ?? [], null);
        $this->setIfExists('include_dispute_form_link', $data ?? [], null);
        $this->setIfExists('is_direct_checkout_onboarded', $data ?? [], null);
        $this->setIfExists('is_etsy_payments_onboarded', $data ?? [], null);
        $this->setIfExists('is_calculated_eligible', $data ?? [], null);
        $this->setIfExists('is_opted_in_to_buyer_promise', $data ?? [], null);
        $this->setIfExists('is_shop_us_based', $data ?? [], null);
        $this->setIfExists('transaction_sold_count', $data ?? [], null);
        $this->setIfExists('shipping_from_country_iso', $data ?? [], null);
        $this->setIfExists('shop_location_country_iso', $data ?? [], null);
        $this->setIfExists('review_count', $data ?? [], null);
        $this->setIfExists('review_average', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['shop_id']) && ($this->container['shop_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shop_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['user_id']) && ($this->container['user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'user_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['create_date']) && ($this->container['create_date'] < 0)) {
            $invalidProperties[] = "invalid value for 'create_date', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 0)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['update_date']) && ($this->container['update_date'] < 0)) {
            $invalidProperties[] = "invalid value for 'update_date', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['updated_timestamp']) && ($this->container['updated_timestamp'] < 0)) {
            $invalidProperties[] = "invalid value for 'updated_timestamp', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['listing_active_count']) && ($this->container['listing_active_count'] < 0)) {
            $invalidProperties[] = "invalid value for 'listing_active_count', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['digital_listing_count']) && ($this->container['digital_listing_count'] < 0)) {
            $invalidProperties[] = "invalid value for 'digital_listing_count', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['policy_update_date']) && ($this->container['policy_update_date'] < 0)) {
            $invalidProperties[] = "invalid value for 'policy_update_date', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['num_favorers']) && ($this->container['num_favorers'] < 0)) {
            $invalidProperties[] = "invalid value for 'num_favorers', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['transaction_sold_count']) && ($this->container['transaction_sold_count'] < 0)) {
            $invalidProperties[] = "invalid value for 'transaction_sold_count', must be bigger than or equal to 0.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets shop_id
     *
     * @return int|null
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int|null $shop_id The unique positive non-zero numeric ID for an Etsy Shop.
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }

        if (($shop_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shop_id when calling ShopListingWithAssociationsShop., must be bigger than or equal to 1.');
        }

        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return int|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param int|null $user_id The numeric user ID of the [user](/documentation/reference#tag/User) who owns this shop.
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        if (is_null($user_id)) {
            throw new \InvalidArgumentException('non-nullable user_id cannot be null');
        }

        if (($user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $user_id when calling ShopListingWithAssociationsShop., must be bigger than or equal to 1.');
        }

        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets shop_name
     *
     * @return string|null
     */
    public function getShopName()
    {
        return $this->container['shop_name'];
    }

    /**
     * Sets shop_name
     *
     * @param string|null $shop_name The shop's name string.
     *
     * @return self
     */
    public function setShopName($shop_name)
    {
        if (is_null($shop_name)) {
            throw new \InvalidArgumentException('non-nullable shop_name cannot be null');
        }
        $this->container['shop_name'] = $shop_name;

        return $this;
    }

    /**
     * Gets create_date
     *
     * @return int|null
     */
    public function getCreateDate()
    {
        return $this->container['create_date'];
    }

    /**
     * Sets create_date
     *
     * @param int|null $create_date The date and time this shop was created, in epoch seconds.
     *
     * @return self
     */
    public function setCreateDate($create_date)
    {
        if (is_null($create_date)) {
            throw new \InvalidArgumentException('non-nullable create_date cannot be null');
        }

        if (($create_date < 0)) {
            throw new \InvalidArgumentException('invalid value for $create_date when calling ShopListingWithAssociationsShop., must be bigger than or equal to 0.');
        }

        $this->container['create_date'] = $create_date;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The date and time this shop was created, in epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 0)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling ShopListingWithAssociationsShop., must be bigger than or equal to 0.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title A brief heading string for the shop\\'s main page.
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            array_push($this->openAPINullablesSetToNull, 'title');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('title', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets announcement
     *
     * @return string|null
     */
    public function getAnnouncement()
    {
        return $this->container['announcement'];
    }

    /**
     * Sets announcement
     *
     * @param string|null $announcement An announcement string to buyers that displays on the shop's homepage.
     *
     * @return self
     */
    public function setAnnouncement($announcement)
    {
        if (is_null($announcement)) {
            array_push($this->openAPINullablesSetToNull, 'announcement');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('announcement', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['announcement'] = $announcement;

        return $this;
    }

    /**
     * Gets currency_code
     *
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->container['currency_code'];
    }

    /**
     * Sets currency_code
     *
     * @param string|null $currency_code The ISO (alphabetic) code for the shop's currency. The shop displays all prices in this currency by default.
     *
     * @return self
     */
    public function setCurrencyCode($currency_code)
    {
        if (is_null($currency_code)) {
            throw new \InvalidArgumentException('non-nullable currency_code cannot be null');
        }
        $this->container['currency_code'] = $currency_code;

        return $this;
    }

    /**
     * Gets is_vacation
     *
     * @return bool|null
     */
    public function getIsVacation()
    {
        return $this->container['is_vacation'];
    }

    /**
     * Sets is_vacation
     *
     * @param bool|null $is_vacation When true, this shop is not accepting purchases.
     *
     * @return self
     */
    public function setIsVacation($is_vacation)
    {
        if (is_null($is_vacation)) {
            throw new \InvalidArgumentException('non-nullable is_vacation cannot be null');
        }
        $this->container['is_vacation'] = $is_vacation;

        return $this;
    }

    /**
     * Gets vacation_message
     *
     * @return string|null
     */
    public function getVacationMessage()
    {
        return $this->container['vacation_message'];
    }

    /**
     * Sets vacation_message
     *
     * @param string|null $vacation_message The shop's message string displayed when `is_vacation` is true.
     *
     * @return self
     */
    public function setVacationMessage($vacation_message)
    {
        if (is_null($vacation_message)) {
            array_push($this->openAPINullablesSetToNull, 'vacation_message');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('vacation_message', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['vacation_message'] = $vacation_message;

        return $this;
    }

    /**
     * Gets sale_message
     *
     * @return string|null
     */
    public function getSaleMessage()
    {
        return $this->container['sale_message'];
    }

    /**
     * Sets sale_message
     *
     * @param string|null $sale_message A message string sent to users who complete a purchase from this shop.
     *
     * @return self
     */
    public function setSaleMessage($sale_message)
    {
        if (is_null($sale_message)) {
            array_push($this->openAPINullablesSetToNull, 'sale_message');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('sale_message', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['sale_message'] = $sale_message;

        return $this;
    }

    /**
     * Gets digital_sale_message
     *
     * @return string|null
     */
    public function getDigitalSaleMessage()
    {
        return $this->container['digital_sale_message'];
    }

    /**
     * Sets digital_sale_message
     *
     * @param string|null $digital_sale_message A message string sent to users who purchase a digital item from this shop.
     *
     * @return self
     */
    public function setDigitalSaleMessage($digital_sale_message)
    {
        if (is_null($digital_sale_message)) {
            array_push($this->openAPINullablesSetToNull, 'digital_sale_message');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('digital_sale_message', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['digital_sale_message'] = $digital_sale_message;

        return $this;
    }

    /**
     * Gets update_date
     *
     * @return int|null
     */
    public function getUpdateDate()
    {
        return $this->container['update_date'];
    }

    /**
     * Sets update_date
     *
     * @param int|null $update_date The date and time of the last update to the shop, in epoch seconds.
     *
     * @return self
     */
    public function setUpdateDate($update_date)
    {
        if (is_null($update_date)) {
            throw new \InvalidArgumentException('non-nullable update_date cannot be null');
        }

        if (($update_date < 0)) {
            throw new \InvalidArgumentException('invalid value for $update_date when calling ShopListingWithAssociationsShop., must be bigger than or equal to 0.');
        }

        $this->container['update_date'] = $update_date;

        return $this;
    }

    /**
     * Gets updated_timestamp
     *
     * @return int|null
     */
    public function getUpdatedTimestamp()
    {
        return $this->container['updated_timestamp'];
    }

    /**
     * Sets updated_timestamp
     *
     * @param int|null $updated_timestamp The date and time of the last update to the shop, in epoch seconds.
     *
     * @return self
     */
    public function setUpdatedTimestamp($updated_timestamp)
    {
        if (is_null($updated_timestamp)) {
            throw new \InvalidArgumentException('non-nullable updated_timestamp cannot be null');
        }

        if (($updated_timestamp < 0)) {
            throw new \InvalidArgumentException('invalid value for $updated_timestamp when calling ShopListingWithAssociationsShop., must be bigger than or equal to 0.');
        }

        $this->container['updated_timestamp'] = $updated_timestamp;

        return $this;
    }

    /**
     * Gets listing_active_count
     *
     * @return int|null
     */
    public function getListingActiveCount()
    {
        return $this->container['listing_active_count'];
    }

    /**
     * Sets listing_active_count
     *
     * @param int|null $listing_active_count The number of active listings in the shop.
     *
     * @return self
     */
    public function setListingActiveCount($listing_active_count)
    {
        if (is_null($listing_active_count)) {
            throw new \InvalidArgumentException('non-nullable listing_active_count cannot be null');
        }

        if (($listing_active_count < 0)) {
            throw new \InvalidArgumentException('invalid value for $listing_active_count when calling ShopListingWithAssociationsShop., must be bigger than or equal to 0.');
        }

        $this->container['listing_active_count'] = $listing_active_count;

        return $this;
    }

    /**
     * Gets digital_listing_count
     *
     * @return int|null
     */
    public function getDigitalListingCount()
    {
        return $this->container['digital_listing_count'];
    }

    /**
     * Sets digital_listing_count
     *
     * @param int|null $digital_listing_count The number of digital listings in the shop.
     *
     * @return self
     */
    public function setDigitalListingCount($digital_listing_count)
    {
        if (is_null($digital_listing_count)) {
            throw new \InvalidArgumentException('non-nullable digital_listing_count cannot be null');
        }

        if (($digital_listing_count < 0)) {
            throw new \InvalidArgumentException('invalid value for $digital_listing_count when calling ShopListingWithAssociationsShop., must be bigger than or equal to 0.');
        }

        $this->container['digital_listing_count'] = $digital_listing_count;

        return $this;
    }

    /**
     * Gets login_name
     *
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->container['login_name'];
    }

    /**
     * Sets login_name
     *
     * @param string|null $login_name The shop owner\\'s login name string.
     *
     * @return self
     */
    public function setLoginName($login_name)
    {
        if (is_null($login_name)) {
            throw new \InvalidArgumentException('non-nullable login_name cannot be null');
        }
        $this->container['login_name'] = $login_name;

        return $this;
    }

    /**
     * Gets accepts_custom_requests
     *
     * @return bool|null
     */
    public function getAcceptsCustomRequests()
    {
        return $this->container['accepts_custom_requests'];
    }

    /**
     * Sets accepts_custom_requests
     *
     * @param bool|null $accepts_custom_requests When true, the shop accepts customization requests.
     *
     * @return self
     */
    public function setAcceptsCustomRequests($accepts_custom_requests)
    {
        if (is_null($accepts_custom_requests)) {
            throw new \InvalidArgumentException('non-nullable accepts_custom_requests cannot be null');
        }
        $this->container['accepts_custom_requests'] = $accepts_custom_requests;

        return $this;
    }

    /**
     * Gets policy_welcome
     *
     * @return string|null
     */
    public function getPolicyWelcome()
    {
        return $this->container['policy_welcome'];
    }

    /**
     * Sets policy_welcome
     *
     * @param string|null $policy_welcome The shop's policy welcome string (may be blank).
     *
     * @return self
     */
    public function setPolicyWelcome($policy_welcome)
    {
        if (is_null($policy_welcome)) {
            array_push($this->openAPINullablesSetToNull, 'policy_welcome');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('policy_welcome', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['policy_welcome'] = $policy_welcome;

        return $this;
    }

    /**
     * Gets policy_payment
     *
     * @return string|null
     */
    public function getPolicyPayment()
    {
        return $this->container['policy_payment'];
    }

    /**
     * Sets policy_payment
     *
     * @param string|null $policy_payment The shop's payment policy string (may be blank).
     *
     * @return self
     */
    public function setPolicyPayment($policy_payment)
    {
        if (is_null($policy_payment)) {
            array_push($this->openAPINullablesSetToNull, 'policy_payment');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('policy_payment', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['policy_payment'] = $policy_payment;

        return $this;
    }

    /**
     * Gets policy_shipping
     *
     * @return string|null
     */
    public function getPolicyShipping()
    {
        return $this->container['policy_shipping'];
    }

    /**
     * Sets policy_shipping
     *
     * @param string|null $policy_shipping The shop's shipping policy string (may be blank).
     *
     * @return self
     */
    public function setPolicyShipping($policy_shipping)
    {
        if (is_null($policy_shipping)) {
            array_push($this->openAPINullablesSetToNull, 'policy_shipping');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('policy_shipping', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['policy_shipping'] = $policy_shipping;

        return $this;
    }

    /**
     * Gets policy_refunds
     *
     * @return string|null
     */
    public function getPolicyRefunds()
    {
        return $this->container['policy_refunds'];
    }

    /**
     * Sets policy_refunds
     *
     * @param string|null $policy_refunds The shop's refund policy string (may be blank).
     *
     * @return self
     */
    public function setPolicyRefunds($policy_refunds)
    {
        if (is_null($policy_refunds)) {
            array_push($this->openAPINullablesSetToNull, 'policy_refunds');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('policy_refunds', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['policy_refunds'] = $policy_refunds;

        return $this;
    }

    /**
     * Gets policy_additional
     *
     * @return string|null
     */
    public function getPolicyAdditional()
    {
        return $this->container['policy_additional'];
    }

    /**
     * Sets policy_additional
     *
     * @param string|null $policy_additional The shop's additional policies string (may be blank).
     *
     * @return self
     */
    public function setPolicyAdditional($policy_additional)
    {
        if (is_null($policy_additional)) {
            array_push($this->openAPINullablesSetToNull, 'policy_additional');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('policy_additional', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['policy_additional'] = $policy_additional;

        return $this;
    }

    /**
     * Gets policy_seller_info
     *
     * @return string|null
     */
    public function getPolicySellerInfo()
    {
        return $this->container['policy_seller_info'];
    }

    /**
     * Sets policy_seller_info
     *
     * @param string|null $policy_seller_info The shop's seller information string (may be blank).
     *
     * @return self
     */
    public function setPolicySellerInfo($policy_seller_info)
    {
        if (is_null($policy_seller_info)) {
            array_push($this->openAPINullablesSetToNull, 'policy_seller_info');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('policy_seller_info', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['policy_seller_info'] = $policy_seller_info;

        return $this;
    }

    /**
     * Gets policy_update_date
     *
     * @return int|null
     */
    public function getPolicyUpdateDate()
    {
        return $this->container['policy_update_date'];
    }

    /**
     * Sets policy_update_date
     *
     * @param int|null $policy_update_date The date and time of the last update to the shop's policies, in epoch seconds.
     *
     * @return self
     */
    public function setPolicyUpdateDate($policy_update_date)
    {
        if (is_null($policy_update_date)) {
            throw new \InvalidArgumentException('non-nullable policy_update_date cannot be null');
        }

        if (($policy_update_date < 0)) {
            throw new \InvalidArgumentException('invalid value for $policy_update_date when calling ShopListingWithAssociationsShop., must be bigger than or equal to 0.');
        }

        $this->container['policy_update_date'] = $policy_update_date;

        return $this;
    }

    /**
     * Gets policy_has_private_receipt_info
     *
     * @return bool|null
     */
    public function getPolicyHasPrivateReceiptInfo()
    {
        return $this->container['policy_has_private_receipt_info'];
    }

    /**
     * Sets policy_has_private_receipt_info
     *
     * @param bool|null $policy_has_private_receipt_info When true, EU receipts display private info.
     *
     * @return self
     */
    public function setPolicyHasPrivateReceiptInfo($policy_has_private_receipt_info)
    {
        if (is_null($policy_has_private_receipt_info)) {
            throw new \InvalidArgumentException('non-nullable policy_has_private_receipt_info cannot be null');
        }
        $this->container['policy_has_private_receipt_info'] = $policy_has_private_receipt_info;

        return $this;
    }

    /**
     * Gets has_unstructured_policies
     *
     * @return bool|null
     */
    public function getHasUnstructuredPolicies()
    {
        return $this->container['has_unstructured_policies'];
    }

    /**
     * Sets has_unstructured_policies
     *
     * @param bool|null $has_unstructured_policies When true, the shop displays additional unstructured policy fields.
     *
     * @return self
     */
    public function setHasUnstructuredPolicies($has_unstructured_policies)
    {
        if (is_null($has_unstructured_policies)) {
            throw new \InvalidArgumentException('non-nullable has_unstructured_policies cannot be null');
        }
        $this->container['has_unstructured_policies'] = $has_unstructured_policies;

        return $this;
    }

    /**
     * Gets policy_privacy
     *
     * @return string|null
     */
    public function getPolicyPrivacy()
    {
        return $this->container['policy_privacy'];
    }

    /**
     * Sets policy_privacy
     *
     * @param string|null $policy_privacy The shop's privacy policy string (may be blank).
     *
     * @return self
     */
    public function setPolicyPrivacy($policy_privacy)
    {
        if (is_null($policy_privacy)) {
            array_push($this->openAPINullablesSetToNull, 'policy_privacy');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('policy_privacy', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['policy_privacy'] = $policy_privacy;

        return $this;
    }

    /**
     * Gets vacation_autoreply
     *
     * @return string|null
     */
    public function getVacationAutoreply()
    {
        return $this->container['vacation_autoreply'];
    }

    /**
     * Sets vacation_autoreply
     *
     * @param string|null $vacation_autoreply The shop's automatic reply string displayed in new conversations when `is_vacation` is true.
     *
     * @return self
     */
    public function setVacationAutoreply($vacation_autoreply)
    {
        if (is_null($vacation_autoreply)) {
            array_push($this->openAPINullablesSetToNull, 'vacation_autoreply');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('vacation_autoreply', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['vacation_autoreply'] = $vacation_autoreply;

        return $this;
    }

    /**
     * Gets url
     *
     * @return string|null
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string|null $url The URL string for this shop.
     *
     * @return self
     */
    public function setUrl($url)
    {
        if (is_null($url)) {
            throw new \InvalidArgumentException('non-nullable url cannot be null');
        }
        $this->container['url'] = $url;

        return $this;
    }

    /**
     * Gets image_url_760x100
     *
     * @return string|null
     */
    public function getImageUrl760x100()
    {
        return $this->container['image_url_760x100'];
    }

    /**
     * Sets image_url_760x100
     *
     * @param string|null $image_url_760x100 The URL string for this shop's banner image.
     *
     * @return self
     */
    public function setImageUrl760x100($image_url_760x100)
    {
        if (is_null($image_url_760x100)) {
            array_push($this->openAPINullablesSetToNull, 'image_url_760x100');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('image_url_760x100', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['image_url_760x100'] = $image_url_760x100;

        return $this;
    }

    /**
     * Gets num_favorers
     *
     * @return int|null
     */
    public function getNumFavorers()
    {
        return $this->container['num_favorers'];
    }

    /**
     * Sets num_favorers
     *
     * @param int|null $num_favorers The number of users who marked this shop a favorite.
     *
     * @return self
     */
    public function setNumFavorers($num_favorers)
    {
        if (is_null($num_favorers)) {
            throw new \InvalidArgumentException('non-nullable num_favorers cannot be null');
        }

        if (($num_favorers < 0)) {
            throw new \InvalidArgumentException('invalid value for $num_favorers when calling ShopListingWithAssociationsShop., must be bigger than or equal to 0.');
        }

        $this->container['num_favorers'] = $num_favorers;

        return $this;
    }

    /**
     * Gets languages
     *
     * @return string[]|null
     */
    public function getLanguages()
    {
        return $this->container['languages'];
    }

    /**
     * Sets languages
     *
     * @param string[]|null $languages A list of language strings for the shop's enrolled languages where the default shop language is the first element in the array.
     *
     * @return self
     */
    public function setLanguages($languages)
    {
        if (is_null($languages)) {
            throw new \InvalidArgumentException('non-nullable languages cannot be null');
        }
        $this->container['languages'] = $languages;

        return $this;
    }

    /**
     * Gets icon_url_fullxfull
     *
     * @return string|null
     */
    public function getIconUrlFullxfull()
    {
        return $this->container['icon_url_fullxfull'];
    }

    /**
     * Sets icon_url_fullxfull
     *
     * @param string|null $icon_url_fullxfull The URL string for this shop's icon image.
     *
     * @return self
     */
    public function setIconUrlFullxfull($icon_url_fullxfull)
    {
        if (is_null($icon_url_fullxfull)) {
            array_push($this->openAPINullablesSetToNull, 'icon_url_fullxfull');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('icon_url_fullxfull', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['icon_url_fullxfull'] = $icon_url_fullxfull;

        return $this;
    }

    /**
     * Gets is_using_structured_policies
     *
     * @return bool|null
     */
    public function getIsUsingStructuredPolicies()
    {
        return $this->container['is_using_structured_policies'];
    }

    /**
     * Sets is_using_structured_policies
     *
     * @param bool|null $is_using_structured_policies When true, the shop accepted using structured policies.
     *
     * @return self
     */
    public function setIsUsingStructuredPolicies($is_using_structured_policies)
    {
        if (is_null($is_using_structured_policies)) {
            throw new \InvalidArgumentException('non-nullable is_using_structured_policies cannot be null');
        }
        $this->container['is_using_structured_policies'] = $is_using_structured_policies;

        return $this;
    }

    /**
     * Gets has_onboarded_structured_policies
     *
     * @return bool|null
     */
    public function getHasOnboardedStructuredPolicies()
    {
        return $this->container['has_onboarded_structured_policies'];
    }

    /**
     * Sets has_onboarded_structured_policies
     *
     * @param bool|null $has_onboarded_structured_policies When true, the shop accepted OR declined after viewing structured policies onboarding.
     *
     * @return self
     */
    public function setHasOnboardedStructuredPolicies($has_onboarded_structured_policies)
    {
        if (is_null($has_onboarded_structured_policies)) {
            throw new \InvalidArgumentException('non-nullable has_onboarded_structured_policies cannot be null');
        }
        $this->container['has_onboarded_structured_policies'] = $has_onboarded_structured_policies;

        return $this;
    }

    /**
     * Gets include_dispute_form_link
     *
     * @return bool|null
     */
    public function getIncludeDisputeFormLink()
    {
        return $this->container['include_dispute_form_link'];
    }

    /**
     * Sets include_dispute_form_link
     *
     * @param bool|null $include_dispute_form_link When true, this shop\\'s policies include a link to an EU online dispute form.
     *
     * @return self
     */
    public function setIncludeDisputeFormLink($include_dispute_form_link)
    {
        if (is_null($include_dispute_form_link)) {
            throw new \InvalidArgumentException('non-nullable include_dispute_form_link cannot be null');
        }
        $this->container['include_dispute_form_link'] = $include_dispute_form_link;

        return $this;
    }

    /**
     * Gets is_direct_checkout_onboarded
     *
     * @return bool|null
     */
    public function getIsDirectCheckoutOnboarded()
    {
        return $this->container['is_direct_checkout_onboarded'];
    }

    /**
     * Sets is_direct_checkout_onboarded
     *
     * @param bool|null $is_direct_checkout_onboarded (**DEPRECATED: Replaced by _is_etsy_payments_onboarded_.) When true, the shop has onboarded onto Etsy Payments.
     *
     * @return self
     */
    public function setIsDirectCheckoutOnboarded($is_direct_checkout_onboarded)
    {
        if (is_null($is_direct_checkout_onboarded)) {
            throw new \InvalidArgumentException('non-nullable is_direct_checkout_onboarded cannot be null');
        }
        $this->container['is_direct_checkout_onboarded'] = $is_direct_checkout_onboarded;

        return $this;
    }

    /**
     * Gets is_etsy_payments_onboarded
     *
     * @return bool|null
     */
    public function getIsEtsyPaymentsOnboarded()
    {
        return $this->container['is_etsy_payments_onboarded'];
    }

    /**
     * Sets is_etsy_payments_onboarded
     *
     * @param bool|null $is_etsy_payments_onboarded When true, the shop has onboarded onto Etsy Payments.
     *
     * @return self
     */
    public function setIsEtsyPaymentsOnboarded($is_etsy_payments_onboarded)
    {
        if (is_null($is_etsy_payments_onboarded)) {
            throw new \InvalidArgumentException('non-nullable is_etsy_payments_onboarded cannot be null');
        }
        $this->container['is_etsy_payments_onboarded'] = $is_etsy_payments_onboarded;

        return $this;
    }

    /**
     * Gets is_calculated_eligible
     *
     * @return bool|null
     */
    public function getIsCalculatedEligible()
    {
        return $this->container['is_calculated_eligible'];
    }

    /**
     * Sets is_calculated_eligible
     *
     * @param bool|null $is_calculated_eligible When true, the shop is eligible for calculated shipping profiles. (Only available in the US and Canada)
     *
     * @return self
     */
    public function setIsCalculatedEligible($is_calculated_eligible)
    {
        if (is_null($is_calculated_eligible)) {
            throw new \InvalidArgumentException('non-nullable is_calculated_eligible cannot be null');
        }
        $this->container['is_calculated_eligible'] = $is_calculated_eligible;

        return $this;
    }

    /**
     * Gets is_opted_in_to_buyer_promise
     *
     * @return bool|null
     */
    public function getIsOptedInToBuyerPromise()
    {
        return $this->container['is_opted_in_to_buyer_promise'];
    }

    /**
     * Sets is_opted_in_to_buyer_promise
     *
     * @param bool|null $is_opted_in_to_buyer_promise When true, the shop opted in to buyer promise.
     *
     * @return self
     */
    public function setIsOptedInToBuyerPromise($is_opted_in_to_buyer_promise)
    {
        if (is_null($is_opted_in_to_buyer_promise)) {
            throw new \InvalidArgumentException('non-nullable is_opted_in_to_buyer_promise cannot be null');
        }
        $this->container['is_opted_in_to_buyer_promise'] = $is_opted_in_to_buyer_promise;

        return $this;
    }

    /**
     * Gets is_shop_us_based
     *
     * @return bool|null
     */
    public function getIsShopUsBased()
    {
        return $this->container['is_shop_us_based'];
    }

    /**
     * Sets is_shop_us_based
     *
     * @param bool|null $is_shop_us_based When true, the shop is based in the US.
     *
     * @return self
     */
    public function setIsShopUsBased($is_shop_us_based)
    {
        if (is_null($is_shop_us_based)) {
            throw new \InvalidArgumentException('non-nullable is_shop_us_based cannot be null');
        }
        $this->container['is_shop_us_based'] = $is_shop_us_based;

        return $this;
    }

    /**
     * Gets transaction_sold_count
     *
     * @return int|null
     */
    public function getTransactionSoldCount()
    {
        return $this->container['transaction_sold_count'];
    }

    /**
     * Sets transaction_sold_count
     *
     * @param int|null $transaction_sold_count The total number of sales ([transactions](/documentation/reference#tag/Shop-Receipt-Transactions)) for this shop.
     *
     * @return self
     */
    public function setTransactionSoldCount($transaction_sold_count)
    {
        if (is_null($transaction_sold_count)) {
            throw new \InvalidArgumentException('non-nullable transaction_sold_count cannot be null');
        }

        if (($transaction_sold_count < 0)) {
            throw new \InvalidArgumentException('invalid value for $transaction_sold_count when calling ShopListingWithAssociationsShop., must be bigger than or equal to 0.');
        }

        $this->container['transaction_sold_count'] = $transaction_sold_count;

        return $this;
    }

    /**
     * Gets shipping_from_country_iso
     *
     * @return string|null
     */
    public function getShippingFromCountryIso()
    {
        return $this->container['shipping_from_country_iso'];
    }

    /**
     * Sets shipping_from_country_iso
     *
     * @param string|null $shipping_from_country_iso The country iso the shop is shipping from.
     *
     * @return self
     */
    public function setShippingFromCountryIso($shipping_from_country_iso)
    {
        if (is_null($shipping_from_country_iso)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_from_country_iso');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_from_country_iso', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shipping_from_country_iso'] = $shipping_from_country_iso;

        return $this;
    }

    /**
     * Gets shop_location_country_iso
     *
     * @return string|null
     */
    public function getShopLocationCountryIso()
    {
        return $this->container['shop_location_country_iso'];
    }

    /**
     * Sets shop_location_country_iso
     *
     * @param string|null $shop_location_country_iso The country iso where the shop is located.
     *
     * @return self
     */
    public function setShopLocationCountryIso($shop_location_country_iso)
    {
        if (is_null($shop_location_country_iso)) {
            array_push($this->openAPINullablesSetToNull, 'shop_location_country_iso');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shop_location_country_iso', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shop_location_country_iso'] = $shop_location_country_iso;

        return $this;
    }

    /**
     * Gets review_count
     *
     * @return int|null
     */
    public function getReviewCount()
    {
        return $this->container['review_count'];
    }

    /**
     * Sets review_count
     *
     * @param int|null $review_count Number of reviews of shop listings in the past year.
     *
     * @return self
     */
    public function setReviewCount($review_count)
    {
        if (is_null($review_count)) {
            array_push($this->openAPINullablesSetToNull, 'review_count');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('review_count', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['review_count'] = $review_count;

        return $this;
    }

    /**
     * Gets review_average
     *
     * @return float|null
     */
    public function getReviewAverage()
    {
        return $this->container['review_average'];
    }

    /**
     * Sets review_average
     *
     * @param float|null $review_average Average rating based on reviews of shop listings in the past year.
     *
     * @return self
     */
    public function setReviewAverage($review_average)
    {
        if (is_null($review_average)) {
            array_push($this->openAPINullablesSetToNull, 'review_average');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('review_average', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['review_average'] = $review_average;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


