<?php
/**
 * ShopListingFile
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * ShopListingFile Class Doc Comment
 *
 * @category Class
 * @description A file associated with a digital listing.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ShopListingFile implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ShopListingFile';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'listing_file_id' => 'int',
        'listing_id' => 'int',
        'rank' => 'int',
        'filename' => 'string',
        'filesize' => 'string',
        'size_bytes' => 'int',
        'filetype' => 'string',
        'create_timestamp' => 'int',
        'created_timestamp' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'listing_file_id' => null,
        'listing_id' => null,
        'rank' => null,
        'filename' => null,
        'filesize' => null,
        'size_bytes' => null,
        'filetype' => null,
        'create_timestamp' => null,
        'created_timestamp' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'listing_file_id' => false,
		'listing_id' => false,
		'rank' => false,
		'filename' => false,
		'filesize' => false,
		'size_bytes' => false,
		'filetype' => false,
		'create_timestamp' => false,
		'created_timestamp' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'listing_file_id' => 'listing_file_id',
        'listing_id' => 'listing_id',
        'rank' => 'rank',
        'filename' => 'filename',
        'filesize' => 'filesize',
        'size_bytes' => 'size_bytes',
        'filetype' => 'filetype',
        'create_timestamp' => 'create_timestamp',
        'created_timestamp' => 'created_timestamp'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'listing_file_id' => 'setListingFileId',
        'listing_id' => 'setListingId',
        'rank' => 'setRank',
        'filename' => 'setFilename',
        'filesize' => 'setFilesize',
        'size_bytes' => 'setSizeBytes',
        'filetype' => 'setFiletype',
        'create_timestamp' => 'setCreateTimestamp',
        'created_timestamp' => 'setCreatedTimestamp'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'listing_file_id' => 'getListingFileId',
        'listing_id' => 'getListingId',
        'rank' => 'getRank',
        'filename' => 'getFilename',
        'filesize' => 'getFilesize',
        'size_bytes' => 'getSizeBytes',
        'filetype' => 'getFiletype',
        'create_timestamp' => 'getCreateTimestamp',
        'created_timestamp' => 'getCreatedTimestamp'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('listing_file_id', $data ?? [], null);
        $this->setIfExists('listing_id', $data ?? [], null);
        $this->setIfExists('rank', $data ?? [], null);
        $this->setIfExists('filename', $data ?? [], null);
        $this->setIfExists('filesize', $data ?? [], null);
        $this->setIfExists('size_bytes', $data ?? [], null);
        $this->setIfExists('filetype', $data ?? [], null);
        $this->setIfExists('create_timestamp', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['listing_file_id']) && ($this->container['listing_file_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'listing_file_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['listing_id']) && ($this->container['listing_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'listing_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['rank']) && ($this->container['rank'] < 0)) {
            $invalidProperties[] = "invalid value for 'rank', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['size_bytes']) && ($this->container['size_bytes'] < 0)) {
            $invalidProperties[] = "invalid value for 'size_bytes', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['create_timestamp']) && ($this->container['create_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'create_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 946684800.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets listing_file_id
     *
     * @return int|null
     */
    public function getListingFileId()
    {
        return $this->container['listing_file_id'];
    }

    /**
     * Sets listing_file_id
     *
     * @param int|null $listing_file_id The unique numeric ID of a file associated with a digital listing.
     *
     * @return self
     */
    public function setListingFileId($listing_file_id)
    {
        if (is_null($listing_file_id)) {
            throw new \InvalidArgumentException('non-nullable listing_file_id cannot be null');
        }

        if (($listing_file_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $listing_file_id when calling ShopListingFile., must be bigger than or equal to 1.');
        }

        $this->container['listing_file_id'] = $listing_file_id;

        return $this;
    }

    /**
     * Gets listing_id
     *
     * @return int|null
     */
    public function getListingId()
    {
        return $this->container['listing_id'];
    }

    /**
     * Sets listing_id
     *
     * @param int|null $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
     *
     * @return self
     */
    public function setListingId($listing_id)
    {
        if (is_null($listing_id)) {
            throw new \InvalidArgumentException('non-nullable listing_id cannot be null');
        }

        if (($listing_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $listing_id when calling ShopListingFile., must be bigger than or equal to 1.');
        }

        $this->container['listing_id'] = $listing_id;

        return $this;
    }

    /**
     * Gets rank
     *
     * @return int|null
     */
    public function getRank()
    {
        return $this->container['rank'];
    }

    /**
     * Sets rank
     *
     * @param int|null $rank The numeric index of the display order position of this file in the listing, starting at 1.
     *
     * @return self
     */
    public function setRank($rank)
    {
        if (is_null($rank)) {
            throw new \InvalidArgumentException('non-nullable rank cannot be null');
        }

        if (($rank < 0)) {
            throw new \InvalidArgumentException('invalid value for $rank when calling ShopListingFile., must be bigger than or equal to 0.');
        }

        $this->container['rank'] = $rank;

        return $this;
    }

    /**
     * Gets filename
     *
     * @return string|null
     */
    public function getFilename()
    {
        return $this->container['filename'];
    }

    /**
     * Sets filename
     *
     * @param string|null $filename The file name string for a file associated with a digital listing.
     *
     * @return self
     */
    public function setFilename($filename)
    {
        if (is_null($filename)) {
            throw new \InvalidArgumentException('non-nullable filename cannot be null');
        }
        $this->container['filename'] = $filename;

        return $this;
    }

    /**
     * Gets filesize
     *
     * @return string|null
     */
    public function getFilesize()
    {
        return $this->container['filesize'];
    }

    /**
     * Sets filesize
     *
     * @param string|null $filesize A human-readable format size string for the size of a file.
     *
     * @return self
     */
    public function setFilesize($filesize)
    {
        if (is_null($filesize)) {
            throw new \InvalidArgumentException('non-nullable filesize cannot be null');
        }
        $this->container['filesize'] = $filesize;

        return $this;
    }

    /**
     * Gets size_bytes
     *
     * @return int|null
     */
    public function getSizeBytes()
    {
        return $this->container['size_bytes'];
    }

    /**
     * Sets size_bytes
     *
     * @param int|null $size_bytes A number indicating the size of a file, measured in bytes.
     *
     * @return self
     */
    public function setSizeBytes($size_bytes)
    {
        if (is_null($size_bytes)) {
            throw new \InvalidArgumentException('non-nullable size_bytes cannot be null');
        }

        if (($size_bytes < 0)) {
            throw new \InvalidArgumentException('invalid value for $size_bytes when calling ShopListingFile., must be bigger than or equal to 0.');
        }

        $this->container['size_bytes'] = $size_bytes;

        return $this;
    }

    /**
     * Gets filetype
     *
     * @return string|null
     */
    public function getFiletype()
    {
        return $this->container['filetype'];
    }

    /**
     * Sets filetype
     *
     * @param string|null $filetype A type string indicating a file's MIME type.
     *
     * @return self
     */
    public function setFiletype($filetype)
    {
        if (is_null($filetype)) {
            throw new \InvalidArgumentException('non-nullable filetype cannot be null');
        }
        $this->container['filetype'] = $filetype;

        return $this;
    }

    /**
     * Gets create_timestamp
     *
     * @return int|null
     */
    public function getCreateTimestamp()
    {
        return $this->container['create_timestamp'];
    }

    /**
     * Sets create_timestamp
     *
     * @param int|null $create_timestamp The unique numeric ID of a file associated with a digital listing.
     *
     * @return self
     */
    public function setCreateTimestamp($create_timestamp)
    {
        if (is_null($create_timestamp)) {
            throw new \InvalidArgumentException('non-nullable create_timestamp cannot be null');
        }

        if (($create_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $create_timestamp when calling ShopListingFile., must be bigger than or equal to 946684800.');
        }

        $this->container['create_timestamp'] = $create_timestamp;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The unique numeric ID of a file associated with a digital listing.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling ShopListingFile., must be bigger than or equal to 946684800.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


