<?php
/**
 * PaymentsResultsInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * PaymentsResultsInner Class Doc Comment
 *
 * @category Class
 * @description A list of payments.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentsResultsInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Payments_results_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'payment_id' => 'int',
        'buyer_user_id' => 'int',
        'shop_id' => 'int',
        'receipt_id' => 'int',
        'amount_gross' => '\Etsy\Model\PaymentAmountGross',
        'amount_fees' => '\Etsy\Model\PaymentAmountFees',
        'amount_net' => '\Etsy\Model\PaymentAmountNet',
        'posted_gross' => '\Etsy\Model\PaymentPostedGross',
        'posted_fees' => '\Etsy\Model\PaymentPostedFees',
        'posted_net' => '\Etsy\Model\PaymentPostedNet',
        'adjusted_gross' => '\Etsy\Model\PaymentAdjustedGross',
        'adjusted_fees' => '\Etsy\Model\PaymentAdjustedFees',
        'adjusted_net' => '\Etsy\Model\PaymentAdjustedNet',
        'currency' => 'string',
        'shop_currency' => 'string',
        'buyer_currency' => 'string',
        'shipping_user_id' => 'int',
        'shipping_address_id' => 'int',
        'billing_address_id' => 'int',
        'status' => 'string',
        'shipped_timestamp' => 'int',
        'create_timestamp' => 'int',
        'created_timestamp' => 'int',
        'update_timestamp' => 'int',
        'updated_timestamp' => 'int',
        'payment_adjustments' => '\Etsy\Model\PaymentAccountLedgerEntryPaymentAdjustmentsInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'payment_id' => null,
        'buyer_user_id' => null,
        'shop_id' => null,
        'receipt_id' => null,
        'amount_gross' => null,
        'amount_fees' => null,
        'amount_net' => null,
        'posted_gross' => null,
        'posted_fees' => null,
        'posted_net' => null,
        'adjusted_gross' => null,
        'adjusted_fees' => null,
        'adjusted_net' => null,
        'currency' => null,
        'shop_currency' => null,
        'buyer_currency' => null,
        'shipping_user_id' => null,
        'shipping_address_id' => null,
        'billing_address_id' => null,
        'status' => null,
        'shipped_timestamp' => null,
        'create_timestamp' => null,
        'created_timestamp' => null,
        'update_timestamp' => null,
        'updated_timestamp' => null,
        'payment_adjustments' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'payment_id' => false,
		'buyer_user_id' => false,
		'shop_id' => false,
		'receipt_id' => false,
		'amount_gross' => false,
		'amount_fees' => false,
		'amount_net' => false,
		'posted_gross' => false,
		'posted_fees' => false,
		'posted_net' => false,
		'adjusted_gross' => false,
		'adjusted_fees' => false,
		'adjusted_net' => false,
		'currency' => false,
		'shop_currency' => true,
		'buyer_currency' => true,
		'shipping_user_id' => true,
		'shipping_address_id' => false,
		'billing_address_id' => false,
		'status' => false,
		'shipped_timestamp' => true,
		'create_timestamp' => false,
		'created_timestamp' => false,
		'update_timestamp' => false,
		'updated_timestamp' => false,
		'payment_adjustments' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'payment_id' => 'payment_id',
        'buyer_user_id' => 'buyer_user_id',
        'shop_id' => 'shop_id',
        'receipt_id' => 'receipt_id',
        'amount_gross' => 'amount_gross',
        'amount_fees' => 'amount_fees',
        'amount_net' => 'amount_net',
        'posted_gross' => 'posted_gross',
        'posted_fees' => 'posted_fees',
        'posted_net' => 'posted_net',
        'adjusted_gross' => 'adjusted_gross',
        'adjusted_fees' => 'adjusted_fees',
        'adjusted_net' => 'adjusted_net',
        'currency' => 'currency',
        'shop_currency' => 'shop_currency',
        'buyer_currency' => 'buyer_currency',
        'shipping_user_id' => 'shipping_user_id',
        'shipping_address_id' => 'shipping_address_id',
        'billing_address_id' => 'billing_address_id',
        'status' => 'status',
        'shipped_timestamp' => 'shipped_timestamp',
        'create_timestamp' => 'create_timestamp',
        'created_timestamp' => 'created_timestamp',
        'update_timestamp' => 'update_timestamp',
        'updated_timestamp' => 'updated_timestamp',
        'payment_adjustments' => 'payment_adjustments'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'payment_id' => 'setPaymentId',
        'buyer_user_id' => 'setBuyerUserId',
        'shop_id' => 'setShopId',
        'receipt_id' => 'setReceiptId',
        'amount_gross' => 'setAmountGross',
        'amount_fees' => 'setAmountFees',
        'amount_net' => 'setAmountNet',
        'posted_gross' => 'setPostedGross',
        'posted_fees' => 'setPostedFees',
        'posted_net' => 'setPostedNet',
        'adjusted_gross' => 'setAdjustedGross',
        'adjusted_fees' => 'setAdjustedFees',
        'adjusted_net' => 'setAdjustedNet',
        'currency' => 'setCurrency',
        'shop_currency' => 'setShopCurrency',
        'buyer_currency' => 'setBuyerCurrency',
        'shipping_user_id' => 'setShippingUserId',
        'shipping_address_id' => 'setShippingAddressId',
        'billing_address_id' => 'setBillingAddressId',
        'status' => 'setStatus',
        'shipped_timestamp' => 'setShippedTimestamp',
        'create_timestamp' => 'setCreateTimestamp',
        'created_timestamp' => 'setCreatedTimestamp',
        'update_timestamp' => 'setUpdateTimestamp',
        'updated_timestamp' => 'setUpdatedTimestamp',
        'payment_adjustments' => 'setPaymentAdjustments'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'payment_id' => 'getPaymentId',
        'buyer_user_id' => 'getBuyerUserId',
        'shop_id' => 'getShopId',
        'receipt_id' => 'getReceiptId',
        'amount_gross' => 'getAmountGross',
        'amount_fees' => 'getAmountFees',
        'amount_net' => 'getAmountNet',
        'posted_gross' => 'getPostedGross',
        'posted_fees' => 'getPostedFees',
        'posted_net' => 'getPostedNet',
        'adjusted_gross' => 'getAdjustedGross',
        'adjusted_fees' => 'getAdjustedFees',
        'adjusted_net' => 'getAdjustedNet',
        'currency' => 'getCurrency',
        'shop_currency' => 'getShopCurrency',
        'buyer_currency' => 'getBuyerCurrency',
        'shipping_user_id' => 'getShippingUserId',
        'shipping_address_id' => 'getShippingAddressId',
        'billing_address_id' => 'getBillingAddressId',
        'status' => 'getStatus',
        'shipped_timestamp' => 'getShippedTimestamp',
        'create_timestamp' => 'getCreateTimestamp',
        'created_timestamp' => 'getCreatedTimestamp',
        'update_timestamp' => 'getUpdateTimestamp',
        'updated_timestamp' => 'getUpdatedTimestamp',
        'payment_adjustments' => 'getPaymentAdjustments'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('payment_id', $data ?? [], null);
        $this->setIfExists('buyer_user_id', $data ?? [], null);
        $this->setIfExists('shop_id', $data ?? [], null);
        $this->setIfExists('receipt_id', $data ?? [], null);
        $this->setIfExists('amount_gross', $data ?? [], null);
        $this->setIfExists('amount_fees', $data ?? [], null);
        $this->setIfExists('amount_net', $data ?? [], null);
        $this->setIfExists('posted_gross', $data ?? [], null);
        $this->setIfExists('posted_fees', $data ?? [], null);
        $this->setIfExists('posted_net', $data ?? [], null);
        $this->setIfExists('adjusted_gross', $data ?? [], null);
        $this->setIfExists('adjusted_fees', $data ?? [], null);
        $this->setIfExists('adjusted_net', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('shop_currency', $data ?? [], null);
        $this->setIfExists('buyer_currency', $data ?? [], null);
        $this->setIfExists('shipping_user_id', $data ?? [], null);
        $this->setIfExists('shipping_address_id', $data ?? [], null);
        $this->setIfExists('billing_address_id', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('shipped_timestamp', $data ?? [], null);
        $this->setIfExists('create_timestamp', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('update_timestamp', $data ?? [], null);
        $this->setIfExists('updated_timestamp', $data ?? [], null);
        $this->setIfExists('payment_adjustments', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['payment_id']) && ($this->container['payment_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'payment_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['buyer_user_id']) && ($this->container['buyer_user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'buyer_user_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['shop_id']) && ($this->container['shop_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shop_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['receipt_id']) && ($this->container['receipt_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'receipt_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['shipping_user_id']) && ($this->container['shipping_user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shipping_user_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['shipping_address_id']) && ($this->container['shipping_address_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'shipping_address_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['billing_address_id']) && ($this->container['billing_address_id'] > 9223372036854775807)) {
            $invalidProperties[] = "invalid value for 'billing_address_id', must be smaller than or equal to 9223372036854775807.";
        }

        if (!is_null($this->container['billing_address_id']) && ($this->container['billing_address_id'] < 0)) {
            $invalidProperties[] = "invalid value for 'billing_address_id', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['shipped_timestamp']) && ($this->container['shipped_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'shipped_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['create_timestamp']) && ($this->container['create_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'create_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['update_timestamp']) && ($this->container['update_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'update_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['updated_timestamp']) && ($this->container['updated_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'updated_timestamp', must be bigger than or equal to 946684800.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets payment_id
     *
     * @return int|null
     */
    public function getPaymentId()
    {
        return $this->container['payment_id'];
    }

    /**
     * Sets payment_id
     *
     * @param int|null $payment_id A unique numeric ID for a payment to a specific Etsy [shop](/documentation/reference#tag/Shop).
     *
     * @return self
     */
    public function setPaymentId($payment_id)
    {
        if (is_null($payment_id)) {
            throw new \InvalidArgumentException('non-nullable payment_id cannot be null');
        }

        if (($payment_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $payment_id when calling PaymentsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['payment_id'] = $payment_id;

        return $this;
    }

    /**
     * Gets buyer_user_id
     *
     * @return int|null
     */
    public function getBuyerUserId()
    {
        return $this->container['buyer_user_id'];
    }

    /**
     * Sets buyer_user_id
     *
     * @param int|null $buyer_user_id The numeric ID for the [user](/documentation/reference#tag/User) who paid the purchase.
     *
     * @return self
     */
    public function setBuyerUserId($buyer_user_id)
    {
        if (is_null($buyer_user_id)) {
            throw new \InvalidArgumentException('non-nullable buyer_user_id cannot be null');
        }

        if (($buyer_user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $buyer_user_id when calling PaymentsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['buyer_user_id'] = $buyer_user_id;

        return $this;
    }

    /**
     * Gets shop_id
     *
     * @return int|null
     */
    public function getShopId()
    {
        return $this->container['shop_id'];
    }

    /**
     * Sets shop_id
     *
     * @param int|null $shop_id The unique positive non-zero numeric ID for an Etsy Shop.
     *
     * @return self
     */
    public function setShopId($shop_id)
    {
        if (is_null($shop_id)) {
            throw new \InvalidArgumentException('non-nullable shop_id cannot be null');
        }

        if (($shop_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shop_id when calling PaymentsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['shop_id'] = $shop_id;

        return $this;
    }

    /**
     * Gets receipt_id
     *
     * @return int|null
     */
    public function getReceiptId()
    {
        return $this->container['receipt_id'];
    }

    /**
     * Sets receipt_id
     *
     * @param int|null $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction.
     *
     * @return self
     */
    public function setReceiptId($receipt_id)
    {
        if (is_null($receipt_id)) {
            throw new \InvalidArgumentException('non-nullable receipt_id cannot be null');
        }

        if (($receipt_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $receipt_id when calling PaymentsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['receipt_id'] = $receipt_id;

        return $this;
    }

    /**
     * Gets amount_gross
     *
     * @return \Etsy\Model\PaymentAmountGross|null
     */
    public function getAmountGross()
    {
        return $this->container['amount_gross'];
    }

    /**
     * Sets amount_gross
     *
     * @param \Etsy\Model\PaymentAmountGross|null $amount_gross amount_gross
     *
     * @return self
     */
    public function setAmountGross($amount_gross)
    {
        if (is_null($amount_gross)) {
            throw new \InvalidArgumentException('non-nullable amount_gross cannot be null');
        }
        $this->container['amount_gross'] = $amount_gross;

        return $this;
    }

    /**
     * Gets amount_fees
     *
     * @return \Etsy\Model\PaymentAmountFees|null
     */
    public function getAmountFees()
    {
        return $this->container['amount_fees'];
    }

    /**
     * Sets amount_fees
     *
     * @param \Etsy\Model\PaymentAmountFees|null $amount_fees amount_fees
     *
     * @return self
     */
    public function setAmountFees($amount_fees)
    {
        if (is_null($amount_fees)) {
            throw new \InvalidArgumentException('non-nullable amount_fees cannot be null');
        }
        $this->container['amount_fees'] = $amount_fees;

        return $this;
    }

    /**
     * Gets amount_net
     *
     * @return \Etsy\Model\PaymentAmountNet|null
     */
    public function getAmountNet()
    {
        return $this->container['amount_net'];
    }

    /**
     * Sets amount_net
     *
     * @param \Etsy\Model\PaymentAmountNet|null $amount_net amount_net
     *
     * @return self
     */
    public function setAmountNet($amount_net)
    {
        if (is_null($amount_net)) {
            throw new \InvalidArgumentException('non-nullable amount_net cannot be null');
        }
        $this->container['amount_net'] = $amount_net;

        return $this;
    }

    /**
     * Gets posted_gross
     *
     * @return \Etsy\Model\PaymentPostedGross|null
     */
    public function getPostedGross()
    {
        return $this->container['posted_gross'];
    }

    /**
     * Sets posted_gross
     *
     * @param \Etsy\Model\PaymentPostedGross|null $posted_gross posted_gross
     *
     * @return self
     */
    public function setPostedGross($posted_gross)
    {
        if (is_null($posted_gross)) {
            throw new \InvalidArgumentException('non-nullable posted_gross cannot be null');
        }
        $this->container['posted_gross'] = $posted_gross;

        return $this;
    }

    /**
     * Gets posted_fees
     *
     * @return \Etsy\Model\PaymentPostedFees|null
     */
    public function getPostedFees()
    {
        return $this->container['posted_fees'];
    }

    /**
     * Sets posted_fees
     *
     * @param \Etsy\Model\PaymentPostedFees|null $posted_fees posted_fees
     *
     * @return self
     */
    public function setPostedFees($posted_fees)
    {
        if (is_null($posted_fees)) {
            throw new \InvalidArgumentException('non-nullable posted_fees cannot be null');
        }
        $this->container['posted_fees'] = $posted_fees;

        return $this;
    }

    /**
     * Gets posted_net
     *
     * @return \Etsy\Model\PaymentPostedNet|null
     */
    public function getPostedNet()
    {
        return $this->container['posted_net'];
    }

    /**
     * Sets posted_net
     *
     * @param \Etsy\Model\PaymentPostedNet|null $posted_net posted_net
     *
     * @return self
     */
    public function setPostedNet($posted_net)
    {
        if (is_null($posted_net)) {
            throw new \InvalidArgumentException('non-nullable posted_net cannot be null');
        }
        $this->container['posted_net'] = $posted_net;

        return $this;
    }

    /**
     * Gets adjusted_gross
     *
     * @return \Etsy\Model\PaymentAdjustedGross|null
     */
    public function getAdjustedGross()
    {
        return $this->container['adjusted_gross'];
    }

    /**
     * Sets adjusted_gross
     *
     * @param \Etsy\Model\PaymentAdjustedGross|null $adjusted_gross adjusted_gross
     *
     * @return self
     */
    public function setAdjustedGross($adjusted_gross)
    {
        if (is_null($adjusted_gross)) {
            throw new \InvalidArgumentException('non-nullable adjusted_gross cannot be null');
        }
        $this->container['adjusted_gross'] = $adjusted_gross;

        return $this;
    }

    /**
     * Gets adjusted_fees
     *
     * @return \Etsy\Model\PaymentAdjustedFees|null
     */
    public function getAdjustedFees()
    {
        return $this->container['adjusted_fees'];
    }

    /**
     * Sets adjusted_fees
     *
     * @param \Etsy\Model\PaymentAdjustedFees|null $adjusted_fees adjusted_fees
     *
     * @return self
     */
    public function setAdjustedFees($adjusted_fees)
    {
        if (is_null($adjusted_fees)) {
            throw new \InvalidArgumentException('non-nullable adjusted_fees cannot be null');
        }
        $this->container['adjusted_fees'] = $adjusted_fees;

        return $this;
    }

    /**
     * Gets adjusted_net
     *
     * @return \Etsy\Model\PaymentAdjustedNet|null
     */
    public function getAdjustedNet()
    {
        return $this->container['adjusted_net'];
    }

    /**
     * Sets adjusted_net
     *
     * @param \Etsy\Model\PaymentAdjustedNet|null $adjusted_net adjusted_net
     *
     * @return self
     */
    public function setAdjustedNet($adjusted_net)
    {
        if (is_null($adjusted_net)) {
            throw new \InvalidArgumentException('non-nullable adjusted_net cannot be null');
        }
        $this->container['adjusted_net'] = $adjusted_net;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency The ISO (alphabetic) code string for the payment's currency.
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets shop_currency
     *
     * @return string|null
     */
    public function getShopCurrency()
    {
        return $this->container['shop_currency'];
    }

    /**
     * Sets shop_currency
     *
     * @param string|null $shop_currency The ISO (alphabetic) code for the shop's currency. The shop displays all prices in this currency by default.
     *
     * @return self
     */
    public function setShopCurrency($shop_currency)
    {
        if (is_null($shop_currency)) {
            array_push($this->openAPINullablesSetToNull, 'shop_currency');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shop_currency', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['shop_currency'] = $shop_currency;

        return $this;
    }

    /**
     * Gets buyer_currency
     *
     * @return string|null
     */
    public function getBuyerCurrency()
    {
        return $this->container['buyer_currency'];
    }

    /**
     * Sets buyer_currency
     *
     * @param string|null $buyer_currency The currency string of the buyer.
     *
     * @return self
     */
    public function setBuyerCurrency($buyer_currency)
    {
        if (is_null($buyer_currency)) {
            array_push($this->openAPINullablesSetToNull, 'buyer_currency');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('buyer_currency', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['buyer_currency'] = $buyer_currency;

        return $this;
    }

    /**
     * Gets shipping_user_id
     *
     * @return int|null
     */
    public function getShippingUserId()
    {
        return $this->container['shipping_user_id'];
    }

    /**
     * Sets shipping_user_id
     *
     * @param int|null $shipping_user_id The numeric ID of the user to which the seller ships the order.
     *
     * @return self
     */
    public function setShippingUserId($shipping_user_id)
    {
        if (is_null($shipping_user_id)) {
            array_push($this->openAPINullablesSetToNull, 'shipping_user_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipping_user_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($shipping_user_id) && ($shipping_user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shipping_user_id when calling PaymentsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['shipping_user_id'] = $shipping_user_id;

        return $this;
    }

    /**
     * Gets shipping_address_id
     *
     * @return int|null
     */
    public function getShippingAddressId()
    {
        return $this->container['shipping_address_id'];
    }

    /**
     * Sets shipping_address_id
     *
     * @param int|null $shipping_address_id The numeric id identifying the shipping address.
     *
     * @return self
     */
    public function setShippingAddressId($shipping_address_id)
    {
        if (is_null($shipping_address_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_address_id cannot be null');
        }

        if (($shipping_address_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $shipping_address_id when calling PaymentsResultsInner., must be bigger than or equal to 1.');
        }

        $this->container['shipping_address_id'] = $shipping_address_id;

        return $this;
    }

    /**
     * Gets billing_address_id
     *
     * @return int|null
     */
    public function getBillingAddressId()
    {
        return $this->container['billing_address_id'];
    }

    /**
     * Sets billing_address_id
     *
     * @param int|null $billing_address_id The numeric ID identifying the billing address of the buyer.
     *
     * @return self
     */
    public function setBillingAddressId($billing_address_id)
    {
        if (is_null($billing_address_id)) {
            throw new \InvalidArgumentException('non-nullable billing_address_id cannot be null');
        }

        if (($billing_address_id > 9223372036854775807)) {
            throw new \InvalidArgumentException('invalid value for $billing_address_id when calling PaymentsResultsInner., must be smaller than or equal to 9223372036854775807.');
        }
        if (($billing_address_id < 0)) {
            throw new \InvalidArgumentException('invalid value for $billing_address_id when calling PaymentsResultsInner., must be bigger than or equal to 0.');
        }

        $this->container['billing_address_id'] = $billing_address_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status A string indicating the current status of the payment, most commonly \"settled\" or \"authed\".
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets shipped_timestamp
     *
     * @return int|null
     */
    public function getShippedTimestamp()
    {
        return $this->container['shipped_timestamp'];
    }

    /**
     * Sets shipped_timestamp
     *
     * @param int|null $shipped_timestamp The transaction\\'s shipping date and time, in epoch seconds.
     *
     * @return self
     */
    public function setShippedTimestamp($shipped_timestamp)
    {
        if (is_null($shipped_timestamp)) {
            array_push($this->openAPINullablesSetToNull, 'shipped_timestamp');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shipped_timestamp', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($shipped_timestamp) && ($shipped_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $shipped_timestamp when calling PaymentsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['shipped_timestamp'] = $shipped_timestamp;

        return $this;
    }

    /**
     * Gets create_timestamp
     *
     * @return int|null
     */
    public function getCreateTimestamp()
    {
        return $this->container['create_timestamp'];
    }

    /**
     * Sets create_timestamp
     *
     * @param int|null $create_timestamp The transaction\\'s creation date and time, in epoch seconds.
     *
     * @return self
     */
    public function setCreateTimestamp($create_timestamp)
    {
        if (is_null($create_timestamp)) {
            throw new \InvalidArgumentException('non-nullable create_timestamp cannot be null');
        }

        if (($create_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $create_timestamp when calling PaymentsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['create_timestamp'] = $create_timestamp;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The transaction\\'s creation date and time, in epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling PaymentsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets update_timestamp
     *
     * @return int|null
     */
    public function getUpdateTimestamp()
    {
        return $this->container['update_timestamp'];
    }

    /**
     * Sets update_timestamp
     *
     * @param int|null $update_timestamp The date and time of the last change to the payment adjustment in epoch seconds.
     *
     * @return self
     */
    public function setUpdateTimestamp($update_timestamp)
    {
        if (is_null($update_timestamp)) {
            throw new \InvalidArgumentException('non-nullable update_timestamp cannot be null');
        }

        if (($update_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $update_timestamp when calling PaymentsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['update_timestamp'] = $update_timestamp;

        return $this;
    }

    /**
     * Gets updated_timestamp
     *
     * @return int|null
     */
    public function getUpdatedTimestamp()
    {
        return $this->container['updated_timestamp'];
    }

    /**
     * Sets updated_timestamp
     *
     * @param int|null $updated_timestamp The date and time of the last change to the payment adjustment in epoch seconds.
     *
     * @return self
     */
    public function setUpdatedTimestamp($updated_timestamp)
    {
        if (is_null($updated_timestamp)) {
            throw new \InvalidArgumentException('non-nullable updated_timestamp cannot be null');
        }

        if (($updated_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $updated_timestamp when calling PaymentsResultsInner., must be bigger than or equal to 946684800.');
        }

        $this->container['updated_timestamp'] = $updated_timestamp;

        return $this;
    }

    /**
     * Gets payment_adjustments
     *
     * @return \Etsy\Model\PaymentAccountLedgerEntryPaymentAdjustmentsInner[]|null
     */
    public function getPaymentAdjustments()
    {
        return $this->container['payment_adjustments'];
    }

    /**
     * Sets payment_adjustments
     *
     * @param \Etsy\Model\PaymentAccountLedgerEntryPaymentAdjustmentsInner[]|null $payment_adjustments List of refund objects on an Etsy Payments transaction. All monetary amounts are in USD pennies unless otherwise specified.
     *
     * @return self
     */
    public function setPaymentAdjustments($payment_adjustments)
    {
        if (is_null($payment_adjustments)) {
            throw new \InvalidArgumentException('non-nullable payment_adjustments cannot be null');
        }
        $this->container['payment_adjustments'] = $payment_adjustments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


