<?php
/**
 * PaymentAdjustmentItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * PaymentAdjustmentItem Class Doc Comment
 *
 * @category Class
 * @description A payemnt adjustment line item for a payment adjustment.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentAdjustmentItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentAdjustmentItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'payment_adjustment_id' => 'int',
        'payment_adjustment_item_id' => 'int',
        'adjustment_type' => 'string',
        'amount' => 'int',
        'shop_amount' => 'int',
        'transaction_id' => 'int',
        'bill_payment_id' => 'int',
        'created_timestamp' => 'int',
        'updated_timestamp' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'payment_adjustment_id' => null,
        'payment_adjustment_item_id' => null,
        'adjustment_type' => null,
        'amount' => null,
        'shop_amount' => null,
        'transaction_id' => null,
        'bill_payment_id' => null,
        'created_timestamp' => null,
        'updated_timestamp' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'payment_adjustment_id' => false,
		'payment_adjustment_item_id' => false,
		'adjustment_type' => true,
		'amount' => false,
		'shop_amount' => false,
		'transaction_id' => true,
		'bill_payment_id' => true,
		'created_timestamp' => false,
		'updated_timestamp' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'payment_adjustment_id' => 'payment_adjustment_id',
        'payment_adjustment_item_id' => 'payment_adjustment_item_id',
        'adjustment_type' => 'adjustment_type',
        'amount' => 'amount',
        'shop_amount' => 'shop_amount',
        'transaction_id' => 'transaction_id',
        'bill_payment_id' => 'bill_payment_id',
        'created_timestamp' => 'created_timestamp',
        'updated_timestamp' => 'updated_timestamp'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'payment_adjustment_id' => 'setPaymentAdjustmentId',
        'payment_adjustment_item_id' => 'setPaymentAdjustmentItemId',
        'adjustment_type' => 'setAdjustmentType',
        'amount' => 'setAmount',
        'shop_amount' => 'setShopAmount',
        'transaction_id' => 'setTransactionId',
        'bill_payment_id' => 'setBillPaymentId',
        'created_timestamp' => 'setCreatedTimestamp',
        'updated_timestamp' => 'setUpdatedTimestamp'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'payment_adjustment_id' => 'getPaymentAdjustmentId',
        'payment_adjustment_item_id' => 'getPaymentAdjustmentItemId',
        'adjustment_type' => 'getAdjustmentType',
        'amount' => 'getAmount',
        'shop_amount' => 'getShopAmount',
        'transaction_id' => 'getTransactionId',
        'bill_payment_id' => 'getBillPaymentId',
        'created_timestamp' => 'getCreatedTimestamp',
        'updated_timestamp' => 'getUpdatedTimestamp'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('payment_adjustment_id', $data ?? [], null);
        $this->setIfExists('payment_adjustment_item_id', $data ?? [], null);
        $this->setIfExists('adjustment_type', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], 0);
        $this->setIfExists('shop_amount', $data ?? [], 0);
        $this->setIfExists('transaction_id', $data ?? [], null);
        $this->setIfExists('bill_payment_id', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('updated_timestamp', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['payment_adjustment_id']) && ($this->container['payment_adjustment_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'payment_adjustment_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['payment_adjustment_item_id']) && ($this->container['payment_adjustment_item_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'payment_adjustment_item_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['transaction_id']) && ($this->container['transaction_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'transaction_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['bill_payment_id']) && ($this->container['bill_payment_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'bill_payment_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['updated_timestamp']) && ($this->container['updated_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'updated_timestamp', must be bigger than or equal to 946684800.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets payment_adjustment_id
     *
     * @return int|null
     */
    public function getPaymentAdjustmentId()
    {
        return $this->container['payment_adjustment_id'];
    }

    /**
     * Sets payment_adjustment_id
     *
     * @param int|null $payment_adjustment_id The numeric ID for a payment adjustment.
     *
     * @return self
     */
    public function setPaymentAdjustmentId($payment_adjustment_id)
    {
        if (is_null($payment_adjustment_id)) {
            throw new \InvalidArgumentException('non-nullable payment_adjustment_id cannot be null');
        }

        if (($payment_adjustment_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $payment_adjustment_id when calling PaymentAdjustmentItem., must be bigger than or equal to 1.');
        }

        $this->container['payment_adjustment_id'] = $payment_adjustment_id;

        return $this;
    }

    /**
     * Gets payment_adjustment_item_id
     *
     * @return int|null
     */
    public function getPaymentAdjustmentItemId()
    {
        return $this->container['payment_adjustment_item_id'];
    }

    /**
     * Sets payment_adjustment_item_id
     *
     * @param int|null $payment_adjustment_item_id Unique ID for the adjustment line item.
     *
     * @return self
     */
    public function setPaymentAdjustmentItemId($payment_adjustment_item_id)
    {
        if (is_null($payment_adjustment_item_id)) {
            throw new \InvalidArgumentException('non-nullable payment_adjustment_item_id cannot be null');
        }

        if (($payment_adjustment_item_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $payment_adjustment_item_id when calling PaymentAdjustmentItem., must be bigger than or equal to 1.');
        }

        $this->container['payment_adjustment_item_id'] = $payment_adjustment_item_id;

        return $this;
    }

    /**
     * Gets adjustment_type
     *
     * @return string|null
     */
    public function getAdjustmentType()
    {
        return $this->container['adjustment_type'];
    }

    /**
     * Sets adjustment_type
     *
     * @param string|null $adjustment_type String indicating the type of adjustment for this line item.
     *
     * @return self
     */
    public function setAdjustmentType($adjustment_type)
    {
        if (is_null($adjustment_type)) {
            array_push($this->openAPINullablesSetToNull, 'adjustment_type');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('adjustment_type', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['adjustment_type'] = $adjustment_type;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return int|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param int|null $amount Integer value for the amount of the adjustment in original currency.
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets shop_amount
     *
     * @return int|null
     */
    public function getShopAmount()
    {
        return $this->container['shop_amount'];
    }

    /**
     * Sets shop_amount
     *
     * @param int|null $shop_amount Integer value for the amount of the adjustment in currency for the shop.
     *
     * @return self
     */
    public function setShopAmount($shop_amount)
    {
        if (is_null($shop_amount)) {
            throw new \InvalidArgumentException('non-nullable shop_amount cannot be null');
        }
        $this->container['shop_amount'] = $shop_amount;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return int|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param int|null $transaction_id The unique numeric ID for a transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        if (is_null($transaction_id)) {
            array_push($this->openAPINullablesSetToNull, 'transaction_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('transaction_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($transaction_id) && ($transaction_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $transaction_id when calling PaymentAdjustmentItem., must be bigger than or equal to 1.');
        }

        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets bill_payment_id
     *
     * @return int|null
     */
    public function getBillPaymentId()
    {
        return $this->container['bill_payment_id'];
    }

    /**
     * Sets bill_payment_id
     *
     * @param int|null $bill_payment_id Unique ID for the bill payment adjustment.
     *
     * @return self
     */
    public function setBillPaymentId($bill_payment_id)
    {
        if (is_null($bill_payment_id)) {
            array_push($this->openAPINullablesSetToNull, 'bill_payment_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bill_payment_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($bill_payment_id) && ($bill_payment_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $bill_payment_id when calling PaymentAdjustmentItem., must be bigger than or equal to 1.');
        }

        $this->container['bill_payment_id'] = $bill_payment_id;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The transaction\\'s creation date and time, in epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling PaymentAdjustmentItem., must be bigger than or equal to 946684800.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets updated_timestamp
     *
     * @return int|null
     */
    public function getUpdatedTimestamp()
    {
        return $this->container['updated_timestamp'];
    }

    /**
     * Sets updated_timestamp
     *
     * @param int|null $updated_timestamp The update date and time the payment adjustment in epoch seconds.
     *
     * @return self
     */
    public function setUpdatedTimestamp($updated_timestamp)
    {
        if (is_null($updated_timestamp)) {
            throw new \InvalidArgumentException('non-nullable updated_timestamp cannot be null');
        }

        if (($updated_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $updated_timestamp when calling PaymentAdjustmentItem., must be bigger than or equal to 946684800.');
        }

        $this->container['updated_timestamp'] = $updated_timestamp;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


