<?php
/**
 * PaymentAdjustment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * PaymentAdjustment Class Doc Comment
 *
 * @category Class
 * @description Represents a refund, which applies to a prior Etsy payment. All monetary amounts are in USD pennies unless otherwise specified.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PaymentAdjustment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentAdjustment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'payment_adjustment_id' => 'int',
        'payment_id' => 'int',
        'status' => 'string',
        'is_success' => 'bool',
        'user_id' => 'int',
        'reason_code' => 'string',
        'total_adjustment_amount' => 'int',
        'shop_total_adjustment_amount' => 'int',
        'buyer_total_adjustment_amount' => 'int',
        'total_fee_adjustment_amount' => 'int',
        'create_timestamp' => 'int',
        'created_timestamp' => 'int',
        'update_timestamp' => 'int',
        'updated_timestamp' => 'int',
        'payment_adjustment_items' => '\Etsy\Model\PaymentAdjustmentPaymentAdjustmentItemsInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'payment_adjustment_id' => null,
        'payment_id' => null,
        'status' => null,
        'is_success' => null,
        'user_id' => null,
        'reason_code' => null,
        'total_adjustment_amount' => null,
        'shop_total_adjustment_amount' => null,
        'buyer_total_adjustment_amount' => null,
        'total_fee_adjustment_amount' => null,
        'create_timestamp' => null,
        'created_timestamp' => null,
        'update_timestamp' => null,
        'updated_timestamp' => null,
        'payment_adjustment_items' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'payment_adjustment_id' => false,
		'payment_id' => false,
		'status' => false,
		'is_success' => false,
		'user_id' => false,
		'reason_code' => false,
		'total_adjustment_amount' => true,
		'shop_total_adjustment_amount' => true,
		'buyer_total_adjustment_amount' => true,
		'total_fee_adjustment_amount' => true,
		'create_timestamp' => false,
		'created_timestamp' => false,
		'update_timestamp' => false,
		'updated_timestamp' => false,
		'payment_adjustment_items' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'payment_adjustment_id' => 'payment_adjustment_id',
        'payment_id' => 'payment_id',
        'status' => 'status',
        'is_success' => 'is_success',
        'user_id' => 'user_id',
        'reason_code' => 'reason_code',
        'total_adjustment_amount' => 'total_adjustment_amount',
        'shop_total_adjustment_amount' => 'shop_total_adjustment_amount',
        'buyer_total_adjustment_amount' => 'buyer_total_adjustment_amount',
        'total_fee_adjustment_amount' => 'total_fee_adjustment_amount',
        'create_timestamp' => 'create_timestamp',
        'created_timestamp' => 'created_timestamp',
        'update_timestamp' => 'update_timestamp',
        'updated_timestamp' => 'updated_timestamp',
        'payment_adjustment_items' => 'payment_adjustment_items'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'payment_adjustment_id' => 'setPaymentAdjustmentId',
        'payment_id' => 'setPaymentId',
        'status' => 'setStatus',
        'is_success' => 'setIsSuccess',
        'user_id' => 'setUserId',
        'reason_code' => 'setReasonCode',
        'total_adjustment_amount' => 'setTotalAdjustmentAmount',
        'shop_total_adjustment_amount' => 'setShopTotalAdjustmentAmount',
        'buyer_total_adjustment_amount' => 'setBuyerTotalAdjustmentAmount',
        'total_fee_adjustment_amount' => 'setTotalFeeAdjustmentAmount',
        'create_timestamp' => 'setCreateTimestamp',
        'created_timestamp' => 'setCreatedTimestamp',
        'update_timestamp' => 'setUpdateTimestamp',
        'updated_timestamp' => 'setUpdatedTimestamp',
        'payment_adjustment_items' => 'setPaymentAdjustmentItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'payment_adjustment_id' => 'getPaymentAdjustmentId',
        'payment_id' => 'getPaymentId',
        'status' => 'getStatus',
        'is_success' => 'getIsSuccess',
        'user_id' => 'getUserId',
        'reason_code' => 'getReasonCode',
        'total_adjustment_amount' => 'getTotalAdjustmentAmount',
        'shop_total_adjustment_amount' => 'getShopTotalAdjustmentAmount',
        'buyer_total_adjustment_amount' => 'getBuyerTotalAdjustmentAmount',
        'total_fee_adjustment_amount' => 'getTotalFeeAdjustmentAmount',
        'create_timestamp' => 'getCreateTimestamp',
        'created_timestamp' => 'getCreatedTimestamp',
        'update_timestamp' => 'getUpdateTimestamp',
        'updated_timestamp' => 'getUpdatedTimestamp',
        'payment_adjustment_items' => 'getPaymentAdjustmentItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('payment_adjustment_id', $data ?? [], null);
        $this->setIfExists('payment_id', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('is_success', $data ?? [], null);
        $this->setIfExists('user_id', $data ?? [], null);
        $this->setIfExists('reason_code', $data ?? [], null);
        $this->setIfExists('total_adjustment_amount', $data ?? [], null);
        $this->setIfExists('shop_total_adjustment_amount', $data ?? [], null);
        $this->setIfExists('buyer_total_adjustment_amount', $data ?? [], null);
        $this->setIfExists('total_fee_adjustment_amount', $data ?? [], null);
        $this->setIfExists('create_timestamp', $data ?? [], null);
        $this->setIfExists('created_timestamp', $data ?? [], null);
        $this->setIfExists('update_timestamp', $data ?? [], null);
        $this->setIfExists('updated_timestamp', $data ?? [], null);
        $this->setIfExists('payment_adjustment_items', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['payment_adjustment_id']) && ($this->container['payment_adjustment_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'payment_adjustment_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['payment_id']) && ($this->container['payment_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'payment_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['user_id']) && ($this->container['user_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'user_id', must be bigger than or equal to 1.";
        }

        if (!is_null($this->container['total_adjustment_amount']) && ($this->container['total_adjustment_amount'] < 0)) {
            $invalidProperties[] = "invalid value for 'total_adjustment_amount', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['shop_total_adjustment_amount']) && ($this->container['shop_total_adjustment_amount'] < 0)) {
            $invalidProperties[] = "invalid value for 'shop_total_adjustment_amount', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['buyer_total_adjustment_amount']) && ($this->container['buyer_total_adjustment_amount'] < 0)) {
            $invalidProperties[] = "invalid value for 'buyer_total_adjustment_amount', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['total_fee_adjustment_amount']) && ($this->container['total_fee_adjustment_amount'] < 0)) {
            $invalidProperties[] = "invalid value for 'total_fee_adjustment_amount', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['create_timestamp']) && ($this->container['create_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'create_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['created_timestamp']) && ($this->container['created_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'created_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['update_timestamp']) && ($this->container['update_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'update_timestamp', must be bigger than or equal to 946684800.";
        }

        if (!is_null($this->container['updated_timestamp']) && ($this->container['updated_timestamp'] < 946684800)) {
            $invalidProperties[] = "invalid value for 'updated_timestamp', must be bigger than or equal to 946684800.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets payment_adjustment_id
     *
     * @return int|null
     */
    public function getPaymentAdjustmentId()
    {
        return $this->container['payment_adjustment_id'];
    }

    /**
     * Sets payment_adjustment_id
     *
     * @param int|null $payment_adjustment_id The numeric ID for a payment adjustment.
     *
     * @return self
     */
    public function setPaymentAdjustmentId($payment_adjustment_id)
    {
        if (is_null($payment_adjustment_id)) {
            throw new \InvalidArgumentException('non-nullable payment_adjustment_id cannot be null');
        }

        if (($payment_adjustment_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $payment_adjustment_id when calling PaymentAdjustment., must be bigger than or equal to 1.');
        }

        $this->container['payment_adjustment_id'] = $payment_adjustment_id;

        return $this;
    }

    /**
     * Gets payment_id
     *
     * @return int|null
     */
    public function getPaymentId()
    {
        return $this->container['payment_id'];
    }

    /**
     * Sets payment_id
     *
     * @param int|null $payment_id A unique numeric ID for a payment to a specific Etsy [shop](/documentation/reference#tag/Shop).
     *
     * @return self
     */
    public function setPaymentId($payment_id)
    {
        if (is_null($payment_id)) {
            throw new \InvalidArgumentException('non-nullable payment_id cannot be null');
        }

        if (($payment_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $payment_id when calling PaymentAdjustment., must be bigger than or equal to 1.');
        }

        $this->container['payment_id'] = $payment_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status The status string of the payment adjustment.
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets is_success
     *
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return $this->container['is_success'];
    }

    /**
     * Sets is_success
     *
     * @param bool|null $is_success When true, the payment adjustment was or is likely to complete successfully.
     *
     * @return self
     */
    public function setIsSuccess($is_success)
    {
        if (is_null($is_success)) {
            throw new \InvalidArgumentException('non-nullable is_success cannot be null');
        }
        $this->container['is_success'] = $is_success;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return int|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param int|null $user_id The numeric ID for the [user](/documentation/reference#tag/User) (seller) fulfilling the purchase.
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        if (is_null($user_id)) {
            throw new \InvalidArgumentException('non-nullable user_id cannot be null');
        }

        if (($user_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $user_id when calling PaymentAdjustment., must be bigger than or equal to 1.');
        }

        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets reason_code
     *
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->container['reason_code'];
    }

    /**
     * Sets reason_code
     *
     * @param string|null $reason_code A human-readable string describing the reason for the refund.
     *
     * @return self
     */
    public function setReasonCode($reason_code)
    {
        if (is_null($reason_code)) {
            throw new \InvalidArgumentException('non-nullable reason_code cannot be null');
        }
        $this->container['reason_code'] = $reason_code;

        return $this;
    }

    /**
     * Gets total_adjustment_amount
     *
     * @return int|null
     */
    public function getTotalAdjustmentAmount()
    {
        return $this->container['total_adjustment_amount'];
    }

    /**
     * Sets total_adjustment_amount
     *
     * @param int|null $total_adjustment_amount The total numeric amount of the refund in the payment currency.
     *
     * @return self
     */
    public function setTotalAdjustmentAmount($total_adjustment_amount)
    {
        if (is_null($total_adjustment_amount)) {
            array_push($this->openAPINullablesSetToNull, 'total_adjustment_amount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('total_adjustment_amount', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($total_adjustment_amount) && ($total_adjustment_amount < 0)) {
            throw new \InvalidArgumentException('invalid value for $total_adjustment_amount when calling PaymentAdjustment., must be bigger than or equal to 0.');
        }

        $this->container['total_adjustment_amount'] = $total_adjustment_amount;

        return $this;
    }

    /**
     * Gets shop_total_adjustment_amount
     *
     * @return int|null
     */
    public function getShopTotalAdjustmentAmount()
    {
        return $this->container['shop_total_adjustment_amount'];
    }

    /**
     * Sets shop_total_adjustment_amount
     *
     * @param int|null $shop_total_adjustment_amount The numeric amount of the refund in the shop currency.
     *
     * @return self
     */
    public function setShopTotalAdjustmentAmount($shop_total_adjustment_amount)
    {
        if (is_null($shop_total_adjustment_amount)) {
            array_push($this->openAPINullablesSetToNull, 'shop_total_adjustment_amount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('shop_total_adjustment_amount', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($shop_total_adjustment_amount) && ($shop_total_adjustment_amount < 0)) {
            throw new \InvalidArgumentException('invalid value for $shop_total_adjustment_amount when calling PaymentAdjustment., must be bigger than or equal to 0.');
        }

        $this->container['shop_total_adjustment_amount'] = $shop_total_adjustment_amount;

        return $this;
    }

    /**
     * Gets buyer_total_adjustment_amount
     *
     * @return int|null
     */
    public function getBuyerTotalAdjustmentAmount()
    {
        return $this->container['buyer_total_adjustment_amount'];
    }

    /**
     * Sets buyer_total_adjustment_amount
     *
     * @param int|null $buyer_total_adjustment_amount The numeric amount of the refund in the buyer currency.
     *
     * @return self
     */
    public function setBuyerTotalAdjustmentAmount($buyer_total_adjustment_amount)
    {
        if (is_null($buyer_total_adjustment_amount)) {
            array_push($this->openAPINullablesSetToNull, 'buyer_total_adjustment_amount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('buyer_total_adjustment_amount', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($buyer_total_adjustment_amount) && ($buyer_total_adjustment_amount < 0)) {
            throw new \InvalidArgumentException('invalid value for $buyer_total_adjustment_amount when calling PaymentAdjustment., must be bigger than or equal to 0.');
        }

        $this->container['buyer_total_adjustment_amount'] = $buyer_total_adjustment_amount;

        return $this;
    }

    /**
     * Gets total_fee_adjustment_amount
     *
     * @return int|null
     */
    public function getTotalFeeAdjustmentAmount()
    {
        return $this->container['total_fee_adjustment_amount'];
    }

    /**
     * Sets total_fee_adjustment_amount
     *
     * @param int|null $total_fee_adjustment_amount The numeric amount of card processing fees associated with a payment adjustment.
     *
     * @return self
     */
    public function setTotalFeeAdjustmentAmount($total_fee_adjustment_amount)
    {
        if (is_null($total_fee_adjustment_amount)) {
            array_push($this->openAPINullablesSetToNull, 'total_fee_adjustment_amount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('total_fee_adjustment_amount', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        if (!is_null($total_fee_adjustment_amount) && ($total_fee_adjustment_amount < 0)) {
            throw new \InvalidArgumentException('invalid value for $total_fee_adjustment_amount when calling PaymentAdjustment., must be bigger than or equal to 0.');
        }

        $this->container['total_fee_adjustment_amount'] = $total_fee_adjustment_amount;

        return $this;
    }

    /**
     * Gets create_timestamp
     *
     * @return int|null
     */
    public function getCreateTimestamp()
    {
        return $this->container['create_timestamp'];
    }

    /**
     * Sets create_timestamp
     *
     * @param int|null $create_timestamp The transaction\\'s creation date and time, in epoch seconds.
     *
     * @return self
     */
    public function setCreateTimestamp($create_timestamp)
    {
        if (is_null($create_timestamp)) {
            throw new \InvalidArgumentException('non-nullable create_timestamp cannot be null');
        }

        if (($create_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $create_timestamp when calling PaymentAdjustment., must be bigger than or equal to 946684800.');
        }

        $this->container['create_timestamp'] = $create_timestamp;

        return $this;
    }

    /**
     * Gets created_timestamp
     *
     * @return int|null
     */
    public function getCreatedTimestamp()
    {
        return $this->container['created_timestamp'];
    }

    /**
     * Sets created_timestamp
     *
     * @param int|null $created_timestamp The transaction\\'s creation date and time, in epoch seconds.
     *
     * @return self
     */
    public function setCreatedTimestamp($created_timestamp)
    {
        if (is_null($created_timestamp)) {
            throw new \InvalidArgumentException('non-nullable created_timestamp cannot be null');
        }

        if (($created_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $created_timestamp when calling PaymentAdjustment., must be bigger than or equal to 946684800.');
        }

        $this->container['created_timestamp'] = $created_timestamp;

        return $this;
    }

    /**
     * Gets update_timestamp
     *
     * @return int|null
     */
    public function getUpdateTimestamp()
    {
        return $this->container['update_timestamp'];
    }

    /**
     * Sets update_timestamp
     *
     * @param int|null $update_timestamp The date and time of the last change to the payment adjustment in epoch seconds.
     *
     * @return self
     */
    public function setUpdateTimestamp($update_timestamp)
    {
        if (is_null($update_timestamp)) {
            throw new \InvalidArgumentException('non-nullable update_timestamp cannot be null');
        }

        if (($update_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $update_timestamp when calling PaymentAdjustment., must be bigger than or equal to 946684800.');
        }

        $this->container['update_timestamp'] = $update_timestamp;

        return $this;
    }

    /**
     * Gets updated_timestamp
     *
     * @return int|null
     */
    public function getUpdatedTimestamp()
    {
        return $this->container['updated_timestamp'];
    }

    /**
     * Sets updated_timestamp
     *
     * @param int|null $updated_timestamp The date and time of the last change to the payment adjustment in epoch seconds.
     *
     * @return self
     */
    public function setUpdatedTimestamp($updated_timestamp)
    {
        if (is_null($updated_timestamp)) {
            throw new \InvalidArgumentException('non-nullable updated_timestamp cannot be null');
        }

        if (($updated_timestamp < 946684800)) {
            throw new \InvalidArgumentException('invalid value for $updated_timestamp when calling PaymentAdjustment., must be bigger than or equal to 946684800.');
        }

        $this->container['updated_timestamp'] = $updated_timestamp;

        return $this;
    }

    /**
     * Gets payment_adjustment_items
     *
     * @return \Etsy\Model\PaymentAdjustmentPaymentAdjustmentItemsInner[]|null
     */
    public function getPaymentAdjustmentItems()
    {
        return $this->container['payment_adjustment_items'];
    }

    /**
     * Sets payment_adjustment_items
     *
     * @param \Etsy\Model\PaymentAdjustmentPaymentAdjustmentItemsInner[]|null $payment_adjustment_items List of payment adjustment line items.
     *
     * @return self
     */
    public function setPaymentAdjustmentItems($payment_adjustment_items)
    {
        if (is_null($payment_adjustment_items)) {
            throw new \InvalidArgumentException('non-nullable payment_adjustment_items cannot be null');
        }
        $this->container['payment_adjustment_items'] = $payment_adjustment_items;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


