<?php
/**
 * BuyerTaxonomyNodeProperty
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Model;

use \ArrayAccess;
use \Etsy\ObjectSerializer;

/**
 * BuyerTaxonomyNodeProperty Class Doc Comment
 *
 * @category Class
 * @description A product property definition.
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class BuyerTaxonomyNodeProperty implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BuyerTaxonomyNodeProperty';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'property_id' => 'int',
        'name' => 'string',
        'display_name' => 'string',
        'scales' => '\Etsy\Model\BuyerTaxonomyNodePropertyScalesInner[]',
        'is_required' => 'bool',
        'supports_attributes' => 'bool',
        'supports_variations' => 'bool',
        'is_multivalued' => 'bool',
        'max_values_allowed' => 'int',
        'possible_values' => '\Etsy\Model\BuyerTaxonomyNodePropertyPossibleValuesInner[]',
        'selected_values' => '\Etsy\Model\BuyerTaxonomyNodePropertySelectedValuesInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'property_id' => null,
        'name' => null,
        'display_name' => null,
        'scales' => null,
        'is_required' => null,
        'supports_attributes' => null,
        'supports_variations' => null,
        'is_multivalued' => null,
        'max_values_allowed' => null,
        'possible_values' => null,
        'selected_values' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'property_id' => false,
		'name' => false,
		'display_name' => false,
		'scales' => false,
		'is_required' => false,
		'supports_attributes' => false,
		'supports_variations' => false,
		'is_multivalued' => false,
		'max_values_allowed' => true,
		'possible_values' => false,
		'selected_values' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'property_id' => 'property_id',
        'name' => 'name',
        'display_name' => 'display_name',
        'scales' => 'scales',
        'is_required' => 'is_required',
        'supports_attributes' => 'supports_attributes',
        'supports_variations' => 'supports_variations',
        'is_multivalued' => 'is_multivalued',
        'max_values_allowed' => 'max_values_allowed',
        'possible_values' => 'possible_values',
        'selected_values' => 'selected_values'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'property_id' => 'setPropertyId',
        'name' => 'setName',
        'display_name' => 'setDisplayName',
        'scales' => 'setScales',
        'is_required' => 'setIsRequired',
        'supports_attributes' => 'setSupportsAttributes',
        'supports_variations' => 'setSupportsVariations',
        'is_multivalued' => 'setIsMultivalued',
        'max_values_allowed' => 'setMaxValuesAllowed',
        'possible_values' => 'setPossibleValues',
        'selected_values' => 'setSelectedValues'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'property_id' => 'getPropertyId',
        'name' => 'getName',
        'display_name' => 'getDisplayName',
        'scales' => 'getScales',
        'is_required' => 'getIsRequired',
        'supports_attributes' => 'getSupportsAttributes',
        'supports_variations' => 'getSupportsVariations',
        'is_multivalued' => 'getIsMultivalued',
        'max_values_allowed' => 'getMaxValuesAllowed',
        'possible_values' => 'getPossibleValues',
        'selected_values' => 'getSelectedValues'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('property_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('display_name', $data ?? [], null);
        $this->setIfExists('scales', $data ?? [], null);
        $this->setIfExists('is_required', $data ?? [], null);
        $this->setIfExists('supports_attributes', $data ?? [], null);
        $this->setIfExists('supports_variations', $data ?? [], null);
        $this->setIfExists('is_multivalued', $data ?? [], null);
        $this->setIfExists('max_values_allowed', $data ?? [], null);
        $this->setIfExists('possible_values', $data ?? [], null);
        $this->setIfExists('selected_values', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['property_id']) && ($this->container['property_id'] < 1)) {
            $invalidProperties[] = "invalid value for 'property_id', must be bigger than or equal to 1.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets property_id
     *
     * @return int|null
     */
    public function getPropertyId()
    {
        return $this->container['property_id'];
    }

    /**
     * Sets property_id
     *
     * @param int|null $property_id The unique numeric ID of this product property.
     *
     * @return self
     */
    public function setPropertyId($property_id)
    {
        if (is_null($property_id)) {
            throw new \InvalidArgumentException('non-nullable property_id cannot be null');
        }

        if (($property_id < 1)) {
            throw new \InvalidArgumentException('invalid value for $property_id when calling BuyerTaxonomyNodeProperty., must be bigger than or equal to 1.');
        }

        $this->container['property_id'] = $property_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name string for this taxonomy node.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets display_name
     *
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->container['display_name'];
    }

    /**
     * Sets display_name
     *
     * @param string|null $display_name The human-readable product property name string.
     *
     * @return self
     */
    public function setDisplayName($display_name)
    {
        if (is_null($display_name)) {
            throw new \InvalidArgumentException('non-nullable display_name cannot be null');
        }
        $this->container['display_name'] = $display_name;

        return $this;
    }

    /**
     * Gets scales
     *
     * @return \Etsy\Model\BuyerTaxonomyNodePropertyScalesInner[]|null
     */
    public function getScales()
    {
        return $this->container['scales'];
    }

    /**
     * Sets scales
     *
     * @param \Etsy\Model\BuyerTaxonomyNodePropertyScalesInner[]|null $scales A list of available scales.
     *
     * @return self
     */
    public function setScales($scales)
    {
        if (is_null($scales)) {
            throw new \InvalidArgumentException('non-nullable scales cannot be null');
        }
        $this->container['scales'] = $scales;

        return $this;
    }

    /**
     * Gets is_required
     *
     * @return bool|null
     */
    public function getIsRequired()
    {
        return $this->container['is_required'];
    }

    /**
     * Sets is_required
     *
     * @param bool|null $is_required When true, listings assigned eligible taxonomy IDs require this property.
     *
     * @return self
     */
    public function setIsRequired($is_required)
    {
        if (is_null($is_required)) {
            throw new \InvalidArgumentException('non-nullable is_required cannot be null');
        }
        $this->container['is_required'] = $is_required;

        return $this;
    }

    /**
     * Gets supports_attributes
     *
     * @return bool|null
     */
    public function getSupportsAttributes()
    {
        return $this->container['supports_attributes'];
    }

    /**
     * Sets supports_attributes
     *
     * @param bool|null $supports_attributes When true, you can use this property in listing attributes.
     *
     * @return self
     */
    public function setSupportsAttributes($supports_attributes)
    {
        if (is_null($supports_attributes)) {
            throw new \InvalidArgumentException('non-nullable supports_attributes cannot be null');
        }
        $this->container['supports_attributes'] = $supports_attributes;

        return $this;
    }

    /**
     * Gets supports_variations
     *
     * @return bool|null
     */
    public function getSupportsVariations()
    {
        return $this->container['supports_variations'];
    }

    /**
     * Sets supports_variations
     *
     * @param bool|null $supports_variations When true, you can use this property in listing variations.
     *
     * @return self
     */
    public function setSupportsVariations($supports_variations)
    {
        if (is_null($supports_variations)) {
            throw new \InvalidArgumentException('non-nullable supports_variations cannot be null');
        }
        $this->container['supports_variations'] = $supports_variations;

        return $this;
    }

    /**
     * Gets is_multivalued
     *
     * @return bool|null
     */
    public function getIsMultivalued()
    {
        return $this->container['is_multivalued'];
    }

    /**
     * Sets is_multivalued
     *
     * @param bool|null $is_multivalued When true, you can assign multiple property values to this property
     *
     * @return self
     */
    public function setIsMultivalued($is_multivalued)
    {
        if (is_null($is_multivalued)) {
            throw new \InvalidArgumentException('non-nullable is_multivalued cannot be null');
        }
        $this->container['is_multivalued'] = $is_multivalued;

        return $this;
    }

    /**
     * Gets max_values_allowed
     *
     * @return int|null
     */
    public function getMaxValuesAllowed()
    {
        return $this->container['max_values_allowed'];
    }

    /**
     * Sets max_values_allowed
     *
     * @param int|null $max_values_allowed When true, you can assign multiple property values to this property
     *
     * @return self
     */
    public function setMaxValuesAllowed($max_values_allowed)
    {
        if (is_null($max_values_allowed)) {
            array_push($this->openAPINullablesSetToNull, 'max_values_allowed');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('max_values_allowed', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['max_values_allowed'] = $max_values_allowed;

        return $this;
    }

    /**
     * Gets possible_values
     *
     * @return \Etsy\Model\BuyerTaxonomyNodePropertyPossibleValuesInner[]|null
     */
    public function getPossibleValues()
    {
        return $this->container['possible_values'];
    }

    /**
     * Sets possible_values
     *
     * @param \Etsy\Model\BuyerTaxonomyNodePropertyPossibleValuesInner[]|null $possible_values A list of supported property value strings for this property.
     *
     * @return self
     */
    public function setPossibleValues($possible_values)
    {
        if (is_null($possible_values)) {
            throw new \InvalidArgumentException('non-nullable possible_values cannot be null');
        }
        $this->container['possible_values'] = $possible_values;

        return $this;
    }

    /**
     * Gets selected_values
     *
     * @return \Etsy\Model\BuyerTaxonomyNodePropertySelectedValuesInner[]|null
     */
    public function getSelectedValues()
    {
        return $this->container['selected_values'];
    }

    /**
     * Sets selected_values
     *
     * @param \Etsy\Model\BuyerTaxonomyNodePropertySelectedValuesInner[]|null $selected_values A list of property value strings automatically and always selected for the given property.
     *
     * @return self
     */
    public function setSelectedValues($selected_values)
    {
        if (is_null($selected_values)) {
            throw new \InvalidArgumentException('non-nullable selected_values cannot be null');
        }
        $this->container['selected_values'] = $selected_values;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


