<?php
/**
 * ShopReturnPolicyApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Etsy\ApiException;
use Etsy\Configuration;
use Etsy\HeaderSelector;
use Etsy\ObjectSerializer;

/**
 * ShopReturnPolicyApi Class Doc Comment
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ShopReturnPolicyApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'consolidateShopReturnPolicies' => [
            'application/x-www-form-urlencoded',
        ],
        'createShopReturnPolicy' => [
            'application/x-www-form-urlencoded',
        ],
        'deleteShopReturnPolicy' => [
            'application/json',
        ],
        'getShopReturnPolicies' => [
            'application/json',
        ],
        'getShopReturnPolicy' => [
            'application/json',
        ],
        'updateShopReturnPolicy' => [
            'application/x-www-form-urlencoded',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation consolidateShopReturnPolicies
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $source_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $destination_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['consolidateShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopReturnPolicy|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function consolidateShopReturnPolicies($shop_id, $source_return_policy_id, $destination_return_policy_id, string $contentType = self::contentTypes['consolidateShopReturnPolicies'][0])
    {
        list($response) = $this->consolidateShopReturnPoliciesWithHttpInfo($shop_id, $source_return_policy_id, $destination_return_policy_id, $contentType);
        return $response;
    }

    /**
     * Operation consolidateShopReturnPoliciesWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $source_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $destination_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['consolidateShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopReturnPolicy|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function consolidateShopReturnPoliciesWithHttpInfo($shop_id, $source_return_policy_id, $destination_return_policy_id, string $contentType = self::contentTypes['consolidateShopReturnPolicies'][0])
    {
        $request = $this->consolidateShopReturnPoliciesRequest($shop_id, $source_return_policy_id, $destination_return_policy_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopReturnPolicy' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopReturnPolicy' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopReturnPolicy', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopReturnPolicy';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopReturnPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation consolidateShopReturnPoliciesAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $source_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $destination_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['consolidateShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function consolidateShopReturnPoliciesAsync($shop_id, $source_return_policy_id, $destination_return_policy_id, string $contentType = self::contentTypes['consolidateShopReturnPolicies'][0])
    {
        return $this->consolidateShopReturnPoliciesAsyncWithHttpInfo($shop_id, $source_return_policy_id, $destination_return_policy_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation consolidateShopReturnPoliciesAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $source_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $destination_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['consolidateShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function consolidateShopReturnPoliciesAsyncWithHttpInfo($shop_id, $source_return_policy_id, $destination_return_policy_id, string $contentType = self::contentTypes['consolidateShopReturnPolicies'][0])
    {
        $returnType = '\Etsy\Model\ShopReturnPolicy';
        $request = $this->consolidateShopReturnPoliciesRequest($shop_id, $source_return_policy_id, $destination_return_policy_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'consolidateShopReturnPolicies'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $source_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  int $destination_return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['consolidateShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function consolidateShopReturnPoliciesRequest($shop_id, $source_return_policy_id, $destination_return_policy_id, string $contentType = self::contentTypes['consolidateShopReturnPolicies'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling consolidateShopReturnPolicies'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReturnPolicyApi.consolidateShopReturnPolicies, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'source_return_policy_id' is set
        if ($source_return_policy_id === null || (is_array($source_return_policy_id) && count($source_return_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $source_return_policy_id when calling consolidateShopReturnPolicies'
            );
        }
        if ($source_return_policy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$source_return_policy_id" when calling ShopReturnPolicyApi.consolidateShopReturnPolicies, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'destination_return_policy_id' is set
        if ($destination_return_policy_id === null || (is_array($destination_return_policy_id) && count($destination_return_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $destination_return_policy_id when calling consolidateShopReturnPolicies'
            );
        }
        if ($destination_return_policy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$destination_return_policy_id" when calling ShopReturnPolicyApi.consolidateShopReturnPolicies, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/policies/return/consolidate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }

        // form params
        if ($source_return_policy_id !== null) {
            $formParams['source_return_policy_id'] = ObjectSerializer::toFormValue($source_return_policy_id);
        }
        // form params
        if ($destination_return_policy_id !== null) {
            $formParams['destination_return_policy_id'] = ObjectSerializer::toFormValue($destination_return_policy_id);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createShopReturnPolicy
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  bool $accepts_returns accepts_returns (required)
     * @param  bool $accepts_exchanges accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopReturnPolicy|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function createShopReturnPolicy($shop_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['createShopReturnPolicy'][0])
    {
        list($response) = $this->createShopReturnPolicyWithHttpInfo($shop_id, $accepts_returns, $accepts_exchanges, $return_deadline, $contentType);
        return $response;
    }

    /**
     * Operation createShopReturnPolicyWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  bool $accepts_returns (required)
     * @param  bool $accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopReturnPolicy|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function createShopReturnPolicyWithHttpInfo($shop_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['createShopReturnPolicy'][0])
    {
        $request = $this->createShopReturnPolicyRequest($shop_id, $accepts_returns, $accepts_exchanges, $return_deadline, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopReturnPolicy' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopReturnPolicy' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopReturnPolicy', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopReturnPolicy';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopReturnPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createShopReturnPolicyAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  bool $accepts_returns (required)
     * @param  bool $accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShopReturnPolicyAsync($shop_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['createShopReturnPolicy'][0])
    {
        return $this->createShopReturnPolicyAsyncWithHttpInfo($shop_id, $accepts_returns, $accepts_exchanges, $return_deadline, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createShopReturnPolicyAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  bool $accepts_returns (required)
     * @param  bool $accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createShopReturnPolicyAsyncWithHttpInfo($shop_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['createShopReturnPolicy'][0])
    {
        $returnType = '\Etsy\Model\ShopReturnPolicy';
        $request = $this->createShopReturnPolicyRequest($shop_id, $accepts_returns, $accepts_exchanges, $return_deadline, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createShopReturnPolicy'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  bool $accepts_returns (required)
     * @param  bool $accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createShopReturnPolicyRequest($shop_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['createShopReturnPolicy'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling createShopReturnPolicy'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReturnPolicyApi.createShopReturnPolicy, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'accepts_returns' is set
        if ($accepts_returns === null || (is_array($accepts_returns) && count($accepts_returns) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $accepts_returns when calling createShopReturnPolicy'
            );
        }

        // verify the required parameter 'accepts_exchanges' is set
        if ($accepts_exchanges === null || (is_array($accepts_exchanges) && count($accepts_exchanges) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $accepts_exchanges when calling createShopReturnPolicy'
            );
        }



        $resourcePath = '/v3/application/shops/{shop_id}/policies/return';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }

        // form params
        if ($accepts_returns !== null) {
            $formParams['accepts_returns'] = ObjectSerializer::toFormValue($accepts_returns);
        }
        // form params
        if ($accepts_exchanges !== null) {
            $formParams['accepts_exchanges'] = ObjectSerializer::toFormValue($accepts_exchanges);
        }
        // form params
        if ($return_deadline !== null) {
            $formParams['return_deadline'] = ObjectSerializer::toFormValue($return_deadline);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteShopReturnPolicy
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteShopReturnPolicy($shop_id, $return_policy_id, string $contentType = self::contentTypes['deleteShopReturnPolicy'][0])
    {
        $this->deleteShopReturnPolicyWithHttpInfo($shop_id, $return_policy_id, $contentType);
    }

    /**
     * Operation deleteShopReturnPolicyWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteShopReturnPolicyWithHttpInfo($shop_id, $return_policy_id, string $contentType = self::contentTypes['deleteShopReturnPolicy'][0])
    {
        $request = $this->deleteShopReturnPolicyRequest($shop_id, $return_policy_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteShopReturnPolicyAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteShopReturnPolicyAsync($shop_id, $return_policy_id, string $contentType = self::contentTypes['deleteShopReturnPolicy'][0])
    {
        return $this->deleteShopReturnPolicyAsyncWithHttpInfo($shop_id, $return_policy_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteShopReturnPolicyAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteShopReturnPolicyAsyncWithHttpInfo($shop_id, $return_policy_id, string $contentType = self::contentTypes['deleteShopReturnPolicy'][0])
    {
        $returnType = '';
        $request = $this->deleteShopReturnPolicyRequest($shop_id, $return_policy_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteShopReturnPolicy'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteShopReturnPolicyRequest($shop_id, $return_policy_id, string $contentType = self::contentTypes['deleteShopReturnPolicy'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling deleteShopReturnPolicy'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReturnPolicyApi.deleteShopReturnPolicy, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'return_policy_id' is set
        if ($return_policy_id === null || (is_array($return_policy_id) && count($return_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_policy_id when calling deleteShopReturnPolicy'
            );
        }
        if ($return_policy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$return_policy_id" when calling ShopReturnPolicyApi.deleteShopReturnPolicy, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/policies/return/{return_policy_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($return_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'return_policy_id' . '}',
                ObjectSerializer::toPathValue($return_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShopReturnPolicies
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopReturnPolicies|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getShopReturnPolicies($shop_id, string $contentType = self::contentTypes['getShopReturnPolicies'][0])
    {
        list($response) = $this->getShopReturnPoliciesWithHttpInfo($shop_id, $contentType);
        return $response;
    }

    /**
     * Operation getShopReturnPoliciesWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopReturnPolicies|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShopReturnPoliciesWithHttpInfo($shop_id, string $contentType = self::contentTypes['getShopReturnPolicies'][0])
    {
        $request = $this->getShopReturnPoliciesRequest($shop_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopReturnPolicies' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopReturnPolicies' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopReturnPolicies', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopReturnPolicies';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopReturnPolicies',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShopReturnPoliciesAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopReturnPoliciesAsync($shop_id, string $contentType = self::contentTypes['getShopReturnPolicies'][0])
    {
        return $this->getShopReturnPoliciesAsyncWithHttpInfo($shop_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShopReturnPoliciesAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopReturnPoliciesAsyncWithHttpInfo($shop_id, string $contentType = self::contentTypes['getShopReturnPolicies'][0])
    {
        $returnType = '\Etsy\Model\ShopReturnPolicies';
        $request = $this->getShopReturnPoliciesRequest($shop_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShopReturnPolicies'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShopReturnPoliciesRequest($shop_id, string $contentType = self::contentTypes['getShopReturnPolicies'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getShopReturnPolicies'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReturnPolicyApi.getShopReturnPolicies, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/policies/return';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShopReturnPolicy
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopReturnPolicy|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getShopReturnPolicy($shop_id, $return_policy_id, string $contentType = self::contentTypes['getShopReturnPolicy'][0])
    {
        list($response) = $this->getShopReturnPolicyWithHttpInfo($shop_id, $return_policy_id, $contentType);
        return $response;
    }

    /**
     * Operation getShopReturnPolicyWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopReturnPolicy|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShopReturnPolicyWithHttpInfo($shop_id, $return_policy_id, string $contentType = self::contentTypes['getShopReturnPolicy'][0])
    {
        $request = $this->getShopReturnPolicyRequest($shop_id, $return_policy_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopReturnPolicy' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopReturnPolicy' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopReturnPolicy', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopReturnPolicy';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopReturnPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShopReturnPolicyAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopReturnPolicyAsync($shop_id, $return_policy_id, string $contentType = self::contentTypes['getShopReturnPolicy'][0])
    {
        return $this->getShopReturnPolicyAsyncWithHttpInfo($shop_id, $return_policy_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShopReturnPolicyAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopReturnPolicyAsyncWithHttpInfo($shop_id, $return_policy_id, string $contentType = self::contentTypes['getShopReturnPolicy'][0])
    {
        $returnType = '\Etsy\Model\ShopReturnPolicy';
        $request = $this->getShopReturnPolicyRequest($shop_id, $return_policy_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShopReturnPolicy'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShopReturnPolicyRequest($shop_id, $return_policy_id, string $contentType = self::contentTypes['getShopReturnPolicy'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getShopReturnPolicy'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReturnPolicyApi.getShopReturnPolicy, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'return_policy_id' is set
        if ($return_policy_id === null || (is_array($return_policy_id) && count($return_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_policy_id when calling getShopReturnPolicy'
            );
        }
        if ($return_policy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$return_policy_id" when calling ShopReturnPolicyApi.getShopReturnPolicy, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/policies/return/{return_policy_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($return_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'return_policy_id' . '}',
                ObjectSerializer::toPathValue($return_policy_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateShopReturnPolicy
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  bool $accepts_returns accepts_returns (required)
     * @param  bool $accepts_exchanges accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopReturnPolicy|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function updateShopReturnPolicy($shop_id, $return_policy_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['updateShopReturnPolicy'][0])
    {
        list($response) = $this->updateShopReturnPolicyWithHttpInfo($shop_id, $return_policy_id, $accepts_returns, $accepts_exchanges, $return_deadline, $contentType);
        return $response;
    }

    /**
     * Operation updateShopReturnPolicyWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  bool $accepts_returns (required)
     * @param  bool $accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopReturnPolicy|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateShopReturnPolicyWithHttpInfo($shop_id, $return_policy_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['updateShopReturnPolicy'][0])
    {
        $request = $this->updateShopReturnPolicyRequest($shop_id, $return_policy_id, $accepts_returns, $accepts_exchanges, $return_deadline, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopReturnPolicy' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopReturnPolicy' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopReturnPolicy', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopReturnPolicy';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopReturnPolicy',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateShopReturnPolicyAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  bool $accepts_returns (required)
     * @param  bool $accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopReturnPolicyAsync($shop_id, $return_policy_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['updateShopReturnPolicy'][0])
    {
        return $this->updateShopReturnPolicyAsyncWithHttpInfo($shop_id, $return_policy_id, $accepts_returns, $accepts_exchanges, $return_deadline, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateShopReturnPolicyAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  bool $accepts_returns (required)
     * @param  bool $accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopReturnPolicyAsyncWithHttpInfo($shop_id, $return_policy_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['updateShopReturnPolicy'][0])
    {
        $returnType = '\Etsy\Model\ShopReturnPolicy';
        $request = $this->updateShopReturnPolicyRequest($shop_id, $return_policy_id, $accepts_returns, $accepts_exchanges, $return_deadline, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateShopReturnPolicy'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $return_policy_id The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). (required)
     * @param  bool $accepts_returns (required)
     * @param  bool $accepts_exchanges (required)
     * @param  int $return_deadline The deadline for the Return Policy, measured in days. The value must be one of the following: [7, 14, 21, 30, 45, 60, 90]. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReturnPolicy'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateShopReturnPolicyRequest($shop_id, $return_policy_id, $accepts_returns, $accepts_exchanges, $return_deadline = null, string $contentType = self::contentTypes['updateShopReturnPolicy'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling updateShopReturnPolicy'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReturnPolicyApi.updateShopReturnPolicy, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'return_policy_id' is set
        if ($return_policy_id === null || (is_array($return_policy_id) && count($return_policy_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_policy_id when calling updateShopReturnPolicy'
            );
        }
        if ($return_policy_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$return_policy_id" when calling ShopReturnPolicyApi.updateShopReturnPolicy, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'accepts_returns' is set
        if ($accepts_returns === null || (is_array($accepts_returns) && count($accepts_returns) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $accepts_returns when calling updateShopReturnPolicy'
            );
        }

        // verify the required parameter 'accepts_exchanges' is set
        if ($accepts_exchanges === null || (is_array($accepts_exchanges) && count($accepts_exchanges) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $accepts_exchanges when calling updateShopReturnPolicy'
            );
        }



        $resourcePath = '/v3/application/shops/{shop_id}/policies/return/{return_policy_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($return_policy_id !== null) {
            $resourcePath = str_replace(
                '{' . 'return_policy_id' . '}',
                ObjectSerializer::toPathValue($return_policy_id),
                $resourcePath
            );
        }

        // form params
        if ($accepts_returns !== null) {
            $formParams['accepts_returns'] = ObjectSerializer::toFormValue($accepts_returns);
        }
        // form params
        if ($accepts_exchanges !== null) {
            $formParams['accepts_exchanges'] = ObjectSerializer::toFormValue($accepts_exchanges);
        }
        // form params
        if ($return_deadline !== null) {
            $formParams['return_deadline'] = ObjectSerializer::toFormValue($return_deadline);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
