<?php
/**
 * ShopReceiptApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Etsy\ApiException;
use Etsy\Configuration;
use Etsy\HeaderSelector;
use Etsy\ObjectSerializer;

/**
 * ShopReceiptApi Class Doc Comment
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ShopReceiptApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createReceiptShipment' => [
            'application/x-www-form-urlencoded',
        ],
        'getShopReceipt' => [
            'application/json',
        ],
        'getShopReceipts' => [
            'application/json',
        ],
        'updateShopReceipt' => [
            'application/x-www-form-urlencoded',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createReceiptShipment
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The receipt to submit tracking for. (required)
     * @param  string $tracking_code The tracking code for this receipt. (optional)
     * @param  string $carrier_name The carrier name for this receipt. (optional)
     * @param  bool $send_bcc If true, the shipping notification will be sent to the seller as well (optional)
     * @param  string $note_to_buyer Message to include in notification to the buyer. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReceiptShipment'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopReceipt|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function createReceiptShipment($shop_id, $receipt_id, $tracking_code = null, $carrier_name = null, $send_bcc = null, $note_to_buyer = null, string $contentType = self::contentTypes['createReceiptShipment'][0])
    {
        list($response) = $this->createReceiptShipmentWithHttpInfo($shop_id, $receipt_id, $tracking_code, $carrier_name, $send_bcc, $note_to_buyer, $contentType);
        return $response;
    }

    /**
     * Operation createReceiptShipmentWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The receipt to submit tracking for. (required)
     * @param  string $tracking_code The tracking code for this receipt. (optional)
     * @param  string $carrier_name The carrier name for this receipt. (optional)
     * @param  bool $send_bcc If true, the shipping notification will be sent to the seller as well (optional)
     * @param  string $note_to_buyer Message to include in notification to the buyer. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReceiptShipment'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopReceipt|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReceiptShipmentWithHttpInfo($shop_id, $receipt_id, $tracking_code = null, $carrier_name = null, $send_bcc = null, $note_to_buyer = null, string $contentType = self::contentTypes['createReceiptShipment'][0])
    {
        $request = $this->createReceiptShipmentRequest($shop_id, $receipt_id, $tracking_code, $carrier_name, $send_bcc, $note_to_buyer, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopReceipt' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopReceipt' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopReceipt', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopReceipt';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopReceipt',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createReceiptShipmentAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The receipt to submit tracking for. (required)
     * @param  string $tracking_code The tracking code for this receipt. (optional)
     * @param  string $carrier_name The carrier name for this receipt. (optional)
     * @param  bool $send_bcc If true, the shipping notification will be sent to the seller as well (optional)
     * @param  string $note_to_buyer Message to include in notification to the buyer. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReceiptShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptShipmentAsync($shop_id, $receipt_id, $tracking_code = null, $carrier_name = null, $send_bcc = null, $note_to_buyer = null, string $contentType = self::contentTypes['createReceiptShipment'][0])
    {
        return $this->createReceiptShipmentAsyncWithHttpInfo($shop_id, $receipt_id, $tracking_code, $carrier_name, $send_bcc, $note_to_buyer, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createReceiptShipmentAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The receipt to submit tracking for. (required)
     * @param  string $tracking_code The tracking code for this receipt. (optional)
     * @param  string $carrier_name The carrier name for this receipt. (optional)
     * @param  bool $send_bcc If true, the shipping notification will be sent to the seller as well (optional)
     * @param  string $note_to_buyer Message to include in notification to the buyer. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReceiptShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReceiptShipmentAsyncWithHttpInfo($shop_id, $receipt_id, $tracking_code = null, $carrier_name = null, $send_bcc = null, $note_to_buyer = null, string $contentType = self::contentTypes['createReceiptShipment'][0])
    {
        $returnType = '\Etsy\Model\ShopReceipt';
        $request = $this->createReceiptShipmentRequest($shop_id, $receipt_id, $tracking_code, $carrier_name, $send_bcc, $note_to_buyer, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReceiptShipment'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The receipt to submit tracking for. (required)
     * @param  string $tracking_code The tracking code for this receipt. (optional)
     * @param  string $carrier_name The carrier name for this receipt. (optional)
     * @param  bool $send_bcc If true, the shipping notification will be sent to the seller as well (optional)
     * @param  string $note_to_buyer Message to include in notification to the buyer. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReceiptShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createReceiptShipmentRequest($shop_id, $receipt_id, $tracking_code = null, $carrier_name = null, $send_bcc = null, $note_to_buyer = null, string $contentType = self::contentTypes['createReceiptShipment'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling createReceiptShipment'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReceiptApi.createReceiptShipment, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'receipt_id' is set
        if ($receipt_id === null || (is_array($receipt_id) && count($receipt_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipt_id when calling createReceiptShipment'
            );
        }
        if ($receipt_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$receipt_id" when calling ShopReceiptApi.createReceiptShipment, must be bigger than or equal to 1.');
        }
        





        $resourcePath = '/v3/application/shops/{shop_id}/receipts/{receipt_id}/tracking';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($receipt_id !== null) {
            $resourcePath = str_replace(
                '{' . 'receipt_id' . '}',
                ObjectSerializer::toPathValue($receipt_id),
                $resourcePath
            );
        }

        // form params
        if ($tracking_code !== null) {
            $formParams['tracking_code'] = ObjectSerializer::toFormValue($tracking_code);
        }
        // form params
        if ($carrier_name !== null) {
            $formParams['carrier_name'] = ObjectSerializer::toFormValue($carrier_name);
        }
        // form params
        if ($send_bcc !== null) {
            $formParams['send_bcc'] = ObjectSerializer::toFormValue($send_bcc);
        }
        // form params
        if ($note_to_buyer !== null) {
            $formParams['note_to_buyer'] = ObjectSerializer::toFormValue($note_to_buyer);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShopReceipt
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipt'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopReceipt|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getShopReceipt($shop_id, $receipt_id, string $contentType = self::contentTypes['getShopReceipt'][0])
    {
        list($response) = $this->getShopReceiptWithHttpInfo($shop_id, $receipt_id, $contentType);
        return $response;
    }

    /**
     * Operation getShopReceiptWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipt'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopReceipt|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShopReceiptWithHttpInfo($shop_id, $receipt_id, string $contentType = self::contentTypes['getShopReceipt'][0])
    {
        $request = $this->getShopReceiptRequest($shop_id, $receipt_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopReceipt' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopReceipt' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopReceipt', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopReceipt';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopReceipt',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShopReceiptAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopReceiptAsync($shop_id, $receipt_id, string $contentType = self::contentTypes['getShopReceipt'][0])
    {
        return $this->getShopReceiptAsyncWithHttpInfo($shop_id, $receipt_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShopReceiptAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopReceiptAsyncWithHttpInfo($shop_id, $receipt_id, string $contentType = self::contentTypes['getShopReceipt'][0])
    {
        $returnType = '\Etsy\Model\ShopReceipt';
        $request = $this->getShopReceiptRequest($shop_id, $receipt_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShopReceipt'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShopReceiptRequest($shop_id, $receipt_id, string $contentType = self::contentTypes['getShopReceipt'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getShopReceipt'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReceiptApi.getShopReceipt, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'receipt_id' is set
        if ($receipt_id === null || (is_array($receipt_id) && count($receipt_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipt_id when calling getShopReceipt'
            );
        }
        if ($receipt_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$receipt_id" when calling ShopReceiptApi.getShopReceipt, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/receipts/{receipt_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($receipt_id !== null) {
            $resourcePath = str_replace(
                '{' . 'receipt_id' . '}',
                ObjectSerializer::toPathValue($receipt_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getShopReceipts
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $min_created The earliest unix timestamp for when a record was created. (optional)
     * @param  int $max_created The latest unix timestamp for when a record was created. (optional)
     * @param  int $min_last_modified The earliest unix timestamp for when a record last changed. (optional)
     * @param  int $max_last_modified The latest unix timestamp for when a record last changed. (optional)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort receipts by. (optional, default to 'desc')
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_delivered When &#x60;true&#x60;, returns receipts that have been marked as delivered. When &#x60;false&#x60;, returns receipts where shipment has not been marked as delivered. (optional)
     * @param  bool $was_canceled When &#x60;true&#x60;, the endpoint will only return the canceled receipts. When &#x60;false&#x60;, the endpoint will only return non-canceled receipts. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipts'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopReceipts|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getShopReceipts($shop_id, $min_created = null, $max_created = null, $min_last_modified = null, $max_last_modified = null, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $was_paid = null, $was_shipped = null, $was_delivered = null, $was_canceled = null, string $contentType = self::contentTypes['getShopReceipts'][0])
    {
        list($response) = $this->getShopReceiptsWithHttpInfo($shop_id, $min_created, $max_created, $min_last_modified, $max_last_modified, $limit, $offset, $sort_on, $sort_order, $was_paid, $was_shipped, $was_delivered, $was_canceled, $contentType);
        return $response;
    }

    /**
     * Operation getShopReceiptsWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $min_created The earliest unix timestamp for when a record was created. (optional)
     * @param  int $max_created The latest unix timestamp for when a record was created. (optional)
     * @param  int $min_last_modified The earliest unix timestamp for when a record last changed. (optional)
     * @param  int $max_last_modified The latest unix timestamp for when a record last changed. (optional)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort receipts by. (optional, default to 'desc')
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_delivered When &#x60;true&#x60;, returns receipts that have been marked as delivered. When &#x60;false&#x60;, returns receipts where shipment has not been marked as delivered. (optional)
     * @param  bool $was_canceled When &#x60;true&#x60;, the endpoint will only return the canceled receipts. When &#x60;false&#x60;, the endpoint will only return non-canceled receipts. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipts'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopReceipts|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getShopReceiptsWithHttpInfo($shop_id, $min_created = null, $max_created = null, $min_last_modified = null, $max_last_modified = null, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $was_paid = null, $was_shipped = null, $was_delivered = null, $was_canceled = null, string $contentType = self::contentTypes['getShopReceipts'][0])
    {
        $request = $this->getShopReceiptsRequest($shop_id, $min_created, $max_created, $min_last_modified, $max_last_modified, $limit, $offset, $sort_on, $sort_order, $was_paid, $was_shipped, $was_delivered, $was_canceled, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopReceipts' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopReceipts' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopReceipts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopReceipts';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopReceipts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getShopReceiptsAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $min_created The earliest unix timestamp for when a record was created. (optional)
     * @param  int $max_created The latest unix timestamp for when a record was created. (optional)
     * @param  int $min_last_modified The earliest unix timestamp for when a record last changed. (optional)
     * @param  int $max_last_modified The latest unix timestamp for when a record last changed. (optional)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort receipts by. (optional, default to 'desc')
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_delivered When &#x60;true&#x60;, returns receipts that have been marked as delivered. When &#x60;false&#x60;, returns receipts where shipment has not been marked as delivered. (optional)
     * @param  bool $was_canceled When &#x60;true&#x60;, the endpoint will only return the canceled receipts. When &#x60;false&#x60;, the endpoint will only return non-canceled receipts. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopReceiptsAsync($shop_id, $min_created = null, $max_created = null, $min_last_modified = null, $max_last_modified = null, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $was_paid = null, $was_shipped = null, $was_delivered = null, $was_canceled = null, string $contentType = self::contentTypes['getShopReceipts'][0])
    {
        return $this->getShopReceiptsAsyncWithHttpInfo($shop_id, $min_created, $max_created, $min_last_modified, $max_last_modified, $limit, $offset, $sort_on, $sort_order, $was_paid, $was_shipped, $was_delivered, $was_canceled, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getShopReceiptsAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $min_created The earliest unix timestamp for when a record was created. (optional)
     * @param  int $max_created The latest unix timestamp for when a record was created. (optional)
     * @param  int $min_last_modified The earliest unix timestamp for when a record last changed. (optional)
     * @param  int $max_last_modified The latest unix timestamp for when a record last changed. (optional)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort receipts by. (optional, default to 'desc')
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_delivered When &#x60;true&#x60;, returns receipts that have been marked as delivered. When &#x60;false&#x60;, returns receipts where shipment has not been marked as delivered. (optional)
     * @param  bool $was_canceled When &#x60;true&#x60;, the endpoint will only return the canceled receipts. When &#x60;false&#x60;, the endpoint will only return non-canceled receipts. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShopReceiptsAsyncWithHttpInfo($shop_id, $min_created = null, $max_created = null, $min_last_modified = null, $max_last_modified = null, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $was_paid = null, $was_shipped = null, $was_delivered = null, $was_canceled = null, string $contentType = self::contentTypes['getShopReceipts'][0])
    {
        $returnType = '\Etsy\Model\ShopReceipts';
        $request = $this->getShopReceiptsRequest($shop_id, $min_created, $max_created, $min_last_modified, $max_last_modified, $limit, $offset, $sort_on, $sort_order, $was_paid, $was_shipped, $was_delivered, $was_canceled, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getShopReceipts'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $min_created The earliest unix timestamp for when a record was created. (optional)
     * @param  int $max_created The latest unix timestamp for when a record was created. (optional)
     * @param  int $min_last_modified The earliest unix timestamp for when a record last changed. (optional)
     * @param  int $max_last_modified The latest unix timestamp for when a record last changed. (optional)
     * @param  int $limit The maximum number of results to return. (optional, default to 25)
     * @param  int $offset The number of records to skip before selecting the first result. (optional, default to 0)
     * @param  string $sort_on The value to sort a search result of listings on. (optional, default to 'created')
     * @param  string $sort_order The ascending(up) or descending(down) order to sort receipts by. (optional, default to 'desc')
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_delivered When &#x60;true&#x60;, returns receipts that have been marked as delivered. When &#x60;false&#x60;, returns receipts where shipment has not been marked as delivered. (optional)
     * @param  bool $was_canceled When &#x60;true&#x60;, the endpoint will only return the canceled receipts. When &#x60;false&#x60;, the endpoint will only return non-canceled receipts. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getShopReceipts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getShopReceiptsRequest($shop_id, $min_created = null, $max_created = null, $min_last_modified = null, $max_last_modified = null, $limit = 25, $offset = 0, $sort_on = 'created', $sort_order = 'desc', $was_paid = null, $was_shipped = null, $was_delivered = null, $was_canceled = null, string $contentType = self::contentTypes['getShopReceipts'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getShopReceipts'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReceiptApi.getShopReceipts, must be bigger than or equal to 1.');
        }
        
        if ($min_created !== null && $min_created < 946684800) {
            throw new \InvalidArgumentException('invalid value for "$min_created" when calling ShopReceiptApi.getShopReceipts, must be bigger than or equal to 946684800.');
        }
        
        if ($max_created !== null && $max_created < 946684800) {
            throw new \InvalidArgumentException('invalid value for "$max_created" when calling ShopReceiptApi.getShopReceipts, must be bigger than or equal to 946684800.');
        }
        
        if ($min_last_modified !== null && $min_last_modified < 946684800) {
            throw new \InvalidArgumentException('invalid value for "$min_last_modified" when calling ShopReceiptApi.getShopReceipts, must be bigger than or equal to 946684800.');
        }
        
        if ($max_last_modified !== null && $max_last_modified < 946684800) {
            throw new \InvalidArgumentException('invalid value for "$max_last_modified" when calling ShopReceiptApi.getShopReceipts, must be bigger than or equal to 946684800.');
        }
        
        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopReceiptApi.getShopReceipts, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ShopReceiptApi.getShopReceipts, must be bigger than or equal to 1.');
        }
        
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling ShopReceiptApi.getShopReceipts, must be bigger than or equal to 0.');
        }
        







        $resourcePath = '/v3/application/shops/{shop_id}/receipts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_created,
            'min_created', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_created,
            'max_created', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $min_last_modified,
            'min_last_modified', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $max_last_modified,
            'max_last_modified', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_on,
            'sort_on', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sort_order', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $was_paid,
            'was_paid', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $was_shipped,
            'was_shipped', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $was_delivered,
            'was_delivered', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $was_canceled,
            'was_canceled', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateShopReceipt
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReceipt'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopReceipt|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function updateShopReceipt($shop_id, $receipt_id, $was_shipped = null, $was_paid = null, string $contentType = self::contentTypes['updateShopReceipt'][0])
    {
        list($response) = $this->updateShopReceiptWithHttpInfo($shop_id, $receipt_id, $was_shipped, $was_paid, $contentType);
        return $response;
    }

    /**
     * Operation updateShopReceiptWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReceipt'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopReceipt|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateShopReceiptWithHttpInfo($shop_id, $receipt_id, $was_shipped = null, $was_paid = null, string $contentType = self::contentTypes['updateShopReceipt'][0])
    {
        $request = $this->updateShopReceiptRequest($shop_id, $receipt_id, $was_shipped, $was_paid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopReceipt' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopReceipt' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopReceipt', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopReceipt';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopReceipt',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateShopReceiptAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReceipt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopReceiptAsync($shop_id, $receipt_id, $was_shipped = null, $was_paid = null, string $contentType = self::contentTypes['updateShopReceipt'][0])
    {
        return $this->updateShopReceiptAsyncWithHttpInfo($shop_id, $receipt_id, $was_shipped, $was_paid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateShopReceiptAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReceipt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShopReceiptAsyncWithHttpInfo($shop_id, $receipt_id, $was_shipped = null, $was_paid = null, string $contentType = self::contentTypes['updateShopReceipt'][0])
    {
        $returnType = '\Etsy\Model\ShopReceipt';
        $request = $this->updateShopReceiptRequest($shop_id, $receipt_id, $was_shipped, $was_paid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateShopReceipt'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $receipt_id The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. (required)
     * @param  bool $was_shipped When &#x60;true&#x60;, returns receipts where the seller shipped the product(s) in this receipt. When &#x60;false&#x60;, returns receipts where shipment has not been set. (optional)
     * @param  bool $was_paid When &#x60;true&#x60;, returns receipts where the seller has recieved payment for the receipt. When &#x60;false&#x60;, returns receipts where payment has not been received. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShopReceipt'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateShopReceiptRequest($shop_id, $receipt_id, $was_shipped = null, $was_paid = null, string $contentType = self::contentTypes['updateShopReceipt'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling updateShopReceipt'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopReceiptApi.updateShopReceipt, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'receipt_id' is set
        if ($receipt_id === null || (is_array($receipt_id) && count($receipt_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $receipt_id when calling updateShopReceipt'
            );
        }
        if ($receipt_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$receipt_id" when calling ShopReceiptApi.updateShopReceipt, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/v3/application/shops/{shop_id}/receipts/{receipt_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($receipt_id !== null) {
            $resourcePath = str_replace(
                '{' . 'receipt_id' . '}',
                ObjectSerializer::toPathValue($receipt_id),
                $resourcePath
            );
        }

        // form params
        if ($was_shipped !== null) {
            $formParams['was_shipped'] = ObjectSerializer::toFormValue($was_shipped);
        }
        // form params
        if ($was_paid !== null) {
            $formParams['was_paid'] = ObjectSerializer::toFormValue($was_paid);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
