<?php
/**
 * ShopListingImageApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Etsy\ApiException;
use Etsy\Configuration;
use Etsy\HeaderSelector;
use Etsy\ObjectSerializer;

/**
 * ShopListingImageApi Class Doc Comment
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ShopListingImageApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'deleteListingImage' => [
            'application/json',
        ],
        'getListingImage' => [
            'application/json',
        ],
        'getListingImageDeprecated' => [
            'application/json',
        ],
        'getListingImages' => [
            'application/json',
        ],
        'getListingImagesDeprecated' => [
            'application/json',
        ],
        'uploadListingImage' => [
            'multipart/form-data',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteListingImage
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingImage'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteListingImage($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['deleteListingImage'][0])
    {
        $this->deleteListingImageWithHttpInfo($shop_id, $listing_id, $listing_image_id, $contentType);
    }

    /**
     * Operation deleteListingImageWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingImage'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteListingImageWithHttpInfo($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['deleteListingImage'][0])
    {
        $request = $this->deleteListingImageRequest($shop_id, $listing_id, $listing_image_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteListingImageAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteListingImageAsync($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['deleteListingImage'][0])
    {
        return $this->deleteListingImageAsyncWithHttpInfo($shop_id, $listing_id, $listing_image_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteListingImageAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteListingImageAsyncWithHttpInfo($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['deleteListingImage'][0])
    {
        $returnType = '';
        $request = $this->deleteListingImageRequest($shop_id, $listing_id, $listing_image_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteListingImage'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteListingImageRequest($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['deleteListingImage'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling deleteListingImage'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingImageApi.deleteListingImage, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling deleteListingImage'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingImageApi.deleteListingImage, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_image_id' is set
        if ($listing_image_id === null || (is_array($listing_image_id) && count($listing_image_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_image_id when calling deleteListingImage'
            );
        }
        if ($listing_image_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_image_id" when calling ShopListingImageApi.deleteListingImage, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/images/{listing_image_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_image_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_image_id' . '}',
                ObjectSerializer::toPathValue($listing_image_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingImage
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImage'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ListingImage|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingImage($listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImage'][0])
    {
        list($response) = $this->getListingImageWithHttpInfo($listing_id, $listing_image_id, $contentType);
        return $response;
    }

    /**
     * Operation getListingImageWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImage'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ListingImage|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingImageWithHttpInfo($listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImage'][0])
    {
        $request = $this->getListingImageRequest($listing_id, $listing_image_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ListingImage' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ListingImage' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ListingImage', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ListingImage';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ListingImage',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingImageAsync
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingImageAsync($listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImage'][0])
    {
        return $this->getListingImageAsyncWithHttpInfo($listing_id, $listing_image_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingImageAsyncWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingImageAsyncWithHttpInfo($listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImage'][0])
    {
        $returnType = '\Etsy\Model\ListingImage';
        $request = $this->getListingImageRequest($listing_id, $listing_image_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingImage'
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingImageRequest($listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImage'][0])
    {

        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling getListingImage'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingImageApi.getListingImage, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_image_id' is set
        if ($listing_image_id === null || (is_array($listing_image_id) && count($listing_image_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_image_id when calling getListingImage'
            );
        }
        if ($listing_image_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_image_id" when calling ShopListingImageApi.getListingImage, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/listings/{listing_id}/images/{listing_image_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_image_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_image_id' . '}',
                ObjectSerializer::toPathValue($listing_image_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingImageDeprecated
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImageDeprecated'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ListingImage|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingImageDeprecated($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImageDeprecated'][0])
    {
        list($response) = $this->getListingImageDeprecatedWithHttpInfo($shop_id, $listing_id, $listing_image_id, $contentType);
        return $response;
    }

    /**
     * Operation getListingImageDeprecatedWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImageDeprecated'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ListingImage|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingImageDeprecatedWithHttpInfo($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImageDeprecated'][0])
    {
        $request = $this->getListingImageDeprecatedRequest($shop_id, $listing_id, $listing_image_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ListingImage' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ListingImage' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ListingImage', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ListingImage';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ListingImage',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingImageDeprecatedAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImageDeprecated'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingImageDeprecatedAsync($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImageDeprecated'][0])
    {
        return $this->getListingImageDeprecatedAsyncWithHttpInfo($shop_id, $listing_id, $listing_image_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingImageDeprecatedAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImageDeprecated'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingImageDeprecatedAsyncWithHttpInfo($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImageDeprecated'][0])
    {
        $returnType = '\Etsy\Model\ListingImage';
        $request = $this->getListingImageDeprecatedRequest($shop_id, $listing_id, $listing_image_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingImageDeprecated'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImageDeprecated'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingImageDeprecatedRequest($shop_id, $listing_id, $listing_image_id, string $contentType = self::contentTypes['getListingImageDeprecated'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getListingImageDeprecated'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingImageApi.getListingImageDeprecated, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling getListingImageDeprecated'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingImageApi.getListingImageDeprecated, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_image_id' is set
        if ($listing_image_id === null || (is_array($listing_image_id) && count($listing_image_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_image_id when calling getListingImageDeprecated'
            );
        }
        if ($listing_image_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_image_id" when calling ShopListingImageApi.getListingImageDeprecated, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/images/{listing_image_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_image_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_image_id' . '}',
                ObjectSerializer::toPathValue($listing_image_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingImages
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImages'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ListingImages|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingImages($listing_id, string $contentType = self::contentTypes['getListingImages'][0])
    {
        list($response) = $this->getListingImagesWithHttpInfo($listing_id, $contentType);
        return $response;
    }

    /**
     * Operation getListingImagesWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImages'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ListingImages|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingImagesWithHttpInfo($listing_id, string $contentType = self::contentTypes['getListingImages'][0])
    {
        $request = $this->getListingImagesRequest($listing_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ListingImages' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ListingImages' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ListingImages', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ListingImages';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ListingImages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingImagesAsync
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingImagesAsync($listing_id, string $contentType = self::contentTypes['getListingImages'][0])
    {
        return $this->getListingImagesAsyncWithHttpInfo($listing_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingImagesAsyncWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingImagesAsyncWithHttpInfo($listing_id, string $contentType = self::contentTypes['getListingImages'][0])
    {
        $returnType = '\Etsy\Model\ListingImages';
        $request = $this->getListingImagesRequest($listing_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingImages'
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingImagesRequest($listing_id, string $contentType = self::contentTypes['getListingImages'][0])
    {

        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling getListingImages'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingImageApi.getListingImages, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/listings/{listing_id}/images';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingImagesDeprecated
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImagesDeprecated'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ListingImages|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingImagesDeprecated($shop_id, $listing_id, string $contentType = self::contentTypes['getListingImagesDeprecated'][0])
    {
        list($response) = $this->getListingImagesDeprecatedWithHttpInfo($shop_id, $listing_id, $contentType);
        return $response;
    }

    /**
     * Operation getListingImagesDeprecatedWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImagesDeprecated'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ListingImages|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingImagesDeprecatedWithHttpInfo($shop_id, $listing_id, string $contentType = self::contentTypes['getListingImagesDeprecated'][0])
    {
        $request = $this->getListingImagesDeprecatedRequest($shop_id, $listing_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ListingImages' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ListingImages' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ListingImages', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ListingImages';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ListingImages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingImagesDeprecatedAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImagesDeprecated'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingImagesDeprecatedAsync($shop_id, $listing_id, string $contentType = self::contentTypes['getListingImagesDeprecated'][0])
    {
        return $this->getListingImagesDeprecatedAsyncWithHttpInfo($shop_id, $listing_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingImagesDeprecatedAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImagesDeprecated'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingImagesDeprecatedAsyncWithHttpInfo($shop_id, $listing_id, string $contentType = self::contentTypes['getListingImagesDeprecated'][0])
    {
        $returnType = '\Etsy\Model\ListingImages';
        $request = $this->getListingImagesDeprecatedRequest($shop_id, $listing_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingImagesDeprecated'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingImagesDeprecated'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingImagesDeprecatedRequest($shop_id, $listing_id, string $contentType = self::contentTypes['getListingImagesDeprecated'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getListingImagesDeprecated'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingImageApi.getListingImagesDeprecated, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling getListingImagesDeprecated'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingImageApi.getListingImagesDeprecated, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/images';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadListingImage
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  \SplFileObject $image The file name string of a file to upload (optional)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  bool $overwrite When true, this request replaces the existing image at a given rank. (optional, default to false)
     * @param  bool $is_watermarked When true, indicates that the uploaded image has a watermark. (optional, default to false)
     * @param  string $alt_text Alt text for the listing image. Max length 250 characters. (optional, default to '')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingImage'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ListingImage|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function uploadListingImage($shop_id, $listing_id, $image = null, $listing_image_id = null, $rank = 1, $overwrite = false, $is_watermarked = false, $alt_text = '', string $contentType = self::contentTypes['uploadListingImage'][0])
    {
        list($response) = $this->uploadListingImageWithHttpInfo($shop_id, $listing_id, $image, $listing_image_id, $rank, $overwrite, $is_watermarked, $alt_text, $contentType);
        return $response;
    }

    /**
     * Operation uploadListingImageWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  \SplFileObject $image The file name string of a file to upload (optional)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  bool $overwrite When true, this request replaces the existing image at a given rank. (optional, default to false)
     * @param  bool $is_watermarked When true, indicates that the uploaded image has a watermark. (optional, default to false)
     * @param  string $alt_text Alt text for the listing image. Max length 250 characters. (optional, default to '')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingImage'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ListingImage|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadListingImageWithHttpInfo($shop_id, $listing_id, $image = null, $listing_image_id = null, $rank = 1, $overwrite = false, $is_watermarked = false, $alt_text = '', string $contentType = self::contentTypes['uploadListingImage'][0])
    {
        $request = $this->uploadListingImageRequest($shop_id, $listing_id, $image, $listing_image_id, $rank, $overwrite, $is_watermarked, $alt_text, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\Etsy\Model\ListingImage' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ListingImage' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ListingImage', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 409:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ListingImage';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ListingImage',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation uploadListingImageAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  \SplFileObject $image The file name string of a file to upload (optional)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  bool $overwrite When true, this request replaces the existing image at a given rank. (optional, default to false)
     * @param  bool $is_watermarked When true, indicates that the uploaded image has a watermark. (optional, default to false)
     * @param  string $alt_text Alt text for the listing image. Max length 250 characters. (optional, default to '')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadListingImageAsync($shop_id, $listing_id, $image = null, $listing_image_id = null, $rank = 1, $overwrite = false, $is_watermarked = false, $alt_text = '', string $contentType = self::contentTypes['uploadListingImage'][0])
    {
        return $this->uploadListingImageAsyncWithHttpInfo($shop_id, $listing_id, $image, $listing_image_id, $rank, $overwrite, $is_watermarked, $alt_text, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadListingImageAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  \SplFileObject $image The file name string of a file to upload (optional)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  bool $overwrite When true, this request replaces the existing image at a given rank. (optional, default to false)
     * @param  bool $is_watermarked When true, indicates that the uploaded image has a watermark. (optional, default to false)
     * @param  string $alt_text Alt text for the listing image. Max length 250 characters. (optional, default to '')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadListingImageAsyncWithHttpInfo($shop_id, $listing_id, $image = null, $listing_image_id = null, $rank = 1, $overwrite = false, $is_watermarked = false, $alt_text = '', string $contentType = self::contentTypes['uploadListingImage'][0])
    {
        $returnType = '\Etsy\Model\ListingImage';
        $request = $this->uploadListingImageRequest($shop_id, $listing_id, $image, $listing_image_id, $rank, $overwrite, $is_watermarked, $alt_text, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadListingImage'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  \SplFileObject $image The file name string of a file to upload (optional)
     * @param  int $listing_image_id The numeric ID of the primary [listing image](/documentation/reference#tag/ShopListing-Image) for this transaction. (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  bool $overwrite When true, this request replaces the existing image at a given rank. (optional, default to false)
     * @param  bool $is_watermarked When true, indicates that the uploaded image has a watermark. (optional, default to false)
     * @param  string $alt_text Alt text for the listing image. Max length 250 characters. (optional, default to '')
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadListingImageRequest($shop_id, $listing_id, $image = null, $listing_image_id = null, $rank = 1, $overwrite = false, $is_watermarked = false, $alt_text = '', string $contentType = self::contentTypes['uploadListingImage'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling uploadListingImage'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingImageApi.uploadListingImage, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling uploadListingImage'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingImageApi.uploadListingImage, must be bigger than or equal to 1.');
        }
        

        if ($listing_image_id !== null && $listing_image_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_image_id" when calling ShopListingImageApi.uploadListingImage, must be bigger than or equal to 1.');
        }
        
        if ($rank !== null && $rank < 0) {
            throw new \InvalidArgumentException('invalid value for "$rank" when calling ShopListingImageApi.uploadListingImage, must be bigger than or equal to 0.');
        }
        




        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/images';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }

        // form params
        if ($image !== null) {
            $multipart = true;
            $formParams['image'] = [];
            $paramFiles = is_array($image) ? $image : [$image];
            foreach ($paramFiles as $paramFile) {
                $formParams['image'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($listing_image_id !== null) {
            $formParams['listing_image_id'] = ObjectSerializer::toFormValue($listing_image_id);
        }
        // form params
        if ($rank !== null) {
            $formParams['rank'] = ObjectSerializer::toFormValue($rank);
        }
        // form params
        if ($overwrite !== null) {
            $formParams['overwrite'] = ObjectSerializer::toFormValue($overwrite);
        }
        // form params
        if ($is_watermarked !== null) {
            $formParams['is_watermarked'] = ObjectSerializer::toFormValue($is_watermarked);
        }
        // form params
        if ($alt_text !== null) {
            $formParams['alt_text'] = ObjectSerializer::toFormValue($alt_text);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
