<?php
/**
 * ShopListingFileApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Etsy Open API v3
 *
 * <div class=\"wt-text-body-01\"><p class=\"wt-pt-xs-2 wt-pb-xs-2\">Etsy's Open API provides a simple RESTful interface for various Etsy.com features. The API endpoints are meant to replace Etsy's Open API v2, which is scheduled to end service in 2022.</p><p class=\"wt-pb-xs-2\">All of the endpoints are callable and the majority of the API endpoints are now in a beta phase. This means we do not expect to make any breaking changes before our general release. A handful of endpoints are currently interface stubs (labeled “Feedback Only”) and returns a \"501 Not Implemented\" response code when called.</p><p class=\"wt-pb-xs-2\">If you'd like to report an issue or provide feedback on the API design, <a target=\"_blank\" class=\"wt-text-link wt-p-xs-0\" href=\"https://github.com/etsy/open-api/discussions\">please add an issue in Github</a>.</p></div>&copy; 2021-2023 Etsy, Inc. All Rights Reserved. Use of this code is subject to Etsy's <a class='wt-text-link wt-p-xs-0' target='_blank' href='https://www.etsy.com/legal/api'>API Developer Terms of Use</a>.
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: developers@etsy.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.6.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Etsy\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Etsy\ApiException;
use Etsy\Configuration;
use Etsy\HeaderSelector;
use Etsy\ObjectSerializer;

/**
 * ShopListingFileApi Class Doc Comment
 *
 * @category Class
 * @package  Etsy
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ShopListingFileApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'deleteListingFile' => [
            'application/json',
        ],
        'getAllListingFiles' => [
            'application/json',
        ],
        'getListingFile' => [
            'application/json',
        ],
        'uploadListingFile' => [
            'multipart/form-data',
        ],
    ];

/**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteListingFile
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingFile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteListingFile($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['deleteListingFile'][0])
    {
        $this->deleteListingFileWithHttpInfo($shop_id, $listing_id, $listing_file_id, $contentType);
    }

    /**
     * Operation deleteListingFileWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingFile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteListingFileWithHttpInfo($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['deleteListingFile'][0])
    {
        $request = $this->deleteListingFileRequest($shop_id, $listing_id, $listing_file_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 409:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteListingFileAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteListingFileAsync($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['deleteListingFile'][0])
    {
        return $this->deleteListingFileAsyncWithHttpInfo($shop_id, $listing_id, $listing_file_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteListingFileAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteListingFileAsyncWithHttpInfo($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['deleteListingFile'][0])
    {
        $returnType = '';
        $request = $this->deleteListingFileRequest($shop_id, $listing_id, $listing_file_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteListingFile'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteListingFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteListingFileRequest($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['deleteListingFile'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling deleteListingFile'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingFileApi.deleteListingFile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling deleteListingFile'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingFileApi.deleteListingFile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_file_id' is set
        if ($listing_file_id === null || (is_array($listing_file_id) && count($listing_file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_file_id when calling deleteListingFile'
            );
        }
        if ($listing_file_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_file_id" when calling ShopListingFileApi.deleteListingFile, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/files/{listing_file_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_file_id' . '}',
                ObjectSerializer::toPathValue($listing_file_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllListingFiles
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllListingFiles'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListingFiles|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getAllListingFiles($listing_id, $shop_id, string $contentType = self::contentTypes['getAllListingFiles'][0])
    {
        list($response) = $this->getAllListingFilesWithHttpInfo($listing_id, $shop_id, $contentType);
        return $response;
    }

    /**
     * Operation getAllListingFilesWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllListingFiles'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListingFiles|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllListingFilesWithHttpInfo($listing_id, $shop_id, string $contentType = self::contentTypes['getAllListingFiles'][0])
    {
        $request = $this->getAllListingFilesRequest($listing_id, $shop_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListingFiles' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListingFiles' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListingFiles', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListingFiles';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListingFiles',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllListingFilesAsync
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllListingFiles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllListingFilesAsync($listing_id, $shop_id, string $contentType = self::contentTypes['getAllListingFiles'][0])
    {
        return $this->getAllListingFilesAsyncWithHttpInfo($listing_id, $shop_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllListingFilesAsyncWithHttpInfo
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllListingFiles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllListingFilesAsyncWithHttpInfo($listing_id, $shop_id, string $contentType = self::contentTypes['getAllListingFiles'][0])
    {
        $returnType = '\Etsy\Model\ShopListingFiles';
        $request = $this->getAllListingFilesRequest($listing_id, $shop_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllListingFiles'
     *
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllListingFiles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllListingFilesRequest($listing_id, $shop_id, string $contentType = self::contentTypes['getAllListingFiles'][0])
    {

        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling getAllListingFiles'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingFileApi.getAllListingFiles, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getAllListingFiles'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingFileApi.getAllListingFiles, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/files';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }
        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getListingFile
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingFile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListingFile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function getListingFile($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['getListingFile'][0])
    {
        list($response) = $this->getListingFileWithHttpInfo($shop_id, $listing_id, $listing_file_id, $contentType);
        return $response;
    }

    /**
     * Operation getListingFileWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingFile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListingFile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function getListingFileWithHttpInfo($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['getListingFile'][0])
    {
        $request = $this->getListingFileRequest($shop_id, $listing_id, $listing_file_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Etsy\Model\ShopListingFile' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListingFile' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListingFile', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListingFile';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListingFile',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getListingFileAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingFileAsync($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['getListingFile'][0])
    {
        return $this->getListingFileAsyncWithHttpInfo($shop_id, $listing_id, $listing_file_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getListingFileAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getListingFileAsyncWithHttpInfo($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['getListingFile'][0])
    {
        $returnType = '\Etsy\Model\ShopListingFile';
        $request = $this->getListingFileRequest($shop_id, $listing_id, $listing_file_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getListingFile'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getListingFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getListingFileRequest($shop_id, $listing_id, $listing_file_id, string $contentType = self::contentTypes['getListingFile'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling getListingFile'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingFileApi.getListingFile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling getListingFile'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingFileApi.getListingFile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_file_id' is set
        if ($listing_file_id === null || (is_array($listing_file_id) && count($listing_file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_file_id when calling getListingFile'
            );
        }
        if ($listing_file_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_file_id" when calling ShopListingFileApi.getListingFile, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/files/{listing_file_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_file_id' . '}',
                ObjectSerializer::toPathValue($listing_file_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadListingFile
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (optional)
     * @param  \SplFileObject $file A binary file to upload. (optional)
     * @param  string $name The file name string of a file to upload (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingFile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Etsy\Model\ShopListingFile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema
     */
    public function uploadListingFile($shop_id, $listing_id, $listing_file_id = null, $file = null, $name = null, $rank = 1, string $contentType = self::contentTypes['uploadListingFile'][0])
    {
        list($response) = $this->uploadListingFileWithHttpInfo($shop_id, $listing_id, $listing_file_id, $file, $name, $rank, $contentType);
        return $response;
    }

    /**
     * Operation uploadListingFileWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (optional)
     * @param  \SplFileObject $file A binary file to upload. (optional)
     * @param  string $name The file name string of a file to upload (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingFile'] to see the possible values for this operation
     *
     * @throws \Etsy\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Etsy\Model\ShopListingFile|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema|\Etsy\Model\ErrorSchema, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadListingFileWithHttpInfo($shop_id, $listing_id, $listing_file_id = null, $file = null, $name = null, $rank = 1, string $contentType = self::contentTypes['uploadListingFile'][0])
    {
        $request = $this->uploadListingFileRequest($shop_id, $listing_id, $listing_file_id, $file, $name, $rank, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\Etsy\Model\ShopListingFile' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ShopListingFile' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ShopListingFile', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 403:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 500:
                    if ('\Etsy\Model\ErrorSchema' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Etsy\Model\ErrorSchema' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Etsy\Model\ErrorSchema', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Etsy\Model\ShopListingFile';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ShopListingFile',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Etsy\Model\ErrorSchema',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation uploadListingFileAsync
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (optional)
     * @param  \SplFileObject $file A binary file to upload. (optional)
     * @param  string $name The file name string of a file to upload (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadListingFileAsync($shop_id, $listing_id, $listing_file_id = null, $file = null, $name = null, $rank = 1, string $contentType = self::contentTypes['uploadListingFile'][0])
    {
        return $this->uploadListingFileAsyncWithHttpInfo($shop_id, $listing_id, $listing_file_id, $file, $name, $rank, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadListingFileAsyncWithHttpInfo
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (optional)
     * @param  \SplFileObject $file A binary file to upload. (optional)
     * @param  string $name The file name string of a file to upload (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadListingFileAsyncWithHttpInfo($shop_id, $listing_id, $listing_file_id = null, $file = null, $name = null, $rank = 1, string $contentType = self::contentTypes['uploadListingFile'][0])
    {
        $returnType = '\Etsy\Model\ShopListingFile';
        $request = $this->uploadListingFileRequest($shop_id, $listing_id, $listing_file_id, $file, $name, $rank, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadListingFile'
     *
     * @param  int $shop_id The unique positive non-zero numeric ID for an Etsy Shop. (required)
     * @param  int $listing_id The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. (required)
     * @param  int $listing_file_id The unique numeric ID of a file associated with a digital listing. (optional)
     * @param  \SplFileObject $file A binary file to upload. (optional)
     * @param  string $name The file name string of a file to upload (optional)
     * @param  int $rank The positive non-zero numeric position in the images displayed in a listing, with rank 1 images appearing in the left-most position in a listing. (optional, default to 1)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadListingFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadListingFileRequest($shop_id, $listing_id, $listing_file_id = null, $file = null, $name = null, $rank = 1, string $contentType = self::contentTypes['uploadListingFile'][0])
    {

        // verify the required parameter 'shop_id' is set
        if ($shop_id === null || (is_array($shop_id) && count($shop_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_id when calling uploadListingFile'
            );
        }
        if ($shop_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$shop_id" when calling ShopListingFileApi.uploadListingFile, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'listing_id' is set
        if ($listing_id === null || (is_array($listing_id) && count($listing_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $listing_id when calling uploadListingFile'
            );
        }
        if ($listing_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_id" when calling ShopListingFileApi.uploadListingFile, must be bigger than or equal to 1.');
        }
        
        if ($listing_file_id !== null && $listing_file_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$listing_file_id" when calling ShopListingFileApi.uploadListingFile, must be bigger than or equal to 1.');
        }
        


        if ($rank !== null && $rank < 1) {
            throw new \InvalidArgumentException('invalid value for "$rank" when calling ShopListingFileApi.uploadListingFile, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/v3/application/shops/{shop_id}/listings/{listing_id}/files';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($shop_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shop_id' . '}',
                ObjectSerializer::toPathValue($shop_id),
                $resourcePath
            );
        }
        // path params
        if ($listing_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listing_id' . '}',
                ObjectSerializer::toPathValue($listing_id),
                $resourcePath
            );
        }

        // form params
        if ($listing_file_id !== null) {
            $formParams['listing_file_id'] = ObjectSerializer::toFormValue($listing_file_id);
        }
        // form params
        if ($file !== null) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($name !== null) {
            $formParams['name'] = ObjectSerializer::toFormValue($name);
        }
        // form params
        if ($rank !== null) {
            $formParams['rank'] = ObjectSerializer::toFormValue($rank);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-api-key');
        if ($apiKey !== null) {
            $headers['x-api-key'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
