# Etsy\ShopListingApi

All URIs are relative to https://openapi.etsy.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createDraftListing()**](ShopListingApi.md#createDraftListing) | **POST** /v3/application/shops/{shop_id}/listings |  |
| [**deleteListing()**](ShopListingApi.md#deleteListing) | **DELETE** /v3/application/listings/{listing_id} |  |
| [**deleteListingProperty()**](ShopListingApi.md#deleteListingProperty) | **DELETE** /v3/application/shops/{shop_id}/listings/{listing_id}/properties/{property_id} |  |
| [**findAllActiveListingsByShop()**](ShopListingApi.md#findAllActiveListingsByShop) | **GET** /v3/application/shops/{shop_id}/listings/active |  |
| [**findAllListingsActive()**](ShopListingApi.md#findAllListingsActive) | **GET** /v3/application/listings/active |  |
| [**getFeaturedListingsByShop()**](ShopListingApi.md#getFeaturedListingsByShop) | **GET** /v3/application/shops/{shop_id}/listings/featured |  |
| [**getListing()**](ShopListingApi.md#getListing) | **GET** /v3/application/listings/{listing_id} |  |
| [**getListingProperties()**](ShopListingApi.md#getListingProperties) | **GET** /v3/application/shops/{shop_id}/listings/{listing_id}/properties |  |
| [**getListingProperty()**](ShopListingApi.md#getListingProperty) | **GET** /v3/application/listings/{listing_id}/properties/{property_id} |  |
| [**getListingsByListingIds()**](ShopListingApi.md#getListingsByListingIds) | **GET** /v3/application/listings/batch |  |
| [**getListingsByShop()**](ShopListingApi.md#getListingsByShop) | **GET** /v3/application/shops/{shop_id}/listings |  |
| [**getListingsByShopReceipt()**](ShopListingApi.md#getListingsByShopReceipt) | **GET** /v3/application/shops/{shop_id}/receipts/{receipt_id}/listings |  |
| [**getListingsByShopReturnPolicy()**](ShopListingApi.md#getListingsByShopReturnPolicy) | **GET** /v3/application/shops/{shop_id}/policies/return/{return_policy_id}/listings |  |
| [**getListingsByShopSectionId()**](ShopListingApi.md#getListingsByShopSectionId) | **GET** /v3/application/shops/{shop_id}/shop-sections/listings |  |
| [**updateListing()**](ShopListingApi.md#updateListing) | **PATCH** /v3/application/shops/{shop_id}/listings/{listing_id} |  |
| [**updateListingDeprecated()**](ShopListingApi.md#updateListingDeprecated) | **PUT** /v3/application/shops/{shop_id}/listings/{listing_id} |  |
| [**updateListingProperty()**](ShopListingApi.md#updateListingProperty) | **PUT** /v3/application/shops/{shop_id}/listings/{listing_id}/properties/{property_id} |  |


## `createDraftListing()`

```php
createDraftListing($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id, $return_policy_id, $materials, $shop_section_id, $processing_min, $processing_max, $tags, $styles, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $production_partner_ids, $image_ids, $is_supply, $is_customizable, $should_auto_renew, $is_taxable, $type): \Etsy\Model\ShopListing
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Creates a physical draft [listing](/documentation/reference#tag/ShopListing) product in a shop on the Etsy channel.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$quantity = 56; // int | The positive non-zero number of products available for purchase in the listing. Note: The listing quantity is the sum of available offering quantities. You can request the quantities for individual offerings from the ListingInventory resource using the [getListingInventory](/documentation/reference#operation/getListingInventory) endpoint.
$title = 'title_example'; // string | The listing's title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, & and + characters once each.
$description = 'description_example'; // string | A description string of the product for sale in the listing.
$price = 3.4; // float | The positive non-zero price of the product. (Sold product listings are private) Note: The price is the minimum possible price. The [`getListingInventory`](/documentation/reference/#operation/getListingInventory) method requests exact prices for available offerings.
$who_made = 'who_made_example'; // string | An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires 'is_supply' and 'when_made'.
$when_made = 'when_made_example'; // string | An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires 'is_supply' and 'who_made'.
$taxonomy_id = 56; // int | The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information.
$shipping_profile_id = 56; // int | The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is `physical`.
$return_policy_id = 56; // int | The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies).
$materials = array('materials_example'); // string[] | A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null.
$shop_section_id = 56; // int | The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null.
$processing_min = 56; // int | The minimum number of days required to process this listing. Default value is null.
$processing_max = 56; // int | The maximum number of days required to process this listing. Default value is null.
$tags = array('tags_example'); // string[] | A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, ', ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-'™©®]/u) Default value is null.
$styles = array('styles_example'); // string[] | An array of style strings for this listing, each of which is free-form text string such as \\\"Formal\\\", or \\\"Steampunk\\\". When creating or updating a listing, the listing may have up to two styles. Valid style strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null.
$item_weight = 3.4; // float | The numeric weight of the product measured in units set in 'item_weight_unit'. Default value is null. If set, the value must be greater than 0.
$item_length = 3.4; // float | The numeric length of the product measured in units set in 'item_dimensions_unit'. Default value is null. If set, the value must be greater than 0.
$item_width = 3.4; // float | The numeric width of the product measured in units set in 'item_dimensions_unit'. Default value is null. If set, the value must be greater than 0.
$item_height = 3.4; // float | The numeric height of the product measured in units set in 'item_dimensions_unit'. Default value is null. If set, the value must be greater than 0.
$item_weight_unit = 'item_weight_unit_example'; // string | A string defining the units used to measure the weight of the product. Default value is null.
$item_dimensions_unit = 'item_dimensions_unit_example'; // string | A string defining the units used to measure the dimensions of the product. Default value is null.
$is_personalizable = True; // bool | When true, this listing is personalizable. The default value is null.
$personalization_is_required = True; // bool | When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is 'true'.
$personalization_char_count_max = 56; // int | This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is 'true'.
$personalization_instructions = 'personalization_instructions_example'; // string | A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is 'true'.
$production_partner_ids = array(56); // int[] | An array of unique IDs of production partner ids.
$image_ids = array(56); // int[] | An array of numeric image IDs of the images in a listing, which can include up to 10 images.
$is_supply = True; // bool | When true, tags the listing as a supply product, else indicates that it's a finished product. Helps buyers locate the listing under the Supplies heading. Requires 'who_made' and 'when_made'.
$is_customizable = True; // bool | When true, a buyer may contact the seller for a customized order. The default value is true when a shop accepts custom orders. Does not apply to shops that do not accept custom orders.
$should_auto_renew = True; // bool | When true, renews a listing for four months upon expiration.
$is_taxable = True; // bool | When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout.
$type = 'type_example'; // string | An enumerated type string that indicates whether the listing is physical or a digital download.

try {
    $result = $apiInstance->createDraftListing($shop_id, $quantity, $title, $description, $price, $who_made, $when_made, $taxonomy_id, $shipping_profile_id, $return_policy_id, $materials, $shop_section_id, $processing_min, $processing_max, $tags, $styles, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $production_partner_ids, $image_ids, $is_supply, $is_customizable, $should_auto_renew, $is_taxable, $type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->createDraftListing: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **quantity** | **int**| The positive non-zero number of products available for purchase in the listing. Note: The listing quantity is the sum of available offering quantities. You can request the quantities for individual offerings from the ListingInventory resource using the [getListingInventory](/documentation/reference#operation/getListingInventory) endpoint. | |
| **title** | **string**| The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. | |
| **description** | **string**| A description string of the product for sale in the listing. | |
| **price** | **float**| The positive non-zero price of the product. (Sold product listings are private) Note: The price is the minimum possible price. The [&#x60;getListingInventory&#x60;](/documentation/reference/#operation/getListingInventory) method requests exact prices for available offerings. | |
| **who_made** | **string**| An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. | |
| **when_made** | **string**| An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. | |
| **taxonomy_id** | **int**| The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. | |
| **shipping_profile_id** | **int**| The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. | [optional] |
| **return_policy_id** | **int**| The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). | [optional] |
| **materials** | [**string[]**](../Model/string.md)| A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. | [optional] |
| **shop_section_id** | **int**| The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. | [optional] |
| **processing_min** | **int**| The minimum number of days required to process this listing. Default value is null. | [optional] |
| **processing_max** | **int**| The maximum number of days required to process this listing. Default value is null. | [optional] |
| **tags** | [**string[]**](../Model/string.md)| A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. | [optional] |
| **styles** | [**string[]**](../Model/string.md)| An array of style strings for this listing, each of which is free-form text string such as \\\&quot;Formal\\\&quot;, or \\\&quot;Steampunk\\\&quot;. When creating or updating a listing, the listing may have up to two styles. Valid style strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. | [optional] |
| **item_weight** | **float**| The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_length** | **float**| The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_width** | **float**| The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_height** | **float**| The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_weight_unit** | **string**| A string defining the units used to measure the weight of the product. Default value is null. | [optional] |
| **item_dimensions_unit** | **string**| A string defining the units used to measure the dimensions of the product. Default value is null. | [optional] |
| **is_personalizable** | **bool**| When true, this listing is personalizable. The default value is null. | [optional] |
| **personalization_is_required** | **bool**| When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. | [optional] |
| **personalization_char_count_max** | **int**| This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. | [optional] |
| **personalization_instructions** | **string**| A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. | [optional] |
| **production_partner_ids** | [**int[]**](../Model/int.md)| An array of unique IDs of production partner ids. | [optional] |
| **image_ids** | [**int[]**](../Model/int.md)| An array of numeric image IDs of the images in a listing, which can include up to 10 images. | [optional] |
| **is_supply** | **bool**| When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. | [optional] |
| **is_customizable** | **bool**| When true, a buyer may contact the seller for a customized order. The default value is true when a shop accepts custom orders. Does not apply to shops that do not accept custom orders. | [optional] |
| **should_auto_renew** | **bool**| When true, renews a listing for four months upon expiration. | [optional] |
| **is_taxable** | **bool**| When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. | [optional] |
| **type** | **string**| An enumerated type string that indicates whether the listing is physical or a digital download. | [optional] |

### Return type

[**\Etsy\Model\ShopListing**](../Model/ShopListing.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: `application/x-www-form-urlencoded`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteListing()`

```php
deleteListing($listing_id)
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Open API V3 endpoint to delete a ShopListing. A ShopListing can be deleted only if the state is one of the following:  SOLD_OUT, DRAFT, EXPIRED, INACTIVE, ACTIVE and is_available or ACTIVE and has seller flags:  SUPRESSED (frozen), VACATION, CUSTOM_SHOPS (pattern), SELL_ON_FACEBOOK

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$listing_id = 56; // int | The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.

try {
    $apiInstance->deleteListing($listing_id);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->deleteListing: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **listing_id** | **int**| The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. | |

### Return type

void (empty response body)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteListingProperty()`

```php
deleteListingProperty($shop_id, $listing_id, $property_id)
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Deletes a property for a Listing.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$listing_id = 56; // int | The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
$property_id = 56; // int | The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties).

try {
    $apiInstance->deleteListingProperty($shop_id, $listing_id, $property_id);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->deleteListingProperty: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **listing_id** | **int**| The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. | |
| **property_id** | **int**| The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). | |

### Return type

void (empty response body)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `findAllActiveListingsByShop()`

```php
findAllActiveListingsByShop($shop_id, $limit, $sort_on, $sort_order, $offset, $keywords): \Etsy\Model\ShopListings
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Retrieves a list of all active listings on Etsy in a specific shop, paginated by listing creation date.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$limit = 25; // int | The maximum number of results to return.
$sort_on = 'created'; // string | The value to sort a search result of listings on. NOTES: a) `sort_on` only works when combined with one of the search options (keywords, region, etc.). b) when using `score` the returned results will always be in _descending_ order, regardless of the `sort_order` parameter.
$sort_order = 'desc'; // string | The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.).
$offset = 0; // int | The number of records to skip before selecting the first result.
$keywords = 'keywords_example'; // string | Search term or phrase that must appear in all results.

try {
    $result = $apiInstance->findAllActiveListingsByShop($shop_id, $limit, $sort_on, $sort_order, $offset, $keywords);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->findAllActiveListingsByShop: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **limit** | **int**| The maximum number of results to return. | [optional] [default to 25] |
| **sort_on** | **string**| The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. | [optional] [default to &#39;created&#39;] |
| **sort_order** | **string**| The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). | [optional] [default to &#39;desc&#39;] |
| **offset** | **int**| The number of records to skip before selecting the first result. | [optional] [default to 0] |
| **keywords** | **string**| Search term or phrase that must appear in all results. | [optional] |

### Return type

[**\Etsy\Model\ShopListings**](../Model/ShopListings.md)

### Authorization

[api_key](../../README.md#api_key)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `findAllListingsActive()`

```php
findAllListingsActive($limit, $offset, $keywords, $sort_on, $sort_order, $min_price, $max_price, $taxonomy_id, $shop_location): \Etsy\Model\ShopListings
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  A list of all active listings on Etsy paginated by their creation date. Without sort_order listings will be returned newest-first by default.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 25; // int | The maximum number of results to return.
$offset = 0; // int | The number of records to skip before selecting the first result.
$keywords = 'keywords_example'; // string | Search term or phrase that must appear in all results.
$sort_on = 'created'; // string | The value to sort a search result of listings on. NOTES: a) `sort_on` only works when combined with one of the search options (keywords, region, etc.). b) when using `score` the returned results will always be in _descending_ order, regardless of the `sort_order` parameter.
$sort_order = 'desc'; // string | The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.).
$min_price = 3.4; // float | The minimum price of listings to be returned by a search result.
$max_price = 3.4; // float | The maximum price of listings to be returned by a search result.
$taxonomy_id = 56; // int | The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information.
$shop_location = 'shop_location_example'; // string | Filters by shop location. If location cannot be parsed, Etsy responds with an error.

try {
    $result = $apiInstance->findAllListingsActive($limit, $offset, $keywords, $sort_on, $sort_order, $min_price, $max_price, $taxonomy_id, $shop_location);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->findAllListingsActive: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **limit** | **int**| The maximum number of results to return. | [optional] [default to 25] |
| **offset** | **int**| The number of records to skip before selecting the first result. | [optional] [default to 0] |
| **keywords** | **string**| Search term or phrase that must appear in all results. | [optional] |
| **sort_on** | **string**| The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. | [optional] [default to &#39;created&#39;] |
| **sort_order** | **string**| The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). | [optional] [default to &#39;desc&#39;] |
| **min_price** | **float**| The minimum price of listings to be returned by a search result. | [optional] |
| **max_price** | **float**| The maximum price of listings to be returned by a search result. | [optional] |
| **taxonomy_id** | **int**| The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. | [optional] |
| **shop_location** | **string**| Filters by shop location. If location cannot be parsed, Etsy responds with an error. | [optional] |

### Return type

[**\Etsy\Model\ShopListings**](../Model/ShopListings.md)

### Authorization

[api_key](../../README.md#api_key)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getFeaturedListingsByShop()`

```php
getFeaturedListingsByShop($shop_id, $limit, $offset): \Etsy\Model\ShopListings
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Retrieves Listings associated to a Shop that are featured.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$limit = 25; // int | The maximum number of results to return.
$offset = 0; // int | The number of records to skip before selecting the first result.

try {
    $result = $apiInstance->getFeaturedListingsByShop($shop_id, $limit, $offset);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->getFeaturedListingsByShop: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **limit** | **int**| The maximum number of results to return. | [optional] [default to 25] |
| **offset** | **int**| The number of records to skip before selecting the first result. | [optional] [default to 0] |

### Return type

[**\Etsy\Model\ShopListings**](../Model/ShopListings.md)

### Authorization

[api_key](../../README.md#api_key)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getListing()`

```php
getListing($listing_id, $includes, $language): \Etsy\Model\ShopListingWithAssociations
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Retrieves a listing record by listing ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$listing_id = 56; // int | The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
$includes = array('includes_example'); // string[] | An enumerated string that attaches a valid association. Acceptable inputs are 'Shipping', 'Shop', 'Images', 'User', 'Translations' and 'Inventory'.
$language = 'language_example'; // string | The IETF language tag for the language of this translation. Ex: `de`, `en`, `es`, `fr`, `it`, `ja`, `nl`, `pl`, `pt`.

try {
    $result = $apiInstance->getListing($listing_id, $includes, $language);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->getListing: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **listing_id** | **int**| The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. | |
| **includes** | [**string[]**](../Model/string.md)| An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. | [optional] |
| **language** | **string**| The IETF language tag for the language of this translation. Ex: &#x60;de&#x60;, &#x60;en&#x60;, &#x60;es&#x60;, &#x60;fr&#x60;, &#x60;it&#x60;, &#x60;ja&#x60;, &#x60;nl&#x60;, &#x60;pl&#x60;, &#x60;pt&#x60;. | [optional] |

### Return type

[**\Etsy\Model\ShopListingWithAssociations**](../Model/ShopListingWithAssociations.md)

### Authorization

[api_key](../../README.md#api_key)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getListingProperties()`

```php
getListingProperties($shop_id, $listing_id): \Etsy\Model\ListingPropertyValues
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Get a listing's properties

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$listing_id = 56; // int | The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.

try {
    $result = $apiInstance->getListingProperties($shop_id, $listing_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->getListingProperties: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **listing_id** | **int**| The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. | |

### Return type

[**\Etsy\Model\ListingPropertyValues**](../Model/ListingPropertyValues.md)

### Authorization

[api_key](../../README.md#api_key)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getListingProperty()`

```php
getListingProperty($listing_id, $property_id): \Etsy\Model\ListingPropertyValue
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-01 wt-mr-xs-2\"> Feedback only </span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Give feedback</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">Development for this endpoint is in progress. It will only return a 501 response.</p></div>  Retrieves a listing's property

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$listing_id = 56; // int | The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
$property_id = 56; // int | The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties).

try {
    $result = $apiInstance->getListingProperty($listing_id, $property_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->getListingProperty: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **listing_id** | **int**| The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. | |
| **property_id** | **int**| The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). | |

### Return type

[**\Etsy\Model\ListingPropertyValue**](../Model/ListingPropertyValue.md)

### Authorization

[api_key](../../README.md#api_key)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getListingsByListingIds()`

```php
getListingsByListingIds($listing_ids, $includes): \Etsy\Model\ShopListingsWithAssociations
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Allows to query multiple listing ids at once. Limit 100 ids maximum per query.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$listing_ids = array(56); // int[] | The list of numeric IDS for the listings in a specific Etsy shop.
$includes = array('includes_example'); // string[] | An enumerated string that attaches a valid association. Acceptable inputs are 'Shipping', 'Shop', 'Images', 'User', 'Translations' and 'Inventory'.

try {
    $result = $apiInstance->getListingsByListingIds($listing_ids, $includes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->getListingsByListingIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **listing_ids** | [**int[]**](../Model/int.md)| The list of numeric IDS for the listings in a specific Etsy shop. | |
| **includes** | [**string[]**](../Model/string.md)| An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. | [optional] |

### Return type

[**\Etsy\Model\ShopListingsWithAssociations**](../Model/ShopListingsWithAssociations.md)

### Authorization

[api_key](../../README.md#api_key)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getListingsByShop()`

```php
getListingsByShop($shop_id, $state, $limit, $offset, $sort_on, $sort_order, $includes): \Etsy\Model\ShopListingsWithAssociations
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Endpoint to list Listings that belong to a Shop. Listings can be filtered using the 'state' param.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$state = 'active'; // string | When _updating_ a listing, this value can be either `active` or `inactive`. Note: Setting a `draft` listing to `active` will also publish the listing on etsy.com and requires that the listing have an image set. Setting a `sold_out` listing to active will update the quantity to 1 and renew the listing on etsy.com.
$limit = 25; // int | The maximum number of results to return.
$offset = 0; // int | The number of records to skip before selecting the first result.
$sort_on = 'created'; // string | The value to sort a search result of listings on. NOTES: a) `sort_on` only works when combined with one of the search options (keywords, region, etc.). b) when using `score` the returned results will always be in _descending_ order, regardless of the `sort_order` parameter.
$sort_order = 'desc'; // string | The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.).
$includes = array('includes_example'); // string[] | An enumerated string that attaches a valid association. Acceptable inputs are 'Shipping', 'Shop', 'Images', 'User', 'Translations' and 'Inventory'.

try {
    $result = $apiInstance->getListingsByShop($shop_id, $state, $limit, $offset, $sort_on, $sort_order, $includes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->getListingsByShop: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **state** | **string**| When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. | [optional] [default to &#39;active&#39;] |
| **limit** | **int**| The maximum number of results to return. | [optional] [default to 25] |
| **offset** | **int**| The number of records to skip before selecting the first result. | [optional] [default to 0] |
| **sort_on** | **string**| The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. | [optional] [default to &#39;created&#39;] |
| **sort_order** | **string**| The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). | [optional] [default to &#39;desc&#39;] |
| **includes** | [**string[]**](../Model/string.md)| An enumerated string that attaches a valid association. Acceptable inputs are &#39;Shipping&#39;, &#39;Shop&#39;, &#39;Images&#39;, &#39;User&#39;, &#39;Translations&#39; and &#39;Inventory&#39;. | [optional] |

### Return type

[**\Etsy\Model\ShopListingsWithAssociations**](../Model/ShopListingsWithAssociations.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getListingsByShopReceipt()`

```php
getListingsByShopReceipt($receipt_id, $shop_id, $limit, $offset): \Etsy\Model\ShopListings
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Gets all listings associated with a receipt.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$receipt_id = 56; // int | The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction.
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$limit = 25; // int | The maximum number of results to return.
$offset = 0; // int | The number of records to skip before selecting the first result.

try {
    $result = $apiInstance->getListingsByShopReceipt($receipt_id, $shop_id, $limit, $offset);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->getListingsByShopReceipt: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **receipt_id** | **int**| The numeric ID for the [receipt](/documentation/reference#tag/Shop-Receipt) associated to this transaction. | |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **limit** | **int**| The maximum number of results to return. | [optional] [default to 25] |
| **offset** | **int**| The number of records to skip before selecting the first result. | [optional] [default to 0] |

### Return type

[**\Etsy\Model\ShopListings**](../Model/ShopListings.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getListingsByShopReturnPolicy()`

```php
getListingsByShopReturnPolicy($return_policy_id, $shop_id): \Etsy\Model\ShopListings
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Gets all listings associated with a Return Policy.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$return_policy_id = 56; // int | The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies).
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.

try {
    $result = $apiInstance->getListingsByShopReturnPolicy($return_policy_id, $shop_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->getListingsByShopReturnPolicy: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **return_policy_id** | **int**| The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). | |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |

### Return type

[**\Etsy\Model\ShopListings**](../Model/ShopListings.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getListingsByShopSectionId()`

```php
getListingsByShopSectionId($shop_id, $shop_section_ids, $limit, $offset, $sort_on, $sort_order): \Etsy\Model\ShopListings
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Retrieves all the listings from the section of a specific shop.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$shop_section_ids = array(56); // int[] | A list of numeric IDS for all sections in a specific Etsy shop.
$limit = 25; // int | The maximum number of results to return.
$offset = 0; // int | The number of records to skip before selecting the first result.
$sort_on = 'created'; // string | The value to sort a search result of listings on. NOTES: a) `sort_on` only works when combined with one of the search options (keywords, region, etc.). b) when using `score` the returned results will always be in _descending_ order, regardless of the `sort_order` parameter.
$sort_order = 'desc'; // string | The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.).

try {
    $result = $apiInstance->getListingsByShopSectionId($shop_id, $shop_section_ids, $limit, $offset, $sort_on, $sort_order);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->getListingsByShopSectionId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **shop_section_ids** | [**int[]**](../Model/int.md)| A list of numeric IDS for all sections in a specific Etsy shop. | |
| **limit** | **int**| The maximum number of results to return. | [optional] [default to 25] |
| **offset** | **int**| The number of records to skip before selecting the first result. | [optional] [default to 0] |
| **sort_on** | **string**| The value to sort a search result of listings on. NOTES: a) &#x60;sort_on&#x60; only works when combined with one of the search options (keywords, region, etc.). b) when using &#x60;score&#x60; the returned results will always be in _descending_ order, regardless of the &#x60;sort_order&#x60; parameter. | [optional] [default to &#39;created&#39;] |
| **sort_order** | **string**| The ascending(up) or descending(down) order to sort listings by. NOTE: sort_order only works when combined with one of the search options (keywords, region, etc.). | [optional] [default to &#39;desc&#39;] |

### Return type

[**\Etsy\Model\ShopListings**](../Model/ShopListings.md)

### Authorization

[api_key](../../README.md#api_key)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateListing()`

```php
updateListing($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $return_policy_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type): \Etsy\Model\ShopListing
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Updates a listing, identified by a listing ID, for a specific shop identified by a shop ID. Note that this is a PATCH method type.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$listing_id = 56; // int | The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
$image_ids = array(56); // int[] | An array of numeric image IDs of the images in a listing, which can include up to 10 images.
$title = 'title_example'; // string | The listing's title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, & and + characters once each.
$description = 'description_example'; // string | A description string of the product for sale in the listing.
$materials = array('materials_example'); // string[] | A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null.
$should_auto_renew = True; // bool | When true, renews a listing for four months upon expiration.
$shipping_profile_id = 56; // int | The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is `physical`.
$return_policy_id = 56; // int | The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). Required for active physical listings. This requirement does not apply to listings of EU-based shops.
$shop_section_id = 56; // int | The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null.
$item_weight = 3.4; // float | The numeric weight of the product measured in units set in 'item_weight_unit'. Default value is null. If set, the value must be greater than 0.
$item_length = 3.4; // float | The numeric length of the product measured in units set in 'item_dimensions_unit'. Default value is null. If set, the value must be greater than 0.
$item_width = 3.4; // float | The numeric width of the product measured in units set in 'item_dimensions_unit'. Default value is null. If set, the value must be greater than 0.
$item_height = 3.4; // float | The numeric height of the product measured in units set in 'item_dimensions_unit'. Default value is null. If set, the value must be greater than 0.
$item_weight_unit = 'item_weight_unit_example'; // string | A string defining the units used to measure the weight of the product. Default value is null.
$item_dimensions_unit = 'item_dimensions_unit_example'; // string | A string defining the units used to measure the dimensions of the product. Default value is null.
$is_taxable = True; // bool | When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout.
$taxonomy_id = 56; // int | The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information.
$tags = array('tags_example'); // string[] | A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, ', ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-'™©®]/u) Default value is null.
$who_made = 'who_made_example'; // string | An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires 'is_supply' and 'when_made'.
$when_made = 'when_made_example'; // string | An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires 'is_supply' and 'who_made'.
$featured_rank = 56; // int | The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page.
$is_personalizable = True; // bool | When true, this listing is personalizable. The default value is null.
$personalization_is_required = True; // bool | When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is 'true'.
$personalization_char_count_max = 56; // int | This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is 'true'.
$personalization_instructions = 'personalization_instructions_example'; // string | A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is 'true'.
$state = 'state_example'; // string | When _updating_ a listing, this value can be either `active` or `inactive`. Note: Setting a `draft` listing to `active` will also publish the listing on etsy.com and requires that the listing have an image set. Setting a `sold_out` listing to active will update the quantity to 1 and renew the listing on etsy.com.
$is_supply = True; // bool | When true, tags the listing as a supply product, else indicates that it's a finished product. Helps buyers locate the listing under the Supplies heading. Requires 'who_made' and 'when_made'.
$production_partner_ids = array(56); // int[] | An array of unique IDs of production partner ids.
$type = 'type_example'; // string | An enumerated type string that indicates whether the listing is physical or a digital download.

try {
    $result = $apiInstance->updateListing($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $return_policy_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->updateListing: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **listing_id** | **int**| The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. | |
| **image_ids** | [**int[]**](../Model/int.md)| An array of numeric image IDs of the images in a listing, which can include up to 10 images. | [optional] |
| **title** | **string**| The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. | [optional] |
| **description** | **string**| A description string of the product for sale in the listing. | [optional] |
| **materials** | [**string[]**](../Model/string.md)| A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. | [optional] |
| **should_auto_renew** | **bool**| When true, renews a listing for four months upon expiration. | [optional] |
| **shipping_profile_id** | **int**| The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. | [optional] |
| **return_policy_id** | **int**| The numeric ID of the [Return Policy](/documentation/reference#operation/getShopReturnPolicies). Required for active physical listings. This requirement does not apply to listings of EU-based shops. | [optional] |
| **shop_section_id** | **int**| The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. | [optional] |
| **item_weight** | **float**| The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_length** | **float**| The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_width** | **float**| The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_height** | **float**| The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_weight_unit** | **string**| A string defining the units used to measure the weight of the product. Default value is null. | [optional] |
| **item_dimensions_unit** | **string**| A string defining the units used to measure the dimensions of the product. Default value is null. | [optional] |
| **is_taxable** | **bool**| When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. | [optional] |
| **taxonomy_id** | **int**| The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. | [optional] |
| **tags** | [**string[]**](../Model/string.md)| A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. | [optional] |
| **who_made** | **string**| An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. | [optional] |
| **when_made** | **string**| An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. | [optional] |
| **featured_rank** | **int**| The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. | [optional] |
| **is_personalizable** | **bool**| When true, this listing is personalizable. The default value is null. | [optional] |
| **personalization_is_required** | **bool**| When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. | [optional] |
| **personalization_char_count_max** | **int**| This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. | [optional] |
| **personalization_instructions** | **string**| A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. | [optional] |
| **state** | **string**| When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. | [optional] |
| **is_supply** | **bool**| When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. | [optional] |
| **production_partner_ids** | [**int[]**](../Model/int.md)| An array of unique IDs of production partner ids. | [optional] |
| **type** | **string**| An enumerated type string that indicates whether the listing is physical or a digital download. | [optional] |

### Return type

[**\Etsy\Model\ShopListing**](../Model/ShopListing.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: `application/x-www-form-urlencoded`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateListingDeprecated()`

```php
updateListingDeprecated($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type): \Etsy\Model\ShopListing
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Updates a listing, identified by a listing ID, for a specific shop identified by a shop ID. This endpoint will be removed in the near future in favor of `updateListing` PATCH version.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$listing_id = 56; // int | The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
$image_ids = array(56); // int[] | An array of numeric image IDs of the images in a listing, which can include up to 10 images.
$title = 'title_example'; // string | The listing's title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, & and + characters once each.
$description = 'description_example'; // string | A description string of the product for sale in the listing.
$materials = array('materials_example'); // string[] | A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null.
$should_auto_renew = True; // bool | When true, renews a listing for four months upon expiration.
$shipping_profile_id = 56; // int | The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is `physical`.
$shop_section_id = 56; // int | The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null.
$item_weight = 3.4; // float | The numeric weight of the product measured in units set in 'item_weight_unit'. Default value is null. If set, the value must be greater than 0.
$item_length = 3.4; // float | The numeric length of the product measured in units set in 'item_dimensions_unit'. Default value is null. If set, the value must be greater than 0.
$item_width = 3.4; // float | The numeric width of the product measured in units set in 'item_dimensions_unit'. Default value is null. If set, the value must be greater than 0.
$item_height = 3.4; // float | The numeric height of the product measured in units set in 'item_dimensions_unit'. Default value is null. If set, the value must be greater than 0.
$item_weight_unit = 'item_weight_unit_example'; // string | A string defining the units used to measure the weight of the product. Default value is null.
$item_dimensions_unit = 'item_dimensions_unit_example'; // string | A string defining the units used to measure the dimensions of the product. Default value is null.
$is_taxable = True; // bool | When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout.
$taxonomy_id = 56; // int | The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information.
$tags = array('tags_example'); // string[] | A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, ', ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-'™©®]/u) Default value is null.
$who_made = 'who_made_example'; // string | An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires 'is_supply' and 'when_made'.
$when_made = 'when_made_example'; // string | An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires 'is_supply' and 'who_made'.
$featured_rank = 56; // int | The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page.
$is_personalizable = True; // bool | When true, this listing is personalizable. The default value is null.
$personalization_is_required = True; // bool | When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is 'true'.
$personalization_char_count_max = 56; // int | This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is 'true'.
$personalization_instructions = 'personalization_instructions_example'; // string | A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is 'true'.
$state = 'state_example'; // string | When _updating_ a listing, this value can be either `active` or `inactive`. Note: Setting a `draft` listing to `active` will also publish the listing on etsy.com and requires that the listing have an image set. Setting a `sold_out` listing to active will update the quantity to 1 and renew the listing on etsy.com.
$is_supply = True; // bool | When true, tags the listing as a supply product, else indicates that it's a finished product. Helps buyers locate the listing under the Supplies heading. Requires 'who_made' and 'when_made'.
$production_partner_ids = array(56); // int[] | An array of unique IDs of production partner ids.
$type = 'type_example'; // string | An enumerated type string that indicates whether the listing is physical or a digital download.

try {
    $result = $apiInstance->updateListingDeprecated($shop_id, $listing_id, $image_ids, $title, $description, $materials, $should_auto_renew, $shipping_profile_id, $shop_section_id, $item_weight, $item_length, $item_width, $item_height, $item_weight_unit, $item_dimensions_unit, $is_taxable, $taxonomy_id, $tags, $who_made, $when_made, $featured_rank, $is_personalizable, $personalization_is_required, $personalization_char_count_max, $personalization_instructions, $state, $is_supply, $production_partner_ids, $type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->updateListingDeprecated: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **listing_id** | **int**| The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. | |
| **image_ids** | [**int[]**](../Model/int.md)| An array of numeric image IDs of the images in a listing, which can include up to 10 images. | [optional] |
| **title** | **string**| The listing&#39;s title string. When creating or updating a listing, valid title strings contain only letters, numbers, punctuation marks, mathematical symbols, whitespace characters, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{P}\\\\p{Sm}\\\\p{Zs}™©®]/u) You can only use the %, :, &amp; and + characters once each. | [optional] |
| **description** | **string**| A description string of the product for sale in the listing. | [optional] |
| **materials** | [**string[]**](../Model/string.md)| A list of material strings for materials used in the product. Valid materials strings contain only letters, numbers, and whitespace characters. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}]/u) Default value is null. | [optional] |
| **should_auto_renew** | **bool**| When true, renews a listing for four months upon expiration. | [optional] |
| **shipping_profile_id** | **int**| The numeric ID of the [shipping profile](/documentation/reference#operation/getShopShippingProfile) associated with the listing. Required when listing type is &#x60;physical&#x60;. | [optional] |
| **shop_section_id** | **int**| The numeric ID of the [shop section](/documentation/reference#tag/Shop-Section) for this listing. Default value is null. | [optional] |
| **item_weight** | **float**| The numeric weight of the product measured in units set in &#39;item_weight_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_length** | **float**| The numeric length of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_width** | **float**| The numeric width of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_height** | **float**| The numeric height of the product measured in units set in &#39;item_dimensions_unit&#39;. Default value is null. If set, the value must be greater than 0. | [optional] |
| **item_weight_unit** | **string**| A string defining the units used to measure the weight of the product. Default value is null. | [optional] |
| **item_dimensions_unit** | **string**| A string defining the units used to measure the dimensions of the product. Default value is null. | [optional] |
| **is_taxable** | **bool**| When true, applicable [shop](/documentation/reference#tag/Shop) tax rates apply to this listing at checkout. | [optional] |
| **taxonomy_id** | **int**| The numerical taxonomy ID of the listing. See [SellerTaxonomy](/documentation/reference#tag/SellerTaxonomy) and [BuyerTaxonomy](/documentation/reference#tag/BuyerTaxonomy) for more information. | [optional] |
| **tags** | [**string[]**](../Model/string.md)| A comma-separated list of tag strings for the listing. When creating or updating a listing, valid tag strings contain only letters, numbers, whitespace characters, -, &#39;, ™, ©, and ®. (regex: /[^\\\\p{L}\\\\p{Nd}\\\\p{Zs}\\\\-&#39;™©®]/u) Default value is null. | [optional] |
| **who_made** | **string**| An enumerated string indicating who made the product. Helps buyers locate the listing under the Handmade heading. Requires &#39;is_supply&#39; and &#39;when_made&#39;. | [optional] |
| **when_made** | **string**| An enumerated string for the era in which the maker made the product in this listing. Helps buyers locate the listing under the Vintage heading. Requires &#39;is_supply&#39; and &#39;who_made&#39;. | [optional] |
| **featured_rank** | **int**| The positive non-zero numeric position in the featured listings of the shop, with rank 1 listings appearing in the left-most position in featured listing on a shop’s home page. | [optional] |
| **is_personalizable** | **bool**| When true, this listing is personalizable. The default value is null. | [optional] |
| **personalization_is_required** | **bool**| When true, this listing requires personalization. The default value is null. Will only change if is_personalizable is &#39;true&#39;. | [optional] |
| **personalization_char_count_max** | **int**| This is an integer value representing the maximum length for the personalization message entered by the buyer. Will only change if is_personalizable is &#39;true&#39;. | [optional] |
| **personalization_instructions** | **string**| A string representing instructions for the buyer to enter the personalization. Will only change if is_personalizable is &#39;true&#39;. | [optional] |
| **state** | **string**| When _updating_ a listing, this value can be either &#x60;active&#x60; or &#x60;inactive&#x60;. Note: Setting a &#x60;draft&#x60; listing to &#x60;active&#x60; will also publish the listing on etsy.com and requires that the listing have an image set. Setting a &#x60;sold_out&#x60; listing to active will update the quantity to 1 and renew the listing on etsy.com. | [optional] |
| **is_supply** | **bool**| When true, tags the listing as a supply product, else indicates that it&#39;s a finished product. Helps buyers locate the listing under the Supplies heading. Requires &#39;who_made&#39; and &#39;when_made&#39;. | [optional] |
| **production_partner_ids** | [**int[]**](../Model/int.md)| An array of unique IDs of production partner ids. | [optional] |
| **type** | **string**| An enumerated type string that indicates whether the listing is physical or a digital download. | [optional] |

### Return type

[**\Etsy\Model\ShopListing**](../Model/ShopListing.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: `application/x-www-form-urlencoded`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateListingProperty()`

```php
updateListingProperty($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id): \Etsy\Model\ListingPropertyValue
```



<div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><span class=\"wt-badge wt-badge--notification-03 wt-bg-slime-tint wt-mr-xs-2\">General Release</span><a class=\"wt-text-link\" href=\"https://github.com/etsy/open-api/discussions\" target=\"_blank\" rel=\"noopener noreferrer\">Report bug</a></div><div class=\"wt-display-flex-xs wt-align-items-center wt-mt-xs-2 wt-mb-xs-3\"><p class=\"wt-text-body-01 banner-text\">This endpoint is ready for production use.</p></div>  Updates or populates the properties list defining product offerings for a listing. Each offering requires both a `value` and a `value_id` that are valid for a `scale_id` assigned to the listing or that you assign to the listing with this request.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: api_key
$config = Etsy\Configuration::getDefaultConfiguration()->setApiKey('x-api-key', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Etsy\Configuration::getDefaultConfiguration()->setApiKeyPrefix('x-api-key', 'Bearer');

// Configure OAuth2 access token for authorization: oauth2
$config = Etsy\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Etsy\Api\ShopListingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$shop_id = 56; // int | The unique positive non-zero numeric ID for an Etsy Shop.
$listing_id = 56; // int | The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction.
$property_id = 56; // int | The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties).
$value_ids = array(56); // int[] | An array of unique IDs of multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different sizes of a product, then the value ID list contains value IDs for each size.
$values = array('values_example'); // string[] | An array of value strings for multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different colored products, then the values array contains the color strings for each color. Note: parenthesis characters (`(` and `)`) are not allowed.
$scale_id = 56; // int | The numeric ID of a single Etsy.com measurement scale. For example, for shoe size, there are three `scale_id`s available - `UK`, `US/Canada`, and `EU`, where `US/Canada` has `scale_id` 19.

try {
    $result = $apiInstance->updateListingProperty($shop_id, $listing_id, $property_id, $value_ids, $values, $scale_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ShopListingApi->updateListingProperty: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_id** | **int**| The unique positive non-zero numeric ID for an Etsy Shop. | |
| **listing_id** | **int**| The numeric ID for the [listing](/documentation/reference#tag/ShopListing) associated to this transaction. | |
| **property_id** | **int**| The unique ID of an Etsy [listing property](/documentation/reference#operation/getListingProperties). | |
| **value_ids** | [**int[]**](../Model/int.md)| An array of unique IDs of multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different sizes of a product, then the value ID list contains value IDs for each size. | |
| **values** | [**string[]**](../Model/string.md)| An array of value strings for multiple Etsy [listing property](/documentation/reference#operation/getListingProperties) values. For example, if your listing offers different colored products, then the values array contains the color strings for each color. Note: parenthesis characters (&#x60;(&#x60; and &#x60;)&#x60;) are not allowed. | |
| **scale_id** | **int**| The numeric ID of a single Etsy.com measurement scale. For example, for shoe size, there are three &#x60;scale_id&#x60;s available - &#x60;UK&#x60;, &#x60;US/Canada&#x60;, and &#x60;EU&#x60;, where &#x60;US/Canada&#x60; has &#x60;scale_id&#x60; 19. | [optional] |

### Return type

[**\Etsy\Model\ListingPropertyValue**](../Model/ListingPropertyValue.md)

### Authorization

[api_key](../../README.md#api_key), [oauth2](../../README.md#oauth2)

### HTTP request headers

- **Content-Type**: `application/x-www-form-urlencoded`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
