<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Eposnow;

use Eposnow\Model\Colour;
use Eposnow\Model\ProductV2;
use PHPUnit\Framework\TestCase;
use Eposnow\Api\EposnowApi;
use Eposnow\Model\Brand;
use Eposnow\Model\CustomerAddressCreateArrayRequest;
use Eposnow\Model\CustomerCreateArrayRequest;
use Eposnow\Model\Device;
use Eposnow\Model\DiscountReason;
use Eposnow\Model\DiscountReasonCreateArrayRequest;
use Eposnow\Model\DiscountReasonCreateRequest;
use Eposnow\Model\EndOfDay;
use Eposnow\Model\MarketingConsent;
use Eposnow\Model\ProductStockAddObjectRequest;
use Eposnow\Model\ProductStockRemoveObjectRequest;
use Eposnow\Model\RefundReason;
use Eposnow\Model\RefundReasonCreateArrayRequest;
use Eposnow\Model\RefundReasonCreateRequest;
use Eposnow\Model\Staff;
use Eposnow\Model\Supplier;
use Eposnow\Model\Tax;
use Eposnow\Model\TaxGroup;
use Eposnow\Model\Tender;
use Eposnow\Model\TenderType;
use Eposnow\Model\Transaction;
use Eposnow\Model\TransactionItem;
use Eposnow\Model\Product;
use Eposnow\Model\ProductStock;
use Eposnow\Model\ProductStockBatch;
use Eposnow\Model\ProductStockAddRequest;
use Eposnow\Model\ProductStockRemoveRequest;
use Eposnow\Model\Location;
use Eposnow\Model\CustomerAddress;
use Eposnow\Model\CustomerAddressCreateRequest;
use Eposnow\Model\Customer;
use Eposnow\Model\CustomerCreateRequest;
use DateTime;
use Eposnow\Model\TransactionReferenceCode;
use Eposnow\Model\TransactionReferenceCodeCreateArrayRequest;
use Eposnow\Model\TransactionReferenceCodeCreateRequest;
use Eposnow\Model\WebhookTrigger;
use Eposnow\Model\WebhookTriggerArrayRequest;
use Eposnow\Model\WebhookTriggerRemoveArrayRequest;
use Eposnow\Model\Category;

/*
 * Find below some example Eposnow service calls. They have been written as tests in order for them to work within this
 * library. However they should not be run as a PHPUnit test since they have dependencies on the existing data within
 * the test Eposnow account.
 *
 * Please note.
 *
 * Because we use the unit test framework to run each of the examples of an Eposnow service call, we do not have a
 * logger defined. In the actual code there should be a logger argument to each of the ClientBuilder::getClient() calls.
 *
 * Where the test is returning a list of items e.g. $endpoint->getProducts() the method may accept a page number if
 * one is needed. Check the source code generated by Swagger for all the optional arguments for each method.
 *
 */

class Examples extends TestCase
{
    public function testGetBrands()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $brands = $endpoint->getBrands()->getResponse();

            /** @var Brand $brand */
            $brand = $brands[0];

            $brandId = $brand->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetBrandById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $brand = $endpoint->getBrandById(267700)->getResponse();

            $brandId = $brand->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetCategories()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $categories = $endpoint->getCategories()->getResponse();

            /** @var Category $category */
            $category = $categories[0];

            $categoryId = $category->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetCategoryById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $category = $endpoint->getCategoryById(1145216)->getResponse();

            $categoryId = $category->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetColours()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $colours = $endpoint->getColours()->getResponse();

            /** @var Colour $colour */
            $colour = $colours[0];

            $colourId = $colour->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetColourById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $colour = $endpoint->getColourById(46172)->getResponse();

            $colourId = $colour->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProducts()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v2/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $products = $endpoint->getProducts()->getResponse();

            /** @var Product $product */
            $product = $products[0];

            $productId = $product->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProductById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            //$product = $endpoint->getProductById(16480310)->getResponse();
            $product = $endpoint->getProductById(18647265)->getResponse();

            $productId = $product->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProductByVariantGroupId()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $products = $endpoint->getProductsByVariantGroupId('18647263')->getResponse();

            /** @var ProductV2 $product */
            $product = $products[0];

            $productId = $product->getProductId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetCustomerAddresses()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $addresses = $endpoint->getCustomerAddresses()->getResponse();

            /** @var CustomerAddress $address */
            $address = $addresses[0];

            $addressId = $address->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetCustomerAddressById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $address = $endpoint->getCustomerAddressById(1031517)->getResponse();

            $addressId = $address->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetCustomerAddressByCustomerId()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $addresses = $endpoint->getCustomerAddressesByCustomerId(2080445)->getResponse();

            /** @var CustomerAddress $address */
            $address = $addresses[0];

            $addressId = $address->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testAddCustomerAddresses()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $address = new CustomerAddressCreateRequest();
            $address->setCustomerId(2201514);
            $address->setName("Main Address");
            $address->setAddressLine1("Highbridge Road");
            $address->setAddressLine2(null);
            $address->setTown("Barking");
            $address->setCounty(null);
            $address->setPostCode("IG11 7BA");
            $address->setIsMainAddress(true);

            $addresses = $endpoint->addCustomerAddresses((new CustomerAddressCreateArrayRequest())->setRequest(array($address)))->getResponse();

            /** @var CustomerAddress $address */
            $address = $addresses[0];

            $addressId = $address->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetCustomers()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $customers = $endpoint->getCustomers()->getResponse();

            /** @var Customer $customer */
            $customer = $customers[0];

            $customerId = $customer->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetCustomerById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $customer = $endpoint->getCustomerById(2080445)->getResponse();

            $customerId = $customer->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetCustomersByEmail()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $customers = $endpoint->getCustomersByEmail('info@hsg.co')->getResponse();

            /** @var Customer $customer */
            $customer = $customers[0];

            $customerId = $customer->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testAddCustomers()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $customer = new CustomerCreateRequest();
            $customer->setTitle(1);
            $customer->setForename('Bob');
            $customer->setSurname('Bloggs');
            $customer->setBusinessName('J Bloggs and Son Ltd');
            $customer->setContactNumber('01234567892');
            $customer->setEmailAddress('bob@bloggs.com');
            $date = DateTime::createFromFormat('Y-m-d', '2018-08-20');
            $customer->setSignUpDate($date);

            $marketing = new MarketingConsent();
            $marketing->setEmail(true);
            $marketing->setMail(false);
            $marketing->setPhone(true);
            $marketing->setText(false);

            $customer->setMarketingConsent($marketing);

            $customers = $endpoint->addCustomers((new CustomerCreateArrayRequest())->setRequest(array($customer)))->getResponse();

            /** @var Customer $customer */
            $customer = $customers[0];

            $customerId = $customer->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProductStock()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $stocks = $endpoint->getProductStock()->getResponse();

            /** @var ProductStock $stock */
            $stock = $stocks[0];

            $stockId = $stock->getId();

            /** @var ProductStockBatch[] $batches */
            $batches = $stock->getProductStockBatches();

            /** @var ProductStockBatch $batch */
            $batch = $batches[0];

            $batchId = $batch->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProductStockByProductId()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $stocks = $endpoint->getProductStockByProductId(16480713)->getResponse();

            /** @var ProductStock $stock */
            $stock = $stocks[0];

            $stockId = $stock->getId();

            /** @var ProductStockBatch[] $batches */
            $batches = $stock->getProductStockBatches();

            /** @var ProductStockBatch $batch */
            $batch = $batches[0];

            $batchId = $batch->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProductStockByLocationId()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $stocks = $endpoint->getProductStockByLocationId(21929)->getResponse();

            /** @var ProductStock $stock */
            $stock = $stocks[0];

            $stockId = $stock->getId();

            /** @var ProductStockBatch[] $batches */
            $batches = $stock->getProductStockBatches();

            /** @var ProductStockBatch $batch */
            $batch = $batches[0];

            $batchId = $batch->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProductStockByProductIdAndLocationId()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $stock = $endpoint->getProductStockByProductIdAndLocationId(16480713, 21929)->getResponse();

            $stockId = $stock->getId();

            /** @var ProductStockBatch[] $batches */
            $batches = $stock->getProductStockBatches();

            /** @var ProductStockBatch $batch */
            $batch = $batches[0];

            $batchId = $batch->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testAddProductStock()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $stock = new ProductStockAddRequest();
            $stock->setProductId(16480713);
            $stock->setLocationId(21929);
            $stock->setChangeInStock(5);
            $stock->setSupplierId(101149);

            $stock = $endpoint->addProductStock((new ProductStockAddObjectRequest())->setRequest($stock))->getResponse();

            $stockId = $stock->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testRemoveProductStock()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $stock = new ProductStockRemoveRequest();
            $stock->setProductId(16480713);
            $stock->setLocationId(21929);
            $stock->setChangeInStock(5);

            $stock = $endpoint->removeProductStock((new ProductStockRemoveObjectRequest())->setRequest($stock))->getResponse();

            $stockId = $stock->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetLocations()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $locations = $endpoint->getLocations()->getResponse();

            /** @var Location $location */
            $location = $locations[0];

            $locationId = $location->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetLocationById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $location = $endpoint->getLocationById(21929)->getResponse();

            $locationId = $location->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetSuppliers()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $suppliers = $endpoint->getSuppliers()->getResponse();

            /** @var Supplier $supplier */
            $supplier = $suppliers[0];

            $supplierId = $supplier->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetSupplierById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $supplier = $endpoint->getSupplierById(101148)->getResponse();

            $supplierId = $supplier->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTaxGroups()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $taxGroups = $endpoint->getTaxGroups()->getResponse();

            /** @var TaxGroup $taxGroup */
            $taxGroup = $taxGroups[0];

            $taxGroupId = $taxGroup->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTaxGroupById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $taxGroup = $endpoint->getTaxGroupById(34561)->getResponse();

            $taxGroupId = $taxGroup->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTenderTypes()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $tenderTypes = $endpoint->getTenderTypes()->getResponse();

            /** @var TenderType $tenderType */
            $tenderType = $tenderTypes[0];

            $tenderTypeId = $tenderType->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTenderTypeById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $tenderType = $endpoint->getTenderTypeById(46770)->getResponse();

            $tenderTypeId = $tenderType->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTransactions()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $transactions = $endpoint->getTransactions()->getResponse();

            /** @var Transaction $transaction */
            $transaction = $transactions[0];

            $transactionId = $transaction->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTransactionsBetweenDates()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $startDate = DateTime::createFromFormat('Y-m-d H:i:s.u', '2018-08-01 00:00:00.000000');
            $endDate = DateTime::createFromFormat('Y-m-d H:i:s.u', '2018-08-19 23:59:59.999999');

            $transactions = $endpoint->getTransactionsBetweenDates($startDate, $endDate)->getResponse();

            /** @var Transaction $transaction */
            $transaction = $transactions[0];

            $transactionId = $transaction->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTransactionById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $transaction = $endpoint->getTransactionById(193759896)->getResponse();

            $transactionId = $transaction->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testAddTransaction()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $transaction = new Transaction();
            $transaction->setStaffId(136565);
            $transaction->setDeviceId(44411);
            $transaction->setDevice('API');
            $transaction->setDateTime('2018-08-19T22:00:00.000Z');
            $transaction->setStatusId(1);
            $transaction->setBarcode('RECB000AIWU3T0A8S54W');
            $transaction->setServiceType(0);
            $transaction->setTotalAmount(3.50);
            $transaction->setDiscountValue(0.0);
            $transaction->setNonDiscountable(0.0);
            $transaction->setNonTax(0.0);

            $item = new TransactionItem();
            $item->setProductId(16480353);
            $item->setUnitPrice(3.50);
            $item->setUnitPriceExcTax(2.92);
            $item->setCostPrice(0.0);
            $item->setTaxAmount(0.58);
            $item->setQuantity(1);
            $item->setPrintOnOrder(false);
            $item->setIsTaxExempt(false);

            $tax1 = new Tax();
            $tax1->setTaxRateId(65533);
            $tax1->setName('20VAT');
            $tax1->setRate(20);
            $tax1->setAmount(0.58);

            $item->setTaxes(array($tax1));

            $transaction->setTransactionItems(array($item));

            $tender = new Tender();
            $tender->setTenderTypeId(46770);
            $tender->setAmount(3.50);
            $tender->setChangeGiven(0.0);

            $transaction->setTenders(array($tender));

            $tax2 = new Tax();
            $tax2->setTaxRateId(65533);
            $tax2->setName('20VAT');
            $tax2->setRate(20);
            $tax2->setAmount(0.58);

            $transaction->setTaxes(array($tax2));

            $transaction = $endpoint->addTransaction($transaction)->getResponse();

            $transactionId = $transaction->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTransactionByBarcode()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $transaction = $endpoint->getTransactionByBarcode('REC13081822000000000')->getResponse();

            $transactionId = $transaction->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetStaff()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $staffs = $endpoint->getStaff()->getResponse();

            /** @var Staff $staff */
            $staff = $staffs[0];

            $staffId = $staff->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetStaffById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $staff = $endpoint->getStaffById(134960)->getResponse();

            $staffId = $staff->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetEndOfDays()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $endOfDays = $endpoint->getEndOfDays()->getResponse();

            /** @var EndOfDay $endOfDay */
            $endOfDay = $endOfDays[0];

            $endOfDayId = $endOfDay->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetEndOfDayById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $endOfDay = $endpoint->getEndOfDayById(2423689)->getResponse();

            $endOfDayId = $endOfDay->getId();
            $startTime = $endOfDay->getStartTime();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetDevices()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $devices = $endpoint->getDevices()->getResponse();

            /** @var Device $device */
            $device = $devices[0];

            $deviceId = $device->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetWebhookTriggers()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $webhook = $endpoint->getWebhookTriggers()->getResponse();

            $baseUrl = $webhook->getBaseUrl();
            $triggers = $webhook->getTriggers();

            /** @var WebhookTrigger $trigger */
            $trigger = $triggers[0];

            $path = $trigger->getPath();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testAddWebhookTriggers()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $trigger = new WebhookTrigger();
            $trigger->setEventTypeId(203);
            $trigger->setPath('/public/eposnow_temp');

            $webhook = $endpoint->addWebhookTriggers((new WebhookTriggerArrayRequest())->setRequest(array($trigger)))->getResponse();

            $baseUrl = $webhook->getBaseUrl();
            $triggers = $webhook->getTriggers();

            /** @var WebhookTrigger $trigger */
            $trigger = $triggers[0];

            $path = $trigger->getPath();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testRemoveWebhookTriggers()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $endpoint->removeWebhookTriggers((new WebhookTriggerRemoveArrayRequest())->setRequest(array(203)));

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testUpdateWebhook()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            // https://7d546e6b.ngrok.io
            $endpoint->updateWebhook('https://7d546e6b.ngrok.io/mike');

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetDiscountReasons()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $discountReasons = $endpoint->getDiscountReasons()->getResponse();

            /** @var DiscountReason $discountReason */
            $discountReason = $discountReasons[0];

            $discountReasonId = $discountReason->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetDiscountReasonById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $discountReason = $endpoint->getDiscountReasonById(73205)->getResponse();

            $discountReasonId = $discountReason->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testAddDiscountReason()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $discountReason = new DiscountReasonCreateRequest();
            $discountReason->setName('Teacher Discount');
            $discountReason->setDefaultPercentage(20);

            $discountReasons = $endpoint->addDiscountReasons((new DiscountReasonCreateArrayRequest())->setRequest(array($discountReason)))->getResponse();

            /** @var DiscountReason $discountReason */
            $discountReason = $discountReasons[0];

            $discountReasonId = $discountReason->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetRefundReasons()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $refundReasons = $endpoint->getRefundReasons()->getResponse();

            /** @var RefundReason $refundReason */
            $discountReason = $refundReasons[0];

            $discountReasonId = $discountReason->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetRefundReasonById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $refundReason = $endpoint->getRefundReasonById(36651)->getResponse();

            $refundReasonId = $refundReason->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testAddRefundReason()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $refundReason = new RefundReasonCreateRequest();
            $refundReason->setName('Faulty Goods');
            $refundReason->setDescription('Faulty Goods');
            $refundReason->setReturnItemsToStock(false);

            $refundReasons = $endpoint->addRefundReasons((new RefundReasonCreateArrayRequest())->setRequest(array($refundReason)))->getResponse();

            /** @var RefundReason $refundReason */
            $refundReason = $refundReasons[0];

            $refundReasonId = $refundReason->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTransactionReferenceCodes()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $transactionReferenceCodes = $endpoint->getTransactionReferenceCodes()->getResponse();

            /** @var TransactionReferenceCode $transactionReferenceCode */
            $transactionReferenceCode = $transactionReferenceCodes[0];

            $transactionReferenceCodeId = $transactionReferenceCode->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTransactionReferenceCodeById()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $transactionReferenceCode = $endpoint->getTransactionReferenceCodeById(378828)->getResponse();

            $transactionReferenceCodeId = $transactionReferenceCode->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testAddTransactionReferenceCode()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $transactionReferenceCode = new TransactionReferenceCodeCreateRequest();
            $transactionReferenceCode->setTransactionId(223845277);
            $transactionReferenceCode->setReferenceCode('ekm_sale_666');

            $transactionReferenceCodes = $endpoint->addTransactionReferenceCodes((new TransactionReferenceCodeCreateArrayRequest())->setRequest(array($transactionReferenceCode)))->getResponse();

            /** @var TransactionReferenceCode $transactionReferenceCode */
            $transactionReferenceCode = $transactionReferenceCodes[0];

            $transactionReferenceCodeId = $transactionReferenceCode->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTransactionReferenceCodeByTransactionId()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $transactionReferenceCode = $endpoint->getTransactionReferenceCodeByTransactionId(223845277)->getResponse();

            $transactionReferenceCodeId = $transactionReferenceCode->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetTransactionByReferenceCode()
    {
        try {

            $client = ClientBuilder::getClient('https://api.eposnowhq.com/api/v4/', 'L4SDN3RSVQ6HGAZJQNOKIH3ZJ5JYHSZS', 'D6IPTWMM6FXSLA7LXUY1OYO2B9MOUGL1', null);

            $endpoint = new EposnowApi($client);

            $transaction = $endpoint->getTransactionByReferenceCode('ekm_sale_28')->getResponse();

            $transactionId = $transaction->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }
}